/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.StringUtil;

public class RootNotFoundHandler
extends NotFoundHandler {
    private static Log log = LogFactory.getLog(RootNotFoundHandler.class);

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        int i2;
        log.debug("Root Not Found");
        String method = request.getMethod();
        if (!method.equals("GET") || !request.getPath().equals("/")) {
            super.handle(pathInContext, pathParams, request, response);
            return;
        }
        response.setStatus(404);
        request.setHandled(true);
        response.setReason("Not Found");
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
        String uri = request.getPath();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");
        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        writer.write("No context on this server matched or handled this request.<BR>");
        writer.write("Contexts known to this server are: <ul>");
        HttpContext[] contexts = this.getHttpContext().getHttpServer().getContexts();
        for (i2 = 0; i2 < contexts.length; ++i2) {
            HttpContext context = contexts[i2];
            writer.write("<li><a href=\"");
            writer.write(context.getContextPath());
            writer.write("/\">");
            writer.write(context.toString());
            writer.write("</a></li>\n");
        }
        writer.write("</ul><small><I>The links above may not work if a virtual host is configured</I></small>");
        for (i2 = 0; i2 < 10; ++i2) {
            writer.write("\n<!-- Padding for IE                  -->");
        }
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response.setContentLength(writer.size());
        OutputStream out = response.getOutputStream();
        writer.writeTo(out);
        out.close();
    }
}

