/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.StringUtil;

public class ErrorPageHandler
extends AbstractHttpHandler {
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);
        this.writeErrorPage(request, writer, response.getStatus(), response.getReason());
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo(response.getOutputStream());
        writer.destroy();
    }

    protected void writeErrorPage(HttpRequest request, Writer writer, int code, String message) throws IOException {
        if (message != null) {
            message = URLDecoder.decode(message, "UTF-8");
            message = StringUtil.replace(message, "<", "&lt;");
            message = StringUtil.replace(message, ">", "&gt;");
        }
        String uri = request.getPath();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");
        writer.write("<html>\n<head>\n<title>Error ");
        writer.write(Integer.toString(code));
        writer.write(32);
        writer.write(message);
        writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
        writer.write(Integer.toString(code));
        writer.write("</h2><pre>");
        writer.write(message);
        writer.write("</pre>\n");
        writer.write("<p>RequestURI=");
        writer.write(uri);
        writer.write("</p>\n<p><i><small><a href=\"http://jetty.mortbay.org\">Powered by Jetty://</a></small></i></p>");
        for (int i2 = 0; i2 < 20; ++i2) {
            writer.write("\n                                                ");
        }
        writer.write("\n</body>\n</html>\n");
    }
}

