/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.ByteArrayPool;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public abstract class AJP13Packet {
    private static Log log = LogFactory.getLog(AJP13Packet.class);
    public static final int __MAX_BUF = 8192;
    public static final int __HDR_SIZE = 4;
    public static final int __DATA_HDR = 7;
    public static final int __MAX_DATA = 8185;
    public static final byte __FORWARD_REQUEST = 2;
    public static final byte __SHUTDOWN = 7;
    public static final byte __SEND_BODY_CHUNK = 3;
    public static final byte __SEND_HEADERS = 4;
    public static final byte __END_RESPONSE = 5;
    public static final byte __GET_BODY_CHUNK = 6;
    public static final String[] __method = new String[]{"ERROR", "OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH"};
    public String[] __header;
    protected HashMap __headerMap = new HashMap();
    private byte[] _buf;
    private int _bytes;
    private int _pos;
    private ByteArrayISO8859Writer _byteWriter;
    private boolean _ownBuffer;

    public abstract void populateHeaders();

    public AJP13Packet(byte[] buffer, int len) {
        this.populateHeaders();
        this._buf = buffer;
        this._ownBuffer = false;
        this._bytes = len;
    }

    public AJP13Packet(byte[] buffer) {
        this.populateHeaders();
        this._buf = buffer;
        this._ownBuffer = false;
    }

    public AJP13Packet(int size) {
        this.populateHeaders();
        this._buf = ByteArrayPool.getByteArray(size);
        this._ownBuffer = true;
    }

    public void prepare() {
        this._bytes = 0;
        this._pos = 0;
        this.addByte((byte)65);
        this.addByte((byte)66);
        this.addInt(0);
    }

    public void destroy() {
        if (this._ownBuffer) {
            ByteArrayPool.returnByteArray(this._buf);
        }
        this._buf = null;
        this._byteWriter = null;
    }

    public void reset() {
        this._bytes = 0;
        this._pos = 0;
    }

    public byte[] getBuffer() {
        return this._buf;
    }

    public void resetData() {
        this._bytes = 4;
        this._pos = 0;
    }

    public int getMark() {
        return this._bytes;
    }

    public int getBufferSize() {
        return this._buf.length;
    }

    public int unconsumedData() {
        return this._bytes - this._pos;
    }

    public int unconsumedCapacity() {
        return this._buf.length - this._bytes;
    }

    public boolean read(InputStream in) throws IOException {
        this._bytes = 0;
        this._pos = 0;
        do {
            int l2;
            if ((l2 = in.read(this._buf, this._bytes, 4 - this._bytes)) < 0) {
                return false;
            }
            this._bytes += l2;
        } while (this._bytes < 4);
        int magic = this.getInt();
        if (magic != 4660) {
            throw new IOException("Bad JSP13 rcv packet:" + magic + " " + this);
        }
        int len = this.getInt();
        int packetLength = 4 + len;
        if (packetLength > this._buf.length) {
            throw new IOException("AJP13 packet (" + packetLength + "bytes) too large for buffer (" + this._buf.length + " bytes)");
        }
        do {
            int l3;
            if ((l3 = in.read(this._buf, this._bytes, packetLength - this._bytes)) < 0) {
                return false;
            }
            this._bytes += l3;
        } while (this._bytes < packetLength);
        if (log.isTraceEnabled()) {
            log.trace("AJP13 rcv: " + this.toString(64));
        }
        return true;
    }

    public void write(OutputStream out) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("AJP13 snd: " + this.toString(64));
        }
        out.write(this._buf, 0, this._bytes);
    }

    public byte getByte() {
        return this._buf[this._pos++];
    }

    public int getBytes(byte[] buf, int offset, int length) {
        if (length > this.unconsumedData()) {
            length = this.unconsumedData();
        }
        System.arraycopy(this._buf, this._pos, buf, offset, length);
        this._pos += length;
        return length;
    }

    public boolean getBoolean() {
        return this._buf[this._pos++] != 0;
    }

    public int getInt() {
        int i2 = this._buf[this._pos++] & 0xFF;
        i2 = (i2 << 8) + (this._buf[this._pos++] & 0xFF);
        return i2;
    }

    public String getString() {
        int len = this.getInt();
        if (len == 65535) {
            return null;
        }
        try {
            String s2 = new String(this._buf, this._pos, len, StringUtil.__ISO_8859_1);
            this._pos += len + 1;
            return s2;
        }
        catch (IndexOutOfBoundsException e2) {
            LogSupport.ignore(log, e2);
            return null;
        }
        catch (UnsupportedEncodingException e3) {
            log.fatal(e3);
            System.exit(1);
            return null;
        }
    }

    public String getMethod() {
        return __method[this.getByte()];
    }

    public String getHeader() {
        if ((0xFF & this._buf[this._pos]) == 160) {
            ++this._pos;
            return this.__header[this._buf[this._pos++]];
        }
        return this.getString();
    }

    public void addByte(byte b2) {
        this._buf[this._bytes++] = b2;
    }

    public int addBytes(byte[] buf, int offset, int length) {
        if (length > this.unconsumedCapacity()) {
            length = this.unconsumedCapacity();
        }
        System.arraycopy(buf, offset, this._buf, this._bytes, length);
        this._bytes += length;
        return length;
    }

    public void addBoolean(boolean b2) {
        this._buf[this._bytes++] = (byte)(b2 ? (char)'\u0001' : '\u0000');
    }

    public void addInt(int i2) {
        this._buf[this._bytes++] = (byte)(i2 >> 8 & 0xFF);
        this._buf[this._bytes++] = (byte)(i2 & 0xFF);
    }

    public void setInt(int mark, int i2) {
        this._buf[mark] = (byte)(i2 >> 8 & 0xFF);
        this._buf[mark + 1] = (byte)(i2 & 0xFF);
    }

    public void addString(String s2) throws IOException {
        if (s2 == null) {
            this.addInt(65535);
            return;
        }
        if (this._byteWriter == null) {
            this._byteWriter = new ByteArrayISO8859Writer(this._buf);
        }
        int p2 = this._bytes + 2;
        this._byteWriter.setLength(p2);
        this._byteWriter.write(s2);
        int l2 = this._byteWriter.size() - p2;
        this.addInt(l2);
        this._bytes += l2;
        this._buf[this._bytes++] = 0;
    }

    public void addHeader(String s2) throws IOException {
        Integer h2 = (Integer)this.__headerMap.get(s2);
        if (h2 != null) {
            this.addInt(h2);
        } else {
            this.addString(s2);
        }
    }

    public int getDataSize() {
        return this._bytes - 4;
    }

    public void setDataSize() {
        this.setDataSize(this._bytes - 4);
    }

    public void setDataSize(int s2) {
        this._bytes = s2 + 4;
        this._buf[2] = (byte)(s2 >> 8 & 0xFF);
        this._buf[3] = (byte)(s2 & 0xFF);
        if (this._buf[4] == 3) {
            this._buf[5] = (byte)((s2 -= 3) >> 8 & 0xFF);
            this._buf[6] = (byte)(s2 & 0xFF);
        }
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int max) {
        StringBuffer b2 = new StringBuffer();
        StringBuffer a2 = new StringBuffer();
        b2.append(this._bytes);
        b2.append('/');
        b2.append(this._buf.length);
        b2.append('[');
        b2.append(this._pos);
        b2.append("]: ");
        switch (this._buf[4]) {
            case 2: {
                b2.append("FORWARD_REQUEST{:");
                break;
            }
            case 7: {
                b2.append("SHUTDOWN        :");
                break;
            }
            case 3: {
                b2.append("SEND_BODY_CHUNK :");
                break;
            }
            case 4: {
                b2.append("SEND_HEADERS  ( :");
                break;
            }
            case 5: {
                b2.append("END_RESPONSE  )}:");
                break;
            }
            case 6: {
                b2.append("GET_BODY_CHUNK  :");
            }
        }
        if (max == 0) {
            return b2.toString();
        }
        b2.append("\n");
        for (int i2 = 0; i2 < this._bytes; ++i2) {
            int d2 = this._buf[i2] & 0xFF;
            if (d2 < 16) {
                b2.append('0');
            }
            b2.append(Integer.toString(d2, 16));
            char c2 = (char)d2;
            if (Character.isLetterOrDigit(c2)) {
                a2.append(c2);
            } else {
                a2.append('.');
            }
            if (i2 % 32 == 31 || i2 == this._bytes - 1) {
                b2.append(" : ");
                b2.append(a2.toString());
                a2.setLength(0);
                b2.append("\n");
                if (max <= 0 || i2 + 1 < max) continue;
                break;
            }
            b2.append(",");
        }
        return b2.toString();
    }
}

