/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpFields;
import org.mortbay.log.LogFactory;
import org.mortbay.util.CachedResource;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;

public class ResourceCache
implements LifeCycle,
Serializable {
    private static Log log = LogFactory.getLog(ResourceCache.class);
    private static final Map __dftMimeMap = new HashMap();
    private static final Map __encodings = new HashMap();
    private int _maxCachedFileSize = 1024;
    private int _maxCacheSize = 1024;
    private Resource _resourceBase;
    private Map _mimeMap;
    private Map _encodingMap;
    private transient boolean _started;
    protected transient Map _cache = new HashMap();
    protected transient int _cacheSize;
    protected transient CachedMetaData _mostRecentlyUsed;
    protected transient CachedMetaData _leastRecentlyUsed;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._cache = new HashMap();
    }

    public String getResourceBase() {
        if (this._resourceBase == null) {
            return null;
        }
        return this._resourceBase.toString();
    }

    public void setResourceBase(String resourceBase) {
        try {
            this._resourceBase = Resource.newResource(resourceBase);
            if (log.isDebugEnabled()) {
                log.debug("resourceBase=" + this._resourceBase + " for " + this);
            }
        }
        catch (IOException e2) {
            log.debug("EXCEPTION ", e2);
            throw new IllegalArgumentException(resourceBase + ":" + e2.toString());
        }
    }

    public Resource getBaseResource() {
        return this._resourceBase;
    }

    public void setBaseResource(Resource base) {
        this._resourceBase = base;
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
        this._cache.clear();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this._maxCacheSize = maxCacheSize;
        this._cache.clear();
    }

    public void flushCache() {
        this._cache.clear();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String pathInContext) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("getResource " + pathInContext);
        }
        if (this._resourceBase == null) {
            return null;
        }
        Resource resource = null;
        Map map = this._cache;
        synchronized (map) {
            CachedResource cached = (CachedResource)this._cache.get(pathInContext);
            if (cached != null) {
                CachedMetaData cmd;
                if (log.isTraceEnabled()) {
                    log.trace("CACHE HIT: " + cached);
                }
                if ((cmd = (CachedMetaData)cached.getAssociate()) != null && cmd.isValid()) {
                    return cached;
                }
            }
            resource = this._resourceBase.addPath(this._resourceBase.encode(pathInContext));
            if (log.isTraceEnabled()) {
                log.trace("CACHE MISS: " + resource);
            }
            if (resource == null) {
                return null;
            }
            if (resource.getAlias() != null) {
                log.warn("Alias request of '" + resource.getAlias() + "' for '" + resource + "'");
                return null;
            }
            long len = resource.length();
            if (resource.exists()) {
                if (!resource.isDirectory() && pathInContext.endsWith("/")) {
                    return null;
                }
                if (resource.isDirectory()) {
                    len = resource.list() != null ? (long)(resource.list().length * 100) : 0L;
                }
                if (len > 0L && len < (long)this._maxCachedFileSize && len < (long)this._maxCacheSize) {
                    int needed = this._maxCacheSize - (int)len;
                    while (this._cacheSize > needed) {
                        this._leastRecentlyUsed.invalidate();
                    }
                    cached = resource.cache();
                    if (log.isTraceEnabled()) {
                        log.trace("CACHED: " + resource);
                    }
                    new CachedMetaData(cached, pathInContext);
                    return cached;
                }
            }
        }
        new ResourceMetaData(resource);
        return resource;
    }

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map mimeMap) {
        this._mimeMap = mimeMap;
    }

    public String getMimeByExtension(String filename) {
        String type = null;
        if (filename != null) {
            int i2 = -1;
            while (type == null && (i2 = filename.indexOf(".", i2 + 1)) >= 0 && i2 < filename.length()) {
                String ext = StringUtil.asciiToLowerCase(filename.substring(i2 + 1));
                if (this._mimeMap != null) {
                    type = (String)this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = (String)__dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = (String)this._mimeMap.get("*");
            }
            if (type == null) {
                type = (String)__dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void setMimeMapping(String extension, String type) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(StringUtil.asciiToLowerCase(extension), type);
    }

    public synchronized Map getEncodingMap() {
        if (this._encodingMap == null) {
            this._encodingMap = Collections.unmodifiableMap(__encodings);
        }
        return this._encodingMap;
    }

    public void setEncodingMap(Map encodingMap) {
        this._encodingMap = encodingMap;
    }

    public String getEncodingByMimeType(String type) {
        String encoding = null;
        if (type != null) {
            encoding = (String)this._encodingMap.get(type);
        }
        return encoding;
    }

    public void setTypeEncoding(String mimeType, String encoding) {
        this.getEncodingMap().put(mimeType, encoding);
    }

    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.getMimeMap();
        this.getEncodingMap();
        this._started = true;
    }

    public boolean isStarted() {
        return this._started;
    }

    public void stop() throws InterruptedException {
        this._started = false;
        this._cache.clear();
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.setMimeMap(null);
        this._encodingMap = null;
    }

    public ResourceMetaData getResourceMetaData(Resource resource) {
        Object o2 = resource.getAssociate();
        if (o2 instanceof ResourceMetaData) {
            return (ResourceMetaData)o2;
        }
        return new ResourceMetaData(resource);
    }

    static {
        ResourceBundle mime = ResourceBundle.getBundle("org/mortbay/http/mime");
        Enumeration<String> i2 = mime.getKeys();
        while (i2.hasMoreElements()) {
            String ext = i2.nextElement();
            __dftMimeMap.put(StringUtil.asciiToLowerCase(ext), mime.getString(ext));
        }
        ResourceBundle encoding = ResourceBundle.getBundle("org/mortbay/http/encoding");
        i2 = encoding.getKeys();
        while (i2.hasMoreElements()) {
            String type = i2.nextElement();
            __encodings.put(type, encoding.getString(type));
        }
    }

    private class CachedMetaData
    extends ResourceMetaData {
        String _lastModified;
        String _encoding;
        String _length;
        String _key;
        CachedResource _cached;
        CachedMetaData _prev;
        CachedMetaData _next;

        CachedMetaData(CachedResource resource, String pathInContext) {
            super(resource);
            this._cached = resource;
            this._length = super.getLength();
            this._lastModified = super.getLastModified();
            this._encoding = super.getMimeType();
            this._key = pathInContext;
            this._next = ResourceCache.this._mostRecentlyUsed;
            ResourceCache.this._mostRecentlyUsed = this;
            if (this._next != null) {
                this._next._prev = this;
            }
            this._prev = null;
            if (ResourceCache.this._leastRecentlyUsed == null) {
                ResourceCache.this._leastRecentlyUsed = this;
            }
            ResourceCache.this._cache.put(this._key, resource);
            ResourceCache.this._cacheSize = (int)((long)ResourceCache.this._cacheSize + this._cached.length());
        }

        public String getLength() {
            return this._length;
        }

        public String getLastModified() {
            return this._lastModified;
        }

        public String getMimeType() {
            return this._encoding;
        }

        boolean isValid() throws IOException {
            if (this._cached.isUptoDate()) {
                if (ResourceCache.this._mostRecentlyUsed != this) {
                    CachedMetaData tp = this._prev;
                    CachedMetaData tn = this._next;
                    this._next = ResourceCache.this._mostRecentlyUsed;
                    ResourceCache.this._mostRecentlyUsed = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    this._prev = null;
                    if (tp != null) {
                        tp._next = tn;
                    }
                    if (tn != null) {
                        tn._prev = tp;
                    }
                    if (ResourceCache.this._leastRecentlyUsed == this && tp != null) {
                        ResourceCache.this._leastRecentlyUsed = tp;
                    }
                }
                return true;
            }
            this.invalidate();
            return false;
        }

        public void invalidate() {
            ResourceCache.this._cache.remove(this._key);
            ResourceCache.this._cacheSize -= (int)this._cached.length();
            if (ResourceCache.this._mostRecentlyUsed == this) {
                ResourceCache.this._mostRecentlyUsed = this._next;
            } else {
                this._prev._next = this._next;
            }
            if (ResourceCache.this._leastRecentlyUsed == this) {
                ResourceCache.this._leastRecentlyUsed = this._prev;
            } else {
                this._next._prev = this._prev;
            }
            this._prev = null;
            this._next = null;
        }
    }

    public class ResourceMetaData {
        protected String _name;
        protected Resource _resource;

        ResourceMetaData(Resource resource) {
            this._resource = resource;
            this._name = this._resource.toString();
            this._resource.setAssociate(this);
        }

        public String getLength() {
            return Long.toString(this._resource.length());
        }

        public String getLastModified() {
            return HttpFields.formatDate(this._resource.lastModified(), false);
        }

        public String getMimeType() {
            return ResourceCache.this.getMimeByExtension(this._name);
        }
    }
}

