/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.log.LogFactory;

public class ClientCertAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(ClientCertAuthenticator.class);
    private int _maxHandShakeSeconds = 60;

    public ClientCertAuthenticator() {
        log.warn("Client Cert Authentication is EXPERIMENTAL");
    }

    public int getMaxHandShakeSeconds() {
        return this._maxHandShakeSeconds;
    }

    public void setMaxHandShakeSeconds(int maxHandShakeSeconds) {
        this._maxHandShakeSeconds = maxHandShakeSeconds;
    }

    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (response != null && (certs == null || certs.length == 0 || certs[0] == null)) {
            Object s2 = HttpConnection.getHttpConnection().getConnection();
            if (!(s2 instanceof SSLSocket)) {
                return null;
            }
            SSLSocket socket = (SSLSocket)s2;
            if (!socket.getNeedClientAuth()) {
                socket.setNeedClientAuth(true);
                socket.startHandshake();
                int i2 = this._maxHandShakeSeconds * 4;
                while (i2-- > 0 && ((certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate")) == null || certs.length <= 0 || certs[0] == null)) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        if (certs == null || certs.length == 0 || certs[0] == null) {
            return null;
        }
        Principal principal = certs[0].getSubjectDN();
        if (principal == null) {
            principal = certs[0].getIssuerDN();
        }
        String username = principal == null ? "clientcert" : principal.getName();
        Principal user = realm.authenticate(username, certs, request);
        request.setAuthType("CLIENT_CERT");
        if (user != null) {
            request.setAuthUser(user.getName());
        }
        request.setUserPrincipal(user);
        return user;
    }

    public String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

