/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class PropertyIterator
implements NodeIterator {
    private boolean empty = false;
    private boolean reverse;
    private String name;
    private int startIndex = 0;
    private boolean targetReady = false;
    private int position = 0;
    private PropertyPointer propertyNodePointer;
    private int startPropertyIndex;
    private boolean ready = false;
    private boolean includeStart = false;

    public PropertyIterator(PropertyOwnerPointer pointer, String name, boolean reverse, NodePointer startWith) {
        this.propertyNodePointer = pointer.getPropertyPointer();
        this.name = name;
        this.reverse = reverse;
        this.includeStart = true;
        if (reverse) {
            this.startPropertyIndex = Integer.MIN_VALUE;
            this.startIndex = -1;
        }
        if (startWith != null) {
            while (startWith != null && startWith.getParent() != pointer) {
                startWith = startWith.getParent();
            }
            if (startWith == null) {
                throw new JXPathException("PropertyIerator startWith parameter is not a child of the supplied parent");
            }
            this.startPropertyIndex = ((PropertyPointer)startWith).getPropertyIndex();
            this.startIndex = startWith.getIndex();
            if (this.startIndex == Integer.MIN_VALUE) {
                this.startIndex = 0;
            }
            this.includeStart = false;
            if (reverse && this.startIndex == -1) {
                this.includeStart = true;
            }
        }
    }

    protected NodePointer getPropertyPointer() {
        return this.propertyNodePointer;
    }

    public void reset() {
        this.position = 0;
        this.targetReady = false;
    }

    public NodePointer getNodePointer() {
        if (this.position == 0) {
            if (this.name != null) {
                if (!this.targetReady) {
                    this.prepareForIndividualProperty(this.name);
                }
                if (this.empty) {
                    return null;
                }
            } else {
                if (!this.setPosition(1)) {
                    return null;
                }
                this.reset();
            }
        }
        try {
            NodePointer clone = (NodePointer)this.propertyNodePointer.clone();
            return clone.getValuePointer();
        }
        catch (Throwable ex) {
            NullPropertyPointer npp = new NullPropertyPointer(this.propertyNodePointer.getParent());
            npp.setPropertyName(this.propertyNodePointer.getPropertyName());
            npp.setIndex(this.propertyNodePointer.getIndex());
            return npp.getValuePointer();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        if (this.name != null) {
            return this.setPositionIndividualProperty(position);
        }
        return this.setPositionAllProperties(position);
    }

    private boolean setPositionIndividualProperty(int position) {
        int index;
        this.position = position;
        if (position < 1) {
            return false;
        }
        if (!this.targetReady) {
            this.prepareForIndividualProperty(this.name);
        }
        if (this.empty) {
            return false;
        }
        int length = this.getLength();
        if (!this.reverse) {
            index = position + this.startIndex;
            if (!this.includeStart) {
                ++index;
            }
            if (index > length) {
                return false;
            }
        } else {
            int end = this.startIndex;
            if (end == -1) {
                end = length - 1;
            }
            index = end - position + 2;
            if (!this.includeStart) {
                --index;
            }
            if (index < 1) {
                return false;
            }
        }
        this.propertyNodePointer.setIndex(index - 1);
        return true;
    }

    private boolean setPositionAllProperties(int position) {
        this.position = position;
        if (position < 1) {
            return false;
        }
        int count = this.propertyNodePointer.getPropertyCount();
        if (!this.reverse) {
            int index = 1;
            int i2 = this.startPropertyIndex;
            while (i2 < count) {
                int offset;
                this.propertyNodePointer.setPropertyIndex(i2);
                int length = this.getLength();
                if (i2 == this.startPropertyIndex) {
                    length -= this.startIndex;
                    if (!this.includeStart) {
                        --length;
                    }
                    offset = this.startIndex + position - index;
                    if (!this.includeStart) {
                        ++offset;
                    }
                } else {
                    offset = position - index;
                }
                if (index <= position && position < index + length) {
                    this.propertyNodePointer.setIndex(offset);
                    return true;
                }
                index += length;
                ++i2;
            }
        } else {
            int index = 1;
            int start = this.startPropertyIndex;
            if (start == Integer.MIN_VALUE) {
                start = count - 1;
            }
            int i3 = start;
            while (i3 >= 0) {
                int offset;
                this.propertyNodePointer.setPropertyIndex(i3);
                int length = this.getLength();
                if (i3 == this.startPropertyIndex) {
                    int end = this.startIndex;
                    if (end == -1) {
                        end = length - 1;
                    }
                    length = end + 1;
                    offset = end - position + 1;
                    if (!this.includeStart) {
                        --offset;
                        --length;
                    }
                } else {
                    offset = length - (position - index) - 1;
                }
                if (index <= position && position < index + length) {
                    this.propertyNodePointer.setIndex(offset);
                    return true;
                }
                index += length;
                --i3;
            }
        }
        return false;
    }

    protected void prepareForIndividualProperty(String name) {
        this.targetReady = true;
        this.empty = true;
        String[] names = this.propertyNodePointer.getPropertyNames();
        if (!this.reverse) {
            if (this.startPropertyIndex == Integer.MIN_VALUE) {
                this.startPropertyIndex = 0;
            }
            if (this.startIndex == Integer.MIN_VALUE) {
                this.startIndex = 0;
            }
            int i2 = this.startPropertyIndex;
            while (i2 < names.length) {
                if (names[i2].equals(name)) {
                    this.propertyNodePointer.setPropertyIndex(i2);
                    if (i2 != this.startPropertyIndex) {
                        this.startIndex = 0;
                        this.includeStart = true;
                    }
                    this.empty = false;
                    break;
                }
                ++i2;
            }
        } else {
            if (this.startPropertyIndex == Integer.MIN_VALUE) {
                this.startPropertyIndex = names.length - 1;
            }
            if (this.startIndex == Integer.MIN_VALUE) {
                this.startIndex = -1;
            }
            int i3 = this.startPropertyIndex;
            while (i3 >= 0) {
                if (names[i3].equals(name)) {
                    this.propertyNodePointer.setPropertyIndex(i3);
                    if (i3 != this.startPropertyIndex) {
                        this.startIndex = -1;
                        this.includeStart = true;
                    }
                    this.empty = false;
                    break;
                }
                --i3;
            }
        }
    }

    private int getLength() {
        int length;
        try {
            length = this.propertyNodePointer.getLength();
        }
        catch (Throwable t2) {
            length = 0;
        }
        return length;
    }
}

