/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Operation;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class CoreFunction
extends Operation {
    private static final Double ZERO = new Double(0.0);
    private int functionCode;

    public CoreFunction(int functionCode, Expression[] args) {
        super(args);
        this.functionCode = functionCode;
    }

    public int getFunctionCode() {
        return this.functionCode;
    }

    protected String getFunctionName() {
        switch (this.functionCode) {
            case 1: {
                return "last";
            }
            case 2: {
                return "position";
            }
            case 3: {
                return "count";
            }
            case 4: {
                return "id";
            }
            case 5: {
                return "local-name";
            }
            case 6: {
                return "namespace-uri";
            }
            case 7: {
                return "name";
            }
            case 8: {
                return "string";
            }
            case 9: {
                return "concat";
            }
            case 10: {
                return "starts-with";
            }
            case 11: {
                return "contains";
            }
            case 12: {
                return "substring-before";
            }
            case 13: {
                return "substring-after";
            }
            case 14: {
                return "substring";
            }
            case 15: {
                return "string-length";
            }
            case 16: {
                return "normalize-space";
            }
            case 17: {
                return "translate";
            }
            case 18: {
                return "boolean";
            }
            case 19: {
                return "not";
            }
            case 20: {
                return "true";
            }
            case 21: {
                return "false";
            }
            case 22: {
                return "lang";
            }
            case 23: {
                return "number";
            }
            case 24: {
                return "sum";
            }
            case 25: {
                return "floor";
            }
            case 26: {
                return "ceiling";
            }
            case 27: {
                return "round";
            }
            case 29: {
                return "key";
            }
            case 30: {
                return "format-number";
            }
        }
        return "unknownFunction" + this.functionCode + "()";
    }

    public Expression getArg1() {
        return this.args[0];
    }

    public Expression getArg2() {
        return this.args[1];
    }

    public Expression getArg3() {
        return this.args[2];
    }

    public int getArgumentCount() {
        if (this.args == null) {
            return 0;
        }
        return this.args.length;
    }

    public boolean computeContextDependent() {
        if (super.computeContextDependent()) {
            return true;
        }
        switch (this.functionCode) {
            case 1: 
            case 2: {
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 22: 
            case 23: {
                return this.args == null || this.args.length == 0;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return false;
            }
            case 30: {
                return this.args != null && this.args.length == 2;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getFunctionName());
        buffer.append('(');
        Expression[] args = this.getArguments();
        if (args != null) {
            int i2 = 0;
            while (i2 < args.length) {
                if (i2 > 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i2]);
                ++i2;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Object compute(EvalContext context) {
        return this.computeValue(context);
    }

    public Object computeValue(EvalContext context) {
        switch (this.functionCode) {
            case 1: {
                return this.functionLast(context);
            }
            case 2: {
                return this.functionPosition(context);
            }
            case 3: {
                return this.functionCount(context);
            }
            case 22: {
                return this.functionLang(context);
            }
            case 4: {
                return this.functionID(context);
            }
            case 5: {
                return this.functionLocalName(context);
            }
            case 6: {
                return this.functionNamespaceURI(context);
            }
            case 7: {
                return this.functionName(context);
            }
            case 8: {
                return this.functionString(context);
            }
            case 9: {
                return this.functionConcat(context);
            }
            case 10: {
                return this.functionStartsWith(context);
            }
            case 11: {
                return this.functionContains(context);
            }
            case 12: {
                return this.functionSubstringBefore(context);
            }
            case 13: {
                return this.functionSubstringAfter(context);
            }
            case 14: {
                return this.functionSubstring(context);
            }
            case 15: {
                return this.functionStringLength(context);
            }
            case 16: {
                return this.functionNormalizeSpace(context);
            }
            case 17: {
                return this.functionTranslate(context);
            }
            case 18: {
                return this.functionBoolean(context);
            }
            case 19: {
                return this.functionNot(context);
            }
            case 20: {
                return this.functionTrue(context);
            }
            case 21: {
                return this.functionFalse(context);
            }
            case 28: {
                return this.functionNull(context);
            }
            case 23: {
                return this.functionNumber(context);
            }
            case 24: {
                return this.functionSum(context);
            }
            case 25: {
                return this.functionFloor(context);
            }
            case 26: {
                return this.functionCeiling(context);
            }
            case 27: {
                return this.functionRound(context);
            }
            case 29: {
                return this.functionKey(context);
            }
            case 30: {
                return this.functionFormatNumber(context);
            }
        }
        return null;
    }

    protected Object functionLast(EvalContext context) {
        this.assertArgCount(0);
        int old = context.getCurrentPosition();
        context.reset();
        int count = 0;
        while (context.nextNode()) {
            ++count;
        }
        if (old != 0) {
            context.setPosition(old);
        }
        return new Double(count);
    }

    protected Object functionPosition(EvalContext context) {
        this.assertArgCount(0);
        return new Integer(context.getCurrentPosition());
    }

    protected Object functionCount(EvalContext context) {
        this.assertArgCount(1);
        Expression arg1 = this.getArg1();
        int count = 0;
        Object value = arg1.compute(context);
        if (value instanceof NodePointer) {
            value = ((NodePointer)value).getValue();
        }
        if (value instanceof EvalContext) {
            EvalContext ctx = (EvalContext)value;
            while (ctx.hasNext()) {
                ctx.next();
                ++count;
            }
        } else {
            count = value instanceof Collection ? ((Collection)value).size() : (value == null ? 0 : 1);
        }
        return new Double(count);
    }

    protected Object functionLang(EvalContext context) {
        this.assertArgCount(1);
        String lang = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        NodePointer pointer = (NodePointer)context.getSingleNodePointer();
        if (pointer == null) {
            return Boolean.FALSE;
        }
        return pointer.isLanguage(lang) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionID(EvalContext context) {
        this.assertArgCount(1);
        String id = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        JXPathContext jxpathContext = context.getJXPathContext();
        NodePointer pointer = (NodePointer)jxpathContext.getContextPointer();
        return pointer.getPointerByID(jxpathContext, id);
    }

    protected Object functionKey(EvalContext context) {
        this.assertArgCount(2);
        String key = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        String value = InfoSetUtil.stringValue(this.getArg2().computeValue(context));
        JXPathContext jxpathContext = context.getJXPathContext();
        NodePointer pointer = (NodePointer)jxpathContext.getContextPointer();
        return pointer.getPointerByKey(jxpathContext, key, value);
    }

    protected Object functionNamespaceURI(EvalContext context) {
        EvalContext ctx;
        if (this.getArgumentCount() == 0) {
            return context.getCurrentNodePointer();
        }
        this.assertArgCount(1);
        Object set = this.getArg1().compute(context);
        if (set instanceof EvalContext && (ctx = (EvalContext)set).hasNext()) {
            NodePointer ptr = (NodePointer)ctx.next();
            String str = ptr.getNamespaceURI();
            return str == null ? "" : str;
        }
        return "";
    }

    protected Object functionLocalName(EvalContext context) {
        EvalContext ctx;
        if (this.getArgumentCount() == 0) {
            return context.getCurrentNodePointer();
        }
        this.assertArgCount(1);
        Object set = this.getArg1().compute(context);
        if (set instanceof EvalContext && (ctx = (EvalContext)set).hasNext()) {
            NodePointer ptr = (NodePointer)ctx.next();
            return ptr.getName().getName();
        }
        return "";
    }

    protected Object functionName(EvalContext context) {
        EvalContext ctx;
        if (this.getArgumentCount() == 0) {
            return context.getCurrentNodePointer();
        }
        this.assertArgCount(1);
        Object set = this.getArg1().compute(context);
        if (set instanceof EvalContext && (ctx = (EvalContext)set).hasNext()) {
            NodePointer ptr = (NodePointer)ctx.next();
            return ptr.getExpandedName().toString();
        }
        return "";
    }

    protected Object functionString(EvalContext context) {
        if (this.getArgumentCount() == 0) {
            return InfoSetUtil.stringValue(context.getCurrentNodePointer());
        }
        this.assertArgCount(1);
        return InfoSetUtil.stringValue(this.getArg1().computeValue(context));
    }

    protected Object functionConcat(EvalContext context) {
        if (this.getArgumentCount() < 2) {
            this.assertArgCount(2);
        }
        StringBuffer buffer = new StringBuffer();
        Expression[] args = this.getArguments();
        int i2 = 0;
        while (i2 < args.length) {
            buffer.append(InfoSetUtil.stringValue(args[i2].compute(context)));
            ++i2;
        }
        return buffer.toString();
    }

    protected Object functionStartsWith(EvalContext context) {
        this.assertArgCount(2);
        String s1 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        String s2 = InfoSetUtil.stringValue(this.getArg2().computeValue(context));
        return s1.startsWith(s2) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionContains(EvalContext context) {
        this.assertArgCount(2);
        String s1 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        String s2 = InfoSetUtil.stringValue(this.getArg2().computeValue(context));
        return s1.indexOf(s2) != -1 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionSubstringBefore(EvalContext context) {
        this.assertArgCount(2);
        String s1 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        String s2 = InfoSetUtil.stringValue(this.getArg2().computeValue(context));
        int index = s1.indexOf(s2);
        if (index == -1) {
            return "";
        }
        return s1.substring(0, index);
    }

    protected Object functionSubstringAfter(EvalContext context) {
        this.assertArgCount(2);
        String s1 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        String s2 = InfoSetUtil.stringValue(this.getArg2().computeValue(context));
        int index = s1.indexOf(s2);
        if (index == -1) {
            return "";
        }
        return s1.substring(index + s2.length());
    }

    protected Object functionSubstring(EvalContext context) {
        int ac = this.getArgumentCount();
        if (ac != 2 && ac != 3) {
            this.assertArgCount(2);
        }
        String s1 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        double from = InfoSetUtil.doubleValue(this.getArg2().computeValue(context));
        if (Double.isNaN(from)) {
            return "";
        }
        from = Math.round(from);
        if (ac == 2) {
            if (from < 1.0) {
                from = 1.0;
            }
            return s1.substring((int)from - 1);
        }
        double length = InfoSetUtil.doubleValue(this.getArg3().computeValue(context));
        if ((length = (double)Math.round(length)) < 0.0) {
            return "";
        }
        double to = from + length;
        if (to < 1.0) {
            return "";
        }
        if (to > (double)(s1.length() + 1)) {
            if (from < 1.0) {
                from = 1.0;
            }
            return s1.substring((int)from - 1);
        }
        if (from < 1.0) {
            from = 1.0;
        }
        return s1.substring((int)from - 1, (int)(to - 1.0));
    }

    protected Object functionStringLength(EvalContext context) {
        String s2;
        if (this.getArgumentCount() == 0) {
            s2 = InfoSetUtil.stringValue(context.getCurrentNodePointer());
        } else {
            this.assertArgCount(1);
            s2 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        }
        return new Double(s2.length());
    }

    protected Object functionNormalizeSpace(EvalContext context) {
        this.assertArgCount(1);
        String s2 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        char[] chars = s2.toCharArray();
        int out = 0;
        int phase = 0;
        int in = 0;
        while (in < chars.length) {
            switch (chars[in]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (phase == 0 || phase != 1) break;
                    phase = 2;
                    chars[out++] = 32;
                    break;
                }
                default: {
                    chars[out++] = chars[in];
                    phase = 1;
                }
            }
            ++in;
        }
        if (phase == 2) {
            --out;
        }
        return new String(chars, 0, out);
    }

    protected Object functionTranslate(EvalContext context) {
        this.assertArgCount(3);
        String s1 = InfoSetUtil.stringValue(this.getArg1().computeValue(context));
        String s2 = InfoSetUtil.stringValue(this.getArg2().computeValue(context));
        String s3 = InfoSetUtil.stringValue(this.getArg3().computeValue(context));
        char[] chars = s1.toCharArray();
        int out = 0;
        int in = 0;
        while (in < chars.length) {
            char c2 = chars[in];
            int inx = s2.indexOf(c2);
            if (inx != -1) {
                if (inx < s3.length()) {
                    chars[out++] = s3.charAt(inx);
                }
            } else {
                chars[out++] = c2;
            }
            ++in;
        }
        return new String(chars, 0, out);
    }

    protected Object functionBoolean(EvalContext context) {
        this.assertArgCount(1);
        return InfoSetUtil.booleanValue(this.getArg1().computeValue(context)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionNot(EvalContext context) {
        this.assertArgCount(1);
        return InfoSetUtil.booleanValue(this.getArg1().computeValue(context)) ? Boolean.FALSE : Boolean.TRUE;
    }

    protected Object functionTrue(EvalContext context) {
        this.assertArgCount(0);
        return Boolean.TRUE;
    }

    protected Object functionFalse(EvalContext context) {
        this.assertArgCount(0);
        return Boolean.FALSE;
    }

    protected Object functionNull(EvalContext context) {
        this.assertArgCount(0);
        return null;
    }

    protected Object functionNumber(EvalContext context) {
        if (this.getArgumentCount() == 0) {
            return InfoSetUtil.number(context.getCurrentNodePointer());
        }
        this.assertArgCount(1);
        return InfoSetUtil.number(this.getArg1().computeValue(context));
    }

    protected Object functionSum(EvalContext context) {
        this.assertArgCount(1);
        Object v2 = this.getArg1().compute(context);
        if (v2 == null) {
            return ZERO;
        }
        if (v2 instanceof EvalContext) {
            double sum = 0.0;
            EvalContext ctx = (EvalContext)v2;
            while (ctx.hasNext()) {
                NodePointer ptr = (NodePointer)ctx.next();
                sum += InfoSetUtil.doubleValue(ptr);
            }
            return new Double(sum);
        }
        throw new JXPathException("Invalid argument type for 'sum': " + v2.getClass().getName());
    }

    protected Object functionFloor(EvalContext context) {
        this.assertArgCount(1);
        double v2 = InfoSetUtil.doubleValue(this.getArg1().computeValue(context));
        return new Double(Math.floor(v2));
    }

    protected Object functionCeiling(EvalContext context) {
        this.assertArgCount(1);
        double v2 = InfoSetUtil.doubleValue(this.getArg1().computeValue(context));
        return new Double(Math.ceil(v2));
    }

    protected Object functionRound(EvalContext context) {
        this.assertArgCount(1);
        double v2 = InfoSetUtil.doubleValue(this.getArg1().computeValue(context));
        return new Double(Math.round(v2));
    }

    private Object functionFormatNumber(EvalContext context) {
        int ac = this.getArgumentCount();
        if (ac != 2 && ac != 3) {
            this.assertArgCount(2);
        }
        double number = InfoSetUtil.doubleValue(this.getArg1().computeValue(context));
        String pattern = InfoSetUtil.stringValue(this.getArg2().computeValue(context));
        DecimalFormatSymbols symbols = null;
        if (ac == 3) {
            String symbolsName = InfoSetUtil.stringValue(this.getArg3().computeValue(context));
            symbols = context.getJXPathContext().getDecimalFormatSymbols(symbolsName);
        } else {
            NodePointer pointer = context.getCurrentNodePointer();
            Locale locale = pointer != null ? pointer.getLocale() : context.getJXPathContext().getLocale();
            symbols = new DecimalFormatSymbols(locale);
        }
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
        format.setDecimalFormatSymbols(symbols);
        format.applyLocalizedPattern(pattern);
        return format.format(number);
    }

    private void assertArgCount(int count) {
        if (this.getArgumentCount() != count) {
            throw new JXPathException("Incorrect number of argument: " + this);
        }
    }
}

