/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.samples;

import java.io.IOException;
import java.net.InetAddress;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.UPNPResponseException;

public class IGDPortsTest {
    public static final void main(String[] args) {
        int discoveryTiemout = 5000;
        try {
            InternetGatewayDevice[] IGDs = InternetGatewayDevice.getDevices(discoveryTiemout);
            if (IGDs != null) {
                for (int i2 = 0; i2 < IGDs.length; ++i2) {
                    boolean unmapped;
                    InternetGatewayDevice testIGD = IGDs[i2];
                    System.out.println("Found device " + testIGD.getIGDRootDevice().getModelName());
                    System.out.println("NAT table size is " + testIGD.getNatTableSize());
                    String localHostIP = InetAddress.getLocalHost().getHostAddress();
                    boolean mapped = testIGD.addPortMapping("Some mapping description", null, 9090, 9090, localHostIP, 0, "TCP");
                    if (!mapped) continue;
                    System.out.println("Port 9090 mapped to " + localHostIP);
                    System.out.println("Current mappings count is " + testIGD.getNatMappingsCount());
                    ActionResponse resp = testIGD.getSpecificPortMappingEntry(null, 9090, "TCP");
                    if (resp != null) {
                        System.out.println("Port 9090 mapping confirmation received from device");
                    }
                    if (!(unmapped = testIGD.deletePortMapping(null, 9090, "TCP"))) continue;
                    System.out.println("Port 9090 unmapped");
                }
            } else {
                System.out.println("Unable to find IGD on your network");
            }
        }
        catch (IOException ex) {
            System.err.println("IOException occured during discovery or ports mapping " + ex.getMessage());
        }
        catch (UPNPResponseException respEx) {
            System.err.println("UPNP device unhappy " + respEx.getDetailErrorCode() + " " + respEx.getDetailErrorDescription());
        }
    }
}

