/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.messages;

import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.ServiceAction;
import net.sbbi.upnp.services.ServiceActionArgument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ActionMessageResponseParser
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ActionMessageResponseParser.class);
    private static final String SOAP_FAULT_EL = "Fault";
    private ServiceAction serviceAction;
    private String bodyElementName;
    private boolean faultResponse = false;
    private UPNPResponseException msgEx;
    private boolean readFaultCode = false;
    private boolean readFaultString = false;
    private boolean readErrorCode = false;
    private boolean readErrorDescription = false;
    private boolean parseOutputParams = false;
    private ActionResponse result;
    private ServiceActionArgument parsedResultOutArg;

    protected ActionMessageResponseParser(ServiceAction serviceAction) {
        this.serviceAction = serviceAction;
        this.bodyElementName = serviceAction.getName() + "Response";
    }

    protected UPNPResponseException getUPNPResponseException() {
        return this.msgEx;
    }

    protected ActionResponse getActionResponse() {
        return this.result;
    }

    public void characters(char[] ch2, int start, int length) {
        if (this.parseOutputParams) {
            if (this.parsedResultOutArg != null) {
                String origChars = this.result.getOutActionArgumentValue(this.parsedResultOutArg.getName());
                String newChars = new String(ch2, start, length);
                if (origChars == null) {
                    this.result.addResult(this.parsedResultOutArg, newChars);
                } else {
                    this.result.addResult(this.parsedResultOutArg, origChars + newChars);
                }
            }
        } else if (this.readFaultCode) {
            this.msgEx.faultCode = new String(ch2, start, length);
            this.readFaultCode = false;
        } else if (this.readFaultString) {
            this.msgEx.faultString = new String(ch2, start, length);
            this.readFaultString = false;
        } else if (this.readErrorCode) {
            String code = new String(ch2, start, length);
            try {
                this.msgEx.detailErrorCode = Integer.parseInt(code);
            }
            catch (Throwable ex) {
                log.debug("Error during returned error code " + code + " parsing");
            }
            this.readErrorCode = false;
        } else if (this.readErrorDescription) {
            this.msgEx.detailErrorDescription = new String(ch2, start, length);
            this.readErrorDescription = false;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.parseOutputParams) {
            ServiceActionArgument arg = this.serviceAction.getActionArgument(localName);
            if (arg != null && arg.getDirection() == "out") {
                this.parsedResultOutArg = arg;
                this.result.addResult(this.parsedResultOutArg, null);
            } else {
                this.parsedResultOutArg = null;
            }
        } else if (this.faultResponse) {
            if (localName.equals("faultcode")) {
                this.readFaultCode = true;
            } else if (localName.equals("faultstring")) {
                this.readFaultString = true;
            } else if (localName.equals("errorCode")) {
                this.readErrorCode = true;
            } else if (localName.equals("errorDescription")) {
                this.readErrorDescription = true;
            }
        } else if (localName.equals(SOAP_FAULT_EL)) {
            this.msgEx = new UPNPResponseException();
            this.faultResponse = true;
        } else if (localName.equals(this.bodyElementName)) {
            this.parseOutputParams = true;
            this.result = new ActionResponse();
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.parsedResultOutArg != null && this.parsedResultOutArg.getName().equals(localName)) {
            this.parsedResultOutArg = null;
        } else if (localName.equals(this.bodyElementName)) {
            this.parseOutputParams = false;
        }
    }
}

