/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.sbbi.upnp.services.ServiceStateVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UPNPMBeanService {
    private static final Log log = LogFactory.getLog(UPNPMBeanService.class);
    private String serviceType;
    private String serviceId;
    private String serviceUUID;
    private String deviceUUID;
    private String deviceSCDP;
    private Map operationsStateVariables;
    private MBeanServer targetServer;
    private MBeanInfo mbeanInfo;
    private ObjectName mbeanName;
    private Class targetBeanClass;

    protected UPNPMBeanService(String deviceUUID, String vendorDomain, String serviceId, String serviceType, int serviceVersion, MBeanInfo mbeanInfo, ObjectName mbeanName, MBeanServer targetServer) throws IOException {
        this.deviceUUID = deviceUUID;
        if (serviceId == null) {
            serviceId = this.generateServiceId(mbeanName);
        }
        this.serviceUUID = deviceUUID + "/" + serviceId;
        this.serviceType = "urn:" + vendorDomain + ":service:" + serviceType + ":" + serviceVersion;
        this.serviceId = "urn:" + vendorDomain + ":serviceId:" + serviceId;
        this.deviceSCDP = this.getDeviceSSDP(mbeanInfo);
        try {
            this.targetBeanClass = Class.forName(mbeanInfo.getClassName());
        }
        catch (ClassNotFoundException ex) {
            IOException ex2 = new IOException("Unable to find target MBean class " + mbeanInfo.getClassName());
            ex2.initCause(ex);
            throw ex2;
        }
        this.mbeanName = mbeanName;
        this.mbeanInfo = mbeanInfo;
        this.targetServer = targetServer;
    }

    protected String getServiceUUID() {
        return this.serviceUUID;
    }

    protected String getDeviceUUID() {
        return this.deviceUUID;
    }

    private String generateServiceId(ObjectName mbeanName) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(mbeanName.toString().getBytes());
            StringBuffer hexString = new StringBuffer();
            byte[] digest = md5.digest();
            for (int i2 = 0; i2 < digest.length; ++i2) {
                hexString.append(Integer.toHexString(0xFF & digest[i2]));
            }
            return hexString.toString().toUpperCase();
        }
        catch (Exception ex) {
            RuntimeException runTimeEx = new RuntimeException("Unexpected error during MD5 hash creation, check your JRE");
            runTimeEx.initCause(ex);
            throw runTimeEx;
        }
    }

    protected String getServiceInfo() {
        StringBuffer rtrVal = new StringBuffer();
        rtrVal.append("<service>\r\n");
        rtrVal.append("<serviceType>").append(this.serviceType).append("</serviceType>\r\n");
        rtrVal.append("<serviceId>").append(this.serviceId).append("</serviceId>\r\n");
        rtrVal.append("<controlURL>").append("/").append(this.serviceUUID).append("/control").append("</controlURL>\r\n");
        rtrVal.append("<eventSubURL>").append("/").append(this.serviceUUID).append("/events").append("</eventSubURL>\r\n");
        rtrVal.append("<SCPDURL>").append("/").append(this.serviceUUID).append("/scpd.xml").append("</SCPDURL>\r\n");
        rtrVal.append("</service>\r\n");
        return rtrVal.toString();
    }

    protected Map getOperationsStateVariables() {
        return this.operationsStateVariables;
    }

    protected String getDeviceSCDP() {
        return this.deviceSCDP;
    }

    protected String getServiceType() {
        return this.serviceType;
    }

    protected Class getTargetBeanClass() {
        return this.targetBeanClass;
    }

    protected ObjectName getObjectName() {
        return this.mbeanName;
    }

    protected Object getAttribute(String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        return this.targetServer.getAttribute(this.mbeanName, attributeName);
    }

    protected Object invoke(String actionName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        return this.targetServer.invoke(this.mbeanName, actionName, params, signature);
    }

    private String getDeviceSSDP(MBeanInfo info) throws IllegalArgumentException {
        MBeanOperationInfo[] ops = info.getOperations();
        MBeanAttributeInfo[] atts = info.getAttributes();
        if (!(ops != null && ops.length != 0 || atts != null && atts.length != 0)) {
            throw new IllegalArgumentException("MBean has no operation and no attribute and cannot be exposed as an UPNP device, provide at least one attribute");
        }
        HashSet<String> deployedActionNames = new HashSet<String>();
        this.operationsStateVariables = new HashMap();
        StringBuffer rtrVal = new StringBuffer();
        rtrVal.append("<?xml version=\"1.0\" ?>\r\n");
        rtrVal.append("<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\r\n");
        rtrVal.append("<specVersion><major>1</major><minor>0</minor></specVersion>\r\n");
        if (ops != null && ops.length > 0) {
            rtrVal.append("<actionList>\r\n");
            for (int i2 = 0; i2 < ops.length; ++i2) {
                MBeanOperationInfo op = ops[i2];
                StringBuffer action = new StringBuffer();
                if (deployedActionNames.contains(op.getName())) {
                    log.debug("The " + op.getName() + " is allready deplyoed and cannot be reused, skipping operation deployment");
                    continue;
                }
                action.append("<action>\r\n");
                action.append("<name>");
                action.append(op.getName());
                action.append("</name>\r\n");
                action.append("<argumentList>\r\n");
                action.append("<argument>\r\n");
                action.append("<name>");
                String outVarName = op.getName() + "_out";
                String actionOutDataType = ServiceStateVariable.getUPNPDataTypeMapping(op.getReturnType());
                if (actionOutDataType == null) {
                    actionOutDataType = "string";
                }
                action.append(outVarName);
                action.append("</name>\r\n");
                action.append("<direction>out</direction>\r\n");
                action.append("<relatedStateVariable>");
                action.append(outVarName);
                action.append("</relatedStateVariable>\r\n");
                action.append("</argument>\r\n");
                boolean nonPrimitiveInputType = false;
                boolean duplicatedInputVarname = false;
                HashMap<String, String> operationsInputStateVariables = new HashMap<String, String>();
                if (op.getSignature() != null) {
                    for (int z2 = 0; z2 < op.getSignature().length; ++z2) {
                        MBeanParameterInfo param = op.getSignature()[z2];
                        String actionInDataType = ServiceStateVariable.getUPNPDataTypeMapping(param.getType());
                        if (actionInDataType == null) {
                            nonPrimitiveInputType = true;
                            log.debug("The " + param.getType() + " type is not an UPNP compatible data type, use only primitives");
                            break;
                        }
                        String inVarName = param.getName();
                        String existing = (String)this.operationsStateVariables.get(inVarName);
                        if (existing != null && !existing.equals(actionInDataType)) {
                            String msg = "The operation " + op.getName() + " " + inVarName + " parameter already exists for another method with another data type (" + existing + ") either match the data type or change the parameter name" + " in you MBeanParameterInfo object for this operation";
                            duplicatedInputVarname = true;
                            log.debug(msg);
                            break;
                        }
                        action.append("<argument>\r\n");
                        action.append("<name>");
                        operationsInputStateVariables.put(inVarName, actionInDataType);
                        action.append(inVarName);
                        action.append("</name>\r\n");
                        action.append("<direction>in</direction>\r\n");
                        action.append("<relatedStateVariable>");
                        action.append(inVarName);
                        action.append("</relatedStateVariable>\r\n");
                        action.append("</argument>\r\n");
                    }
                }
                action.append("</argumentList>\r\n");
                action.append("</action>\r\n");
                if (nonPrimitiveInputType || duplicatedInputVarname) continue;
                this.operationsStateVariables.putAll(operationsInputStateVariables);
                this.operationsStateVariables.put(outVarName, actionOutDataType);
                rtrVal.append(action.toString());
                deployedActionNames.add(op.getName());
            }
            rtrVal.append("</actionList>\r\n");
        } else {
            rtrVal.append("<actionList/>\r\n");
        }
        rtrVal.append("<serviceStateTable>\r\n");
        Iterator i3 = this.operationsStateVariables.keySet().iterator();
        while (i3.hasNext()) {
            String name = (String)i3.next();
            String type = (String)this.operationsStateVariables.get(name);
            rtrVal.append("<stateVariable sendEvents=\"no\">\r\n");
            rtrVal.append("<name>");
            rtrVal.append(name);
            rtrVal.append("</name>\r\n");
            rtrVal.append("<dataType>");
            rtrVal.append(type);
            rtrVal.append("</dataType>\r\n");
            rtrVal.append("</stateVariable>\r\n");
        }
        if (atts != null && atts.length > 0) {
            for (int i4 = 0; i4 < atts.length; ++i4) {
                MBeanAttributeInfo att = atts[i4];
                if (!att.isReadable()) continue;
                rtrVal.append("<stateVariable sendEvents=\"no\">\r\n");
                rtrVal.append("<name>");
                rtrVal.append(att.getName());
                rtrVal.append("</name>\r\n");
                rtrVal.append("<dataType>");
                String stateVarType = ServiceStateVariable.getUPNPDataTypeMapping(att.getType());
                if (stateVarType == null) {
                    stateVarType = "string";
                }
                rtrVal.append(stateVarType);
                rtrVal.append("</dataType>\r\n");
                rtrVal.append("</stateVariable>\r\n");
            }
        }
        rtrVal.append("</serviceStateTable>\r\n");
        rtrVal.append("</scpd>");
        return rtrVal.toString();
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }
}

