/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class HttpRequest {
    private String httpCommand;
    private String httpCommandArg;
    private Map fields;
    private String body;

    public HttpRequest(String rawHttpRequest) {
        if (rawHttpRequest.trim().length() == 0) {
            throw new IllegalArgumentException("Empty HTTP request message");
        }
        boolean bodyParsing = false;
        StringBuffer bodyParsed = new StringBuffer();
        this.fields = new HashMap();
        String[] lines = rawHttpRequest.split("\\r\\n");
        String header = lines[0].trim();
        int space = header.indexOf(" ");
        if (space != -1) {
            this.httpCommand = header.substring(0, space);
            int space2 = header.indexOf(" ", space + 1);
            if (space2 != -1) {
                this.httpCommandArg = header.substring(space + 1, space2);
            }
        }
        for (int i2 = 1; i2 < lines.length; ++i2) {
            int delim;
            String line = lines[i2];
            if (line.length() == 0) {
                bodyParsing = true;
                continue;
            }
            if (bodyParsing) {
                bodyParsed.append(line).append("\r\n");
                continue;
            }
            if (line.length() <= 0 || (delim = line.indexOf(58)) == -1) continue;
            String key = line.substring(0, delim).toUpperCase();
            String value = line.substring(delim + 1).trim();
            this.fields.put(key, value);
        }
        if (bodyParsing) {
            this.body = bodyParsed.toString();
        }
    }

    public String getHttpCommand() {
        return this.httpCommand;
    }

    public String getHttpCommandArg() {
        return this.httpCommandArg;
    }

    public String getBody() {
        return this.body;
    }

    public String getHTTPFieldElement(String fieldName, String elementName) throws IllegalArgumentException {
        String fieldNameValue = this.getHTTPHeaderField(fieldName);
        if (fieldName != null) {
            StringTokenizer tokenizer = new StringTokenizer(fieldNameValue.trim(), ",");
            while (tokenizer.countTokens() > 0) {
                int index;
                String nextToken = tokenizer.nextToken().trim();
                if (!nextToken.startsWith(elementName) || (index = nextToken.indexOf("=")) == -1) continue;
                return nextToken.substring(index + 1);
            }
        }
        return null;
    }

    public String getHTTPHeaderField(String fieldName) throws IllegalArgumentException {
        return (String)this.fields.get(fieldName.toUpperCase());
    }
}

