/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sbbi.upnp.DiscoveryListener;
import net.sbbi.upnp.DiscoveryResultsHandler;
import net.sbbi.upnp.devices.UPNPRootDevice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Discovery {
    private static final Log log = LogFactory.getLog(Discovery.class);
    public static final String ROOT_DEVICES = "upnp:rootdevice";
    public static final String ALL_DEVICES = "ssdp:all";
    public static final int DEFAULT_MX = 3;
    public static final int DEFAULT_TTL = 4;
    public static final int DEFAULT_TIMEOUT = 1500;
    public static final String DEFAULT_SEARCH = "ssdp:all";
    public static final int DEFAULT_SSDP_SEARCH_PORT = 1901;
    public static final String SSDP_IP = "239.255.255.250";
    public static final int SSDP_PORT = 1900;

    public static UPNPRootDevice[] discover() throws IOException {
        return Discovery.discover(1500, 4, 3, "ssdp:all");
    }

    public static UPNPRootDevice[] discover(String searchTarget) throws IOException {
        return Discovery.discover(1500, 4, 3, searchTarget);
    }

    public static UPNPRootDevice[] discover(int timeOut, String searchTarget) throws IOException {
        return Discovery.discover(timeOut, 4, 3, searchTarget);
    }

    public static UPNPRootDevice[] discover(int timeOut, int ttl, int mx, String searchTarget) throws IOException {
        if (searchTarget == null || searchTarget.trim().length() == 0) {
            throw new IllegalArgumentException("Illegal searchTarget");
        }
        final HashMap devices = new HashMap();
        DiscoveryResultsHandler handler = new DiscoveryResultsHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void discoveredDevice(String usn, String udn, String nt, String maxAge, URL location, String firmware) {
                Map map = devices;
                synchronized (map) {
                    if (!devices.containsKey(usn)) {
                        try {
                            UPNPRootDevice device = new UPNPRootDevice(location, maxAge, firmware, usn, udn);
                            devices.put(usn, device);
                        }
                        catch (Exception ex) {
                            log.error("Error occured during upnp root device object creation from location " + location, ex);
                        }
                    }
                }
            }
        };
        DiscoveryListener.getInstance().registerResultsHandler(handler, searchTarget);
        Enumeration<NetworkInterface> e2 = NetworkInterface.getNetworkInterfaces();
        while (e2.hasMoreElements()) {
            NetworkInterface intf = e2.nextElement();
            Enumeration<InetAddress> adrs = intf.getInetAddresses();
            while (adrs.hasMoreElements()) {
                InetAddress adr = adrs.nextElement();
                if (!(adr instanceof Inet4Address) || adr.isLoopbackAddress()) continue;
                Discovery.sendSearchMessage(adr, ttl, mx, searchTarget);
            }
        }
        try {
            Thread.sleep(timeOut);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        DiscoveryListener.getInstance().unRegisterResultsHandler(handler, searchTarget);
        if (devices.size() == 0) {
            return null;
        }
        int j2 = 0;
        UPNPRootDevice[] rootDevices = new UPNPRootDevice[devices.size()];
        Iterator i2 = devices.values().iterator();
        while (i2.hasNext()) {
            rootDevices[j2++] = (UPNPRootDevice)i2.next();
        }
        return rootDevices;
    }

    public static void sendSearchMessage(InetAddress src, int ttl, int mx, String searchTarget) throws IOException {
        int bindPort = 1901;
        String port = System.getProperty("net.sbbi.upnp.Discovery.bindPort");
        if (port != null) {
            bindPort = Integer.parseInt(port);
        }
        InetSocketAddress adr = new InetSocketAddress(InetAddress.getByName(SSDP_IP), 1900);
        MulticastSocket skt = new MulticastSocket(null);
        skt.bind(new InetSocketAddress(src, bindPort));
        skt.setTimeToLive(ttl);
        StringBuffer packet = new StringBuffer();
        packet.append("M-SEARCH * HTTP/1.1\r\n");
        packet.append("HOST: 239.255.255.250:1900\r\n");
        packet.append("MAN: \"ssdp:discover\"\r\n");
        packet.append("MX: ").append(mx).append("\r\n");
        packet.append("ST: ").append(searchTarget).append("\r\n").append("\r\n");
        if (log.isDebugEnabled()) {
            log.debug("Sending discovery message on 239.255.255.250:1900 multicast address form ip " + src.getHostAddress() + ":\n" + packet.toString());
        }
        String toSend = packet.toString();
        byte[] pk = toSend.getBytes();
        skt.send(new DatagramPacket(pk, pk.length, adr));
        skt.disconnect();
        skt.close();
    }
}

