/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.SynthesisFilter;

class LayerIIDecoder
extends LayerIDecoder
implements FrameDecoder {
    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i2 = 0; i2 < this.num_subbands; ++i2) {
                this.subbands[i2] = new SubbandLayer2(i2);
            }
        } else if (this.mode == 1) {
            int n2;
            for (n2 = 0; n2 < this.header.intensity_stereo_bound(); ++n2) {
                this.subbands[n2] = new SubbandLayer2Stereo(n2);
            }
            while (n2 < this.num_subbands) {
                this.subbands[n2] = new SubbandLayer2IntensityStereo(n2);
                ++n2;
            }
        } else {
            for (int i3 = 0; i3 < this.num_subbands; ++i3) {
                this.subbands[i3] = new SubbandLayer2Stereo(i3);
            }
        }
    }

    protected void readScaleFactorSelection() {
        for (int i2 = 0; i2 < this.num_subbands; ++i2) {
            ((SubbandLayer2)this.subbands[i2]).read_scalefactor_selection(this.stream, this.crc);
        }
    }

    static class SubbandLayer2Stereo
    extends SubbandLayer2 {
        protected int channel2_allocation;
        protected int channel2_scfsi;
        protected float channel2_scalefactor1;
        protected float channel2_scalefactor2;
        protected float channel2_scalefactor3;
        protected int[] channel2_codelength = new int[]{0};
        protected float[] channel2_factor = new float[]{0.0f};
        protected float[] channel2_samples;
        protected float[] channel2_c = new float[]{0.0f};
        protected float[] channel2_d = new float[]{0.0f};

        public SubbandLayer2Stereo(int n2) {
            super(n2);
            this.channel2_samples = new float[3];
        }

        public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
            int n2 = this.get_allocationlength(header);
            this.allocation = bitstream.get_bits(n2);
            this.channel2_allocation = bitstream.get_bits(n2);
            if (crc16 != null) {
                crc16.add_bits(this.allocation, n2);
                crc16.add_bits(this.channel2_allocation, n2);
            }
        }

        public void read_scalefactor_selection(Bitstream bitstream, Crc16 crc16) {
            if (this.allocation != 0) {
                this.scfsi = bitstream.get_bits(2);
                if (crc16 != null) {
                    crc16.add_bits(this.scfsi, 2);
                }
            }
            if (this.channel2_allocation != 0) {
                this.channel2_scfsi = bitstream.get_bits(2);
                if (crc16 != null) {
                    crc16.add_bits(this.channel2_scfsi, 2);
                }
            }
        }

        public void read_scalefactor(Bitstream bitstream, Header header) {
            super.read_scalefactor(bitstream, header);
            if (this.channel2_allocation != 0) {
                switch (this.channel2_scfsi) {
                    case 0: {
                        this.channel2_scalefactor1 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor2 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2_scalefactor1 = this.channel2_scalefactor2 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor1 = this.channel2_scalefactor3;
                        break;
                    }
                    case 3: {
                        this.channel2_scalefactor1 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.channel2_allocation, 1, this.channel2_factor, this.channel2_codelength, this.channel2_c, this.channel2_d);
            }
        }

        public boolean read_sampledata(Bitstream bitstream) {
            boolean bl2 = super.read_sampledata(bitstream);
            if (this.channel2_allocation != 0) {
                if (this.groupingtable[1] != null) {
                    int n2 = bitstream.get_bits(this.channel2_codelength[0]);
                    n2 += n2 << 1;
                    float[] fArray = this.channel2_samples;
                    float[] fArray2 = this.groupingtable[1];
                    int n3 = 0;
                    int n4 = n2;
                    fArray[n3] = fArray2[n4];
                    fArray[++n3] = fArray2[++n4];
                    fArray[++n3] = fArray2[++n4];
                } else {
                    this.channel2_samples[0] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                    this.channel2_samples[1] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                    this.channel2_samples[2] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                }
            }
            return bl2;
        }

        public boolean put_next_sample(int n2, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2) {
            boolean bl2 = super.put_next_sample(n2, synthesisFilter, synthesisFilter2);
            if (this.channel2_allocation != 0 && n2 != 1) {
                float f2 = this.channel2_samples[this.samplenumber - 1];
                if (this.groupingtable[1] == null) {
                    f2 = (f2 + this.channel2_d[0]) * this.channel2_c[0];
                }
                f2 = this.groupnumber <= 4 ? (f2 *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (f2 *= this.channel2_scalefactor2) : (f2 *= this.channel2_scalefactor3));
                if (n2 == 0) {
                    synthesisFilter2.input_sample(f2, this.subbandnumber);
                } else {
                    synthesisFilter.input_sample(f2, this.subbandnumber);
                }
            }
            return bl2;
        }
    }

    static class SubbandLayer2IntensityStereo
    extends SubbandLayer2 {
        protected int channel2_scfsi;
        protected float channel2_scalefactor1;
        protected float channel2_scalefactor2;
        protected float channel2_scalefactor3;

        public SubbandLayer2IntensityStereo(int n2) {
            super(n2);
        }

        public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
            super.read_allocation(bitstream, header, crc16);
        }

        public void read_scalefactor_selection(Bitstream bitstream, Crc16 crc16) {
            if (this.allocation != 0) {
                this.scfsi = bitstream.get_bits(2);
                this.channel2_scfsi = bitstream.get_bits(2);
                if (crc16 != null) {
                    crc16.add_bits(this.scfsi, 2);
                    crc16.add_bits(this.channel2_scfsi, 2);
                }
            }
        }

        public void read_scalefactor(Bitstream bitstream, Header header) {
            if (this.allocation != 0) {
                super.read_scalefactor(bitstream, header);
                switch (this.channel2_scfsi) {
                    case 0: {
                        this.channel2_scalefactor1 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor2 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2_scalefactor1 = this.channel2_scalefactor2 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor1 = this.channel2_scalefactor3;
                        break;
                    }
                    case 3: {
                        this.channel2_scalefactor1 = scalefactors[bitstream.get_bits(6)];
                        this.channel2_scalefactor2 = this.channel2_scalefactor3 = scalefactors[bitstream.get_bits(6)];
                    }
                }
            }
        }

        public boolean read_sampledata(Bitstream bitstream) {
            return super.read_sampledata(bitstream);
        }

        public boolean put_next_sample(int n2, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2) {
            if (this.allocation != 0) {
                float f2 = this.samples[this.samplenumber];
                if (this.groupingtable[0] == null) {
                    f2 = (f2 + this.d[0]) * this.c[0];
                }
                if (n2 == 0) {
                    float f3 = f2;
                    if (this.groupnumber <= 4) {
                        f2 *= this.scalefactor1;
                        f3 *= this.channel2_scalefactor1;
                    } else if (this.groupnumber <= 8) {
                        f2 *= this.scalefactor2;
                        f3 *= this.channel2_scalefactor2;
                    } else {
                        f2 *= this.scalefactor3;
                        f3 *= this.channel2_scalefactor3;
                    }
                    synthesisFilter.input_sample(f2, this.subbandnumber);
                    synthesisFilter2.input_sample(f3, this.subbandnumber);
                } else if (n2 == 1) {
                    f2 = this.groupnumber <= 4 ? (f2 *= this.scalefactor1) : (this.groupnumber <= 8 ? (f2 *= this.scalefactor2) : (f2 *= this.scalefactor3));
                    synthesisFilter.input_sample(f2, this.subbandnumber);
                } else {
                    f2 = this.groupnumber <= 4 ? (f2 *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (f2 *= this.channel2_scalefactor2) : (f2 *= this.channel2_scalefactor3));
                    synthesisFilter.input_sample(f2, this.subbandnumber);
                }
            }
            return ++this.samplenumber == 3;
        }
    }

    static class SubbandLayer2
    extends LayerIDecoder.Subband {
        public static final float[] grouping_5bits = new float[]{-0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f};
        public static final float[] grouping_7bits = new float[]{-0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.4f, -0.8f, -0.4f, 0.0f, -0.8f, -0.4f, 0.4f, -0.8f, -0.4f, 0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.4f, -0.4f, -0.4f, 0.0f, -0.4f, -0.4f, 0.4f, -0.4f, -0.4f, 0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.4f, 0.0f, -0.4f, 0.0f, 0.0f, -0.4f, 0.4f, 0.0f, -0.4f, 0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.4f, 0.4f, -0.4f, 0.0f, 0.4f, -0.4f, 0.4f, 0.4f, -0.4f, 0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.4f, 0.8f, -0.4f, 0.0f, 0.8f, -0.4f, 0.4f, 0.8f, -0.4f, 0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.4f, -0.8f, 0.0f, 0.0f, -0.8f, 0.0f, 0.4f, -0.8f, 0.0f, 0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.4f, -0.4f, 0.0f, 0.0f, -0.4f, 0.0f, 0.4f, -0.4f, 0.0f, 0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.0f, 0.0f, 0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.4f, 0.4f, 0.0f, 0.0f, 0.4f, 0.0f, 0.4f, 0.4f, 0.0f, 0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.4f, 0.8f, 0.0f, 0.0f, 0.8f, 0.0f, 0.4f, 0.8f, 0.0f, 0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.4f, -0.8f, 0.4f, 0.0f, -0.8f, 0.4f, 0.4f, -0.8f, 0.4f, 0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.4f, -0.4f, 0.4f, 0.0f, -0.4f, 0.4f, 0.4f, -0.4f, 0.4f, 0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.4f, 0.0f, 0.4f, 0.0f, 0.0f, 0.4f, 0.4f, 0.0f, 0.4f, 0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.4f, 0.4f, 0.4f, 0.0f, 0.4f, 0.4f, 0.4f, 0.4f, 0.4f, 0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.4f, 0.8f, 0.4f, 0.0f, 0.8f, 0.4f, 0.4f, 0.8f, 0.4f, 0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.4f, -0.8f, 0.8f, 0.0f, -0.8f, 0.8f, 0.4f, -0.8f, 0.8f, 0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.4f, -0.4f, 0.8f, 0.0f, -0.4f, 0.8f, 0.4f, -0.4f, 0.8f, 0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.4f, 0.0f, 0.8f, 0.0f, 0.0f, 0.8f, 0.4f, 0.0f, 0.8f, 0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.4f, 0.4f, 0.8f, 0.0f, 0.4f, 0.8f, 0.4f, 0.4f, 0.8f, 0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.4f, 0.8f, 0.8f, 0.0f, 0.8f, 0.8f, 0.4f, 0.8f, 0.8f, 0.8f, 0.8f, 0.8f};
        public static final float[] grouping_10bits = new float[]{-0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f};
        public static final int[] table_ab1_codelength = new int[]{0, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        public static final float[][] table_ab1_groupingtables = new float[][]{null, grouping_5bits, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        public static final float[] table_ab1_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f, 3.0517578E-5f};
        public static final float[] table_ab1_c = new float[]{0.0f, 1.3333334f, 1.1428572f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f, 1.0000153f};
        public static final float[] table_ab1_d = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f, 3.051758E-5f};
        public static final float[][] table_ab234_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, null, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null};
        public static final int[] table_ab2_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16};
        public static final float[] table_ab2_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.0517578E-5f};
        public static final float[] table_ab2_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.0000153f};
        public static final float[] table_ab2_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.051758E-5f};
        public static final int[] table_ab3_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 16};
        public static final float[] table_ab3_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 3.0517578E-5f};
        public static final float[] table_ab3_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0000153f};
        public static final float[] table_ab3_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 3.051758E-5f};
        public static final int[] table_ab4_codelength = new int[]{0, 5, 7, 16};
        public static final float[] table_ab4_factor = new float[]{0.0f, 0.5f, 0.25f, 3.0517578E-5f};
        public static final float[] table_ab4_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.0000153f};
        public static final float[] table_ab4_d = new float[]{0.0f, 0.5f, 0.5f, 3.051758E-5f};
        public static final int[] table_cd_codelength = new int[]{0, 5, 7, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        public static final float[][] table_cd_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null, null};
        public static final float[] table_cd_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f};
        public static final float[] table_cd_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f};
        public static final float[] table_cd_d = new float[]{0.0f, 0.5f, 0.5f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f};
        protected int subbandnumber;
        protected int allocation;
        protected int scfsi;
        protected float scalefactor1;
        protected float scalefactor2;
        protected float scalefactor3;
        protected int[] codelength = new int[]{0};
        protected float[][] groupingtable = new float[2][];
        protected float[] factor = new float[]{0.0f};
        protected int groupnumber;
        protected int samplenumber;
        protected float[] samples = new float[3];
        protected float[] c = new float[]{0.0f};
        protected float[] d = new float[]{0.0f};

        public SubbandLayer2(int n2) {
            this.subbandnumber = n2;
            this.samplenumber = 0;
            this.groupnumber = 0;
        }

        protected int get_allocationlength(Header header) {
            if (header.version() == 1) {
                int n2 = header.bitrate_index();
                if (header.mode() != 3) {
                    n2 = n2 == 4 ? 1 : (n2 -= 4);
                }
                if (n2 == 1 || n2 == 2) {
                    if (this.subbandnumber <= 1) {
                        return 4;
                    }
                    return 3;
                }
                if (this.subbandnumber <= 10) {
                    return 4;
                }
                if (this.subbandnumber <= 22) {
                    return 3;
                }
                return 2;
            }
            if (this.subbandnumber <= 3) {
                return 4;
            }
            if (this.subbandnumber <= 10) {
                return 3;
            }
            return 2;
        }

        protected void prepare_sample_reading(Header header, int n2, int n3, float[] fArray, int[] nArray, float[] fArray2, float[] fArray3) {
            int n4 = header.bitrate_index();
            if (header.mode() != 3) {
                n4 = n4 == 4 ? 1 : (n4 -= 4);
            }
            if (n4 == 1 || n4 == 2) {
                this.groupingtable[n3] = table_cd_groupingtables[n2];
                fArray[0] = table_cd_factor[n2];
                nArray[0] = table_cd_codelength[n2];
                fArray2[0] = table_cd_c[n2];
                fArray3[0] = table_cd_d[n2];
            } else if (this.subbandnumber <= 2) {
                this.groupingtable[n3] = table_ab1_groupingtables[n2];
                fArray[0] = table_ab1_factor[n2];
                nArray[0] = table_ab1_codelength[n2];
                fArray2[0] = table_ab1_c[n2];
                fArray3[0] = table_ab1_d[n2];
            } else {
                this.groupingtable[n3] = table_ab234_groupingtables[n2];
                if (this.subbandnumber <= 10) {
                    fArray[0] = table_ab2_factor[n2];
                    nArray[0] = table_ab2_codelength[n2];
                    fArray2[0] = table_ab2_c[n2];
                    fArray3[0] = table_ab2_d[n2];
                } else if (this.subbandnumber <= 22) {
                    fArray[0] = table_ab3_factor[n2];
                    nArray[0] = table_ab3_codelength[n2];
                    fArray2[0] = table_ab3_c[n2];
                    fArray3[0] = table_ab3_d[n2];
                } else {
                    fArray[0] = table_ab4_factor[n2];
                    nArray[0] = table_ab4_codelength[n2];
                    fArray2[0] = table_ab4_c[n2];
                    fArray3[0] = table_ab4_d[n2];
                }
            }
        }

        public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
            int n2 = this.get_allocationlength(header);
            this.allocation = bitstream.get_bits(n2);
            if (crc16 != null) {
                crc16.add_bits(this.allocation, n2);
            }
        }

        public void read_scalefactor_selection(Bitstream bitstream, Crc16 crc16) {
            if (this.allocation != 0) {
                this.scfsi = bitstream.get_bits(2);
                if (crc16 != null) {
                    crc16.add_bits(this.scfsi, 2);
                }
            }
        }

        public void read_scalefactor(Bitstream bitstream, Header header) {
            if (this.allocation != 0) {
                switch (this.scfsi) {
                    case 0: {
                        this.scalefactor1 = scalefactors[bitstream.get_bits(6)];
                        this.scalefactor2 = scalefactors[bitstream.get_bits(6)];
                        this.scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        break;
                    }
                    case 1: {
                        this.scalefactor1 = this.scalefactor2 = scalefactors[bitstream.get_bits(6)];
                        this.scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        break;
                    }
                    case 2: {
                        this.scalefactor2 = this.scalefactor3 = scalefactors[bitstream.get_bits(6)];
                        this.scalefactor1 = this.scalefactor3;
                        break;
                    }
                    case 3: {
                        this.scalefactor1 = scalefactors[bitstream.get_bits(6)];
                        this.scalefactor2 = this.scalefactor3 = scalefactors[bitstream.get_bits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.allocation, 0, this.factor, this.codelength, this.c, this.d);
            }
        }

        public boolean read_sampledata(Bitstream bitstream) {
            if (this.allocation != 0) {
                if (this.groupingtable[0] != null) {
                    int n2 = bitstream.get_bits(this.codelength[0]);
                    n2 += n2 << 1;
                    float[] fArray = this.samples;
                    float[] fArray2 = this.groupingtable[0];
                    int n3 = 0;
                    int n4 = n2;
                    if (n4 > fArray2.length - 3) {
                        n4 = fArray2.length - 3;
                    }
                    fArray[n3] = fArray2[n4];
                    fArray[++n3] = fArray2[++n4];
                    fArray[++n3] = fArray2[++n4];
                } else {
                    this.samples[0] = (float)((double)((float)bitstream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                    this.samples[1] = (float)((double)((float)bitstream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                    this.samples[2] = (float)((double)((float)bitstream.get_bits(this.codelength[0]) * this.factor[0]) - 1.0);
                }
            }
            this.samplenumber = 0;
            return ++this.groupnumber == 12;
        }

        public boolean put_next_sample(int n2, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2) {
            if (this.allocation != 0 && n2 != 2) {
                float f2 = this.samples[this.samplenumber];
                if (this.groupingtable[0] == null) {
                    f2 = (f2 + this.d[0]) * this.c[0];
                }
                f2 = this.groupnumber <= 4 ? (f2 *= this.scalefactor1) : (this.groupnumber <= 8 ? (f2 *= this.scalefactor2) : (f2 *= this.scalefactor3));
                synthesisFilter.input_sample(f2, this.subbandnumber);
            }
            return ++this.samplenumber == 3;
        }
    }
}

