/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.sftp.SftpFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SftpAdapter
implements RemoteFS {
    private int port = 22;
    private boolean passiveMode;
    private boolean forceUTF8;
    private boolean connected;
    private Session session = null;
    private ChannelSftp channelSftp = null;
    private SftpProgressMonitor monitor = null;

    public void setPort(int port) throws RemoteFSException {
        this.port = port;
    }

    public int getPort() throws RemoteFSException {
        return this.port;
    }

    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.forceUTF8 = force;
    }

    public boolean isForceUTF8() throws RemoteFSException {
        return this.forceUTF8;
    }

    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.passiveMode = mode;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public String getDirectory() throws RemoteFSException, IOException {
        return this.channelSftp.pwd();
    }

    public void setDirectory(String directory) throws RemoteFSException, IOException {
        try {
            this.channelSftp.cd(this.toUTF8(directory));
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void toParentDirectory() throws RemoteFSException, IOException {
        try {
            this.channelSftp.cd("..");
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void createDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.channelSftp.mkdir(this.toUTF8(name));
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void removeDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.channelSftp.rmdir(this.toUTF8(name));
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        if (!this.connected) {
            JSch jsch = new JSch();
            try {
                this.session = jsch.getSession(user, server, this.port);
                MyUserInfo ui = new MyUserInfo(password);
                this.session.setUserInfo(ui);
                this.session.connect();
                Channel channel = this.session.openChannel("sftp");
                channel.connect();
                this.channelSftp = (ChannelSftp)channel;
                this.connected = true;
            }
            catch (JSchException e2) {
                throw new RemoteFSException(e2);
            }
        }
    }

    public void abortConnect() {
        this.session.disconnect();
    }

    public void disconnect() throws IOException, RemoteFSException {
        if (!this.connected) {
            throw new RemoteFSException("Not connected to remote server");
        }
        this.connected = false;
        this.session.disconnect();
    }

    public boolean isConnected() throws RemoteFSException {
        return this.connected;
    }

    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getFiles(".");
    }

    public RemoteFile[] getFiles(String dir2) throws IOException, RemoteFSException {
        try {
            if (dir2.equals("")) {
                dir2 = ".";
            }
            dir2 = this.toUTF8(dir2);
            Vector ls = this.channelSftp.ls(dir2);
            RemoteFile[] files = new SftpFile[ls.size()];
            for (int i2 = 0; i2 < ls.size(); ++i2) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)ls.get(i2);
                files[i2] = new SftpFile(entry, this);
            }
            return files;
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void putFile(File file) throws IOException, RemoteFSException {
        this.putFile(file, ".");
    }

    public void putFile(File file, String path) throws IOException, RemoteFSException {
        String src = file.getAbsolutePath();
        path = this.toUTF8(path);
        int mode = 0;
        try {
            if (this.monitor != null) {
                this.channelSftp.put(new FileInputStream(file), path, this.monitor, mode);
            } else {
                this.channelSftp.put((InputStream)new FileInputStream(file), path, mode);
            }
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void removeFile(String filename) throws IOException, RemoteFSException {
        try {
            this.channelSftp.rm(this.toUTF8(filename));
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void setProgressMonitor(final RemoteFSProgressMonitor monitor) {
        this.monitor = new SftpProgressMonitor(){
            int bytesTransferred = 0;

            public void init(int int0, String string, String string2, long long3) {
                this.bytesTransferred = 0;
            }

            public boolean count(long long0) {
                this.bytesTransferred = (int)((long)this.bytesTransferred + long0);
                monitor.bytesTransferred(this.bytesTransferred);
                return true;
            }

            public void end() {
            }
        };
    }

    public void rename(String from, String to) throws RemoteFSException, IOException {
        try {
            this.channelSftp.rename(this.toUTF8(from), this.toUTF8(to));
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    String toUTF8(String s2) {
        if (!this.forceUTF8) {
            return s2;
        }
        byte[] buf = null;
        try {
            buf = s2.getBytes("UTF-8");
            return new String(buf);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s2;
        }
    }

    String fromUTF8(String s2) {
        if (!this.forceUTF8) {
            return s2;
        }
        byte[] buf = s2.getBytes();
        try {
            s2 = new String(buf, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s2;
    }

    public boolean exists(String path) throws IOException, RemoteFSException {
        try {
            return this.channelSftp.stat(this.toUTF8(path)) != null;
        }
        catch (SftpException e2) {
            return false;
        }
    }

    public static class MyUserInfo
    implements UserInfo {
        private String passwd;

        public MyUserInfo(String password) {
            this.passwd = password;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }
    }
}

