/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs;

import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSFactory;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.RemoteFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import se.datadosen.util.IO;

public class RemoteFSBean
implements RemoteFS {
    private RemoteFS remoteFS = null;
    private boolean secure = false;
    private String currentDirectory = "";
    private String server;
    private String user;
    private String password;
    public static RemoteFileFilter noDotDotDotFileFilter = new RemoteFileFilter(){

        public boolean accept(RemoteFile rf) {
            String name = rf.getName();
            return !name.equals(".") && !name.equals("..");
        }
    };

    public void setSecure(boolean sec) {
        if (sec != this.secure) {
            this.remoteFS = null;
        }
        this.secure = sec;
    }

    public boolean isSecure() {
        return this.secure;
    }

    private RemoteFS getRemoteFS() throws RemoteFSException {
        if (this.remoteFS == null) {
            this.remoteFS = !this.secure ? RemoteFSFactory.getRemoteFS("ftp") : RemoteFSFactory.getRemoteFS("sftp");
        }
        return this.remoteFS;
    }

    public void testConnection(String server, String user, String password) throws IOException, RemoteFSException {
        this.connect(server, user, password);
        if (!this.isConnected()) {
            throw new RemoteFSException("Not connected to server");
        }
        this.disconnect();
        if (this.isConnected()) {
            throw new RemoteFSException("Still connected to server");
        }
    }

    public void setPort(int port) throws RemoteFSException {
        this.getRemoteFS().setPort(port);
    }

    public int getPort() throws RemoteFSException {
        return this.getRemoteFS().getPort();
    }

    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.getRemoteFS().setForceUTF8(force);
    }

    public boolean isForceUTF8() throws RemoteFSException {
        return this.getRemoteFS().isForceUTF8();
    }

    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.getRemoteFS().setPassiveMode(mode);
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.getRemoteFS().isPassiveMode();
    }

    public String getDirectory() throws IOException, RemoteFSException {
        return this.getRemoteFS().getDirectory();
    }

    public void setDirectory(String directory) throws IOException, RemoteFSException {
        if (directory.length() == 0) {
            return;
        }
        this.getRemoteFS().setDirectory(directory);
        this.currentDirectory = directory.equals("/") ? "" : IO.combinePaths(this.currentDirectory, directory);
    }

    public void toParentDirectory() throws RemoteFSException, IOException {
        this.getRemoteFS().toParentDirectory();
        int lastSlashIndex = this.currentDirectory.lastIndexOf(47);
        this.currentDirectory = lastSlashIndex == -1 ? "" : this.currentDirectory.substring(0, lastSlashIndex);
    }

    public void createDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().createDirectory(name);
    }

    public void removeDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().removeDirectory(name);
    }

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        this.getRemoteFS().connect(server, user, password);
        this.server = server;
        this.user = user;
        this.password = password;
        this.currentDirectory = "";
    }

    public void abortConnect() throws RemoteFSException, IOException {
        this.getRemoteFS().abortConnect();
    }

    public void reconnect() throws RemoteFSException, IOException {
        this.getRemoteFS().connect(this.server, this.user, this.password);
        if (!"".equals(this.currentDirectory)) {
            this.getRemoteFS().setDirectory(this.currentDirectory);
        }
    }

    public void disconnect() throws IOException, RemoteFSException {
        this.getRemoteFS().disconnect();
    }

    public boolean isConnected() throws RemoteFSException {
        return this.getRemoteFS().isConnected();
    }

    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles();
    }

    public RemoteFile[] getFiles(String dir2) throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles(dir2);
    }

    public RemoteFile[] getFiles(RemoteFileFilter filter) throws IOException, RemoteFSException {
        return this.getFiles(".", filter);
    }

    public RemoteFile[] getFiles(String dir2, RemoteFileFilter filter) throws IOException, RemoteFSException {
        RemoteFile[] allFiles = this.getFiles(dir2);
        LinkedList<RemoteFile> list = new LinkedList<RemoteFile>();
        for (int i2 = 0; i2 < allFiles.length; ++i2) {
            if (!filter.accept(allFiles[i2])) continue;
            list.addLast(allFiles[i2]);
        }
        return list.toArray(new RemoteFile[list.size()]);
    }

    public void putFile(File file) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file);
    }

    public void putFile(File file, String path) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file, path);
    }

    public void removeFile(String filename) throws IOException, RemoteFSException {
        this.getRemoteFS().removeFile(filename);
    }

    public void setProgressMonitor(RemoteFSProgressMonitor monitor) throws RemoteFSException {
        this.getRemoteFS().setProgressMonitor(monitor);
    }

    public void rename(String from, String to) throws IOException, RemoteFSException {
        this.getRemoteFS().rename(from, to);
    }

    public boolean exists(String path) throws IOException, RemoteFSException {
        return this.getRemoteFS().exists(path);
    }
}

