/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class KnownHosts
implements HostKeyRepository {
    private static final String _known_hosts = "known_hosts";
    private JSch jsch = null;
    private String known_hosts = null;
    private Vector pool = null;
    private MAC hmacsha1 = null;
    private static final byte[] space = new byte[]{32};
    private static final byte[] cr = "\n".getBytes();

    KnownHosts(JSch jSch) {
        this.jsch = jSch;
        this.pool = new Vector();
    }

    void setKnownHosts(String string) throws JSchException {
        try {
            this.known_hosts = string;
            FileInputStream fileInputStream = new FileInputStream(string);
            this.setKnownHosts(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    void setKnownHosts(InputStream inputStream) throws JSchException {
        this.pool.removeAllElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        try {
            InputStream inputStream2 = inputStream;
            String string = null;
            byte[] byArray = new byte[1024];
            int n2 = 0;
            block2: while (true) {
                byte by2;
                Object object;
                int n3;
                n2 = 0;
                while (true) {
                    if ((n3 = inputStream2.read()) == -1) {
                        if (n2 != 0) break;
                        break block2;
                    }
                    if (n3 == 13) continue;
                    if (n3 == 10) break;
                    if (byArray.length <= n2) {
                        if (n2 > 10240) break;
                        object = new byte[byArray.length * 2];
                        System.arraycopy(byArray, 0, object, 0, byArray.length);
                        byArray = object;
                    }
                    byArray[n2++] = (byte)n3;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    by2 = byArray[n3];
                    if (by2 == 32 || by2 == 9) {
                        continue;
                    }
                    if (by2 != 35) break;
                    this.addInvalidLine(new String(byArray, 0, n2));
                    continue block2;
                }
                if (n3 >= n2) {
                    this.addInvalidLine(new String(byArray, 0, n2));
                    continue;
                }
                stringBuffer.setLength(0);
                while (n3 < n2) {
                    if ((by2 = byArray[n3++]) == 32 || by2 == 9) break;
                    stringBuffer.append((char)by2);
                }
                String string2 = stringBuffer.toString();
                if (n3 >= n2 || string2.length() == 0) {
                    this.addInvalidLine(new String(byArray, 0, n2));
                    continue;
                }
                stringBuffer.setLength(0);
                int n4 = -1;
                while (n3 < n2) {
                    if ((by2 = byArray[n3++]) == 32 || by2 == 9) break;
                    stringBuffer.append((char)by2);
                }
                if (stringBuffer.toString().equals("ssh-dss")) {
                    n4 = 1;
                } else if (stringBuffer.toString().equals("ssh-rsa")) {
                    n4 = 2;
                } else {
                    n3 = n2;
                }
                if (n3 >= n2) {
                    this.addInvalidLine(new String(byArray, 0, n2));
                    continue;
                }
                stringBuffer.setLength(0);
                while (n3 < n2) {
                    if ((by2 = byArray[n3++]) == 13) continue;
                    if (by2 == 10) break;
                    stringBuffer.append((char)by2);
                }
                string = stringBuffer.toString();
                if (string.length() == 0) {
                    this.addInvalidLine(new String(byArray, 0, n2));
                    continue;
                }
                object = null;
                object = new HashedHostKey(string2, n4, Util.fromBase64(string.getBytes(), 0, string.length()));
                this.pool.addElement(object);
            }
            inputStream2.close();
            if (bl2) {
                throw new JSchException("KnownHosts: invalid format");
            }
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    private void addInvalidLine(String string) throws JSchException {
        HostKey hostKey = new HostKey(string, 3, null);
        this.pool.addElement(hostKey);
    }

    String getKnownHostsFile() {
        return this.known_hosts;
    }

    public String getKnownHostsRepositoryID() {
        return this.known_hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int check(String string, byte[] byArray) {
        int n2 = 1;
        if (string == null) {
            return n2;
        }
        int n3 = this.getType(byArray);
        Vector vector = this.pool;
        synchronized (vector) {
            int n4 = 0;
            while (n4 < this.pool.size()) {
                HostKey hostKey = (HostKey)this.pool.elementAt(n4);
                if (hostKey.isMatched(string) && hostKey.type == n3) {
                    if (Util.array_equals(hostKey.key, byArray)) {
                        return 0;
                    }
                    n2 = 2;
                }
                ++n4;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HostKey hostKey, UserInfo userInfo) {
        int n2 = hostKey.type;
        String string = hostKey.getHost();
        byte[] byArray = hostKey.key;
        HostKey hostKey2 = null;
        Vector vector = this.pool;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < this.pool.size()) {
                hostKey2 = (HostKey)this.pool.elementAt(n3);
                if (!hostKey2.isMatched(string) || hostKey2.type == n2) {
                    // empty if block
                }
                ++n3;
            }
        }
        hostKey2 = hostKey;
        this.pool.addElement(hostKey2);
        String string2 = this.getKnownHostsRepositoryID();
        if (string2 != null) {
            boolean bl2 = true;
            File file = new File(string2);
            if (!file.exists()) {
                bl2 = false;
                if (userInfo != null) {
                    bl2 = userInfo.promptYesNo(string2 + " does not exist.\n" + "Are you sure you want to create it?");
                    file = file.getParentFile();
                    if (bl2 && file != null && !file.exists() && (bl2 = userInfo.promptYesNo("The parent directory " + file + " does not exist.\n" + "Are you sure you want to create it?"))) {
                        if (!file.mkdirs()) {
                            userInfo.showMessage(file + " has not been created.");
                            bl2 = false;
                        } else {
                            userInfo.showMessage(file + " has been succesfully created.\nPlease check its access permission.");
                        }
                    }
                    if (file == null) {
                        bl2 = false;
                    }
                }
            }
            if (bl2) {
                try {
                    this.sync(string2);
                }
                catch (Exception exception) {
                    System.err.println("sync known_hosts: " + exception);
                }
            }
        }
    }

    public HostKey[] getHostKey() {
        return this.getHostKey(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostKey[] getHostKey(String string, String string2) {
        Vector vector = this.pool;
        synchronized (vector) {
            Object object;
            int n2;
            block8: {
                HostKey hostKey;
                n2 = 0;
                int n3 = 0;
                while (n3 < this.pool.size()) {
                    hostKey = (HostKey)this.pool.elementAt(n3);
                    if (hostKey.type != 3 && (string == null || hostKey.isMatched(string) && (string2 == null || hostKey.getType().equals(string2)))) {
                        ++n2;
                    }
                    ++n3;
                }
                if (n2 != 0) break block8;
                hostKey = null;
                return hostKey;
            }
            HostKey[] hostKeyArray = new HostKey[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.pool.size()) {
                object = (HostKey)this.pool.elementAt(n5);
                if (((HostKey)object).type != 3 && (string == null || ((HostKey)object).isMatched(string) && (string2 == null || ((HostKey)object).getType().equals(string2)))) {
                    hostKeyArray[n4++] = object;
                }
                ++n5;
            }
            object = hostKeyArray;
            return object;
        }
    }

    public void remove(String string, String string2) {
        this.remove(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string, String string2, byte[] byArray) {
        boolean bl2 = false;
        Vector vector = this.pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.pool.size()) {
                HostKey hostKey = (HostKey)this.pool.elementAt(n2);
                if (string == null || hostKey.isMatched(string) && (string2 == null || hostKey.getType().equals(string2) && (byArray == null || Util.array_equals(byArray, hostKey.key)))) {
                    String string3 = hostKey.getHost();
                    if (string3.equals(string) || hostKey instanceof HashedHostKey && ((HashedHostKey)hostKey).isHashed()) {
                        this.pool.removeElement(hostKey);
                    } else {
                        hostKey.host = this.deleteSubString(string3, string);
                    }
                    bl2 = true;
                }
                ++n2;
            }
        }
        if (bl2) {
            try {
                this.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void sync() throws IOException {
        if (this.known_hosts != null) {
            this.sync(this.known_hosts);
        }
    }

    protected synchronized void sync(String string) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.dump(fileOutputStream);
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(OutputStream outputStream) throws IOException {
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                int n2 = 0;
                while (n2 < this.pool.size()) {
                    HostKey hostKey = (HostKey)this.pool.elementAt(n2);
                    String string = hostKey.getHost();
                    String string2 = hostKey.getType();
                    if (string2.equals("UNKNOWN")) {
                        outputStream.write(string.getBytes());
                        outputStream.write(cr);
                    } else {
                        outputStream.write(string.getBytes());
                        outputStream.write(space);
                        outputStream.write(string2.getBytes());
                        outputStream.write(space);
                        outputStream.write(hostKey.getKey().getBytes());
                        outputStream.write(cr);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private int getType(byte[] byArray) {
        if (byArray[8] == 100) {
            return 1;
        }
        if (byArray[8] == 114) {
            return 2;
        }
        return 3;
    }

    private String deleteSubString(String string, String string2) {
        int n2 = 0;
        int n3 = string2.length();
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.indexOf(44, n2);
            if (n5 == -1) break;
            if (!string2.equals(string.substring(n2, n5))) {
                n2 = n5 + 1;
                continue;
            }
            return string.substring(0, n2) + string.substring(n5 + 1);
        }
        if (string.endsWith(string2) && n4 - n2 == n3) {
            return string.substring(0, n3 == n4 ? 0 : n4 - n3 - 1);
        }
        return string;
    }

    private synchronized MAC getHMACSHA1() {
        if (this.hmacsha1 == null) {
            try {
                Class<?> clazz = Class.forName(this.jsch.getConfig("hmac-sha1"));
                this.hmacsha1 = (MAC)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("hmacsha1: " + exception);
            }
        }
        return this.hmacsha1;
    }

    HostKey createHashedHostKey(String string, byte[] byArray) throws JSchException {
        HashedHostKey hashedHostKey = new HashedHostKey(string, byArray);
        hashedHostKey.hash();
        return hashedHostKey;
    }

    class HashedHostKey
    extends HostKey {
        private static final String HASH_MAGIC = "|1|";
        private static final String HASH_DELIM = "|";
        private boolean hashed = false;
        byte[] salt = null;
        byte[] hash = null;

        HashedHostKey(String string, byte[] byArray) throws JSchException {
            this(string, 0, byArray);
        }

        HashedHostKey(String string, int n2, byte[] byArray) throws JSchException {
            super(string, n2, byArray);
            if (this.host.startsWith(HASH_MAGIC) && this.host.substring(HASH_MAGIC.length()).indexOf(HASH_DELIM) > 0) {
                String string2 = this.host.substring(HASH_MAGIC.length());
                String string3 = string2.substring(0, string2.indexOf(HASH_DELIM));
                String string4 = string2.substring(string2.indexOf(HASH_DELIM) + 1);
                this.salt = Util.fromBase64(string3.getBytes(), 0, string3.length());
                this.hash = Util.fromBase64(string4.getBytes(), 0, string4.length());
                if (this.salt.length != 20 || this.hash.length != 20) {
                    this.salt = null;
                    this.hash = null;
                    return;
                }
                this.hashed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isMatched(String string) {
            if (!this.hashed) {
                return super.isMatched(string);
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            try {
                MAC mAC2 = mAC;
                synchronized (mAC2) {
                    mAC.init(this.salt);
                    byte[] byArray = string.getBytes();
                    mAC.update(byArray, 0, byArray.length);
                    byte[] byArray2 = new byte[mAC.getBlockSize()];
                    mAC.doFinal(byArray2, 0);
                    boolean bl2 = Util.array_equals(this.hash, byArray2);
                    return bl2;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                return false;
            }
        }

        boolean isHashed() {
            return this.hashed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void hash() {
            Object object;
            Object object2;
            if (this.hashed) {
                return;
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            if (this.salt == null) {
                object = object2 = Session.random;
                synchronized (object) {
                    this.salt = new byte[mAC.getBlockSize()];
                    object2.fill(this.salt, 0, this.salt.length);
                }
            }
            try {
                object2 = mAC;
                synchronized (object2) {
                    mAC.init(this.salt);
                    object = this.host.getBytes();
                    mAC.update((byte[])object, 0, ((Object)object).length);
                    this.hash = new byte[mAC.getBlockSize()];
                    mAC.doFinal(this.hash, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = HASH_MAGIC + new String(Util.toBase64(this.salt, 0, this.salt.length)) + HASH_DELIM + new String(Util.toBase64(this.hash, 0, this.hash.length));
            this.hashed = true;
        }
    }
}

