/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenRSA;
import com.jcraft.jsch.Util;

public class KeyPairRSA
extends KeyPair {
    private byte[] prv_array;
    private byte[] pub_array;
    private byte[] n_array;
    private byte[] p_array;
    private byte[] q_array;
    private byte[] ep_array;
    private byte[] eq_array;
    private byte[] c_array;
    private int key_size = 1024;
    private static final byte[] begin = "-----BEGIN RSA PRIVATE KEY-----".getBytes();
    private static final byte[] end = "-----END RSA PRIVATE KEY-----".getBytes();
    private static final byte[] sshrsa = "ssh-rsa".getBytes();

    public KeyPairRSA(JSch jSch) {
        super(jSch);
    }

    void generate(int n2) throws JSchException {
        this.key_size = n2;
        try {
            Class<?> clazz = Class.forName(this.jsch.getConfig("keypairgen.rsa"));
            KeyPairGenRSA keyPairGenRSA = (KeyPairGenRSA)clazz.newInstance();
            keyPairGenRSA.init(n2);
            this.pub_array = keyPairGenRSA.getE();
            this.prv_array = keyPairGenRSA.getD();
            this.n_array = keyPairGenRSA.getN();
            this.p_array = keyPairGenRSA.getP();
            this.q_array = keyPairGenRSA.getQ();
            this.ep_array = keyPairGenRSA.getEP();
            this.eq_array = keyPairGenRSA.getEQ();
            this.c_array = keyPairGenRSA.getC();
            keyPairGenRSA = null;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    byte[] getBegin() {
        return begin;
    }

    byte[] getEnd() {
        return end;
    }

    byte[] getPrivateKey() {
        int n2 = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.n_array.length) + this.n_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length + 1 + this.countLength(this.p_array.length) + this.p_array.length + 1 + this.countLength(this.q_array.length) + this.q_array.length + 1 + this.countLength(this.ep_array.length) + this.ep_array.length + 1 + this.countLength(this.eq_array.length) + this.eq_array.length + 1 + this.countLength(this.c_array.length) + this.c_array.length;
        int n3 = 1 + this.countLength(n2) + n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        n4 = this.writeSEQUENCE(byArray, n4, n2);
        n4 = this.writeINTEGER(byArray, n4, new byte[1]);
        n4 = this.writeINTEGER(byArray, n4, this.n_array);
        n4 = this.writeINTEGER(byArray, n4, this.pub_array);
        n4 = this.writeINTEGER(byArray, n4, this.prv_array);
        n4 = this.writeINTEGER(byArray, n4, this.p_array);
        n4 = this.writeINTEGER(byArray, n4, this.q_array);
        n4 = this.writeINTEGER(byArray, n4, this.ep_array);
        n4 = this.writeINTEGER(byArray, n4, this.eq_array);
        n4 = this.writeINTEGER(byArray, n4, this.c_array);
        return byArray;
    }

    boolean parse(byte[] byArray) {
        try {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (this.vendor == 1) {
                if (byArray[n3] != 48) {
                    Buffer buffer = new Buffer(byArray);
                    this.pub_array = buffer.getMPIntBits();
                    this.prv_array = buffer.getMPIntBits();
                    this.n_array = buffer.getMPIntBits();
                    byte[] byArray2 = buffer.getMPIntBits();
                    this.p_array = buffer.getMPIntBits();
                    this.q_array = buffer.getMPIntBits();
                    return true;
                }
                return false;
            }
            int n5 = ++n3;
            ++n3;
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            if (byArray[n3] != 2) {
                return false;
            }
            int n6 = ++n3;
            ++n3;
            n4 = byArray[n6] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            n3 += n4;
            int n7 = ++n3;
            ++n3;
            n4 = byArray[n7] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.n_array = new byte[n4];
            System.arraycopy(byArray, n3, this.n_array, 0, n4);
            n3 += n4;
            int n8 = ++n3;
            ++n3;
            n4 = byArray[n8] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.pub_array = new byte[n4];
            System.arraycopy(byArray, n3, this.pub_array, 0, n4);
            n3 += n4;
            int n9 = ++n3;
            ++n3;
            n4 = byArray[n9] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.prv_array = new byte[n4];
            System.arraycopy(byArray, n3, this.prv_array, 0, n4);
            n3 += n4;
            int n10 = ++n3;
            ++n3;
            n4 = byArray[n10] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.p_array = new byte[n4];
            System.arraycopy(byArray, n3, this.p_array, 0, n4);
            n3 += n4;
            int n11 = ++n3;
            ++n3;
            n4 = byArray[n11] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.q_array = new byte[n4];
            System.arraycopy(byArray, n3, this.q_array, 0, n4);
            n3 += n4;
            int n12 = ++n3;
            ++n3;
            n4 = byArray[n12] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.ep_array = new byte[n4];
            System.arraycopy(byArray, n3, this.ep_array, 0, n4);
            n3 += n4;
            int n13 = ++n3;
            ++n3;
            n4 = byArray[n13] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.eq_array = new byte[n4];
            System.arraycopy(byArray, n3, this.eq_array, 0, n4);
            n3 += n4;
            int n14 = ++n3;
            ++n3;
            n4 = byArray[n14] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.c_array = new byte[n4];
            System.arraycopy(byArray, n3, this.c_array, 0, n4);
            n3 += n4;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public byte[] getPublicKeyBlob() {
        byte[] byArray = super.getPublicKeyBlob();
        if (byArray != null) {
            return byArray;
        }
        if (this.pub_array == null) {
            return null;
        }
        Buffer buffer = new Buffer(sshrsa.length + 4 + this.pub_array.length + 4 + this.n_array.length + 4);
        buffer.putString(sshrsa);
        buffer.putString(this.pub_array);
        buffer.putString(this.n_array);
        return buffer.buffer;
    }

    byte[] getKeyTypeName() {
        return sshrsa;
    }

    public int getKeyType() {
        return 2;
    }

    public int getKeySize() {
        return this.key_size;
    }

    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

