/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPairDSA;
import com.jcraft.jsch.KeyPairRSA;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class KeyPair {
    public static final int ERROR = 0;
    public static final int DSA = 1;
    public static final int RSA = 2;
    public static final int UNKNOWN = 3;
    static final int VENDOR_OPENSSH = 0;
    static final int VENDOR_FSECURE = 1;
    int vendor = 0;
    private static final byte[] cr = "\n".getBytes();
    JSch jsch = null;
    private Cipher cipher;
    private HASH hash;
    private Random random;
    private byte[] passphrase;
    static byte[][] header = new byte[][]{"Proc-Type: 4,ENCRYPTED".getBytes(), "DEK-Info: DES-EDE3-CBC,".getBytes()};
    private static byte[] space = " ".getBytes();
    private boolean encrypted = false;
    private byte[] data = null;
    private byte[] iv = null;
    private byte[] publickeyblob = null;

    public static KeyPair genKeyPair(JSch jSch, int n2) throws JSchException {
        return KeyPair.genKeyPair(jSch, n2, 1024);
    }

    public static KeyPair genKeyPair(JSch jSch, int n2, int n3) throws JSchException {
        KeyPair keyPair = null;
        if (n2 == 1) {
            keyPair = new KeyPairDSA(jSch);
        } else if (n2 == 2) {
            keyPair = new KeyPairRSA(jSch);
        }
        if (keyPair != null) {
            ((KeyPair)keyPair).generate(n3);
        }
        return keyPair;
    }

    abstract void generate(int var1) throws JSchException;

    abstract byte[] getBegin();

    abstract byte[] getEnd();

    abstract int getKeySize();

    public KeyPair(JSch jSch) {
        this.jsch = jSch;
    }

    abstract byte[] getPrivateKey();

    public void writePrivateKey(OutputStream outputStream) {
        byte[][] byArrayArray;
        byte[] byArray = this.getPrivateKey();
        byte[] byArray2 = this.encrypt(byArray, byArrayArray = new byte[1][]);
        if (byArray2 != byArray) {
            Util.bzero(byArray);
        }
        byte[] byArray3 = byArrayArray[0];
        byte[] byArray4 = Util.toBase64(byArray2, 0, byArray2.length);
        try {
            int n2;
            outputStream.write(this.getBegin());
            outputStream.write(cr);
            if (this.passphrase != null) {
                outputStream.write(header[0]);
                outputStream.write(cr);
                outputStream.write(header[1]);
                n2 = 0;
                while (n2 < byArray3.length) {
                    outputStream.write(KeyPair.b2a((byte)(byArray3[n2] >>> 4 & 0xF)));
                    outputStream.write(KeyPair.b2a((byte)(byArray3[n2] & 0xF)));
                    ++n2;
                }
                outputStream.write(cr);
                outputStream.write(cr);
            }
            for (n2 = 0; n2 < byArray4.length; n2 += 64) {
                if (n2 + 64 < byArray4.length) {
                    outputStream.write(byArray4, n2, 64);
                    outputStream.write(cr);
                    continue;
                }
                outputStream.write(byArray4, n2, byArray4.length - n2);
                outputStream.write(cr);
                break;
            }
            outputStream.write(this.getEnd());
            outputStream.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract byte[] getKeyTypeName();

    public abstract int getKeyType();

    public byte[] getPublicKeyBlob() {
        return this.publickeyblob;
    }

    public void writePublicKey(OutputStream outputStream, String string) {
        byte[] byArray = this.getPublicKeyBlob();
        byte[] byArray2 = Util.toBase64(byArray, 0, byArray.length);
        try {
            outputStream.write(this.getKeyTypeName());
            outputStream.write(space);
            outputStream.write(byArray2, 0, byArray2.length);
            outputStream.write(space);
            outputStream.write(string.getBytes());
            outputStream.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writePublicKey(String string, String string2) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writePublicKey(fileOutputStream, string2);
        fileOutputStream.close();
    }

    public void writeSECSHPublicKey(OutputStream outputStream, String string) {
        byte[] byArray = this.getPublicKeyBlob();
        byte[] byArray2 = Util.toBase64(byArray, 0, byArray.length);
        try {
            outputStream.write("---- BEGIN SSH2 PUBLIC KEY ----".getBytes());
            outputStream.write(cr);
            outputStream.write(("Comment: \"" + string + "\"").getBytes());
            outputStream.write(cr);
            int n2 = 0;
            while (n2 < byArray2.length) {
                int n3 = 70;
                if (byArray2.length - n2 < n3) {
                    n3 = byArray2.length - n2;
                }
                outputStream.write(byArray2, n2, n3);
                outputStream.write(cr);
                n2 += n3;
            }
            outputStream.write("---- END SSH2 PUBLIC KEY ----".getBytes());
            outputStream.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeSECSHPublicKey(String string, String string2) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writeSECSHPublicKey(fileOutputStream, string2);
        fileOutputStream.close();
    }

    public void writePrivateKey(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writePrivateKey(fileOutputStream);
        fileOutputStream.close();
    }

    public String getFingerPrint() {
        byte[] byArray;
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        if ((byArray = this.getPublicKeyBlob()) == null) {
            return null;
        }
        return this.getKeySize() + " " + Util.getFingerPrint(this.hash, byArray);
    }

    private byte[] encrypt(byte[] byArray, byte[][] byArray2) {
        if (this.passphrase == null) {
            return byArray;
        }
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        byArray2[0] = new byte[this.cipher.getIVSize()];
        byte[] byArray3 = byArray2[0];
        if (this.random == null) {
            this.random = this.genRandom();
        }
        this.random.fill(byArray3, 0, byArray3.length);
        byte[] byArray4 = this.genKey(this.passphrase, byArray3);
        byte[] byArray5 = byArray;
        int n2 = this.cipher.getIVSize();
        byte[] byArray6 = new byte[(byArray5.length / n2 + 1) * n2];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        int n3 = n2 - byArray5.length % n2;
        int n4 = byArray6.length - 1;
        while (byArray6.length - n3 <= n4) {
            byArray6[n4] = (byte)n3;
            --n4;
        }
        byArray5 = byArray6;
        try {
            this.cipher.init(0, byArray4, byArray3);
            this.cipher.update(byArray5, 0, byArray5.length, byArray5, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Util.bzero(byArray4);
        return byArray5;
    }

    abstract boolean parse(byte[] var1);

    private byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            byte[] byArray4 = this.genKey(byArray2, byArray3);
            this.cipher.init(1, byArray4, byArray3);
            Util.bzero(byArray4);
            byte[] byArray5 = new byte[byArray.length];
            this.cipher.update(byArray, 0, byArray.length, byArray5, 0);
            return byArray5;
        }
        catch (Exception exception) {
            return null;
        }
    }

    int writeSEQUENCE(byte[] byArray, int n2, int n3) {
        byArray[n2++] = 48;
        n2 = this.writeLength(byArray, n2, n3);
        return n2;
    }

    int writeINTEGER(byte[] byArray, int n2, byte[] byArray2) {
        byArray[n2++] = 2;
        n2 = this.writeLength(byArray, n2, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return n2 += byArray2.length;
    }

    /*
     * Unable to fully structure code
     */
    int countLength(int var1_1) {
        var2_2 = 1;
        if (var1_1 > 127) ** GOTO lbl6
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var1_1 >>>= 8;
            ++var2_2;
lbl6:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl7:
        // 1 sources

        return var2_2;
    }

    int writeLength(byte[] byArray, int n2, int n3) {
        int n4 = this.countLength(n3) - 1;
        if (n4 == 0) {
            byArray[n2++] = (byte)n3;
            return n2;
        }
        byArray[n2++] = (byte)(0x80 | n4);
        int n5 = n2 + n4;
        while (n4 > 0) {
            byArray[n2 + n4 - 1] = (byte)(n3 & 0xFF);
            n3 >>>= 8;
            --n4;
        }
        return n5;
    }

    private Random genRandom() {
        if (this.random == null) {
            try {
                Class<?> clazz = Class.forName(this.jsch.getConfig("random"));
                this.random = (Random)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("connect: random " + exception);
            }
        }
        return this.random;
    }

    private HASH genHash() {
        try {
            Class<?> clazz = Class.forName(this.jsch.getConfig("md5"));
            this.hash = (HASH)clazz.newInstance();
            this.hash.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hash;
    }

    private Cipher genCipher() {
        try {
            Class<?> clazz = Class.forName(this.jsch.getConfig("3des-cbc"));
            this.cipher = (Cipher)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cipher;
    }

    synchronized byte[] genKey(byte[] byArray, byte[] byArray2) {
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        byte[] byArray3 = new byte[this.cipher.getBlockSize()];
        int n2 = this.hash.getBlockSize();
        byte[] byArray4 = new byte[byArray3.length / n2 * n2 + (byArray3.length % n2 == 0 ? 0 : n2)];
        try {
            byte[] byArray5 = null;
            if (this.vendor == 0) {
                int n3 = 0;
                while (n3 + n2 <= byArray4.length) {
                    if (byArray5 != null) {
                        this.hash.update(byArray5, 0, byArray5.length);
                    }
                    this.hash.update(byArray, 0, byArray.length);
                    this.hash.update(byArray2, 0, byArray2.length);
                    byArray5 = this.hash.digest();
                    System.arraycopy(byArray5, 0, byArray4, n3, byArray5.length);
                    n3 += byArray5.length;
                }
                System.arraycopy(byArray4, 0, byArray3, 0, byArray3.length);
            } else if (this.vendor == 1) {
                int n4 = 0;
                while (n4 + n2 <= byArray4.length) {
                    if (byArray5 != null) {
                        this.hash.update(byArray5, 0, byArray5.length);
                    }
                    this.hash.update(byArray, 0, byArray.length);
                    byArray5 = this.hash.digest();
                    System.arraycopy(byArray5, 0, byArray4, n4, byArray5.length);
                    n4 += byArray5.length;
                }
                System.arraycopy(byArray4, 0, byArray3, 0, byArray3.length);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return byArray3;
    }

    public void setPassphrase(String string) {
        if (string == null || string.length() == 0) {
            this.setPassphrase((byte[])null);
        } else {
            this.setPassphrase(Util.str2byte(string));
        }
    }

    public void setPassphrase(byte[] byArray) {
        if (byArray != null && byArray.length == 0) {
            byArray = null;
        }
        this.passphrase = byArray;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean decrypt(String string) {
        if (string == null || string.length() == 0) {
            return !this.encrypted;
        }
        return this.decrypt(Util.str2byte(string));
    }

    public boolean decrypt(byte[] byArray) {
        if (!this.encrypted) {
            return true;
        }
        if (byArray == null) {
            return !this.encrypted;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byArray = byArray2;
        byte[] byArray3 = this.decrypt(this.data, byArray, this.iv);
        Util.bzero(byArray);
        if (this.parse(byArray3)) {
            this.encrypted = false;
        }
        return !this.encrypted;
    }

    public static KeyPair load(JSch jSch, String string) throws JSchException {
        String string2 = string + ".pub";
        if (!new File(string2).exists()) {
            string2 = null;
        }
        return KeyPair.load(jSch, string, string2);
    }

    public static KeyPair load(JSch jSch, String string, String string2) throws JSchException {
        Object object;
        int n2;
        int n3;
        byte[] byArray;
        byte[] byArray2;
        boolean bl2;
        byte[] byArray3;
        block60: {
            byArray3 = new byte[8];
            bl2 = true;
            byArray2 = null;
            byArray = null;
            n3 = 0;
            n2 = 0;
            try {
                int n4;
                int n5;
                int n6;
                object = new File(string);
                FileInputStream fileInputStream = new FileInputStream(string);
                byte[] byArray4 = new byte[(int)((File)object).length()];
                int n7 = 0;
                while ((n6 = fileInputStream.read(byArray4, n7, byArray4.length - n7)) > 0) {
                    n7 += n6;
                }
                fileInputStream.close();
                n6 = 0;
                while (n6 < n7) {
                    if (byArray4[n6] == 66 && byArray4[n6 + 1] == 69 && byArray4[n6 + 2] == 71 && byArray4[n6 + 3] == 73) {
                        if (byArray4[n6 += 6] == 68 && byArray4[n6 + 1] == 83 && byArray4[n6 + 2] == 65) {
                            n3 = 1;
                        } else if (byArray4[n6] == 82 && byArray4[n6 + 1] == 83 && byArray4[n6 + 2] == 65) {
                            n3 = 2;
                        } else if (byArray4[n6] == 83 && byArray4[n6 + 1] == 83 && byArray4[n6 + 2] == 72) {
                            n3 = 3;
                            n2 = 1;
                        } else {
                            throw new JSchException("invalid privatekey: " + string);
                        }
                        n6 += 3;
                        continue;
                    }
                    if (byArray4[n6] == 67 && byArray4[n6 + 1] == 66 && byArray4[n6 + 2] == 67 && byArray4[n6 + 3] == 44) {
                        n6 += 4;
                        n5 = 0;
                        while (n5 < byArray3.length) {
                            byArray3[n5] = (byte)((KeyPair.a2b(byArray4[n6++]) << 4 & 0xF0) + (KeyPair.a2b(byArray4[n6++]) & 0xF));
                            ++n5;
                        }
                        continue;
                    }
                    if (byArray4[n6] == 13 && n6 + 1 < byArray4.length && byArray4[n6 + 1] == 10) {
                        ++n6;
                        continue;
                    }
                    if (byArray4[n6] == 10 && n6 + 1 < byArray4.length) {
                        if (byArray4[n6 + 1] == 10) {
                            n6 += 2;
                            break;
                        }
                        if (byArray4[n6 + 1] == 13 && n6 + 2 < byArray4.length && byArray4[n6 + 2] == 10) {
                            n6 += 3;
                            break;
                        }
                        n5 = 0;
                        n4 = n6 + 1;
                        while (n4 < byArray4.length) {
                            if (byArray4[n4] == 10) break;
                            if (byArray4[n4] == 58) {
                                n5 = 1;
                                break;
                            }
                            ++n4;
                        }
                        if (n5 == 0) {
                            ++n6;
                            bl2 = false;
                            break;
                        }
                    }
                    ++n6;
                }
                if (n3 == 0) {
                    throw new JSchException("invalid privatekey: " + string);
                }
                n5 = n6;
                while (n6 < n7) {
                    if (byArray4[n6] == 10) {
                        n4 = byArray4[n6 - 1] == 13 ? 1 : 0;
                        System.arraycopy(byArray4, n6 + 1, byArray4, n6 - (n4 != 0 ? 1 : 0), n7 - n6 - 1 - (n4 != 0 ? 1 : 0));
                        if (n4 != 0) {
                            --n7;
                        }
                        --n7;
                        continue;
                    }
                    if (byArray4[n6] == 45) break;
                    ++n6;
                }
                byArray2 = Util.fromBase64(byArray4, n5, n6 - n5);
                if (byArray2.length > 4 && byArray2[0] == 63 && byArray2[1] == 111 && byArray2[2] == -7 && byArray2[3] == -21) {
                    Buffer buffer = new Buffer(byArray2);
                    buffer.getInt();
                    buffer.getInt();
                    byte[] byArray5 = buffer.getString();
                    byte[] byArray6 = buffer.getString();
                    String string3 = new String(byArray6);
                    if (string3.equals("3des-cbc")) {
                        buffer.getInt();
                        byte[] byArray7 = new byte[byArray2.length - buffer.getOffSet()];
                        buffer.getByte(byArray7);
                        byArray2 = byArray7;
                        bl2 = true;
                        throw new JSchException("unknown privatekey format: " + string);
                    }
                    if (string3.equals("none")) {
                        buffer.getInt();
                        buffer.getInt();
                        bl2 = false;
                        byte[] byArray8 = new byte[byArray2.length - buffer.getOffSet()];
                        buffer.getByte(byArray8);
                        byArray2 = byArray8;
                    }
                }
                if (string2 == null) break block60;
                try {
                    object = new File(string2);
                    fileInputStream = new FileInputStream(string2);
                    byArray4 = new byte[(int)((File)object).length()];
                    n7 = 0;
                    while ((n6 = fileInputStream.read(byArray4, n7, byArray4.length - n7)) > 0) {
                        n7 += n6;
                    }
                    fileInputStream.close();
                    if (byArray4.length > 4 && byArray4[0] == 45 && byArray4[1] == 45 && byArray4[2] == 45 && byArray4[3] == 45) {
                        boolean bl3 = true;
                        n6 = 0;
                        while (byArray4.length > ++n6 && byArray4[n6] != 10) {
                        }
                        if (byArray4.length <= n6) {
                            bl3 = false;
                        }
                        while (bl3) {
                            if (byArray4[n6] == 10) {
                                boolean bl4 = false;
                                int n8 = n6 + 1;
                                while (n8 < byArray4.length) {
                                    if (byArray4[n8] == 10) break;
                                    if (byArray4[n8] == 58) {
                                        bl4 = true;
                                        break;
                                    }
                                    ++n8;
                                }
                                if (!bl4) {
                                    ++n6;
                                    break;
                                }
                            }
                            ++n6;
                        }
                        if (byArray4.length <= n6) {
                            bl3 = false;
                        }
                        n5 = n6;
                        while (bl3 && n6 < n7) {
                            if (byArray4[n6] == 10) {
                                System.arraycopy(byArray4, n6 + 1, byArray4, n6, n7 - n6 - 1);
                                --n7;
                                continue;
                            }
                            if (byArray4[n6] == 45) break;
                            ++n6;
                        }
                        if (bl3) {
                            byArray = Util.fromBase64(byArray4, n5, n6 - n5);
                            if (n3 == 3) {
                                if (byArray[8] == 100) {
                                    n3 = 1;
                                } else if (byArray[8] == 114) {
                                    n3 = 2;
                                }
                            }
                        }
                    } else if (byArray4[0] == 115 && byArray4[1] == 115 && byArray4[2] == 104 && byArray4[3] == 45) {
                        n6 = 0;
                        while (n6 < n7) {
                            if (byArray4[n6] == 32) break;
                            ++n6;
                        }
                        if (++n6 < n7) {
                            n5 = n6;
                            while (n6 < n7) {
                                if (byArray4[n6] == 32) break;
                                ++n6;
                            }
                            byArray = Util.fromBase64(byArray4, n5, n6 - n5);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                if (exception instanceof JSchException) {
                    throw (JSchException)exception;
                }
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
        }
        object = null;
        if (n3 == 1) {
            object = new KeyPairDSA(jSch);
        } else if (n3 == 2) {
            object = new KeyPairRSA(jSch);
        }
        if (object != null) {
            ((KeyPair)object).encrypted = bl2;
            ((KeyPair)object).publickeyblob = byArray;
            ((KeyPair)object).vendor = n2;
            if (bl2) {
                ((KeyPair)object).iv = byArray3;
                ((KeyPair)object).data = byArray2;
            } else {
                if (((KeyPair)object).parse(byArray2)) {
                    return object;
                }
                throw new JSchException("invalid privatekey: " + string);
            }
        }
        return object;
    }

    private static byte a2b(byte by2) {
        if (48 <= by2 && by2 <= 57) {
            return (byte)(by2 - 48);
        }
        return (byte)(by2 - 97 + 10);
    }

    private static byte b2a(byte by2) {
        if (0 <= by2 && by2 <= 9) {
            return (byte)(by2 + 48);
        }
        return (byte)(by2 - 10 + 65);
    }

    public void dispose() {
        Util.bzero(this.passphrase);
    }

    public void finalize() {
        this.dispose();
    }
}

