/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestResume
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestResume.java,v 1.6 2005/11/15 21:07:30 bruceb Exp $";

    protected String getLogName() {
        return "TestResume.log";
    }

    public void testResumePut() throws Exception {
        this.log.debug("testResumePut()");
        this.setup();
        String filename = this.generateRandomFilename();
        this.ftp.setProgressMonitor(new CancelProgressMonitor(this.ftp), 131072L);
        try {
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
        }
        catch (IOException ex) {
            this.log.debug("Caught expected exception", ex);
        }
        catch (FTPTransferCancelledException ex) {
            this.log.debug("Caught expected cancellation exception", ex);
        }
        try {
            this.ftp.quit();
        }
        catch (Exception ex) {
            this.log.debug("Exception caught on quit", ex);
        }
        this.setup();
        this.ftp.resume();
        this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
        this.ftp.get(this.localDataDir + filename, filename);
        this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
        this.ftp.cancelResume();
        this.ftp.get(this.localDataDir + filename, filename);
        this.ftp.delete(filename);
        File local = new File(this.localDataDir + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testResumeGet() throws Exception {
        this.log.debug("testResumeGet()");
        this.setup();
        String filename = this.generateRandomFilename();
        this.ftp.setProgressMonitor(new CancelProgressMonitor(this.ftp), 131072L);
        try {
            this.ftp.get(this.localDataDir + filename, this.remoteBinaryFile);
        }
        catch (IOException ex) {
            this.log.debug("Caught expected exception", ex);
        }
        catch (FTPTransferCancelledException ex) {
            this.log.debug("Caught expected cancellation exception", ex);
        }
        try {
            this.ftp.quit();
        }
        catch (Exception ex) {
            this.log.debug("Exception caught on quit", ex);
        }
        this.setup();
        this.ftp.resume();
        this.ftp.get(this.localDataDir + filename, this.remoteBinaryFile);
        String filename2 = this.generateRandomFilename();
        this.ftp.get(this.localDataDir + filename2, this.remoteBinaryFile);
        this.assertIdentical(this.localDataDir + filename, this.localDataDir + filename2);
        File local = new File(this.localDataDir + filename);
        local.delete();
        local = new File(this.localDataDir + filename2);
        local.delete();
        this.ftp.quit();
    }

    private void setup() throws Exception {
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
    }

    public static Test suite() {
        return new TestSuite(TestResume.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestResume.suite());
    }

    class CancelProgressMonitor
    implements FTPProgressMonitor {
        private boolean cancelled = false;
        private FTPClientInterface ftpClient;

        public CancelProgressMonitor(FTPClientInterface ftp) {
            this.ftpClient = ftp;
        }

        public void bytesTransferred(long bytes) {
            TestResume.this.log.debug("bytesTransferred(" + bytes + ") called");
            if (!this.cancelled) {
                this.ftpClient.cancelTransfer();
                this.cancelled = true;
            }
        }
    }
}

