/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestBigTransfer
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestBigTransfer.java,v 1.2 2005/07/15 17:30:06 bruceb Exp $";
    private static int PROGRESS_INTERVAL = 1048575;

    protected String getLogName() {
        return "TestTransferLarge.log";
    }

    public void testTransferLarge() throws Exception {
        this.log.debug("TransferLarge()");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        this.ftp.setProgressMonitor(new TestProgressMonitor(), PROGRESS_INTERVAL);
        this.bigTransfer(this.localBigFile);
        this.ftp.quit();
    }

    private void bigTransfer(String bigFile) throws Exception {
        this.ftp.put(this.localDataDir + bigFile, bigFile);
        this.ftp.get(this.localDataDir + bigFile + ".copy", bigFile);
        this.ftp.delete(bigFile);
        this.assertIdentical(this.localDataDir + bigFile + ".copy", this.localDataDir + bigFile);
        File local = new File(this.localDataDir + bigFile + ".copy");
        local.delete();
    }

    public static Test suite() {
        return new TestSuite(TestBigTransfer.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestBigTransfer.suite());
    }

    class TestProgressMonitor
    implements FTPProgressMonitor {
        TestProgressMonitor() {
        }

        public void bytesTransferred(long bytes) {
            TestBigTransfer.this.log.debug(bytes + " transferred");
        }
    }
}

