/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class UnixFileParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: UnixFileParser.java,v 1.14 2006/10/11 08:57:40 hans Exp $";
    private static final String SYMLINK_ARROW = "->";
    private static final char SYMLINK_CHAR = 'l';
    private static final char[] FILE_CHARS = new char[]{'-', 'p'};
    private static final char DIRECTORY_CHAR = 'd';
    private SimpleDateFormat formatter1;
    private SimpleDateFormat formatter2;
    private static final int MIN_FIELD_COUNT = 8;

    public UnixFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public void setLocale(Locale locale) {
        this.formatter1 = new SimpleDateFormat("MMM-dd-yyyy", locale);
        this.formatter2 = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", locale);
    }

    public static boolean isUnix(String raw) {
        char ch2 = raw.charAt(0);
        if (ch2 == 'd' || ch2 == 'l') {
            return true;
        }
        for (int i2 = 0; i2 < FILE_CHARS.length; ++i2) {
            if (ch2 != FILE_CHARS[i2]) continue;
            return true;
        }
        return false;
    }

    public FTPFile parse(String raw) throws ParseException {
        if (!UnixFileParser.isUnix(raw)) {
            return null;
        }
        String[] fields = this.split(raw);
        if (fields.length < 8) {
            StringBuffer listing = new StringBuffer("Unexpected number of fields in listing '");
            listing.append(raw).append("' - expected minimum ").append(8).append(" fields but found ").append(fields.length).append(" fields");
            throw new ParseException(listing.toString(), 0);
        }
        int index = 0;
        char ch2 = raw.charAt(0);
        String permissions = fields[index++];
        ch2 = permissions.charAt(0);
        boolean isDir = false;
        boolean isLink = false;
        if (ch2 == 'd') {
            isDir = true;
        } else if (ch2 == 'l') {
            isLink = true;
        }
        int linkCount = 0;
        if (Character.isDigit(fields[index].charAt(0))) {
            try {
                linkCount = Integer.parseInt(fields[index++]);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        String owner = fields[index++];
        String group = fields[index++];
        long size = 0L;
        String sizeStr = fields[index];
        if (!Character.isDigit(sizeStr.charAt(0)) && Character.isDigit(group.charAt(0))) {
            sizeStr = group;
            group = "";
        } else {
            ++index;
        }
        try {
            size = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Failed to parse size: " + sizeStr, 0);
        }
        int dateTimePos = index;
        Date lastModified = null;
        StringBuffer stamp = new StringBuffer(fields[index++]);
        stamp.append('-').append(fields[index++]).append('-');
        String field = fields[index++];
        if (field.indexOf(58) < 0) {
            stamp.append(field);
            lastModified = this.formatter1.parse(stamp.toString());
        } else {
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            stamp.append(year).append('-').append(field);
            lastModified = this.formatter2.parse(stamp.toString());
            if (lastModified.after(cal.getTime())) {
                cal.setTime(lastModified);
                cal.add(1, -1);
                lastModified = cal.getTime();
            }
        }
        String name = null;
        String linkedname = null;
        int pos = 0;
        boolean ok = true;
        for (int i2 = dateTimePos; i2 < dateTimePos + 3; ++i2) {
            if ((pos = raw.indexOf(fields[i2], pos)) < 0) {
                ok = false;
                break;
            }
            pos += fields[i2].length();
        }
        if (ok) {
            String remainder = raw.substring(pos).trim();
            if (!isLink) {
                name = remainder;
            } else {
                pos = remainder.indexOf(SYMLINK_ARROW);
                if (pos <= 0) {
                    name = remainder;
                } else {
                    int len = SYMLINK_ARROW.length();
                    name = remainder.substring(0, pos).trim();
                    if (pos + len < remainder.length()) {
                        linkedname = remainder.substring(pos + len);
                    }
                }
            }
        } else {
            throw new ParseException("Failed to retrieve name: " + raw, 0);
        }
        FTPFile file = new FTPFile(raw, name, size, isDir, lastModified);
        file.setGroup(group);
        file.setOwner(owner);
        file.setLink(isLink);
        file.setLinkCount(linkCount);
        file.setLinkedName(linkedname);
        file.setPermissions(permissions);
        return file;
    }
}

