/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHIfStatement;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;

class BSHForStatement
extends SimpleNode
implements ParserConstants {
    public boolean hasForInit;
    public boolean hasExpression;
    public boolean hasForUpdate;
    private SimpleNode forInit;
    private SimpleNode expression;
    private SimpleNode forUpdate;
    private SimpleNode statement;
    private boolean parsed;

    BSHForStatement(int n2) {
        super(n2);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        boolean bl2;
        int n2 = 0;
        if (this.hasForInit) {
            this.forInit = (SimpleNode)this.jjtGetChild(n2++);
        }
        if (this.hasExpression) {
            this.expression = (SimpleNode)this.jjtGetChild(n2++);
        }
        if (this.hasForUpdate) {
            this.forUpdate = (SimpleNode)this.jjtGetChild(n2++);
        }
        if (n2 < this.jjtGetNumChildren()) {
            this.statement = (SimpleNode)this.jjtGetChild(n2);
        }
        NameSpace nameSpace = callStack.top();
        BlockNameSpace blockNameSpace = new BlockNameSpace(nameSpace);
        callStack.swap(blockNameSpace);
        if (this.hasForInit) {
            this.forInit.eval(callStack, interpreter);
        }
        Object object = Primitive.VOID;
        while (!this.hasExpression || (bl2 = BSHIfStatement.evaluateCondition(this.expression, callStack, interpreter))) {
            Object object2;
            bl2 = false;
            if (this.statement != null && (object2 = this.statement.eval(callStack, interpreter)) instanceof ReturnControl) {
                switch (((ReturnControl)object2).kind) {
                    case 46: {
                        object = object2;
                        bl2 = true;
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 12: {
                        bl2 = true;
                    }
                }
            }
            if (bl2) break;
            if (!this.hasForUpdate) continue;
            this.forUpdate.eval(callStack, interpreter);
        }
        callStack.swap(nameSpace);
        return object;
    }
}

