/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.UtilEvalError;
import java.lang.reflect.Array;

class BSHArrayInitializer
extends SimpleNode {
    BSHArrayInitializer(int n2) {
        super(n2);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        throw new EvalError("Array initializer has no base type.", this, callStack);
    }

    public Object eval(Class clazz, int n2, CallStack callStack, Interpreter interpreter) throws EvalError {
        int n3 = this.jjtGetNumChildren();
        int[] nArray = new int[n2];
        nArray[0] = n3;
        Object object = Array.newInstance(clazz, nArray);
        int n4 = 0;
        while (n4 < n3) {
            Object object2;
            Object object3;
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(n4);
            if (simpleNode instanceof BSHArrayInitializer) {
                if (n2 < 2) {
                    throw new EvalError("Invalid Location for Intializer, position: " + n4, this, callStack);
                }
                object3 = ((BSHArrayInitializer)simpleNode).eval(clazz, n2 - 1, callStack, interpreter);
            } else {
                object3 = simpleNode.eval(callStack, interpreter);
            }
            if (object3 == Primitive.VOID) {
                throw new EvalError("Void in array initializer, position" + n4, this, callStack);
            }
            if (object3 instanceof Primitive) {
                Primitive primitive = (Primitive)object3;
                if (clazz.isPrimitive()) {
                    try {
                        primitive = primitive.castToType(clazz, 0);
                    }
                    catch (UtilEvalError utilEvalError) {
                        utilEvalError.printStackTrace();
                        Interpreter.debug("error:" + utilEvalError);
                        this.throwTypeError(clazz, primitive, n4, callStack);
                    }
                }
                object2 = primitive.getValue();
            } else {
                object2 = object3;
            }
            try {
                Array.set(object, n4, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Interpreter.debug("illegal arg" + illegalArgumentException);
                this.throwTypeError(clazz, object3, n4, callStack);
            }
            catch (ArrayStoreException arrayStoreException) {
                Interpreter.debug("arraystore" + arrayStoreException);
                this.throwTypeError(clazz, object3, n4, callStack);
            }
            ++n4;
        }
        return object;
    }

    private void throwTypeError(Class clazz, Object object, int n2, CallStack callStack) throws EvalError {
        String string = object instanceof Primitive ? ((Primitive)object).getType().getName() : Reflect.normalizeClassName(object.getClass());
        throw new EvalError("Incompatible type: " + string + " in initializer of array type: " + clazz + " at position: " + n2, this, callStack);
    }
}

