.*
.* gbmdlg.scr - Help for Gbm file formats dialog
.*
.* Important: Only edit the original .SCR file.
.* If this file is not by the filename given above, then it has been put
.* through IPFCPREP and so will be regenerated next MAKE.
.*
.*...vgbmdlgrc\46\h:0:
:userdoc.
.*...sprolog:0:
:prolog.
:title.GbmDlg Help
:author.Andy Key
:eprolog.
.*...e
:toc.
:body.
.*...sHID_GBM_FILEDLG   \45\ Bitmap File dialog:0:
:h1 res=2000.Bitmap File dialog
:i1 id=gbmfile.Bitmap File dialog
:p.This dialog allows you to load a bitmap from a file, or save a bitmap to
a file.
Filenames and directories may be selected from the listboxes via the
keyboard or the mouse, just like in any other File dialog.
:p.You can handle bitmap files of a variety of different formats.
For example,  OS/2 Bitmaps, CompuServe GIF files, ZSoft PCX files
and many others.
:p.To see an extensive list of the level of support for the various
bitmap formats, and the format specific options available in each, see the
:link reftype=hd res=2001.Bitmap file format support:elink.
section of this help.
:p.You can select which files are listed in the files listbox using the
:hp2.Bitmap filetype filter:ehp2. combo box.
You can pick, :hp2.<All files>:ehp2.,
:hp2.<All GBM supported files>:ehp2. and various :hp2.<Format>:ehp2.s.
:p.The program will look at the :hp2.file extension:ehp2. and determine
the format of the file and use the relevant bitmap file handling code.
:p.The :hp2.Optional bitmap format specific options:ehp2. field allows you
to specify a string which is used to give hints to the relevant bitmap file
handling code. For example, you can tell the GIF file reader to ignore
corrupt data and return how far it got by giving the ":hp9.errok:ehp9."
option.
.*...e
.*...sHID_GBM_SUPPORT   \45\ Bitmap file format support:0:
:h1 res=2001.Bitmap file format support
:i1 id=gbmsupp.Bitmap file format support
:p.This program uses the :hp2.Generalised Bitmap Module:ehp2..
This peice of code can read and write a variety of bitmap formats.
The application program is unaware of the file format of any bitmaps, and
is just presented with the bitmap data in a single standard way.
:p.Some bitmap formats allow additional :hp2.options:ehp2. to be supplied
and these options are listed highlighted like :hp9.this:ehp9..
:p.This section fully defines the level of support &colon.-
:p.
Formats supported are &colon.
:sl.
:li.:link reftype=hd res=2002.OS/2 / Windows Bitmap:elink.
:li.:link reftype=hd res=2003.CompuServe Graphics Interchange Format:elink.
:li.:link reftype=hd res=2004.ZSoft PC Paintbrush Image Format:elink.
:li.:link reftype=hd res=2005.Microsoft/Aldus Tagged Image File Format:elink.
:li.:link reftype=hd res=2006.Truevision Targa/Vista:elink.
:li.:link reftype=hd res=2007.Amiga IFF / ILBM Interleaved bitmap format:elink.
:li.:link reftype=hd res=2008.YUV12C M-Motion Frame Buffer:elink.
:li.:link reftype=hd res=2009.Portable Greyscale-map:elink.
:li.:link reftype=hd res=2010.Portable Pixel-map:elink.
:li.:link reftype=hd res=2011.IBM KIPS:elink.
:li.:link reftype=hd res=2012.IBM Image Access eXecutive:elink.
:li.:link reftype=hd res=2013.X Windows bitmap:elink.
:li.:link reftype=hd res=2014.RiscOS Sprite:elink.
:li.:link reftype=hd res=2015.IBM Printer Page Segment:elink.
:li.:link reftype=hd res=2016.GEM Raster:elink.
:li.:link reftype=hd res=2017.Portrait:elink.
:li.:link reftype=hd res=2018.JPEG:elink.
:li.:link reftype=hd res=2019.Others:elink.
:esl.
:p.The :link reftype=hd res=2000.Bitmap File Dialog:elink.
can handle bitmaps in any of the formats documented above.
.*...e
.*...sHID_GBM_BITMAP    \45\   OS\47\2 \47\ Windows bitmap:0:
:h2 res=2002.OS/2 / Windows bitmap
:i2 refid=gbmsupp.OS/2 / Windows bitmap
:p.The following file extensions
:xmp.
  .BMP .VGA .BGA .RLE .DIB .RL4 .RL8
:exmp.
:p.are recognised as OS/2 1.1, 1.2, 2.0 or Windows 3.0 bitmaps.
:p.:hp2.Input:ehp2.
:p.The bitmap support will read any of the above if uncompressed or
run-length compressed.
:p.CCITT G3 MH Fax compressed files, or RLE24 compressed files can't be read.
:dl compact tsize=7 break=all.
:dt.:hp9.index=N:ehp9.
:dd.Can be used if the file is an OS/2 bitmap-array file to specify which
bitmap in the array to read (default N=0 - the first in the array).
:dt.:hp9.inv:ehp9.
:dd.Causes the palette to get inverted after reading.
Provided to allow for inconsistencies between Windows and OS/2 programs in
how the palette of 1bpp files should be interpreted.
:dt.:hp9.invb:ehp9.
:dd.Causes the bitmap bits to get inverted after reading.
:edl.
:p.:hp2.Output:ehp2.
:p.The this module can write both OS/2 1.1 and OS/2 2.0 / Windows 3.0 style
bitmaps.
:p.By default OS/2 2.0 or Windows 3.0 bitmaps are written.
:p.The OS/2 2.0 / Windows 3.0 style of bitmaps written are written with a
header size (cbFix) of 40, which is compatible with both Windows 3.0 and
OS/2 2.0.
:dl compact tsize=7 break=all.
:dt.:hp9.1.1:ehp9.
:dd.Causes the bitmap to be written OS/2 1.1 style.
:dt.:hp9.2.0:ehp9. or :hp9.win:ehp9.
:dd.Causes the bitmap to be written OS/2 2.0 / Windows 3.0 style.
:dt.:hp9.inv:ehp9.
:dd.Causes the palette to get inverted before written.
Provided to allow for inconsistencies between Windows and OS/2 programs in
how the palette of 1bpp files should be interpreted.
:dt.:hp9.invb:ehp9.
:dd.Causes the bitmap bits to get inverted before written.
:dt.:hp9.darkfg:ehp9.
:dd.This is probably the best option to use when writing 1bpp bitmaps.
It ensures that the darkest colour is represented in the file as 1's
(and is therefore the foreground), and when the bitmap is reloaded, this
will come out black.
:dt.:hp9.lightfg:ehp9.
:dd.As darkfg, but the lightest colour is stored as 1's.
:edl.
:p.The newer MultiMedia Windows bitmap format that allows 16 and 32 bpp
support is not currently supported.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_GIF       \45\   CompuServe Graphics Interchange Format:0:
:h2 res=2003.CompuServe Graphics Interchange Format
:i2 refid=gbmsupp.CompuServe Graphics Interchange Format
:p.The :hp2..GIF:ehp2. file extension is recognised as a GIF file.
:p.:hp2.Input:ehp2.
:p.1 bpp GIF files are read as 1 bpp data.
:p.2, 3 and 4 bit GIF files are read and returned as 4 bpp data.
:p.5, 6, 7 and 8 bit GIF files are read and returned as 8 bpp data.
:p.GIF files provide no support for 24 bpp images.
:p.Both :hp2.GIF87a:ehp2. and :hp2.GIF89a:ehp2. level files may be read.
:p.The code will correctly handle deferred clear-codes in the LZW data
stream.
Files with these often break earlier programs that claim to load GIF files.
:dl compact tsize=7 break=all.
:dt.:hp9.index=N:ehp9.
:dd.Can be used to specify which image in the GIF file to read (default N=0).
:dt.:hp9.errok:ehp9.
:dd.If a corrupted or truncated GIF file is encountered, normally an error
is returned.
With this option, as much data as was decoded before the error is returned,
and no error occurs.
:edl.
:p.:hp2.Output:ehp2.
:p.The :hp2.GIF87a:ehp2. style of GIF files are written, and since the
GIF standard is backwardly compatible, all programs that claim to load GIF
files should handle the output generated by this program.
:p.The exception to this is that if the :hp2.transcol:ehp2. option is used
a :hp2.GIF89a:ehp2. style file will be written.
:p.This program does not generate GIF files with deferred-clear-codes, as
these have been shown to break many older GIF readers.
:dl compact tsize=7 break=all.
:dt.:hp9.xscreen=N:ehp9.,:hp9.yscreen=N:ehp9.
:dd.Specifies what values to put in these fields of the GIF file header.
The default is the image size.
:dt.:hp9.background=N:ehp9.
:dd.Specifies what background colour index to write in the GIF file header.
The default is 0.
:dt.:hp9.xpos=N:ehp9.,:hp9.ypos=N:ehp9.
:dd.Specifies what values to put in these fields in the GIF file header.
The defaults are 0 and 0.
:dt.:hp9.transcol=N:ehp9.
:dd.Specifies that index N designates a transparent colour.
This option is useful for when you wish to embed GIF files in HTML documents.
Using this option causes a GIF89a file to be written because the
Graphics Extension Block holding the transparency information is a part of
the GIF89a spec., and not the GIF87a.
:dt.:hp9.transcol=edge:ehp9.
:dd.As above, except transparent colour is the colour of the first pixel
in the bitmap.
:dt.:hp9.ilace:ehp9.
:dd.Causes the GIF file to be written interlaced, which can be good for those
GIF files referenced from HTML documents.
:edl.
:p.This code correctly handles 1bpp GIF files.
Some programs make incorrect assumptions about the initial LZW code table size
in the 1bpp case, and so fall over.
UBU is/was guilty of this.
:p.This code has been tested on a wide selection of files from a wide
variety of sources.
It has been tested against the output of public domain PPMTOGIF.EXE,
and tested for compatibility with UNIX X Windows xloadimage and xv.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
:p.GIF and 'Graphics Interchange Format' are trademarks (tm) of
Compuserve, Incorporated, an H&amp.R Block Company.
.*...e
.*...sHID_GBM_PCX       \45\   ZSoft PC Paintbrush Image Format:0:
:h2 res=2004.ZSoft PC Paintbrush Image Format
:i2 refid=gbmsupp.ZSoft PC Paintbrush Image Format
:p.The :hp2..PCX:ehp2. and :hp2..PCC:ehp2. file extensions are recognised as
a Paintbrush file.
:p.Only a subset of the possible planes/bits-per-plane combinations are
supported.
:p.:hp2.Input:ehp2.
:p.This program reads 1,4,8 and 24 bpp files.
:p.The run-length encoding scheme is supported.
:p.Compressed runs of pixels are not supposed to straddle scan lines.
Some other applications violate this rule.
By default, if this code finds that a run of pixels is longer than the scan
line, it will use the leftover pixels on the next scan line.
Some images will not load properly, as they require the loading
program to discard those pixels in the run that extend beyond the end
of the scan line.
This behaviour can be enabled using the :hp9.trunc:ehp9. option.
:p.:hp2.Output:ehp2.
:p.This program writes 1,4,8 and 24 bpp files, using run-length compression.
:p.It will always ensure run-lengths of pixels do not straddle scan lines.
:p.This code has been tested on some PC Paintbrush originated .PCX files.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_TIFF      \45\   Microsoft\47\Aldus Tagged Image File Format:0:
:h2 res=2005.Microsoft/Aldus Tagged Image File Format
:i2 refid=gbmsupp.Microsoft/Aldus Tagged Image File Format
:p.The :hp2..TIF:ehp2. and :hp2..TIFF:ehp2. file extensions are
recognised as TIFF files.
:p.There is support to handle 1,4,8 and 24 bpp files.
:p.:hp2.Input:ehp2.
:p.This program reads uncompressed, Packbits and LZW compressed files.
:p.This code will read all Baseline TIFF 6.0 files, except CCITT Modified
Huffman encoded bi-level files.
:dl compact tsize=7 break=all.
:dt.:hp9.index=N:ehp9.
:dd.Can be used if the file contains more than one image to specify which
image to read (default N=0 - the first).
:edl.
:p.:hp2.Output:ehp2.
:p.This program usually writes uncompressed data.
:p.Data are written in a single large strip.
:p.Files written by this code are Baseline TIFF 6.0 compliant.
:dl compact tsize=7 break=all.
:dt.:hp9.artist=TEXT:ehp9.
:dd.Causes an :hp2.Artist:ehp2. tag to be added with text TEXT.
:dt.:hp9.lzw:ehp9.
:dd.Asks GBM to use LZW compression.
:dt.:hp9.software=TEXT:ehp9.
:dd.Causes the :hp2.Software:ehp2. tag to be added with text TEXT.
:dt.:hp9.make=TEXT:ehp9.
:dd.Causes the :hp2.Make:ehp2. tag to be added with text TEXT.
:dt.:hp9.model=TEXT:ehp9.
:dd.Causes the :hp2.Model:ehp2. tag to be added with text TEXT.
:dt.:hp9.host=TEXT:ehp9.
:dd.Causes the :hp2.Host:ehp2. tag to be added with text TEXT.
:dt.:hp9.documentname=TEXT:ehp9.
:dd.Causes the :hp2.DocumentName:ehp2. tag to be added with text TEXT.
:dt.:hp9.pagename=TEXT:ehp9.
:dd.Causes the :hp2.PageName:ehp2. tag to be added with text TEXT.
:dt.:hp9.imagedescription=TEXT:ehp9.
:dd.Causes the :hp2.ImageDescription:ehp2. tag to be added with text TEXT.
:dt.:hp9.pal1bpp:ehp9.
:dd.Causes 1 bpp data to be written as a palettised file, with 2 palette
entries.
Technically this is not TIFF 6.0 Baseline compliant.
The default is to write out a bi-level file with the brightest colour as
white.
This is Baseline compliant.
:edl.
:p.The TEXT should not include spaces.
:p.There are 2 well known corruptions of the TIFF format.
:p.Some TIFF writers write the ColorMap tags length to be 2^N, whereas it
should be 3*2^N.
This code will detect this tag having a bad length, and correct for it
transparently.
UBU is/was guilty of this.
:p.Some TIFF readers/writers believe that ColorMap entrys are bytes.
In fact they are words.
When reading TIFF files, if this code finds that all the palette entrys
are in the range 0-255, as opposed to 0-65535, then it multiplys them all
by 256, thus transparently overcoming the problem.
When writing TIFF files, this code writes the 8 bit palette entry in both
the low and high bytes of the tag.
Thus programs that look at the high byte work fine.
Programs that use the full word work fine (the colours get 0.5% brighter).
Programs that incorrectly look at the bottom byte work fine too.
At least one version of Image Support is/was guilty of this.
:p.JPEG compressed data, and data in the Y-Cb-Cr colour space is not supported.
:p.CCITT G3 Modified Huffman / Facsimile compressed data is not supported.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_TARGA     \45\   Truevision Targa\47\Vista bitmap:0:
:h2 res=2006.Truevision Targa/Vista bitmap
:i2 refid=gbmsupp.Truevision Targa/Vista bitmap
:p.The following file extensions
:xmp.
  .TGA .VST .AFI
:exmp.
:p.are recognised as Targa/Vista files.
:p.This code can read the uncompressed or run-length compressed Targa/Vista
formats.
It will write uncompressed files.
:p.This code only supports 8 bpp and 24 bpp images.
:p.:hp2.Input:ehp2.
:p.This code will read files with both top-left-origin and bottom-left-origin.
Not all Targa readers correctly handle bottom-left-origin files.
:p.When reading 16 bpp files (which are 5 red + 5 green + 5 blue + 1 alpha),
they are loaded and presented as 24 bpp bitmaps with only the top 5 bits of
each of the 8 bit bytes valid.
The bottom 3 bits are zero.
:p.When reading 32 bpp files (which are 8 red + 8 green + 8 blue + 8 alpha),
the alpha channel is ignored.
:p.:hp2.Output:ehp2.
:dl compact tsize=7 break=all.
:dt.:hp9.yup:ehp9. and :hp9.ydown:ehp9.
:dd.Causes the data to be written in bottom-left-origin or top-left-origin
form. The default is bottom-left-origin.
:dt.:hp9.16:ehp9.
:dd.If the data is 24 bpp, then the 16 flag causes only the most significant
5 bits of the red, green and blue to be written in a 16 bit pixel.
:dt.:hp9.24:ehp9.
:dd.Has no effect, as this is the default.
:dt.:hp9.32:ehp9.
:dd.If the data is 24 bpp, then the 32 flag causes the data to be padded with
8 zero bits of alpha channel to make a 32 bit pixel.
:edl.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_ILBM      \45\   Amiga IFF \47\ ILBM Interleaved bitmap format:0:
:h2 res=2007.Amiga IFF / ILBM Interleaved bitmap format
:i2 refid=gbmsupp.Amiga IFF / ILBM Interleaved bitmap format
:p.The following file extensions
:xmp.
  .IFF .LBM
:exmp.
:p.are recognised as interleaved bitmap files.
:p.Normally ILBM files are 1,2,3,4 or 5 bpp,
because the early Amigas supported upto 32 colours at once.
6,7, 8 and 24 bpp files are also found nowadays too.
:p.:hp2.Extra-HalfBrite:ehp2., or :hp2.EHB:ehp2. is a mode where N
colours have palette entries, but the file may contain 2*N colours.
The second set of N colours are half the brightness of the first half.
In this way, for example, 64 colours may be displayed on an early Amiga.
:p.:hp2.Hold-And-Modify:ehp2., or :hp2.HAM:ehp2. is a type of screen format
where each pixel is either one of a small number of colours in a palette,
or is held the same as the pixel to its left except that either the red,
green or blue is modified.
In this way a much larger range of colours can be displayed.
:p.HAM modes sometimes have fringes down the vertical edges of
shapes in the picture, as sometimes it is necessary to modify the lefthand
pixel several times to get to the desired colour, if a suitable entry is
not in the palette.
:p.:hp2.HAM6:ehp2. is a HAM mode where there are 16 base palette
entries and a possible maximum of 4096 colours.
This is found on early Amigas.
:p.:hp2.HAM8:ehp2. is a HAM mode where there are 64 base palette
entries and a full 24 bit range of colours.
Also because of the larger palette, fringing is less than in HAM6.
This mode is present on later Amigas.
:p.:hp2.Sliced-Hold-And-Modify:ehp2., or :hp2.SHAM:ehp2. is a mode where
the palette is changed on every (or every other) scan line.
This also helps reduce fringing compared to normal HAM6.
SHAM is actually sliced HAM6, and might really be called SHAM6, and
SHAM8 is not known to exist.
:p.:hp2.Input:ehp2.
:p.This code can read files that contain uncompressed or RLE compressed
data.
:p.1 bpp files can be read ok.
:p.2,3 and 4 bpp files are read and returned as 4 bpp data.
:p.5,6,7 and 8 bpp files are read and returned as 8 bpp data.
:p.24 bpp files are read and returned as 24 bpp data.
:p.EHB images can be read and are returned as 8 bpp data.
:p.HAM6, HAM8 and SHAM files can be read and are returned as 24 bpp data.
:p.Only the :hp2.BMHD:ehp2., :hp2.CMAP:ehp2., :hp2.CAMG:ehp2. and
:hp2.BODY:ehp2. chunks are used when reading the file.
:p.:hp2.Output:ehp2.
:p.This code can write 1, 4, 8 and 24 bpp files.
:p.24 bpp files can also be written in HAM6 form.
This loses quality, but, is still better than a normal 8 bpp file.
:p.This code writes RLE compressed data, as this usually results in
much smaller files.
:p.Only the :hp2.BMHD:ehp2., :hp2.CMAP:ehp2. and :hp2.BODY:ehp2. chunks
are written to the file.
When writing HAM data, a :hp2.CAMG:ehp2. chunk is written also.
:p.You can optionally override parts of the BMHD header.
:dl compact tsize=7 break=all.
:dt.:hp9.ham6:ehp9.
:dd.Means write 24 bpp data in HAM6 format, rather than as a true
24 bpp file.
:dt.:hp9.xpos=N:ehp9.,:hp9.ypos=N:ehp9.
:dd.Overrides the origin information in the file. Defaults are 0,0.
:dt.:hp9.transcol=N:ehp9.
:dd.Overrides the transparent colour field. Default is 0.
:dt.:hp9.xaspect=N:ehp9.,:hp9.yaspect=N:ehp9.
:dd.Overrides the aspect ratio information. Defaults are 1,1.
This header information is not always honored by ILBM readers.
:dt.:hp9.xscreen=N:ehp9.,:hp9.yscreen=N:ehp9.
:dd.Overrides the screen size information.
This is not often used by ILBM readers.
The default is the image size.
:edl.
:p.Note that when some early programs try to load an >5 bpp ILBM file,
they can switch to a 32 colour (5 bpp mode) and only read the 5 least
significant planes of the file. This generally looks bad.
:p.This support has been tested using a large range of sample files.
But, some sample files supplied to the author have yet to be loaded.
In particular some (24bpp?) DCTV originated files are not yet understood.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_YUV12C    \45\   YUV12C M\45\Motion Frame Buffer:0:
:h2 res=2008.YUV12C M-Motion Frame Buffer
:i2 refid=gbmsupp.YUV12C M-Motion Frame Buffer
:p.The :hp2..VID:ehp2. file extension is recognised as a YUV12C file.
:p.Although YUV12C files contain 12 bit YUV encoded colour image data,
this code pretends they contain 24 bit RGB encoded colour data.
:p.:hp2.Input:ehp2.
:p.The files are converted from YUV to RGB data before the data is
presented to the program.
:p.:hp2.Output:ehp2.
:p.The RGB data is converted to YUV when it is written to disk.
:p.YUV12C files must be a multiple of 4 pixels wide.
When trying to write a bitmap that is not a multiple of 4 pixels wide, this
code truncates the last 1, 2 or 3 pixels left over.
:dl compact tsize=7 break=all.
:dt.:hp9.xpos=N:ehp9.,:hp9.ypos=N:ehp9.
:dd.Overrides the origin information in the file. Defaults are 0,0.
:edl.
:p.This support has been tested using the M-Control Program 2.0,
Browser sample application.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_GREYMAP   \45\   Portable Greyscale\45\map:0:
:h2 res=2009.Portable Greyscale-map
:i2 refid=gbmsupp.Portable Greyscale-map
:p.The :hp2..PGM:ehp2. file extension is recognised as a Greymap file.
:p.Credit for file format to Jef Poskanzer.
:p.Only the Binary :hp2.P5:ehp2. form of this format is supported.
:p.These files hold :hp2.no palette:ehp2. information.
:p.:hp2.Input:ehp2.
:p.The files are returned as an 8 bit image usually with a greyscale palette.
:dl compact tsize=7 break=all.
:dt.:hp9.r:ehp9.,:hp9.g:ehp9.,:hp9.b:ehp9. or :hp9.k:ehp9.
:dd.Forces the image to be read as shades of red, green, blue or grey
(the default).
:edl.
:p.:hp2.Output:ehp2.
:p.Normally 8 bpp image data as the greyscale equivelent of the bitmap data.
:dl compact tsize=7 break=all.
:dt.:hp9.r:ehp9.,:hp9.g:ehp9.,:hp9.b:ehp9. or :hp9.k:ehp9.
:dd.Forces the red,green or blue component of the image to be written, or
alternatively to write the greyscale equivelent (the default).
:edl.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_PIXMAP    \45\   Portable Pixel\45\map:0:
:h2 res=2010.Portable Pixel-map
:i2 refid=gbmsupp.Portable Pixel-map
:p.The :hp2..PPM:ehp2. file extension is recognised as a Pixel-map file.
:p.Credit for file format to Jef Poskanzer.
:p.Only the Binary :hp2.P6:ehp2. form of this format is supported.
:p.The Portable Pixel-map format is only capable of holding 24 bpp RGB data,
and this code fully supports this.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_KIPS      \45\   IBM KIPS:0:
:h2 res=2011.IBM KIPS
:i2 refid=gbmsupp.IBM KIPS
:p.The :hp2..KPS:ehp2. file extension is recognised as a IBM KIPS file.
:p.The .KPS file is not enough to define a KIPS image.
:p.The palette is stored in either an associated
:hp2..PAL:ehp2. or :hp2..KPL:ehp2. file.
:p.:hp2.Input:ehp2.
:dl compact tsize=7 break=all.
:dt.:hp9.pal:ehp9. or :hp9.kpl:ehp9.
:dd.Tells this code to look for a .PAL or a .KPL file to find the palette
(default is .PAL)
:edl.
:p.:hp2.Output:ehp2.
:dl compact tsize=7 break=all.
:dt.:hp9.pal:ehp9. or :hp9.kpl:ehp9.
:dd.Tells this code to write  a .PAL or a .KPL file containing the palette.
(default is .PAL)
:edl.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_IAX       \45\   IBM Image Access eXecutive:0:
:h2 res=2012.IBM Image Access eXecutive
:i2 refid=gbmsupp.IBM Image Access eXecutive
:p.The :hp2..IAX:ehp2. file extension is recognised as a IAX file.
:p.This image format does not include a palette or a file header.
In particular, the image file size cannot be determined from the file!
This code assumes an image width of 512 pixels, and determines the image
height by dividing the file size by the width.
:p.The data is presented as a greyscale.
:p.:hp2.Input:ehp2.
:dl compact tsize=7 break=all.
:dt.:hp9.r:ehp9.,:hp9.g:ehp9.,:hp9.b:ehp9. or :hp9.k:ehp9.
:dd.Forces the image to be read as shades of red, green, blue or grey
(the default).
:dt.:hp9.width=N:ehp9.
:dd.Overrides the default assumption that the image width is 512 pixels.
:edl.
:p.:hp2.Output:ehp2.
:p.Normally 8 bpp image data as the greyscale equivelent of the bitmap data.
:dl compact tsize=7 break=all.
:dt.:hp9.r:ehp9.,:hp9.g:ehp9.,:hp9.b:ehp9. or :hp9.k:ehp9.
:dd.Forces the red,green or blue component of the image to be written, or
alternatively to write the greyscale equivelent (the default).
:edl.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_XBITMAP   \45\   X Windows Bitmap:0:
:h2 res=2013.X Windows Bitmap
:i2 refid=gbmsupp.X Windows Bitmap
:p.The :hp2..XBM:ehp2. file extension is recognised as a X Bitmap file.
:p.X Bitmap files are ASCII text files, that look to be directly source
include-able in C programs.
:p.This program is very generous in its parsing of the files.
:p.This program supports X10 and X11 1bpp bitmaps.
Some .XBM files with text strings inside have been encountered.
These looked to be sprites or icons and are not supported.
:p.When reading X Bitmaps, 1's are returned as black, 0's as white.
:p.When writing X bitmaps, the darkest colour is written as 1's, the lightest
as 0's.
:p.This code has been tested on some .XBM files.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_SPRITE    \45\   RiscOS Sprite:0:
:h2 res=2014.RiscOS Sprite
:i2 refid=gbmsupp.RiscOS Sprite
:p.The :hp2..SPR:ehp2. and :hp2..SPRITE:ehp2. file extensions are
recognised as a RiscOS sprite file.
Technically, due to the way the RiscOS works, files don't have extensions.
But for convenience, I have arbitrarily said .SPR, to allow sprites to fit in
with all the other image formats.
:p.:hp2.Input:ehp2.
:p.This code will read 1,2,4 and 8 bpp files.
2bpp files will be expanded to 4bpp on reading.
:p.Sprite files can contain an image, or an image and a mask plane.
This code will ignore the mask plane.
:p.If no palette is present in the file, GBM will assume a default palette
similar to that used by the RiscOS Wimp.
:p.There is a limitation in that the :hp2.first-bit:ehp2. field of the
sprite header must be a multiple of 8 (highly likely).
:dl compact tsize=7 break=all.
:dt.:hp9.index=N:ehp9.
:dd.Can be used if the file contains more than one sprite to specify which
sprite in the file to read (default N=0 - the first in the file).
:edl.
:p.:hp2.Output:ehp2.
:p.This code will write 1,4 and 8bpp files.
:p.A palette will be written into the file.
:p.Only the image plane is written, ie&colon. no mask plane.
:p.When outputting 8bpp bitmaps, the usual wierd Archimedes palette is written
and the bitmap data is :hp2.mapped to this palette:ehp2..
This is because the Archimedes cannot support arbitrary 256 colour palettes.
The VIDC chip only has 16 palette registers, with 16 fixed overrides on
(or shades of) each.
:p.GBM writes 16 palette entries to the file.
Sprite files can be found with 64 palette entries (with 4 overrides on each).
However, it is seen that these 64 palette entries are actually just 16 entries
with the 4 overrides on each. Hence this is equivelent to 16 entries with 16
overrides, except some of the overrides are explicitly stored in the file.
:p.Tested reading 4bpp sprites with no palette.
:p.Tested reading 8bpp sprites with no palette and with 64 entry palette.
:p.Sprites generated by GBM have been loaded on RiscOS.
Remember&colon. Use SetType to change type of file from PC-file to Sprite,
by SetType option of filer menu or "*SetType <filename> Sprite".
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_PSEG      \45\   IBM Printer Page Segment:0:
:h2 res=2015.IBM Printer Page Segment
:i2 refid=gbmsupp.IBM Printer Page Segment
:p.The following file extensions
:xmp.
  .PSE .PSEG .PSEG38PP .PSEG3820
:exmp.
:p.are recognised as PSEG files.
:p.PSEG files are used as a way to include image data in SCRIPT documents.
:p.PSEG files only contain 1bpp data, which is always ink on paper, ie&colon.
black on white.
:p.:hp2.Input:ehp2.
:p.PSEG files should be downloaded from the host in binary mode.
No EBCDIC/ASCII conversion should be used in the download process.
:p.The palette is always returned as black 1's on white 0's, because PSEG
files do not include any palette.
:dl compact tsize=7 break=all.
:dt.:hp9.fixrec:ehp9.
:dd.Some PSEG files have been observed to have shorter records than specified
in the length field (2nd and 3rd bytes) of a record.
Although this doesn't matter when on VM, it can confuse non-VM readers, such
as GBM.
GBM can be told to attempt to compensate for this corrupt record structure
using the fixrec option.
:edl.
:p.:hp2.Output:ehp2.
:p.When writing PSEG files, any colour palette is lost.
:p.The resulting file is a binary file and should be uploaded to a VM machine
as such.
No EBCDIC/ASCII conversion should be used.
However, on a VM host, the record structure of a PSEG is necessary for
it to be correctly interpreted by the VM tools.
On non VM systems, files do not have a record structure.
Therefore after uploading, the PSEG files must be 'fixed'.
You need a tool, like FIXL3820 EXEC to do this.
Basically, each PSEG files record starts with a 0x5a character, and this can
be used to delineate records.
:p.PSEG files are a multiple of 8 pixels wide, so this code writes a file
with the width the next multiple of 8 pixels wide.
The right edge is padded with white pixels.
:dl compact tsize=7 break=all.
:dt.:hp9.scalex=X:ehp9., :hp9.scaley=Y:ehp9.
:dd.Change the scale factor(s) in the header from their default of 1000.
:dt.:hp9.double:ehp9.
:dd.This option doubles the value of the scale factors.
:dt.:hp9.pelx=X:ehp9., :hp9.pely=Y:ehp9.
:dd.Change the pixel size field(s) in the header from their default of 2400,
which means 2400 pixels per 10 inches.
For example 3000 would therefore mean 300 dpi.
:edl.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_GEMRAS    \45\   GEM Raster:0:
:h2 res=2016.GEM Raster
:i2 refid=gbmsupp.GEM Raster
:p.Files with the :hp2..IMG:ehp2. extension are recognised as GEM Raster
files.
:p.The GEM Raster file format is an old format, found primarily on the Atari
platform.
:p.It has a basic flavor in which &colon.-
:sl.
:li.1 bpp bitmaps can only be black and white.
:li.4 bpp bitmaps can only use a fixed 'standard' palette, or be greyscale.
:li.2,3,5,6,7 and 8 bpp bitmaps can only be greyscale.
:li.24 bpp bitmaps are not supported.
:esl.
:p.In addition there are XIMG extensions to the format &colon.-
:sl.
:li.1-8 bpp bitmaps can contain a palette.
:li.24 bpp bitmaps are now allowed.
:esl.
:p.:hp2.Input:ehp2.
:p.This code can read all of the above, with the usual proviso that 2 and 3
bpp are rounded up to 4 bpp, and 5,6 and 7 bpp are rounded up to 8.
:p.:hp2.Output:ehp2.
:p.GBM will write all the above formats, and where there are choices,
the following options can be used &colon.-
:dl compact tsize=7 break=all.
:dt.:hp9.grey:ehp9.
:dd.GBM writes 4 bpp files by mapping them to the standard palette by
default.
The non default behaviour of mapping to a grayscale can be enabled by this
flag.
:dt.:hp9.pal:ehp9.
:dd.When writing 4 or 8 bpp files, this option tells GBM to write an XIMG
format file with the palette included.
:dt.:hp9.pixw=N:ehp9.,:hp9.pixh=N:ehp9.
:dd.This overrides the default pixel dimensions in the header.
The default is 85 by 85 microns.
:edl.
:p.Note that Image Alchemy 17 appears to assume a different standard 16 colour
palette when converting to GEM Raster format.
This disagrees with :hp2.all:ehp2. the testcase images currently encountered.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_PORTRAIT  \45\   Portrait:0:
:h2 res=2017.Portrait
:i2 refid=gbmsupp.Portrait
:p.Files with the :hp2..CVP:ehp2. extension are recognised as Portrait files.
:p.These files hold a single 512x512 24bpp RGB image.
Some photographers in Germany hand you a disk containing a .CVP file
when you get your passport pictures taken.
You can return later with the disk and get further prints made.
:p.Now with GBM supporting this format, you can convert to and from other
file formats and use paintbox programs to remove those ugly pimples...
:p.Pixels are not square in this file format, so images when loaded appear
horizontally stretched.
GBM leaves it up to the user to rescale the image to look nice.
Scaling horizontally by a factor somewhere between 0.75 and 0.8 gives a
pleasing effect.
:p.Of course, it is important to remember that Portrait files only hold
512x512 images, and if you take an image from elsewhere and convert to
Portrait, the image will be printed thinner at the photographers due to
this non-square-pixel problem.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_JPEG      \45\   JPEG:0:
:h2 res=2018.JPEG
:i2 refid=gbmsupp.JPEG
:p.The following file extensions
:xmp.
  .JPG .JPEG .JPE
:exmp.
:p.are recognised as JPEG files.
:p.Technically it is the JFIF type of JPEG files which are supported.
:p.8 bpp (greyscale) and 24 bpp files may be read.
:p.Only 24 bpp data may be written.
:p.:hp2.Output:ehp2.
:p.Bitmaps can be written with varying degrees of quality
(ie: degrees of lossyness of the compression).
They can also be written in a simple progressive manner.
:dl compact tsize=7 break=all.
:dt.:hp9.quality=Q:ehp9.
:dd.Causes the file to be written at quality Q, where Q is a rather
arbitrary measure.
Q can be in the range 0 to 100, with a reasonable default of 75.
:dt.:hp9.prog:ehp9.
:dd.Causes the file to be written as a progressive JPEG.
:edl.
:p.GBM can be compiled up either with or without support for JPEG.
If you don't see JPEG amongst the list of supported file formats on the
File Open dialog box, then you are using a GBM.DLL without support.
:p.The JPEG support for GBM is provided by the Independant JPEG Groups
JPEGLIB library, version 6a.
It may be freely used provided the IJG are credited (hence its use in GBM,
and this paragraph in the online help).
:p.The code to interface GBM to IJG 6a was written by
Mark Lisowski <mlisowski@aixterm1.urz.uni-heidelberg.de>.
I have made a couple of minor modifications.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
.*...sHID_GBM_OTHERS    \45\   Others:0:
:h2 res=2019.Others
:i2 refid=gbmsupp.Others
:p.Support for all the bitmap file formats may be added at any time,
without application writers being aware of it.
:p.Any new formats will be listed in the dialog filetype combobox,
although the help may not (yet) have an entry for them.
:p.The :link reftype=hd res=2001.Bitmap file format support:elink.
help panel lists other supported file formats.
.*...e
:index.
:euserdoc.
