/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.XrefErrorException;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import javax.swing.JOptionPane;

public class XrefCharBuffer {
    static final int ALLOCATION_UNIT_SIZE = 4096;
    public char[] buf = new char[4096];
    public int buflen = 4096;
    public int bufi = 0;

    void increaseSize(long len) {
        if ((long)this.bufi + len >= (long)this.buflen) {
            int nsize = this.buflen;
            while ((long)this.bufi + len >= (long)nsize) {
                nsize *= 2;
            }
            char[] nbuf = new char[nsize];
            System.arraycopy(this.buf, 0, nbuf, 0, this.bufi);
            this.buflen = nsize;
            this.buf = nbuf;
        }
    }

    public int length() {
        return this.bufi;
    }

    public char lastChar() {
        if (this.bufi > 0) {
            return this.buf[this.bufi - 1];
        }
        return '\u0000';
    }

    public void append(char[] b, int len) {
        this.increaseSize(len);
        System.arraycopy(b, 0, this.buf, this.bufi, len);
        this.bufi += len;
    }

    public void append(String ss) {
        int len = ss.length();
        this.increaseSize(len);
        ss.getChars(0, len, this.buf, this.bufi);
        this.bufi += len;
    }

    public void append(XrefCharBuffer ss, int offset, int len) {
        this.increaseSize(len);
        System.arraycopy(ss.buf, offset, this.buf, this.bufi, len);
        this.bufi += len;
    }

    public String toString() {
        return new String(this.buf, 0, this.bufi);
    }

    public String substring(int beginIndex, int endIndex) {
        return new String(this.buf, beginIndex, endIndex - beginIndex);
    }

    public int indexOf(char c, int beginIndex) {
        int i = beginIndex;
        while (i < this.bufi) {
            if (this.buf[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void appendFileContent(File ff) throws Exception {
        long fsize = ff.length();
        if (fsize > 20000000L) {
            int confirm = 0;
            confirm = JOptionPane.showConfirmDialog((Component)s.view, "Internal problem: Xrefactory tries to read a document which is too long. This may run\nXrefactory out of memory. Canceling this action usually does not cause serious problems.\n Can I cancel this reading?", "Xrefactory", 0, 2);
            if (confirm == 0) {
                return;
            }
        }
        if (fsize > 0L) {
            this.increaseSize(fsize);
            FileReader tf = new FileReader(ff);
            int n = tf.read(this.buf, this.bufi, this.buflen);
            tf.close();
            if ((long)n != fsize) {
                throw new XrefErrorException("file " + ff.getName() + " of size " + fsize + " but read only " + n + " bytes");
            }
            this.bufi += n;
        }
    }

    public void clear() {
        this.bufi = 0;
    }

    public XrefCharBuffer() {
    }

    public XrefCharBuffer(String initialValue) {
        this();
        this.append(initialValue);
    }

    static {
        ALLOCATION_UNIT_SIZE = 4096;
    }
}

