/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.XrefErrorException;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;

class Options {
    public static final int OPT_GENERAL = 0;
    public static final int OPT_COMMON = 1;
    public static final int OPT_PROJECT = 2;
    public static final int OPT_BOTH = 3;
    public static OptionDescription optFilesCaseUnSensitive;
    public static OptionDescription optJavaVersion;
    public static OptionDescription optCSuffixes;
    public static OptionDescription optJavaSuffixes;
    public static OptionDescription optProjectMarker;
    public static OptionDescription optInputFile;
    public static OptionDescription optPruneDirs;
    public static OptionDescription optRecurseDirs;
    public static OptionDescription optXrefsFile;
    public static OptionDescription optXrefNum;
    public static OptionDescription optCommentOption;
    public static OptionDescription optClassPath;
    public static OptionDescription optSourcePath;
    public static OptionDescription optJavaDocPath;
    public static OptionDescription optJdkClassPath;
    public static OptionDescription optLicense;
    public static OptionDescription[] allOptions;
    public static final int OPTIONS_ALLOCC_CHUNK = 2;
    String projectName;
    Option[] option = new Option[0];
    int optioni = 0;
    int allocatedSize = 0;

    Options(Options op) {
        this.projectName = op.projectName;
        this.option = new Option[op.option.length];
        int i = 0;
        while (i < op.optioni) {
            this.option[i] = new Option(op.option[i]);
            ++i;
        }
        this.optioni = op.optioni;
        this.allocatedSize = op.allocatedSize;
    }

    int indexOf(Option opt) {
        int i = 0;
        while (i < this.optioni) {
            if (s.stringArrayEqual(this.option[i].fulltext, opt.fulltext)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean contains(Option opt) {
        return this.indexOf(opt) != -1;
    }

    Option getContainedOption(OptionDescription od) {
        int i = 0;
        while (i < this.optioni) {
            if (this.option[i].option == od) {
                return this.option[i];
            }
            ++i;
        }
        return null;
    }

    void add(Option o) {
        if (this.optioni >= this.allocatedSize) {
            Option[] n = new Option[this.allocatedSize + 2];
            System.arraycopy(this.option, 0, n, 0, this.allocatedSize);
            this.option = n;
            this.allocatedSize += 2;
        }
        if (o.option.addAtBeginning) {
            System.arraycopy(this.option, 0, this.option, 1, this.optioni);
            this.option[0] = o;
        } else {
            this.option[this.optioni] = o;
        }
        ++this.optioni;
    }

    void add(Option o, int preferedIndex) {
        if (this.optioni >= this.allocatedSize) {
            Option[] n = new Option[this.allocatedSize + 2];
            System.arraycopy(this.option, 0, n, 0, this.allocatedSize);
            this.option = n;
            this.allocatedSize += 2;
        }
        if (preferedIndex < 0 || preferedIndex >= this.optioni) {
            this.option[this.optioni] = o;
        } else {
            int i = this.optioni;
            while (i > preferedIndex) {
                this.option[i] = this.option[i - 1];
                --i;
            }
            this.option[preferedIndex] = o;
        }
        ++this.optioni;
    }

    void delete(int i) {
        s.assertt(this.optioni > 0);
        --this.optioni;
        int j = i;
        while (j < this.optioni) {
            this.option[j] = this.option[j + 1];
            ++j;
        }
    }

    int delete(Option opt) {
        int i = this.indexOf(opt);
        if (i != -1) {
            this.delete(i);
        }
        return i;
    }

    String getProjectAutoDetectionOpt() {
        int i = 0;
        while (i < this.optioni) {
            if (this.option[i].option == optProjectMarker) {
                return this.option[i].fulltext[1];
            }
            ++i;
        }
        return "";
    }

    String getOptionText(Option o) {
        String res = "";
        if (o.option.compact) {
            String oo = "";
            int j = 0;
            while (j < o.fulltext.length) {
                oo = oo + o.fulltext[j];
                ++j;
            }
            res = o.option == optCommentOption ? res + oo + "\n" : res + s.sprintOption(oo);
        } else {
            int j = 0;
            while (j < o.fulltext.length) {
                if (j != 0) {
                    res = res + " ";
                }
                res = res + s.sprintOption(o.fulltext[j]);
                ++j;
            }
        }
        return res;
    }

    public String toString(boolean fileFormat) {
        String res = "\n";
        if (!this.projectName.equals("")) {
            res = res + "[" + this.projectName;
            String changeDirectories = this.getProjectAutoDetectionOpt();
            if (!changeDirectories.equals("")) {
                res = res + s.classPathSeparator + changeDirectories;
            }
            res = res + "]\n  ";
        } else {
            res = res + "  ";
        }
        int i = 0;
        while (i < this.optioni) {
            if (this.option[i].option != optProjectMarker) {
                res = (res = res + this.getOptionText(this.option[i])).charAt(res.length() - 1) == '\n' ? res + "  " : res + "\n  ";
            }
            ++i;
        }
        return res;
    }

    public String toString() {
        return this.toString(false);
    }

    public static void printOptions(Options[] pp, PrintStream oo) {
        int i = 0;
        while (i < pp.length) {
            oo.println(pp[i].toString());
            ++i;
        }
    }

    public static boolean projectMarkersOverlapps(String d1, String d2) {
        int d2len;
        int d1len = d1.length();
        return d1len == (d2len = d2.length()) ? d1.equals(d2) : (d1len < d2len ? d1.equals(d2.substring(0, d1len - 1)) && d2.substring(d1len, d1len + 1).equals(s.slash) : d2.equals(d1.substring(0, d2len - 1)) && d1.substring(d2len, d2len + 1).equals(s.slash));
    }

    /*
     * Unable to fully structure code
     */
    public static String getProjectName(String oo) {
        ii = new PathIterator(oo, s.classPathSeparator);
        if (ii.hasNext()) ** GOTO lbl7
        return "";
lbl-1000:
        // 1 sources

        {
            p = ii.next();
            if (p.length() <= 0 || p.substring(0, 1).equals(s.slash)) continue;
            return p;
lbl7:
            // 2 sources

            ** while (ii.hasNext())
        }
lbl8:
        // 1 sources

        ii = new PathIterator(oo, s.classPathSeparator);
        return ii.next();
    }

    public static String getProjectChangeDirs(String oo) {
        String pname = Options.getProjectName(oo);
        PathIterator ii = new PathIterator(oo, s.classPathSeparator);
        if (!ii.hasNext()) {
            return "";
        }
        String res = "";
        while (ii.hasNext()) {
            String p = ii.next();
            if (p.equals(pname)) continue;
            res = res.equals("") ? p : res + s.classPathSeparator + p;
        }
        return res;
    }

    public static String[] getProjectNames(Options[] projects, String zeroName) {
        String[] pn = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            pn[i] = projects[i].projectName;
            ++i;
        }
        pn[0] = zeroName;
        return pn;
    }

    public static void saveOptions(Options[] pp, String fileName) {
        block3: {
            PrintStream ps = null;
            try {
                ps = new PrintStream(new FileOutputStream(fileName));
                Options.printOptions(pp, ps);
                ps.close();
            }
            catch (Exception e) {
                if (s.debug) {
                    e.printStackTrace(System.err);
                }
                JOptionPane.showMessageDialog((Component)s.view, "While saving options: " + e, "Xrefactory Error", 0);
                if (ps == null) break block3;
                ps.close();
            }
        }
    }

    public static void dump(Options[] pp) {
        Options.printOptions(pp, System.err);
    }

    void addNewProjectOptions(String projectName, String changeDirectories, String classPath, String sourcePath) {
        this.add(new Option(optInputFile, changeDirectories));
        this.add(new Option(optPruneDirs, "CVS" + s.classPathSeparator + "backup"));
        this.add(new Option(optXrefsFile, s.tagFilesDirectory + projectName));
        this.add(new Option(optXrefNum, "10"));
        this.add(new Option(optClassPath, classPath));
        this.add(new Option(optSourcePath, sourcePath));
        this.add(new Option(optJavaVersion, "1.3"));
        this.add(new Option(optCSuffixes, "c" + s.classPathSeparator + "C"));
        this.add(new Option(optJavaSuffixes, "java"));
        this.add(new Option(optJdkClassPath, s.jdkClassPath));
        String jdkhome = new File(s.javaHome).getParent();
        if (jdkhome != null) {
            this.add(new Option(optJavaDocPath, jdkhome + "/docs/api"));
        }
    }

    Options(String projectName, String changeDirectories) {
        this.projectName = projectName;
        this.optioni = 0;
        this.add(new Option(optProjectMarker, changeDirectories));
    }

    static {
        OPT_GENERAL = 0;
        OPT_COMMON = 1;
        OPT_PROJECT = 2;
        OPT_BOTH = 3;
        optFilesCaseUnSensitive = new OptionDescription("-filescaseunsensitive", false, 0, 1, true, "File names are considered case unsensitive", "File names are considered case unsensitive", null, false, true);
        optJavaVersion = new OptionDescription("-source", true, 3, 2, false, "Sources are written in Java: ", "Java version in which sources are written.", null, false, true);
        optCSuffixes = new OptionDescription("-csuffixes=", false, 3, 2, true, "Suffixes determining C sources: ", "Identify files with those suffixes as C sources", null, true, true);
        optJavaSuffixes = new OptionDescription("-javasuffixes=", false, 3, 2, true, "Suffixes determining Java sources: ", "Identify files with those suffixes as Java sources", null, true, true);
        optProjectMarker = new OptionDescription("[", true, 2, 2, true, "Project auto detection directories: ", "Project auto detection directories", "p", false, false);
        optInputFile = new OptionDescription("", true, 2, 2, true, "Source files & directories: ", "Source files & directories", "p", false, true);
        optPruneDirs = new OptionDescription("-prune", true, 2, 2, false, "Prune directories: ", "Prune directories", "p", false, true);
        optRecurseDirs = new OptionDescription("--r", false, 2, 1, true, "Do not descent into subdirectories when looking for input files", "Do not descent into subdirectories when looking for input files", null, true, true);
        optXrefsFile = new OptionDescription("-refs", true, 2, 2, false, "Place to store Tags: ", "Place to store Tag", "fd", false, true);
        optXrefNum = new OptionDescription("-refnum=", false, 2, 2, true, "Number of Tag files: ", "Number of Tag files", null, false, true);
        optCommentOption = new OptionDescription("//", false, 3, 0, true, "Comment", "Comment", null, false, false);
        optClassPath = new OptionDescription("-classpath", true, 3, 2, false, "Classpath: ", "Top directories with .class files (classpath)", "p", false, true);
        optSourcePath = new OptionDescription("-sourcepath", true, 3, 2, false, "Sourcepath: ", "Top directories with source code (sourcepath)", "p", false, true);
        optJavaDocPath = new OptionDescription("-javadocpath", true, 3, 2, false, "Javadocpath: ", "Top directories with javadoc documentation (javadocpath)", "p", false, false);
        optJdkClassPath = new OptionDescription("-jdkclasspath", true, 3, 2, false, "Jdk runtime library (rt.jar): ", "Jdk runtime library (rt.jar)", "p", false, true);
        optLicense = new OptionDescription("-license=", true, 1, 2, true, "License string: ", "License string", null, false, false);
        allOptions = new OptionDescription[]{optInputFile, optPruneDirs, optRecurseDirs, optCSuffixes, optJavaSuffixes, optLicense, optClassPath, optSourcePath, optJavaDocPath, optJavaVersion, optXrefNum, optProjectMarker, optXrefsFile, optJdkClassPath, optCommentOption, new OptionDescription("-set", false, 3, 3, false, "Set a user defined variable: ", "Set a user defined variable", "fd", false, false), new OptionDescription("-refs=", false, 2, 2, true, "Place to store Tags: ", "Place to store Tags", "fd", false, true)};
        OPTIONS_ALLOCC_CHUNK = 2;
    }

    static class OptionParser {
        XrefCharBuffer ss;
        int sslen;
        int ind;
        public static final int MAX_PROJECTS = 1000;

        private static OptionDescription getOptionDescription(String opt) {
            int i = allOptions.length - 1;
            while (i >= 0) {
                OptionDescription o = allOptions[i];
                if (o.compact && opt.length() >= o.nameLen && opt.substring(0, o.nameLen).equals(o.name) || !o.compact && opt.equals(o.name)) {
                    return o;
                }
                --i;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        String parseOptItem() {
            block3: {
                b = this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
                if (this.ind >= this.sslen || this.ss.buf[this.ind] != '\"') ** GOTO lbl11
                ++this.ind;
                while (this.ind < this.sslen && this.ss.buf[this.ind] != '\"') {
                    ++this.ind;
                }
                opt = this.ss.substring(b + 1, this.ind);
                ++this.ind;
                break block3;
lbl-1000:
                // 1 sources

                {
                    ++this.ind;
lbl11:
                    // 2 sources

                    ** while (this.ind < this.sslen && !Character.isWhitespace((char)this.ss.buf[this.ind]))
                }
lbl12:
                // 1 sources

                opt = this.ss.substring(b, this.ind);
            }
            while ((j = opt.indexOf("${dq}")) != -1) {
                opt = opt.substring(0, (int)var3_3) + "\"" + opt.substring((int)(var3_3 + 5));
            }
            return opt;
        }

        private Option parseOption() throws XrefErrorException {
            Object res = null;
            int b = this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
            if (this.ind < this.sslen && this.ss.buf[this.ind] == '[') {
                while (this.ind < this.sslen && this.ss.buf[this.ind] != ']') {
                    ++this.ind;
                }
                String opt = this.ss.substring(b + 1, this.ind);
                ++this.ind;
                return new Option(optProjectMarker, opt);
            }
            String opt = this.parseOptItem();
            OptionDescription desc = OptionParser.getOptionDescription(opt);
            if (desc == null) {
                throw new XrefErrorException("unknown option " + opt);
            }
            if (desc.name.equals("//")) {
                b = this.ind;
                while (this.ind < this.sslen && this.ss.buf[this.ind] != '\n') {
                    ++this.ind;
                }
                String oval = opt.substring(2) + this.ss.substring(b, this.ind);
                return new Option(desc, oval);
            }
            if (desc.compact) {
                return new Option(desc, opt.substring(desc.nameLen));
            }
            String[] vals = new String[desc.arity - 1];
            int i = 1;
            while (i < desc.arity) {
                vals[i - 1] = this.parseOptItem();
                ++i;
            }
            return new Option(desc, vals);
        }

        public void reParseSingleProject(Options cp) throws Exception {
            cp.optioni = 0;
            while (this.ind < this.sslen) {
                Option oo = this.parseOption();
                if (oo.option == optProjectMarker) {
                    cp.add(new Option(optProjectMarker, Options.getProjectChangeDirs(oo.fulltext[1])));
                } else {
                    cp.add(oo);
                }
                this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
            }
        }

        public Options[] parseFile() throws Exception {
            Options cp;
            Options[] res = new Options[1000];
            int resi = 0;
            res[resi++] = cp = new Options("", "");
            while (this.ind < this.sslen) {
                Option oo = this.parseOption();
                if (oo.option == optProjectMarker) {
                    String pname = Options.getProjectName(oo.fulltext[1]);
                    String chdirs = Options.getProjectChangeDirs(oo.fulltext[1]);
                    res[resi++] = cp = new Options(pname, chdirs);
                } else {
                    cp.add(oo);
                }
                this.ind = s.skipBlank(this.ss, this.ind, this.sslen);
            }
            Options[] rres = new Options[resi];
            System.arraycopy(res, 0, rres, 0, resi);
            return rres;
        }

        OptionParser(File ff) throws Exception {
            this.ss = new XrefCharBuffer();
            this.ss.appendFileContent(ff);
            this.sslen = this.ss.length();
            this.ind = 0;
        }

        OptionParser(String s2) {
            this.ss = new XrefCharBuffer(s2);
            this.sslen = this.ss.length();
            this.ind = 0;
        }

        static {
            MAX_PROJECTS = 1000;
        }
    }

    static class Option {
        OptionDescription option;
        String[] fulltext;

        Option(OptionDescription desc) {
            this.option = desc;
            this.fulltext = new String[]{desc.name};
        }

        Option(OptionDescription desc, String optval) {
            this.option = desc;
            this.fulltext = new String[]{desc.name, optval};
        }

        Option(OptionDescription desc, String[] optvals) {
            this.option = desc;
            this.fulltext = new String[optvals.length + 1];
            this.fulltext[0] = desc.name;
            int i = 0;
            while (i < optvals.length) {
                this.fulltext[i + 1] = optvals[i];
                ++i;
            }
        }

        Option(Option o) {
            this.option = o.option;
            this.fulltext = new String[o.fulltext.length];
            int i = 0;
            while (i < o.fulltext.length) {
                this.fulltext[i] = o.fulltext[i];
                ++i;
            }
        }
    }

    public static class PathIterator {
        String ss;
        int sslen;
        int i;
        String separator;

        public String next() {
            String res;
            int j = this.ss.indexOf(this.separator, this.i);
            if (j == -1) {
                res = this.ss.substring(this.i);
                this.i = this.sslen + 1;
            } else {
                res = this.ss.substring(this.i, j);
                this.i = j + 1;
            }
            return res;
        }

        public boolean hasNext() {
            return this.i < this.sslen;
        }

        public void remove() {
        }

        PathIterator(String ss, String separator) {
            this.ss = ss;
            this.separator = separator;
            this.sslen = ss.length();
            this.i = 0;
        }
    }

    public static class OptionDescription {
        String name;
        int nameLen;
        int arity;
        boolean compact;
        String shortDescription;
        String longDescription;
        boolean interactive;
        int kind;
        boolean addAtBeginning;
        boolean recreateTagsIfModified;
        String fileSystemBrowseOptions;

        OptionDescription(String name, boolean interactive, int kind, int arity, boolean compact, String shortDescription, String longDescription, String fileSystemBrowseOptions, boolean addAtBeginning, boolean recreateTagsIfModified) {
            this.interactive = interactive;
            this.name = name;
            this.nameLen = name.length();
            this.arity = arity;
            this.kind = kind;
            this.compact = compact;
            this.shortDescription = shortDescription;
            this.longDescription = longDescription;
            this.fileSystemBrowseOptions = fileSystemBrowseOptions;
            this.addAtBeginning = false;
            this.recreateTagsIfModified = recreateTagsIfModified;
        }
    }
}

