/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class DockableUrlBrowser
extends JPanel {
    View view;
    JButton back;
    JButton forward;
    JEditorPane viewer;
    JTextField urlField;
    String[] history;
    int historyPos;
    String baseURL;

    public void gotoURL(String url, boolean addToHistory) {
        this.viewer.setCursor(Cursor.getDefaultCursor());
        URL _url = null;
        try {
            _url = new URL(url);
            this.urlField.setText(_url.toString());
            this.viewer.setPage(_url);
            if (addToHistory) {
                this.history[this.historyPos] = url;
                if (this.historyPos + 1 == this.history.length) {
                    System.arraycopy(this.history, 1, this.history, 0, this.history.length - 1);
                    this.history[this.historyPos] = null;
                } else {
                    ++this.historyPos;
                }
            }
        }
        catch (MalformedURLException mf) {
            Log.log((int)9, (Object)this, (Object)mf);
            Object[] args = new String[]{url, mf.getMessage()};
            GUIUtilities.error((Component)this, (String)"badurl", (Object[])args);
            return;
        }
        catch (IOException io) {
            Log.log((int)9, (Object)this, (Object)io);
            Object[] args = new String[]{url, io.toString()};
            GUIUtilities.error((Component)this, (String)"read-error", (Object[])args);
            return;
        }
    }

    public DockableUrlBrowser(View view, String position) {
        this.view = view;
        try {
            this.baseURL = new File(MiscUtilities.constructPath((String)jEdit.getJEditHome(), (String)"doc")).toURL().toString();
        }
        catch (MalformedURLException mu) {
            Log.log((int)9, (Object)this, (Object)mu);
        }
        this.history = new String[25];
        ActionHandler actionListener = new ActionHandler();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        JLabel label = new JLabel(jEdit.getProperty((String)"helpviewer.url"));
        label.setBorder(new EmptyBorder(0, 12, 0, 12));
        Box box = new Box(1);
        box.add(Box.createGlue());
        this.urlField = new JTextField();
        this.urlField.addKeyListener(new KeyHandler());
        Dimension dim = this.urlField.getPreferredSize();
        dim.width = Integer.MAX_VALUE;
        this.urlField.setMaximumSize(dim);
        box.add(this.urlField);
        box.add(Box.createGlue());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.setBorder(new EmptyBorder(0, 12, 0, 0));
        this.back = new RolloverButton(GUIUtilities.loadIcon((String)jEdit.getProperty((String)"helpviewer.back.icon")));
        this.back.setToolTipText(jEdit.getProperty((String)"helpviewer.back.label"));
        this.back.addActionListener(actionListener);
        toolBar.add(this.back);
        this.forward = new RolloverButton(GUIUtilities.loadIcon((String)jEdit.getProperty((String)"helpviewer.forward.icon")));
        this.forward.addActionListener(actionListener);
        this.forward.setToolTipText(jEdit.getProperty((String)"helpviewer.forward.label"));
        toolBar.add(this.forward);
        toolBar.add(Box.createGlue());
        this.back.setPreferredSize(this.forward.getPreferredSize());
        if (s.javaVersion.compareTo("1.4.0") >= 0) {
            this.viewer = new JEditorPane("text/html", "");
            StyleSheet styles = ((HTMLEditorKit)this.viewer.getEditorKit()).getStyleSheet();
            styles.removeStyle("body");
        } else {
            this.viewer = new JEditorPane();
        }
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.setLayout(new GridBagLayout());
        s.addGbcComponent(this, 0, 0, 1, 1, 1000, 1000, 1, new JScrollPane(this.viewer));
        s.addGbcComponent(this, 1, 0, 1, 1, 1, 1, 1, toolBar);
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                DockableUrlBrowser.this.gotoURL(DockableUrlBrowser.this.urlField.getText(), true);
            }
        }
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (evt instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)DockableUrlBrowser.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
                } else {
                    URL url = evt.getURL();
                    if (url != null) {
                        DockableUrlBrowser.this.gotoURL(url.toString(), true);
                    }
                }
            } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                DockableUrlBrowser.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                DockableUrlBrowser.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == DockableUrlBrowser.this.back) {
                if (DockableUrlBrowser.this.historyPos <= 1) {
                    DockableUrlBrowser.this.getToolkit().beep();
                } else {
                    String url = DockableUrlBrowser.this.history[--DockableUrlBrowser.this.historyPos - 1];
                    DockableUrlBrowser.this.gotoURL(url, false);
                }
            } else if (source == DockableUrlBrowser.this.forward) {
                if (DockableUrlBrowser.this.history.length - DockableUrlBrowser.this.historyPos <= 1) {
                    DockableUrlBrowser.this.getToolkit().beep();
                } else {
                    String url = DockableUrlBrowser.this.history[DockableUrlBrowser.this.historyPos];
                    if (url == null) {
                        DockableUrlBrowser.this.getToolkit().beep();
                    } else {
                        ++DockableUrlBrowser.this.historyPos;
                        DockableUrlBrowser.this.gotoURL(url, false);
                    }
                }
            }
        }
    }
}

