/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.ArrayEnumerator;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeNode;

class DirectoryNode
implements TreeNode,
Comparable {
    File ff;
    DirectoryNode parent;
    DirectoryNode[] subs = null;
    String name;
    boolean isDirectory;

    private boolean fileFilter(File ff) {
        if (ff.isDirectory()) {
            return true;
        }
        String name = ff.getName();
        int len = name.length();
        if (name.lastIndexOf(".java") == len - 5) {
            return true;
        }
        if (name.lastIndexOf(".JAVA") == len - 5) {
            return true;
        }
        if (name.lastIndexOf(".jav") == len - 4) {
            return true;
        }
        if (name.lastIndexOf(".JAV") == len - 4) {
            return true;
        }
        if (name.lastIndexOf(".jar") == len - 4) {
            return true;
        }
        if (name.lastIndexOf(".JAR") == len - 4) {
            return true;
        }
        if (name.lastIndexOf(".zip") == len - 4) {
            return true;
        }
        return name.lastIndexOf(".ZIP") == len - 4;
    }

    public int compareTo(Object o) {
        return this.ff.getName().compareTo(((DirectoryNode)o).ff.getName());
    }

    private void setSubs() {
        File[] files = FileSystemView.getFileSystemView().getFiles(this.ff, true);
        int count = 0;
        int i = 0;
        while (i < files.length) {
            if (this.fileFilter(files[i])) {
                ++count;
            }
            ++i;
        }
        this.subs = new DirectoryNode[count];
        int j = 0;
        int i2 = 0;
        while (i2 < files.length) {
            if (this.fileFilter(files[i2])) {
                this.subs[j] = new DirectoryNode(this, files[i2]);
                ++j;
            }
            ++i2;
        }
        Arrays.sort(this.subs);
    }

    public Enumeration children() {
        if (this.subs == null) {
            this.setSubs();
        }
        return new ArrayEnumerator(this.subs);
    }

    public TreeNode getChildAt(int i) {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs[i];
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean getAllowsChildren() {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs.length != 0;
    }

    public boolean isLeaf() {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs.length == 0 && !this.isDirectory;
    }

    public int getChildCount() {
        if (this.subs == null) {
            this.setSubs();
        }
        return this.subs.length;
    }

    public int getIndex(TreeNode t) {
        if (this.subs == null) {
            this.setSubs();
        }
        int i = 0;
        while (i < this.subs.length) {
            if (t == this.subs[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        return this.name;
    }

    DirectoryNode(DirectoryNode parent, File ff) {
        this.parent = parent;
        this.ff = ff;
        this.isDirectory = ff.isDirectory();
        String str = ff.toString();
        String pth = ff.getAbsolutePath();
        this.name = str.equals(pth) ? ff.getName() : str;
        if (this.name.equals("")) {
            this.name = str;
        }
    }
}

