/*
 * Decompiled with CFR 0.152.
 */
package com.xrefactory.jedit;

import com.xrefactory.jedit.Dispatch;
import com.xrefactory.jedit.DispatchData;
import com.xrefactory.jedit.Opt;
import com.xrefactory.jedit.XrefCharBuffer;
import com.xrefactory.jedit.s;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class CompletionDialog2
extends JDialog {
    DispatchData data;
    XrefCharBuffer completions = new XrefCharBuffer();
    int[] lines;
    int[] cidents;
    int[] vlevs;
    JTable table;
    JScrollPane scrollPane;
    public static CompletionDialog2 lastcDialog = null;

    void closeDialog() {
        this.setVisible(false);
    }

    void showDialog() {
        this.table.setModel(new CompletionTableModel());
        this.table.setShowGrid(false);
        this.table.setDefaultRenderer(this.table.getColumnClass(0), new CompletionTableCellRenderer());
        this.pack();
        Dimension dim = this.table.getSize();
        dim.height += 3;
        dim.width += 3;
        if (dim.getHeight() > (double)Opt.completionDialogMaxHeight()) {
            dim.setSize(dim.getWidth() + 20.0, (double)Opt.completionDialogMaxHeight());
        }
        if (dim.getWidth() > (double)Opt.completionDialogMaxWidth()) {
            dim.setSize((double)Opt.completionDialogMaxWidth(), dim.getHeight() + 20.0);
        }
        this.setSize(dim);
        this.table.setAutoResizeMode(4);
        this.table.doLayout();
        this.setLocation(s.recommendedLocation((Component)s.getTextArea()));
        s.moveOnScreen(this);
        this.setVisible(true);
    }

    static CompletionDialog2 initCompletionDialog(DispatchData data, int number, int noFocus) {
        if (lastcDialog == null) {
            lastcDialog = new CompletionDialog2();
        } else if (lastcDialog.isVisible()) {
            lastcDialog.setVisible(false);
            lastcDialog = new CompletionDialog2();
        } else {
            lastcDialog = new CompletionDialog2();
        }
        CompletionDialog2.lastcDialog.data = data;
        CompletionDialog2.lastcDialog.completions.clear();
        CompletionDialog2.lastcDialog.lines = new int[number + 1];
        CompletionDialog2.lastcDialog.cidents = new int[number];
        CompletionDialog2.lastcDialog.vlevs = new int[number];
        return lastcDialog;
    }

    static void showCompletionDialog() {
        lastcDialog.showDialog();
    }

    CompletionDialog2() {
        super((Frame)s.view, "");
        if (s.javaVersion.compareTo("1.4.0") >= 0) {
            this.setUndecorated(true);
        }
        this.table = new JTable();
        this.scrollPane = new JScrollPane(this.table);
        this.setContentPane(this.scrollPane);
        this.setModal(true);
        this.table.addKeyListener(new CompletionKeyAdapter());
        this.enableEvents(8L);
    }

    public class CompletionKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            boolean searchFlag;
            char key = e.getKeyChar();
            int code = e.getKeyCode();
            int mod = e.getModifiers();
            boolean bl = searchFlag = code == 9;
            if (code != 38 && code != 40 && code != 224 && code != 225 && code != 33 && code != 34 && code != 37 && code != 39 && code != 36 && code != 35) {
                e.consume();
            }
            if (code == 10) {
                int line = CompletionDialog2.this.table.getSelectedRow() + 1;
                CompletionDialog2.this.setVisible(false);
                DispatchData ndata = new DispatchData(CompletionDialog2.this.data, (Component)CompletionDialog2.this);
                XrefCharBuffer receipt = ndata.xTask.callProcessSingleOpt("-olcomplselect" + line, ndata);
                Dispatch.dispatch(receipt, ndata);
            } else if (!(code == 32 && (e.getModifiers() & 2) != 0 || code == 32 || code == 8 || Character.isLetterOrDigit(key) || key == '_' || key == '$' || searchFlag || "`~!@#$%^&*()_+|-=\\{}[]:\";'<>?,./".indexOf(key) != -1 || code != 27)) {
                CompletionDialog2.this.closeDialog();
            }
        }

        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    }

    public class CompletionTableCellRenderer
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable t, Object val, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                return new JLabel(CompletionDialog2.this.completions.substring(CompletionDialog2.this.lines[row], CompletionDialog2.this.cidents[row]), 4);
            }
            if (column == 1) {
                return new JLabel(CompletionDialog2.this.completions.substring(CompletionDialog2.this.cidents[row], CompletionDialog2.this.lines[row + 1]), 2);
            }
            return new JLabel("");
        }
    }

    public class CompletionTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return CompletionDialog2.this.lines.length - 1;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return CompletionDialog2.this.completions.substring(CompletionDialog2.this.lines[row], CompletionDialog2.this.cidents[row]);
            }
            return CompletionDialog2.this.completions.substring(CompletionDialog2.this.cidents[row], CompletionDialog2.this.lines[row + 1]);
        }
    }
}

