' FileName: FTNApp.Bas
' Date: 12-12-2016
' Author: Ben Ritchey
' Description: FIDONet Application Generator

#COMPILER PBCC 5
#COMPILE EXE
#DIM ALL

DECLARE FUNCTION TextInput(Buffer AS STRING, Row AS LONG, Col AS LONG, _
                           History() AS STRING) AS LONG

FUNCTION PBMAIN () AS LONG

LOCAL MONTHTAB() AS STRING
LOCAL EOTIMEOUT AS DOUBLE
LOCAL ETO AS DOUBLE
LOCAL PNAME, PrTxt AS STRING
LOCAL UName, BName, LName, VNum,DNum, BTime, EMAddy, IConnect AS STRING
LOCAL DMain, BRate, SpIns, MSoft, EToss, FToss, FSysOp AS STRING
LOCAL A, C AS STRING
LOCAL B, retVal, GoBack AS LONG
LOCAL Row, Col, TCol AS Integer
LOCAL Z AS STRING
LOCAL AA, AB AS INTEGER
LOCAL L AS INTEGER
LOCAL AC AS STRING
LOCAL CX, CY, SX, SY AS Long
  LOCAL buffer AS STRING
  REDIM history1(0) AS STRING  'add a history array for each text field if needed.

' Init Code Starts Here * * * * * * * *
  SHELL "Cmd /C Mode Con Cols=80 Lines=50"
  COLOR 15,9: CLS: ON ERROR GOTO INTERROR
  DIM MONTHTAB(12): TCol=80: Row=46: Col=4
  EOTIMEOUT=TIMER+60
100 PNAME="FIDONet"
  IF Len(COMMAND$)>1 THEN PNAME=COMMAND$
  PName=" -=:{ "+PName+" Application }:=-"
  FOR L=1 TO 12
    MONTHTAB(L)=READ$(L)
   NEXT L
  Open "MyFTNApp.Txt" for Output as #1
  Print #1,TIME$;" ";PName;"  on ";

200  LOCATE 1,1
  COLOR 14: LOCATE 1, INT((80 - LEN(PNAME$)) / 2): PRINT PNAME$;
  COLOR 11: LOCATE 1, 2: PRINT " FTNApp v1.1.B ";
  COLOR 4: LOCATE 2,3: PRINT " {c} 2017  BJr ";
'    LOCATE 25,60: PRINT " Serial #";
'    COLOR 15: PRINT "xxxyymB100";  '                       *** Serial # ***
  COLOR 15: LOCATE 3,1

300  Z=Z+MONTHTAB(VAL(MID$(DATE$,1,2)))+STR$(VAL(MID$(DATE$,4,2)))
  A="th": AA=VAL(MID$(DATE$,4,2))
  IF AA=1 OR AA=21 OR AA=31 THEN A="st"
  IF AA = 2 OR AA = 22 THEN A = "nd"
  IF AA = 3 OR AA = 23 THEN A = "rd"
  Z = Z + A + ", " + MID$(DATE$, 7, 4): AA=79-LEN(Z)
  LOCATE 1,AA: PRINT Z;
  Print #1,Z: Print #1

' 400  GOSUB DOTOD

' 1000  LOCATE 3, 1: COLOR 3

' * * * * * * * *  C O D E  G O E S  B E L O W  * * * * * * * *

GetUName:
PrTxt="Enter REAL Name (First Last): "
Buffer=UName
Gosub Grabit
If C="" then beep: beep: beep: goto GetUName
UName=C
Locate 4,1: Color 15,9
Print space$(TCol);: Locate 4,1
Print "User Name = ";UName;

GetEMAddy:
PrTxt="Enter Email Address: "
Buffer=EMAddy
Gosub Grabit
If GoBack then goto GetUName
If C="" then beep: beep: beep: goto GetEMAddy
EMAddy=C
locate 5,1: Color 15,9
Print space$(TCol);: Locate 5,1
Print "Email Address = ";EMAddy;

GetBName:
PrTxt="Enter BBS/Site Name: "
Buffer=BName
Gosub Grabit
If GoBack then goto GetEMAddy
If C="" then beep: beep: beep: goto GetBName
BName=C
locate 6,1: Color 15,9
Print space$(TCol);: Locate 6,1
Print "BBS/Site Name = ";BName;

GetLName:
PrTxt="Enter Location (City, State): "
Buffer=LName
Gosub Grabit
If GoBack then goto GetBName
If C="" then beep: beep: beep: goto GetLName
LName=C
locate 7,1: Color 15,9
Print space$(TCol);: Locate 7,1
Print "Location = ";LName;

GetVNum:
PrTxt="Enter Voice phone no. (i.e. 1-337-555-1212): "
Buffer=VNum
Gosub Grabit
If GoBack then goto GetLName
If C="" then beep: beep: beep: goto GetVNum
VNum=C
locate 8,1: Color 15,9
Print space$(TCol);: Locate 8,1
Print "Voice phone no. = ";VNum;

GetBTime:
PrTxt="Enter Best time to call (i.e. 7am-9pm): "
Buffer=BTime
Gosub Grabit
If GoBack then goto GetVNum
' If C="" then beep: beep: beep: goto GetBTime
BTime=C
locate 9,1: Color 15,9
Print space$(TCol);: Locate 9,1
Print "Best Time to call = ";BTime;

GetDNum:
PrTxt="Enter Data phone no. (Dialup only): "
Buffer=DNum
Gosub Grabit
If GoBack then goto GetBTime
' If C="" then beep: beep: beep: goto GetDNum
DNum=C
locate 10,1: Color 15,9
Print space$(TCol);: Locate 10,1
Print "Data phone no. = ";DNum;

GetBRate:
If GoBack and DNum="" then goto GetDNum
If DNum="" then goto GetIConnect  ' no Dialup

PrTxt="Enter Max DCE BAUD Rate (300-38400): "
Buffer=BRate
Gosub Grabit
If GoBack then goto GetDNum
' If C="" then beep: beep: beep: goto GetBRate
BRate=C
locate 11,1: Color 15,9
Print space$(TCol);: Locate 11,1
Print "BAUD Rate = ";BRate;

GetIConnect:
PrTxt="Internet Connectivity? (BinkP, Telnet, FTP): "
Buffer=IConnect
Gosub Grabit
If GoBack then goto GetBRate
' If C="" then beep: beep: beep: goto GetIConnect
IConnect=C
locate 12,1: Color 15,9
Print space$(TCol);: Locate 12,1
Print "Internet Connectivity = ";IConnect;

GetDMain:
PrTxt="Enter Domain Name or Static IP Address: "
Buffer=DMain
Gosub Grabit
If GoBack then goto GetIConnect
' If C="" then beep: beep: beep: goto GetDMain
DMain=C
locate 13,1: Color 15,9
Print space$(TCol);: Locate 13,1
Print "Domain/Static IP = ";Dmain;

GetMSoft:
PrTxt="Enter Name of Mailer Software: "
Buffer=MSoft
Gosub Grabit
If GoBack then goto GetDMain
' If C="" then beep: beep: beep: goto GetMSoft
MSoft=C
locate 14,1: Color 15,9
Print space$(TCol);: Locate 14,1
Print "Mailer Software = ";MSoft;

GetEToss:
PrTxt="Enter Name of Echomail Tosser: "
Buffer=EToss
Gosub Grabit
If GoBack then goto GetMSoft
' If C="" then beep: beep: beep: goto GetEToss
EToss=C
locate 15,1: Color 15,9
Print space$(TCol);: Locate 15,1
Print "Echomail Tosser = ";EToss;

GetFToss:
PrTxt="Enter Name of File Tosser: "
Buffer=FToss
Gosub Grabit
If GoBack then goto GetEToss
' If C="" then beep: beep: beep: goto GetFToss
FToss=C
locate 16,1: Color 15,9
Print space$(TCol);: Locate 16,1
Print "File Tosser = ";FToss;

GetFSysOp:
PrTxt="Were you ever a Listed FIDONet SysOp? (Y/N): "
Buffer=FSysOp
Gosub Grabit
If GoBack then goto GetFToss
If C="" then beep: beep: beep: goto GetFSysOp
If C="Y" or C="y" then C="Yes"
If C="N" or C="n" then C="No"
FSysOp=C
locate 17,1: Color 15,9
Print space$(TCol);: Locate 17,1
Print "Former SysOp = ";FSysOp;

GetSpIns:
PrTxt="Enter any Special Instructions: "
Buffer=SpIns
Gosub Grabit
If GoBack then goto GetFSysOp
' If C="" then beep: beep: beep: goto GetSpIns
SpIns=C
locate 18,1: Color 15,9
Print space$(TCol);: Locate 18,1
Print "Special Instructions = ";SpIns;

locate Row-3,1
for L=1 to 7: Print space$(TCol);: next L

locate Row,1
Print "Everything OK? (Y/N) ";: Input A

If A="Y" or A="y" or A="YES" or A="Yes" or A="yes" then
  Print
  Print "Data output to file MyFTNApp.Txt ... {Press ENTER} ";
  Input A
  Goto Finished
 else
  Goto GetUName
end if

' * * * * * * * * Sub-routines below * * * * * * * *

Dumpem:
Print #1,"Real Name = ";UName
Print #1,"Email Address = ";EMAddy
Print #1,"BBS/Site Name = ";BName
Print #1,"Location = ";LName
Print #1,"Voice Phone = ";VNum
Print #1,"Best Time to call = ";BTime
Print #1,"Data Phone = ";DNum
Print #1,"BAUD Rate = ";BRate
Print #1,"Internet = ";IConnect
Print #1,"Domain/IP = ";DMain
Print #1,"Mailer = ";MSoft
Print #1,"Echomail Tosser = ";EToss
Print #1,"File Tosser = ";FToss
Print #1,"Former SysOp = ";FSysOp
Print #1,"Instructions = ";SpIns
Print #1
Print #1,TIME$;" ==={ End of Application }=== "
Close
Return

Grabit:

' SX=CURSORX: SY=CURSORY
'Locate CursorY-1
Locate Row-3, 1: Color 14,9
Print space$(TCol);
Locate Row-3, 1
Print PrTxt

Locate Row-2, 1: Color 11
Print space$(TCol);
Locate Row-2, 1
if buffer<>"" then
  Print " { ESC = clear  Alt+B = go Back  SmartEdit ON  Home|End|Ins|Del|Arrows } "
 else
  Print " { ESC = clear  Alt+B = go Back  Home|End|Ins|Del|Arrows } "
end if

Color 14
Print
Print " ";chr$(16);" ";
GoBack=0
CX=CURSORX: CY=CURSORY

' *** Check if passing data to edit
if buffer="" then
  buffer=space$(255)
 else
  buffer=buffer+space$(255-len(buffer))
end if

'If A<>"" then buffer=A+Mid$(buffer,2) ' pass 1st key ...

retVal=TextInput(buffer,CY,CX,history1())
C=Trim$(buffer)
If Mid$(C,1,2)=Chr$(0)+Chr$(48) then GoBack=1: C=""

Return

' * * * * * * * *  C O D E  G O E S  A B O V E  * * * * * * * *
REM  ERROR(123)
  GOTO FINISHED

PROMPT:
  COLOR 15: PRINT Z: COLOR 14: INPUT A
  COLOR 15
 RETURN
MESSAGE:
  PRINT Z
 RETURN
DOTOD:
  CX=CURSORX: CY=CURSORY
  Z=TIME$: AA=VAL(MID$(TIME$, 1, 2))
  IF AA>11 THEN Z=Z+" Pm" ELSE Z=Z+" Am"
  IF AA>12 THEN
    A=MID$(STR$(AA-12),2)
    IF LEN(A)=1 THEN A=" "+A
    MID$(Z,1)=A
  END IF
  LOCATE 2,67: PRINT Z;
  LOCATE CY,CX
 RETURN

INTERROR:
  AB=ERL: AC=ERROR$(ERR): AA=ERRCLEAR

10000 PRINT

  BEEP
  COLOR 4
  PRINT "  Internal Error: ";
  COLOR 3: PRINT "Line";
  COLOR 15: PRINT AB;: COLOR 3: PRINT "  Code";
  COLOR 15: PRINT AA;: COLOR 3: PRINT " = ";
  COLOR 15: PRINT AC
  COLOR 3: PRINT "  Press any key ...";

  A="": WHILE A="": A=INKEY$: WEND
'  ON ERROR GOTO 0 ' Run-time use!
  RESUME FINISHED

' *** Debug
  BEEP
  PRINT "Ok": A="": WHILE A="": A=INKEY$: WEND
' *** Debug

FINISHED:
55000 Rem
  Gosub Dumpem

COLOR 7: PRINT
  ON ERROR GOTO EXITOR
  Z="": ETO=0

55500  SHELL "CMD /C CLS"

EXITOR:

REM Month Table Data
DATA January, February, March, April, May, June
DATA July, August, September, October, November, December

END FUNCTION

' TextInput function (c) 2005 Geo Massar

FUNCTION TextInput(Buffer AS STRING, Row AS LONG, Col AS LONG, _
                   History() AS STRING) AS LONG
  STATIC InsertOff    AS LONG
  LOCAL  BufferLen    AS LONG
  LOCAL  MyKey        AS STRING
  LOCAL  KeyVal       AS LONG
  LOCAL  ColorDefault AS BYTE
  LOCAL  CurPos       AS LONG
  LOCAL  HistoryIdx   AS LONG

  BufferLen = LEN(Buffer)
  HistoryIdx = UBOUND(History)                 'index to the empty slot
  ColorDefault = SCREENATTR(CURSORY,CURSORX)
  LOCATE Row, Col : COLOR 14, 1, BufferLen     'bright yellow against blue
  If mid$(Buffer,1,1)<>" " then
    PRINT String$(BufferLen,chr$(249));
    LOCATE Row, Col: print buffer;
   else
    PRINT String$(BufferLen,chr$(249));
  End if
  LOCATE Row, Col
  CurPos = 1

  DO
    MyKey = WAITKEY$
    SELECT CASE LEN(MyKey)
      CASE 1    : KeyVal = ASC(MyKey)
      CASE 2    : KeyVal = - ASC(MyKey, 2)
      CASE ELSE : ITERATE
    END SELECT

    SELECT CASE KeyVal
      CASE 13, 9  'Enter, Tab
        COLOR ColorDefault MOD 16, ColorDefault \ 16
        FUNCTION = KeyVal
        IF TRIM$(Buffer) = "" THEN EXIT FUNCTION
        HistoryIdx = UBOUND(History)
        IF HistoryIdx > 0 THEN IF Buffer = History(HistoryIdx-1) THEN EXIT FUNCTION
        History(HistoryIdx) = Buffer
        INCR HistoryIdx
        REDIM PRESERVE History(HistoryIdx)
        History(HistoryIdx) = SPACE$(BufferLen)  'new slot for the next entry
        EXIT FUNCTION

      CASE 27  ' ESCape
        If CurPos=1 then 
          If Buffer="" then Exit Function
          LOCATE Row, Col
          PRINT Space$(Len(Buffer));
          Buffer=""
         else
          CurPos=1
        End if

      CASE -48  'Alt+B
        Mid$(Buffer,1,2)=Chr$(0)+Chr$(48)
        Exit Function

      CASE -72  'Up
        IF HistoryIdx > 0 THEN  DECR HistoryIdx
        Buffer = History(HistoryIdx)
        CurPos = LEN(RTRIM$(Buffer)) + 1

      CASE -80  'Down
        IF HistoryIdx < UBOUND(History) THEN INCR HistoryIdx
        Buffer = History(HistoryIdx)
        CurPos = LEN(RTRIM$(Buffer)) + 1

      CASE -82 'Insert
       IF InsertOff THEN
         InsertOff = 0
         CURSOR ON, 1
       ELSE
         InsertOff = 1
         CURSOR ON, 100
       END IF

      CASE 8 'BackSpace
       IF CurPos > 1 THEN
         DECR CurPos
         Buffer = LEFT$(Buffer, CurPos - 1) & MID$(Buffer, CurPos + 1) & " "
       END IF

      CASE -75 'Left
       IF CurPos > 1 THEN DECR CurPos

      CASE -77 'Right
       IF CurPos < BufferLen THEN INCR CurPos

      CASE -71 'Home
       CurPos = 1

      CASE -79 'End
       CurPos = MIN(LEN(RTRIM$(Buffer)) + 1, BufferLen)

      CASE -83 'Del
       Buffer = LEFT$(Buffer, CurPos - 1) & MID$(Buffer, CurPos + 1) & " "

      CASE 32 TO 255 'Valid charaters
       IF InsertOff THEN
         MID$(Buffer, CurPos, 1) = MyKey
       ELSE
         Buffer = LEFT$(Buffer, CurPos - 1) & MyKey & MID$(Buffer, CurPos, BufferLen - CurPos)
       END IF
       IF CurPos < BufferLen THEN INCR CurPos

      CASE ELSE
       ITERATE
    END SELECT

    LOCATE Row, Col
    PRINT Buffer;
    LOCATE Row, Col + CurPos - 1
  LOOP
END FUNCTION

' End of FTNApp.Bas
