;-----------------------------------------------------------------------------------------------
;  NetFoss Spy Monitor
;  Version 1.10
;  Written by Mike Ehlert - PC Micro Systems, Inc. 
;  http://pcmicro.com/netfoss
;  Released as Public Domain, Open Source Code.
;  Read NetFoss.txt for license details.
; 
;  Compile in MASM32, using Qeditor > Project > "Console Assemble and Link"
;  or link using Polink.exe for optimum file size.
;------------------------------------------------------------------------------------------------

.586
.model flat,stdcall

option casemap:none
   include \masm32\include\windows.inc	; Windows
   include \masm32\include\user32.inc	; User
   include \masm32\include\kernel32.inc	; Kernel
   include \masm32\include\winmm.inc	; MultiMedia play functions
   include \masm32\include\masm32.inc	; MASM32
   include \masm32\macros\macros.asm	; MASM32 Macros
   includelib \masm32\lib\user32.lib	; User
   includelib \masm32\lib\kernel32.lib	; Kernel
   includelib \masm32\lib\winmm.lib 	; MultiMedia play functions
   includelib \masm32\lib\masm32.lib	; MASM32
   includelib \masm32\lib\msvcrt.lib	; C library (only used for getkey)

   StartMonitor      proto
   SetTextColor      proto :BYTE
   MonitorMailThread proto
   String2Dword      proto :DWORD

ESC_CHAR       EQU     27

.data
align 4

   OsVer			OSVERSIONINFO <>

   sb_len             dd 0
   null	              dd 0	   
   bytes_written      dd 0
   fMtStrinG          db  "%lu",0			; Format string mode used by wsprintf
   ;ClassName         db  "ConsoleWindowClass",0
   AppName            db  'NetSpy',0
   BBSSpyTitle	      db  "NetSpy node "
   NodeTxt            db  "   ",0
   TelnetSrvTxt       db  "BBS node snooping tool - version 1.10", 0 ; 225,"3",0 
   zero               db  "0",0			; zero ascii string
   one                db  "1",0			; one  ascii string
   DotSlash           db  "./",0		; Default StartPath
   spacestring        db  " ",0                ; string spacer
   CRLF               db  10,13,0
   HitEscAgainTxt     db  10,10,10,10,10,"        Press [ESC] to exit BBSsPY, or any other key to resume."
   
   mailslot_spy_cons  db '\\.\mailslot\netfoss\spy_console' ; mailslot provides bbsspy data from netcom
   slotnodetxt_cons   db "   ",0

   mailslot_spy_input db '\\.\mailslot\netfoss\spy_input' ; mailslot sends input data from bbsspy to netfoss.dll
   slotnodetxt_input  db '   ',0

   outkey db 0,0
   WindowSize DW 0,0,79,24  ;WindowSize  SMALL_RECT <0,0,79,24>

   Align 4
   hMailslot_CONS       dd 0 ; Handle of our MailSlot
   hMailslot_INPUT      dd 0

   csbi CONSOLE_SCREEN_BUFFER_INFO <> ; Structure used for Console screen positioning

.data?
align 4
   INI_ADDR       dd ?		; Address of NET2BBS.INI
   hWnd           dd ?		; Handle of Console Window
   hStdIn         dd ?		; Handle of Standard Input - not used
   hStdOut        dd ?		; Handle ot Standard Output - Needed for Color text 
   ThreadID       dd ?		; Thread ID is not used currently (write only)
   written        dd ?		; Bytes written to log file - Not currently used (write only)

   CommandLine     db 128 dup (?); Command Line
   SlotHeader      dd ?
   SlotHeaderxy    dd ?
   WindowSize1     dd ?
   WindowSize2     dd ?
   SlotBuffer2     db 16000 dup (?) ; MailSlot Read Buffer
   buffer db 1000 dup (?)


   DebugModeTxt    db   2 dup (?) ; Ascii "0"=disable, "1"=enable - Display debug messages 
   MainViewTxt     db   3 dup (?) ; Ascii text of the ShowWindow mode for this window
   temp            dd          ?  ; Temporary dword used by FillConsoleOutputAttribute

.code

start:
	invoke ArgClC,1,ADDR CommandLine ; Check command line
	mov ax, word ptr CommandLine
	or ah,020h
	cmp ax,'n/' ; check for /n being passed as first Command Line parameter.
	je got_node
	cmp ax,'n-' ; check for -n being passed as first Command Line parameter.
	jne exitnow
got_node:
	mov eax, dword ptr CommandLine+2
	mov esi,offset NodeTxt
	mov ecx,4
getnodelp:
	cmp al,"0"
	jl  gotnode2
	cmp al,"9"
	ja gotnode2
	mov [esi],al
	shr eax,8
	inc esi
	dec ecx
	jnz getnodelp
        xor eax,eax

gotnode2:
	mov byte ptr [esi],0 
	mov eax, dword ptr NodeTxt
	mov dword ptr slotnodetxt_cons,eax
	mov dword ptr slotnodetxt_input,eax

	invoke StartMonitor

exitnow:
	invoke ExitProcess,0

;---------------------------------------------------------------------------------------------

; StartMonitor - Configure Console screen and connect to the Net2BBS MailSlot,
  StartMonitor proc near


;	invoke	AllocConsole ; Allocate Consoe is not needed?!

init_console:

	invoke GetConsoleWindow                                ; Define Console Window Handle
	mov    hWnd,eax 
	invoke GetStdHandle,STD_OUTPUT_HANDLE                  ; Define Output Handle
	mov   hStdOut,eax
	invoke  GetStdHandle,STD_INPUT_HANDLE
	mov   hStdIn,eax
	Invoke SetConsoleTitle, ADDR BBSSpyTitle              ; Set Console Window Title
;	call   InitConsole

	invoke SetConsoleCtrlHandler,NULL,TRUE ; Prevent Ctrl-C from killing us.

	invoke FillConsoleOutputCharacter,hStdOut,32,ecx,NULL,ADDR temp ; null=cord
	;movzx edx,ATTRIBUTE
	xor edx,edx
	invoke FillConsoleOutputAttribute,hStdOut,edx,ecx,NULL,ADDR temp ; null=cord
	xor edx,edx
	invoke locate,edx,edx
	invoke SetTextColor,15
	;cls
	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi

	movzx  ebx,csbi.dwSize.x ; columns
	movzx  eax,csbi.dwSize.y ; rows
	shl    ebx,16  ; Multiply column count by 256 to create a blue screen
	; This size is overkill!
	invoke FillConsoleOutputAttribute,hStdOut,31,ebx,0,ADDR temp    ; Create Blue background color
	invoke SetTextColor,10+(1*16) ;Green text on purple background
	print " BBSsPYķ " ; Was -=BBSsPY=-
	invoke SetTextColor,15+(1*16) ; white text on purple background
	invoke StdOut,ADDR TelnetSrvTxt
	xor ebx,ebx
 	invoke locate,6,ebx
	print "s"               ; make the "2" in Net2BBS white
	invoke SetTextColor,7+(1*16) ; blue text on blue background
	invoke locate,74,ebx
	print chr$(250),"pcm",250,13,10,10 ; sign it .pcm.

;--------------------------------------------------------------------------
; Create spy Read Mailslot (CONSOLE)
;--------------------------------------------------------------------------

; maxsize of the mailslot should be either 8192, or 16384

	invoke CreateMailslot,
	ADDR mailslot_spy_cons,		; Filename
	16384, ;sizeof SlotBuffer2,      ; was ADDR maxsize Maximum size
	MAILSLOT_WAIT_FOREVER,  ; Read timeout in milliseconds
	NULL              	; pointer to security struct	

	.if   eax == INVALID_HANDLE_VALUE ; was it created?

		print "Failed to create read mailslot."
		jmp   error_exit
	.endif 

	mov   hMailslot_CONS,eax
	print "BBSsPY mailslot inbound CONSOLE created.",13,10
	invoke Sleep,1000
	xor eax,eax
	invoke CreateThread,eax,eax,offset MonitorMailThread,eax,eax,addr ThreadID ;hAcceptThread2
	invoke CloseHandle,eax


readkey:
	Call   AnyKey
	and ecx, 00000011b
	jz noalt
	mov al,0 ; if it is an ALT-key, then AL=0
noalt:
	cmp hMailslot_INPUT,0 ; If a mailslot is created, then send the key... otherwise try to create it.
	jne MailSlotAlive
	push eax

;pusha
;print "creating input mailslot",13,10
;popa

	invoke CreateFile,ADDR mailslot_spy_input,\
			  GENERIC_WRITE,\
			  FILE_SHARE_READ,\
			  0,\
			  OPEN_EXISTING,\
			  FILE_ATTRIBUTE_NORMAL,\
			  0

	cmp eax,INVALID_HANDLE_VALUE
	jne  spycreated

	invoke CloseHandle,hMailslot_CONS ; first close the Read MailSlot

	print "The outbound mailslot connecting to NETFOSS.DLL failed to open.",13,10
	print "Check that you have the current NETFOSS.DLL located in: \Windows\system32\",13,10
	POP EAX
	jmp error_exit

spycreated:
	mov hMailslot_INPUT, eax

	;pusha
	;print "spy_input created",13,10
	;popa

	pop EAX

MailSlotAlive:

	;or ecx,ecx		; is it an extended key code, (function key, arrow, etc)?
	;jz standard_key	; skip this if its not.

	;extended_key:
	;	cmp al,59		; test for F1 key	
	;	je gotF1
	;	jne readkey		; ignore any other extended key

standard_key:

	cmp al,16 ; ctrl-P is the Escape from the redirector key
	je gotesc

	mov word ptr outkey,ax

	invoke WriteFile, hMailslot_INPUT,\   ; handle to write to
		OFFSET outkey,\                       ; buffer address
		2,\                    ; max bytes to write is 2
		OFFSET bytes_written,\        ; bytes actually written
		0                           ; Flags

	jmp readkey		; loop if no matches

;------
gotesc:
	; "ESC" was pressed - Display a separate console buffer with a Red background to confirm exit

	invoke	SetTextColor,15+(4*16)   ; Create a new Console screen with White Text on Red Background
	xor ecx,ecx
	invoke	CreateConsoleScreenBuffer,GENERIC_READ OR GENERIC_WRITE,ECX,ECX,CONSOLE_TEXTMODE_BUFFER,ECX
	mov	ebx,eax 	    ; Save Handle of Screenbuffer in ebx
	invoke	WriteConsole,ebx,ADDR HitEscAgainTxt, sizeof HitEscAgainTxt, ADDR written, NULL ;Print to it

	invoke	SetConsoleActiveScreenBuffer, ebx ; Activate it
	invoke	SetTextColor,10 + 0 ; Bright Green  ; Restore color of future output
	getkey			; wait for a second keypress
	push eax
	invoke CloseHandle,ebx	; close the red console buffer first (1.02 fix for Win 7)
	pop eax
	cmp al,01Bh		; ESC key?
	je done		; If so, cleanup and exit
	or al,020h		; force lower-case result
readkeyx:
    	jmp readkey    ; Return to main key menu

error_exit:
	invoke SetTextColor,15 + 0	; Color= White
	print chr$(10), 13, "*** Press Enter to Exit ***"
jel:
	getkey
	cmp al,13  ; Got Enter?
	jne jel    ; jello till we do
	jmp done


done:
	invoke SetTextColor,15 + 0	; Set White text on black background
	ret				; Exit

StartMonitor endp

    
;-------------------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------------------------------
MonitorMailThread proc Near

	invoke ReadFile, hMailslot_CONS,\ ; Read data from mailslot
		OFFSET SlotHeader,\                   ; Buffer address
		16384, ; sizeof SlotBuffer2,\           ; Max amount to read
		OFFSET sb_len,\         ; number of bytes actually read
		NULL                    ; overlapped

	mov esi, sb_len             ; See how much we got
	or  esi, esi                ; got nothing this time?
	jz  MonitorMailThread

	mov edx, SlotHeaderxy
	cmp edx, -1    ; Check for "die" command
	jne setcursor  ; if not found, then set cursor
	invoke ExitProcess,0 ; Die if told to


setcursor:

; CURSOR POSITIONING provided by NetCom

	mov eax, SlotHeader
	movsx ebx,ax
	shr eax,16
	invoke locate,ebx,eax ; position the cursor to the correct location

	mov edx, SlotHeaderxy
	or edx,edx
	jz MonitorMailThread ; If the xy position is zero, then only a cursor update was requested

; ebx = first physical screen position to write to (always start at the top)
; edx = size (in x/y positions) to write to

	xor ebx,ebx   ; start at the top row

	invoke   WriteConsoleOutput, hStdOut,  ; handle
                            offset SlotBuffer2, ;
                            edx,   ; Lines (H)-Cols (L)
                            ebx,   ; first buffer cell screen position
                            offset WindowSize1  ; rectangle
                            
	jmp MonitorMailThread

MonitorMailThread endp


;------------------------------------------------------------------------------------------------
; Get the Application Path

GetAppPath proc near lpPathBuffer:DWORD

	invoke GetModuleFileName,0,lpPathBuffer,128  ; return length in eax
	add eax, lpPathBuffer         ; Search from end to start
findslash:
	dec eax                        
	cmp BYTE PTR [eax],"\"  	; find the last "\"
	jne  findslash
	mov  BYTE PTR [eax+1],0		; write zero terminator after "\"
	;mov  eax, lpPathBuffer
	ret
GetAppPath endp



;------------------------------------------------------------------------------------------------
; Convert Double-Word to ASCII string
;
; dwValue is passed as a value, direct, indirect or in register
; lpBuffer is the ADDRESS of the receiving buffer
; Returns with eax= number of characters written to buffer (zero=error).
;
; EXAMPLE:
; invoke dw2a,edx,ADDR buffer


dw2a proc near dwValue:DWORD, lpBuffer:DWORD

	invoke wsprintfA,lpBuffer,ADDR fMtStrinG,dwValue
	ret
dw2a endp


;------------------------------------------------------------------------------------------------
SetTextColor proc near foreback16:BYTE ;was fore:DWORD,back:DWORD

; 
; This proc sets the foreground and background attributes for
; the characters written to the console screen buffer.
;
; The color values are normal 4-bit IRGB character mode
; attributes where:
;   bit3 = intensity
;   bit2 = red
;   bit1 = green
;   bit0 = blue
; 
; The attribute is stored in a single byte (contained in a dword).
	;mov   eax,back
	;shl   eax,4
	;or	  eax,fore
      movzx eax,foreback16
      ;mov ATTRIBUTE,al ;!!!!
	invoke SetConsoleTextAttribute,hStdOut,eax ; was ,eax
	ret
SetTextColor endp

;======================================================================
;                               String2Dword
;======================================================================
; This procedure takes an address of a string and converts it to a dword
; value which it returns in eax
;======================================================================
String2Dword proc near String:DWORD ;uses ecx edi edx esi String:DWORD
	xor     ecx,ecx
	mov     edi,String
	invoke StrLen,String 
	
	.while eax!=0   ; eax = length
		;xor edx,edx
		movzx edx,byte ptr [edi]
		sub dl,"0"      ; subtrack each digit with "0" to convert it to hex value
	;  jc error
		mov esi,eax
		dec esi
		push eax
		mov eax,edx
		push ebx
		mov ebx,10
		.while esi > 0
			mul ebx
			dec esi
		.endw
		pop ebx
		dec eax
		add ecx,eax
		pop eax
		inc edi
		dec eax
	.endw
	mov eax,ecx
	ret
String2Dword endp

;*************************************************************************************************************

AnyKey  PROC

;Wait for Any Console Key Press - contributed by DednDave
;
; This function returns when any console key is pressed (bKeyDown = 1).
; A possible drawback is that all input pevent records are removed from
; the console input queue until a key is pressed. In many cases, this is
; not an issue. The virtual key code, virtual scan code, TCHAR character,
; and control key state values are returned in registers.

;Call With: Nothing
;
;  Returns: EAX = TCHAR character (high word of EAX = 0)
;           ECX = control key state flags
;               Bit   Name                Meaning
;                0    RIGHT_ALT_PRESSED   Right ALT key is pressed
;                1    LEFT_ALT_PRESSED    Left ALT key is pressed
;                2    RIGHT_CTRL_PRESSED  Right CTRL key is pressed
;                3    LEFT_CTRL_PRESSED   Left CTRL key is pressed
;                4    SHIFT_PRESSED       SHIFT key is pressed
;                5    NUMLOCK_ON          NUM LOCK light is on
;                6    SCROLLLOCK_ON       SCROLL LOCK light is on
;                7    CAPSLOCK_ON         CAPS LOCK light is on
;                8    ENHANCED_KEY        Key is enhanced
;           EDX:
;           low word (DX) = virtual key code
;               high word = virtual scan code
;
;           all other registers are preserved

        push    edx
        push    ebx
        push    ebp
        sub     esp,(sizeof INPUT_RECORD+3) and -4
        mov     ebp,esp
        ;INVOKE  GetStdHandle,STD_INPUT_HANDLE
mov ebx, hStdIn
        ;xchg    eax,ebx
        push    ecx

AnyKy0:
        invoke  Sleep,10
        INVOKE  ReadConsoleInput,ebx,ebp,1,esp
        movzx   edx,word ptr [ebp].INPUT_RECORD.EventType
        cmp     edx,KEY_EVENT                             ;KEY_EVENT EQU 1
        jnz     AnyKy0

        cmp     edx,[ebp].INPUT_RECORD.KeyEvent.bKeyDown
        jnz     AnyKy0

        pop     ecx
        movzx   eax,word ptr [ebp].INPUT_RECORD.KeyEvent.UnicodeChar
        mov     edx,dword ptr [ebp].INPUT_RECORD.KeyEvent.wVirtualKeyCode
        shr     edx,16
        mov     ah,dl
        mov     ecx,[ebp].INPUT_RECORD.KeyEvent.dwControlKeyState
        add     esp,(sizeof INPUT_RECORD+3) and -4
        pop     ebp
        pop     ebx
        pop     edx

;--- mikes patch---
	cmp eax,03800h ; check for just alt key - filter this out
	JE AnyKey
;------------------
        ret

AnyKey  ENDP

end start
 