;-----------------------------------------------------------------------------------------------
;  Net2BBS Service Monitor
;  Version 1.10
;  Written by Mike Ehlert - PC Micro Systems, Inc. 
;  http://pcmicro.com/netfoss
;  Released as Public Domain, Open Source Code.
;  Read Net2BBS.txt for license details.
; 
;  Compile in MASM32, using Qeditor > Project > "Console Assemble and Link"
;  or link using Polink.exe for optimum file size.
;------------------------------------------------------------------------------------------------

.586
.model flat,stdcall

option casemap:none
   include \masm32\include\windows.inc	; Windows
   include \masm32\include\user32.inc	; User
   include \masm32\include\kernel32.inc	; Kernel
   include \masm32\include\winmm.inc	; MultiMedia play functions
   include \masm32\include\masm32.inc	; MASM32
   include \masm32\include\advapi32.inc	; Services

   include \masm32\macros\macros.asm	; MASM32 Macros
   includelib \masm32\lib\user32.lib	; User
   includelib \masm32\lib\kernel32.lib	; Kernel
   includelib \masm32\lib\winmm.lib 	; MultiMedia play functions
   includelib \masm32\lib\masm32.lib	; MASM32
   includelib \masm32\lib\msvcrt.lib	; C library (only used for getkey)
   includelib \masm32\lib\advapi32.lib    ; Services


   StartMonitor      proto
   GetAppPath        proto :DWORD
   ReadMyFile        proto :DWORD    
   PlayWav           proto :DWORD
   SetTextColor      proto :BYTE
   Shell             proto :DWORD,:DWORD
   GetFromIni        proto :DWORD,:DWORD,:DWORD,:DWORD
   MonitorMailThread proto
   ShowError         proto :DWORD
   ServiceStop       proto
   OpenMyService     proto

.data
align 4

   ServiceHandle		dd	0
   ServicesDatabase	dd	0
   ServiceCurrentStatus	dd	0
   ServiceEvent		dd	0
   hServiceThread		dd	0
   ServiceDesc		dd	0
   ServiceStatus		dd	0
   OsVer			OSVERSIONINFO <>

   ServiceTable		SERVICE_TABLE_ENTRY <0,0>
   status			SERVICE_STATUS <>

   ServiceFileName	db	"net2bbs.exe",0
   FileParameter	db    " /s",0          ; /s informs exe to run as a service.
   ServiceName		db	"Net2BBS",0		
   DisplayName		db	"Net2BBS Telnet Server",0		
   ServiceDescription	db	"Allows Incoming telnet connections.",0
; The ServiceDescription is only supported in Windows 2000 and later

; Service Start Method:
	; SERVICE_BOOT_START
	; SERVICE_SYSTEM_START
	; SERVICE_AUTO_START
	; SERVICE_DEMAND_START - Start using Windows service manager.

   ServiceStartFlag	dd	SERVICE_DEMAND_START
   ServiceTypeFlag	dd	SERVICE_WIN32_OWN_PROCESS or SERVICE_INTERACTIVE_PROCESS

   sb_len           dd 0
   null             dd  0	   
   fMtStrinG        db  "%lu",0			; F;ormat string mode used by wsprintf
   ;ClassName       db  "ConsoleWindowClass",0
   Net2BBSTitle	    db  "Net2BBS "
   TelnetSrvTxt     db  "Telnet Server Monitor",0
   VersionTxt       db  " 1.10",0 ; 225,"1",0 
   IniFileName      db  "net2bbs.ini",0
   HelpFileName     db  "net2bbs.txt",0
   SpyFileName      db  "netspy.exe -n"
   SpyNodeTxt       db "   ",0
   IniSectionName   db  "Settings", 0	; [Settings] is our .INI Section
   MissingTxt       db  "Missing ",0         ; Log message when missing socket policy
   zero             db  "0",0			; zero ascii string
   one              db  "1",0			; one  ascii string
   DotSlash         db  "./",0		; Default StartPath

   LogonWav         db  "logon.wav",0        ; Play this sound during a new logon (if it exists)
   LogoffWav        db  "logoff.wav",0       ; Play this sound during a logoff (if it exists)
   spacestring      db  " ",0                ; string spacer
   CRLFLFLFLF       db  10
   CRLFLFLF         db  10
   CRLFLF           db  10
   CRLF             db  10,13,0
;  ANSIClear        db  01Bh,"[2J"		; ANSI command to clear the remote screen
   HitEscAgainTxt   db  10,10,10,10,10,"    Press [ESC] to exit [R] to restart service, or any other key to resume."

   HitEscAgainTxt2  db  13,10,10,10,   "    If the Interactive Services Detection Service is running you may also",13,10,"    press [0] to switch to Session 0.",13,10
   


   mailslot       db '\\.\mailslot\net2bbs',0 ;  mailslot provides log updates from Net2BBS.EXE
   Align 4
   readslot       dd 0 ; Handle of our MailSlot

   Session0       db "rundll32.exe winsta.dll,WinStationSwitchToServicesSession",0
 
   csbi CONSOLE_SCREEN_BUFFER_INFO <> ; Structure used for Console screen positioning

.data?
align 4
   INI_ADDR       dd ?		; Address of NET2BBS.INI
   hWnd           dd ?		; Handle of Console Window
;  hStdIn         dd ?		; Handle of Standard Input - not used
   hStdOut        dd ?		; Handle ot Standard Output - Needed for Color text 
   ThreadID       dd ?		; Thread ID is not used currently (write only)
   written        dd ?		; Bytes written to log file - Not currently used (write only)
   HelpY          dd ?		; Y position of the help line on the Console screen

   PathName        db 256 dup (?) ; PathName of Service EXE.
   CommandTxt      db 128 dup (?) ; Spawn Command line provided in INI
   StartPath       db 128 dup (?) ; Node Start Path provided in INI
   KillFileName    db 128 dup (?) ; List of blocked IP's
   EditorName      db 256 dup (?) ; Editor Filename + space + path to Net2BBS\
   EditorCmd       db 256 dup (?) ; Editor Filename + space + path to Net2BBS\filename to open
   LogFileName     db 128 dup (?) ; Log FileName
   SlotBuffer      db 132 dup (?) ; MailSlot Buffer
   DebugModeTxt    db   2 dup (?) ; Ascii "0"=disable, "1"=enable - Display debug messages 
   MainViewTxt     db   3 dup (?) ; Ascii text of the ShowWindow mode for this window
   SpyViewTxt      db   3 dup (?) ; Ascii text of the showWindow mode for node windows
   NodeLinesTxt    db   4 dup (?) ; Ascii text of the number of lines in the node window (25 or 50)
   SpyView         db          ?  ; Node ShowWindow view. Default = 1 (Normal)

   temp            dd          ?  ; Temporary dword used by FillConsoleOutputAttribute

; Data structures:

   sinfo_   STARTUPINFO <?>		; Used for shell
   pinfo_   PROCESS_INFORMATION <?> ; Used for shell

.code

start:
			invoke ArgClC,1,ADDR EditorCmd ; Check command line
			mov ax, word ptr EditorCmd
			or ah,020h
			cmp ax,'i/' ; check for /i being passed as first Command Line parameter.
			je Do_Install
			cmp ax,'i-' ; check for /i being passed as first Command Line parameter.
			je Do_Install
	      		cmp ax, 'f/'  ; check for /u being passed as first Command Line parameter.
      			je Do_Delete
      			cmp ax, 'f-'  ; check for /u being passed as first Command Line parameter.
      			je Do_Delete

			invoke StartMonitor  ; Otherwise just run the monitor normally
			invoke ExitProcess,0

;---------
Do_Install: 

			invoke OpenMyService
			invoke CloseServiceHandle,ServiceHandle
			invoke GetFullPathName, addr ServiceFileName, sizeof PathName, addr PathName, NULL
			invoke lstrcat, ADDR PathName, ADDR FileParameter	; Append the PathName 	   

			invoke CreateService,ServicesDatabase,addr ServiceName,addr DisplayName,SERVICE_ALL_ACCESS,ServiceTypeFlag,ServiceStartFlag,SERVICE_ERROR_NORMAL,addr PathName,0,0,0,0,0
			mov	ServiceHandle,eax
			test	eax,eax
			jnz	ServiceCreated
			invoke	GetLastError
			cmp	eax,ERROR_SERVICE_EXISTS
			jne	ServiceExit2

alreadyexists:
			print "Service already exists.",13,10
			jmp ServiceExit2

ServiceCreated:
		mov	[OsVer.dwOSVersionInfoSize],sizeof OsVer;
		invoke GetVersionEx,addr OsVer
		test	eax,eax
		jz	UnknownVersion
		.if	[OsVer.dwOSVersionInfoSize] >= 5
			; Add service description if OS >= Win2k
			.if	[OsVer.dwPlatformId] == VER_PLATFORM_WIN32_NT
				mov	eax,offset ServiceDescription
				mov	[ServiceDesc], eax
				invoke	ChangeServiceConfig2, ServiceHandle, 1, addr ServiceDesc ; SERVICE_CONFIG_DESCRIPTION
			.endif
		.endif
UnknownVersion:

		invoke	StartService,ServiceHandle,0,0 ; Start the service
		print "Service Installed.",13,10
		jmp ServiceExit


; Delete the service!

Do_Delete:
			invoke OpenMyService
			jc	DoesNotExist
			invoke CloseServiceHandle,ServiceHandle

			invoke OpenService,ServicesDatabase,addr ServiceName,SERVICE_ALL_ACCESS or DELETE
			mov	ServiceHandle,eax
			test	eax,eax
			jnz	ServiceOpened
			print "Can't open Service."
			jmp ServiceExit2
DoesNotExist:
			cmp eax,123456789
			je ServiceExit2
			print "Service does not exist.",13,10
			jmp ServiceExit2
ServiceOpened:
			invoke ServiceStop
			jc CantStopx
			invoke DeleteService,ServiceHandle
			test	eax,eax
			jnz	ServiceDeleted
			print "Unable to delete Service.",13,10
			jmp ServiceExit
CantStopx:
			print "Unable to stop Service.",13,10
			jmp ServiceExit

ServiceDeleted:
			print "Service Deleted.",13,10
ServiceExit:
			invoke	CloseServiceHandle,ServiceHandle
ServiceExit2:
			invoke	CloseServiceHandle,ServicesDatabase
			invoke	ExitProcess,0

;---------------------------------------------------------------------------------------------
; Open the Service Control Manager, and Open the Service itself
OpenMyService proc
			invoke OpenSCManager,0,0,SC_MANAGER_CREATE_SERVICE
			test	eax,eax
			jnz	GotDatabase

			mov	[OsVer.dwOSVersionInfoSize],sizeof OsVer;
			invoke	GetVersionEx,addr OsVer
			test	eax,eax
			jz	OSunknown
			.if	[OsVer.dwOSVersionInfoSize] >= 6
				; Check if if OS >= Vista
				print "Administrator rights required.",13,10
				mov eax,123456789 ; dirty id
			.else
				print "Cant open Services Database.",13,10
				xor eax,eax
			.endif
OSunknown:
			stc
			ret
GotDatabase:
			mov	ServicesDatabase,eax
			invoke OpenService,eax,addr ServiceName,SERVICE_ALL_ACCESS
			test	eax,eax
			jz	InvalidService
			mov	ServiceHandle,eax ; Save Service Handle
			clc
			ret ; Returns ServiceHandle in EAX
InvalidService:
			stc
			ret
OpenMyService endp

;---------------------------------------------------------------------------------------------
; Stop the Service, and wait for the Service to Stop
ServiceStop proc

			invoke	QueryServiceStatus,ServiceHandle,addr status ; Get the status
			test	eax,eax
			jz	NoServiceState2
			mov	eax,status.dwCurrentState
   			cmp	eax,SERVICE_STOPPED 			; Check if Service is Stopped.
   			je	ServiceStopped                        ; If so, start it.

			invoke	ControlService,ServiceHandle,SERVICE_CONTROL_STOP,addr status ; Stop Service!
			test eax,eax
			jz CantStop

waitforstopped:
			invoke Sleep,10
			;print "waiting for stop",13,10
			invoke	QueryServiceStatus,ServiceHandle,addr status
			test	eax,eax
			jz	NoServiceState2
			mov	eax,status.dwCurrentState
			cmp	eax,SERVICE_STOPPED
 			jne	waitforstopped
ServiceStopped:
			clc
			ret
NoServiceState2:
			print "No Service State.",13,10
CantStop:
			stc
			ret

ServiceStop endp

;---------------------------------------------------------------------------------------------

; StartMonitor - Configure Console screen and connect to the Net2BBS MailSlot,
  StartMonitor proc near

	invoke	AllocConsole ; Allocate Consoe


init_console:

		invoke GetConsoleWindow                                ; Define Console Window Handle
		mov    hWnd,eax 
		invoke GetStdHandle,STD_OUTPUT_HANDLE                  ; Define Output Handle
		mov   hStdOut,eax
		Invoke SetConsoleTitle, ADDR Net2BBSTitle              ; Set Console Window Title
		;call   InitConsole

		cls
		invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
		movzx ebx,csbi.dwSize.x
		shl   ebx,1  ; Multiply column count by 2 to create a 2-line purple bar
		invoke FillConsoleOutputAttribute,hStdOut,81,ebx,NULL,ADDR temp    ; Create Purple background color at top
		invoke SetTextColor,10+(5*16) ;Green text on purple background
		print " Net2BBSķ " ; Was -=Net2BBS=-
		invoke SetTextColor,15+(5*16) ; white text on purple background
		;print " Telnet Server 1.xx",225,"2" ; 1.xxB2
		invoke StdOut,ADDR TelnetSrvTxt
		invoke StdOut,ADDR VersionTxt

		xor ebx,ebx
		invoke locate,6,ebx
		print "2"               ; make the "2" in Net2BBS white
		invoke SetTextColor,7+(5*16) ; blue text on blue background
		invoke locate,74,ebx
		print chr$(250),"pcm",250,13,10,10 ; sign it .pcm.
  
readini:
		call GetSettingsFromIni 	; Read the INI file and process it (this sets text color to green)
		jnc iniok
		jmp error_exit			; exit if INI file not found
iniok:	

		cmp byte ptr DebugModeTxt,"0"
		je Nodebug
		print "Debug: Cmd="
		invoke StdOut,ADDR CommandTxt
		invoke StdOut,ADDR CRLF		; print chr$(13),10

Nodebug:

		invoke StdOut,ADDR CRLFLFLF ; move cursor 3 lines down
		invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
		movzx eax,csbi.dwCursorPosition.y ; Get 'y' Cursor position.
		dec eax
		dec eax
		mov HelpY,eax ; HelpY is the Vertiical position of the help-text showing the hotkey commands.


;--------------------------------------------------------------------------
; Create Read Mailslot
;--------------------------------------------------------------------------

		invoke CreateMailslot,
			ADDR mailslot,		; Filename
			sizeof SlotBuffer,      ; was ADDR maxsize Maximum size
			MAILSLOT_WAIT_FOREVER,  ; Read timeout in milliseconds
			NULL              	; pointer to security struct	

		.if   eax == INVALID_HANDLE_VALUE ; was it created?

			print "Failed to create mailslot."
			jmp   error_exit
		.endif 
		mov   readslot,eax

		xor eax,eax
		invoke CreateThread,eax,eax,offset MonitorMailThread,eax,eax,addr ThreadID ;hAcceptThread2
		invoke CloseHandle,eax

		invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
		mov ebx,HelpY
		invoke locate,0,ebx
		invoke SetTextColor,7 + 0 ; Light White Text

	print "Commands: [ESC] Exit, [C] Configure INI, [E] Edit Blocked IP List, [F1] Help"

		invoke SetTextColor,15 + 0	; white text on black background
		invoke locate,11,ebx          ; Position cursor
		print "ESC"                   ; Whiten it
		invoke locate,23,ebx          ; Postion cursor
		print "C"                     ; Whiteen it
		invoke locate,42,ebx          ; Postion cursor
		print "E"                     ; Whiten it
		invoke locate,68,ebx          ; Postion cursor
		print "F1"                    ; Whiten it
		invoke StdOut,ADDR CRLFLF     ; print 10,10,13

doreadkey:
	 	movzx eax,csbi.dwCursorPosition.y ; Get Saved 'y' Cursor position.
		invoke locate,0,eax
		invoke SetTextColor,10 + 0 ; Green text on black background

readkey:
		getkey      	; get a key press
		or ecx,ecx		; is it an extended key code, (function key, arrow, etc)?
		jz standard_key	; skip this if its not.

extended_key:
		cmp al,59		; test for F1 key	
		je gotF1
		jne readkey		; ignore any other extended key

standard_key:
		cmp al,01Bh		; test for ESC
		je gotesc
		or al,020h		; force lower-case result
		cmp al,"e"		; test for "E" or "e"
		je gote
		cmp al,"c"		; test for "C" or "c"
		je gotc
		cmp al,"0"		; test for "0"
		je got0
		jne readkey		; loop if no matches

;-----
gotF1:
	; "F1" was pressed - Run editor and pass file name of the HelpFile

		mov ebx, offset HelpFileName	; F1 pressed, Open Helpfile net2bbs.txt
		jmp RunEditor

;-----
gotc: 
	; "c" was pressed - Run editor and pass the name of the Configuration INI file 

	;print "Restart after saving changes",10,13
		mov ebx,offset IniFileName
		jmp RunEditor

;-----
gote:
	; "e" was pressed - Run editor and pass the name of the kill list

		mov ebx,offset KillFileName
		jmp RunEditor

;------
gotesc:
	; "ESC" was pressed - Display a separate console buffer with a Red background to confirm exit

		invoke	SetTextColor,15+(4*16)   ; Create a new Console screen with White Text on Red Background
		xor ecx,ecx
		invoke	CreateConsoleScreenBuffer,GENERIC_READ OR GENERIC_WRITE,ECX,ECX,CONSOLE_TEXTMODE_BUFFER,ECX
		mov	ebx,eax 	    ; Save Handle of Screenbuffer in ebx
		invoke	WriteConsole,ebx,ADDR HitEscAgainTxt, sizeof HitEscAgainTxt, ADDR written, NULL ;Print to it

		invoke	SetConsoleActiveScreenBuffer, ebx ; Activate it
		invoke	SetTextColor,10 + 0 ; Bright Green  ; Restore color of future output
		getkey			; wait for a second keypress
		push eax
		invoke CloseHandle,ebx	; close the red console buffer first (1.02 fix for Win 7)
		pop eax
		cmp al,01Bh		; ESC key?
		je done		; If so, cleanup and exit
		or al,020h		; force lower-case result
		cmp al,"r"		; "R" or "r" to Restart?
		je RestartService
		cmp al,"0"
      		je GoSession0


readkeyx:
	    	jmp readkey    ; Return to main key menu

got0:
		jmp GoSession0

; ---------
; RunEditor runs the defined editor and passes it a filename to open.
; EBX = pointer to the filename string.

RunEditor:
		mov byte ptr EditorCmd, 0   ; Zero (terminate) the string
		invoke lstrcat, ADDR EditorCmd, ADDR EditorName    ; Copy the EditorName to the Editor Command line
		invoke lstrcat, ADDR EditorCmd, ebx  ; Add filename to edit to the "edit filename" Command Line

		mov sinfo_.cb,sizeof sinfo_ ; this is done to maintain compatibility with future versions of Windows
		invoke GetStartupInfo,addr sinfo_
		xor ecx,ecx
		invoke CreateProcess, ecx, ADDR EditorCmd, ecx, ecx, ecx,
			      ecx, ecx, ecx, addr sinfo_,addr pinfo_ 
proc_created:
		invoke CloseHandle, pinfo_.hThread			    ; Close open handles
		invoke CloseHandle, pinfo_.hProcess	   
		jmp short readkeyx     ; resume processing keyboard input

error_exit:
		invoke SetTextColor,15 + 0	; Color= White
		print chr$(10), 13, "*** Press Enter to Exit ***"
jel:
		getkey
		cmp al,13  ; Got Enter?
		jne jel    ; jello till we do
		jmp done

GoSession0:
		print "Switching to Session 0",13,10
		mov sinfo_.cb,sizeof sinfo_ ; this is done to maintain compatibility with future versions of Windows
		invoke GetStartupInfo,addr sinfo_
		xor ecx,ecx
		invoke CreateProcess, ecx, ADDR Session0, ecx, ecx, ecx,
			      ecx, ecx, ecx, addr sinfo_,addr pinfo_ 
		jmp proc_created 

RestartService:
		invoke OpenMyService   ; Open Service DataBase
		jc	InvalidService3

		invoke ServiceStop ;
		jc CantStartStop
ServiceStart:
		invoke	StartService,ServiceHandle,0,0
		test eax,eax
		jz CantStartStop

resume:
		invoke	CloseServiceHandle,ServiceHandle
		jmp readkey

InvalidService3:
		cmp eax,123456789
		jne notvista
                invoke SetTextColor,11 + 0	; Color= White
		print "   The Net2BBS Service could not be stopped/started from this account.",13,10,\
		      "   In order to allow the Net2BBS Service to be started or stopped without",13,10,\
 		      "   Administrator rights, configure the Net2BBS Service security to allow",13,10,
 		print "   this using the ServiceSecurityEditor available here:",13,10
		invoke SetTextColor,15 + 0	; Color= White
		print "   http://www.coretechnologies.com/products/ServiceSecurityEditor/",13,10
		invoke SetTextColor,11 + 0	; Color= White
		jmp short resume
notvista:
		print "Error: Net2BBS has not been installed as a service.", 13,10
		jmp short resume

CantStartStop:
		print "Can not Start or Stop the Service.",10,13
		jmp resume
done:
		invoke SetTextColor,15 + 0	; Set White text on black background
		ret				; Exit Net2BBS

StartMonitor endp

    
;-------------------------------------------------------------------------------------------------------
MonitorMailThread proc Near

rsloop:

		invoke ReadFile, readslot,\ ; Read data from mailslot
			OFFSET SlotBuffer,\                   ; Buffer address
			sizeof SlotBuffer,\           ; Max amount to read
			OFFSET sb_len,\         ; number of bytes actually read
			NULL                    ; overlapped

		mov esi, sb_len             ; See how much we got
		or  esi, esi                ; got nothing this time?
		jz  rsloop

; Check if this is a request to spawn Net2Spy
    		mov al,SlotBuffer+2
    		or al,al
    		jnz SpawnSpy


;Check if a sound is requested
		mov al,SlotBuffer+1
		or al,al
		jz nosound
		dec al ; Set Zero Flag
		lea eax, LogonWav
		jz playit
		lea eax, LogoffWav
playit:
		invoke PlayWav, eax
		;print "played sound",10,13
nosound:
		mov [SlotBuffer+esi],0
		invoke SetTextColor, SlotBuffer        ; first byte is the text color
		invoke StdOut,ADDR SlotBuffer+4        ; Print it to screen as well
		jmp rsloop


SpawnSpy:
		;  al contains the node number to spawn

		movzx edx,al
		invoke dw2a,edx,ADDR  SpyNodeTxt

    		invoke Shell, ADDR DotSlash, ADDR SpyFileName  ; Shell to NF+BBS, passing Path + Command to Spawn
		jmp rsloop

MonitorMailThread endp

;----------------------------------------------------------------------------------------------- 
Shell proc near lppath:DWORD,lpfilename:DWORD

; Shell - Spawn a process
; 
;
; LPCTSTR lpApplicationName,		       null
; LPTSTR lpCommandLine, 		       lpfilename
; LPSECURITY_ATTRIBUTES lpProcessAttributes,   null
; LPSECURITY_ATTRIBUTES lpThreadAttributes,    null 
; BOOL bInheritHandles, 		       true
; DWORD dwCreationFlags,		       create_new_cons+normal_prior (30h)
; LPVOID lpEnvironment, 		       null
; LPCTSTR lpCurrentDirectory,		       lppath
; LPSTARTUPINFO lpStartupInfo,		       addr sinfo
; LPPROCESS_INFORMATION lpProcessInformation   addr pinfo

LOCAL sinfo:STARTUPINFO
LOCAL pinfo:PROCESS_INFORMATION

	cmp byte ptr DebugModeTxt,"0"
	je skipdebug
	invoke SetTextColor,2 + 0	   ; Text = Dark Green
	print " Spawn: "
	invoke StdOut,lpfilename
	invoke StdOut,ADDR CRLF ; print $chr(13),10
	invoke SetTextColor,  10 + 0	   ; Text = Bright Green

skipdebug:

	mov sinfo.cb,sizeof sinfo ; this is done to maintain compatibility with future versions of Windows
	invoke GetStartupInfo,addr sinfo
	;;;;;mov sinfo.lpTitle, offset BBSTitle
	; Don't Set the Window Title

;	mov sinfo.dwFlags, STARTF_USESHOWWINDOW	; Demand setting window view mode.
	mov ebx, STARTF_USESHOWWINDOW			; Demand setting window view mode.

	invoke atodw,addr NodeLinesTxt		; Get NodeLines= value
	or eax,eax
	jz skipsize

	or ebx, STARTF_USECOUNTCHARS Or STARTF_USESIZE ;or STARTF_USEPOSITION

; This sets the console buffer size (buffer size can be bigger then screen size, but must not be smaller!)
	mov sinfo.dwXCountChars,80
	mov sinfo.dwYCountChars,eax
    
; The console screen size can only be set in Pixels, so we must assume the default font size of 8x12 for this to work:
	mov sinfo.dwXSize, 80*8 ; multiply X size by font width, and always use X-size=80
	mov edx,12              ; multiply Y size by font height 
	mul edx  
	mov sinfo.dwYSize, eax

skipsize:
	mov sinfo.dwFlags, ebx	; Set the STARTF flags.

  ; ShowWindow modes:
  ; These are described here:  http://msdn.microsoft.com/en-us/library/ms633548.aspx
  ;
  ; SW_HIDE = 0
  ; SW_NORMAL = 1
  ; SW_SHOWMINIMIZED = 2
  ; SW_MAXIMIZE = 3
  ; SW_SHOWNOACTIVATE = 4
  ; SW_SHOW = 5
  ; SW_MINIMIZE = 6
  ; SW_SHOWMINNOACTIVE = 7
  ; SW_SHOWNA = 8
  ; SW_RESTORE = 9
  ; SW_SHOWDEFAULT = 10
  ; SW_FORCEMINIMIZE = 11
 
	movzx eax,SpyView 	; Window Show mode: Normal, Minimize, Maximize, Hidden, etc.
 or eax,eax
 jnz set_node_view
 inc eax ; don't allow SW_HIDE for the BBS Spy

; Full Screen View option was disabled in version 1.03a
; because this function was only supported in XP and 2003.
;
; cmp al,99 ;99=Full-Screen
; jne set_node_view
;=======================================================
; Force Full-Screen window by stuffing keyboard events
; Sends Alt-Enter to console for Win XP, 2000, and 2003
; This will not work under Windows Vista or later!
;  invoke keybd_event,VK_MENU,38h,0,0
;  invoke keybd_event,VK_RETURN,1Ch,0,0
;  invoke keybd_event,VK_RETURN,1Ch,KEYEVENTF_KEYUP,0
;  invoke keybd_event,VK_MENU,38h,KEYEVENTF_KEYUP,0
;  mov ax,SW_NORMAL
;=======================================================

set_node_view:
	mov sinfo.wShowWindow, ax

; CreateProcess
	xor ecx,ecx
	invoke CreateProcess, ecx, lpfilename, ecx, ecx, TRUE,
			CREATE_NEW_CONSOLE Or NORMAL_PRIORITY_CLASS,
			ecx, lppath, addr sinfo, addr pinfo

    .if eax 

;print "Spawned BBS Spy",13,10
    .else
	invoke SetTextColor,2 + 0	    ; Text = Dark Green
	  print " Spawn Netspy Failed!",13,10
	invoke SetTextColor,10 + 0	    ; Text = Bright Green
    .endif 

Shell_end:
	;invoke CloseHandle, pinfo.hThread		; Close open handles
	;invoke CloseHandle, pinfo.hProcess	   
	ret

Shell endp



;------------------------------------------------------------------------------------------------
ReadMyFile proc near lpfilename

; This opens a file (if the file already exists), and reads the entire file into memory.
; Exit with Carry Set to indicate an error
; Exit with ESI= Global Memory handle (to be released) if successful
; AND ECX= bytes read

local hTempFile
local bytesread

	invoke GetFileAttributes, lpfilename		   ; Check if the file exists
	inc eax
	jz readmyfile_error

	invoke CreateFile,lpfilename,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,NULL
	mov hTempFile,eax
	invoke GetFileSize,eax,NULL	; get the file size
	push eax
	invoke GlobalAlloc,GMEM_FIXED,eax	;  allocate at least that much memory (Destroys ECX and ?)
	pop ecx
	mov esi, eax				;  Save the memory Handle.
	invoke	ReadFile,hTempFile,	;  Read the File
			esi,				;  Buffer Address
			ecx,				;  Max Amount to send
			ADDR bytesread, 		;  In: bytes actually read
			NULL				;  overlapped

	or eax,eax
	jz readmyfile_error ; This may be overkill since the file exists

; Here we should make sure the entire file was read, and try to read the remainder if needed.
; Exit this proce with carry set if there was an error?
		
	invoke CloseHandle, hTempFile		   ; close the file handle
	mov ecx, bytesread			   ; Return bytes read in ECX
	clc
	ret

readmyfile_error:
;print "file not found",10,13
	stc
	ret

ReadMyFile endp

;------------------------------------------------------------------------------------------------
PlayWav proc near lpfilename
; 
; Check if a WAV file exits, and if it does, play it

	invoke GetFileAttributes, lpfilename
	inc eax		; Check that EAX!=-1
	jz NoPlay
	Invoke PlaySound, lpfilename, NULL, SND_FILENAME or SND_ASYNC
NoPlay:
	ret
PlayWav endp


;------------------------------------------------------------------------------------------------
; Get Settings from net2bbs.ini

GetSettingsFromIni proc near ; uses ebx esi edi

    ;LOCAL   APP_Path[128] :BYTE
    LOCAL   INI_Path[128] :BYTE

    CTEXT MACRO text:VARARG
      LOCAL TxtName
      .data
	TxtName BYTE text, 0
      .code
      EXITM <ADDR TxtName>
    ENDM
    
	;invoke  GetAppPath, ADDR APP_Path			; Get path of Application  
	invoke  GetAppPath, ADDR INI_Path			; Get path of Application for INI
	invoke  SetCurrentDirectory, ADDR INI_Path      ; Set CurrentDirectory (in case of Service)
	invoke lstrcat, ADDR INI_Path, ADDR IniFileName	; Append the Ini FileName to the INI path 	   

	; Make sure ini file can be found, or else we fail.

	invoke GetFileAttributes, addr INI_Path ; Does the .ini file exist?
	inc eax				; -1 means it doesn't exist
	jnz iniread
	invoke SetTextColor,12 + 0	; color=Red
	;print  "Config missing: "
	invoke StdOut,ADDR MissingTxt
	invoke SetTextColor,7 + 0	; color=White
	invoke StdOut,ADDR INI_Path
inifail:
	stc 				; set carry to indicate error and exit
	ret
		
iniread:
	lea eax,INI_Path
	mov INI_ADDR, eax


; GetFromIni uses:  Command Text, default value, Where to place it, maximum size in bytes

 invoke GetFromIni, CTEXT("Command"),    ADDR null,    ADDR CommandTxt, sizeof CommandTxt
 invoke GetFromIni, CTEXT("StartPath"),  ADDR DotSlash,  ADDR StartPath, sizeof StartPath
 invoke GetFromIni, CTEXT("Debug"),      ADDR one,   ADDR DebugModeTxt, sizeof DebugModeTxt

 ;invoke GetFromIni, CTEXT("Port"),       CTEXT("23"),ADDR TCPportTxt,sizeof TCPportTxt
 ;invoke GetFromIni, CTEXT("PolicyPort"), ADDR zero,  ADDR PolicyPortTxt,sizeof PolicyPortTxt
 ;invoke GetFromIni, CTEXT("Nodes"),      CTEXT("256"),ADDR MaxNodesTxt, sizeof MaxNodesTxt
 ;invoke GetFromIni, CTEXT("StartNode"),  ADDR one,   ADDR StartNodeTxt, sizeof StartNodeTxt
 ;invoke GetFromIni, CTEXT("Resolve"),    ADDR one,   ADDR ResolveModeTxt, sizeof ResolveModeTxt
 ;invoke GetFromIni, CTEXT("Log"),        CTEXT("telnet.log"), ADDR LogFileName, sizeof LogFileName

 invoke GetFromIni, CTEXT("Editor"),     CTEXT("notepad"), ADDR EditorName, sizeof EditorName
 invoke GetFromIni, CTEXT("KillList"),   CTEXT("kill.txt"), ADDR KillFileName, sizeof KillFileName

 ;invoke GetFromIni, CTEXT("KillMsg"),    CTEXT("Access Denied."), ADDR KillMsg, sizeof KillMsg
 ;invoke GetFromIni, CTEXT("KillMsgFile"),ADDR null,  ADDR KillMsgFileName, sizeof KillMsgFileName
 ;invoke GetFromIni, CTEXT("Semaphore"),  ADDR null,  ADDR SemFileName, sizeof SemFileName
 ;invoke GetFromIni, CTEXT("ResolveMsg"), ADDR null,  ADDR ResolveMsg, sizeof ResolveMsg
 ;invoke GetFromIni, CTEXT("ShowHost"),   ADDR zero,   ADDR ShowHostTxt, sizeof ShowHostTxt

 invoke GetFromIni, CTEXT("SpyView"),   ADDR one,   ADDR SpyViewTxt, sizeof SpyViewTxt
 invoke GetFromIni, CTEXT("MainView"),   ADDR one,   ADDR MainViewTxt, sizeof MainViewTxt
 invoke GetFromIni, CTEXT("NodeLines"),  ADDR zero,  ADDR NodeLinesTxt, sizeof NodeLinesTxt

	cmp byte ptr StartPath,0 ; Empty StartPath is illegal
	jne pathok
	invoke lstrcat, ADDR StartPath, ADDR DotSlash   ; Add a ./ to an empty StartPath 
pathok:

	invoke lstrcat, ADDR EditorName, ADDR spacestring   ; Add a space to the base EditorName 
	;invoke lstrcat, ADDR ResolveMsg, ADDR spacestring   ; Add a space to the resolve message 
	;;invoke lstrcat, ADDR EditorName, ADDR APP_Path      ; Add the Application path to the EditorName
	; There is no longer any need to add the app path to the editor name since we changed to the app dir


	;invoke atodw,addr NodeViewTxt	; Save the NodeView= value

	;cmp ServiceFlag,0
	;je SetNodeView
	;xor eax,eax ; SW_HIDE ; force nodes to be hidden if servicemode is active?!?!?!?!
	;SetNodeView:

	;mov NodeView,al
	invoke atodw,addr MainViewTxt	; Get MainView= value

	;cmp ServiceFlag,0
	;jne skipShowWin
	invoke ShowWindow,hWnd,eax   ; Set our Console Window view

skipShowWin:

; this is now done later
;	invoke atodw,addr NodeLinesTxt	; Get NodeLines= value
;	mov NodeLines,eax
	
	;invoke atodw,addr TCPportTxt	; Save the provided TCP port if its non-zero
	;mov TCPport,eax
	;invoke atodw,addr PolicyPortTxt	; Save the provided Policy port
	;mov PolicyPort,eax
	;invoke atodw,addr StartNodeTxt	 ; Save the start node if its non-zero
	;or eax,eax
	;jnz setstartnode
	;inc eax
;setstartnode:
	;mov StartNode,eax

	;invoke atodw,addr MaxNodesTxt	; Save the max nodes if its non-zero
	;or eax,eax
	;jnz setmaxnode
	;mov ax,256
setmaxnode:
	;mov MaxNodes,eax
	;add eax,StartNode
	;dec eax
	;mov LastNode,eax		; Define LastNode (StartNode+MaxNodes-1)
    
    	cmp byte ptr DebugModeTxt,"0"
	je initdone
	invoke SetTextColor,2 + 0
	print "Debug: Read "
	invoke StdOut,ADDR INI_Path
	invoke StdOut,ADDR CRLF ; print " ",10,13

initdone:
	clc
	ret
GetSettingsFromIni endp

;------------------------------------------------------------------------------------------------
; Get a command from INI file

GetFromIni proc near lpCmd:DWORD, lpDefault:DWORD, lpDest:DWORD, DestSize:DWORD

; This stub calls GetPrivateProfileString in Kernel32.dll

	invoke GetPrivateProfileString, ADDR IniSectionName, lpCmd, lpDefault, lpDest, DestSize, INI_ADDR
	ret
GetFromIni endp


;------------------------------------------------------------------------------------------------
; Get the Application Path

GetAppPath proc near lpPathBuffer:DWORD

	invoke GetModuleFileName,0,lpPathBuffer,128  ; return length in eax
	add eax, lpPathBuffer         ; Search from end to start
findslash:
	dec eax                        
	cmp BYTE PTR [eax],"\"  	; find the last "\"
	jne  findslash
	mov  BYTE PTR [eax+1],0		; write zero terminator after "\"
	;mov  eax, lpPathBuffer
	ret
GetAppPath endp


;------------------------------------------------------------------------------------------------
; Initialize Console
;
; Returns with: EBX = X-console width
;               ECX = Y-console height (currently disabled)
;InitConsole proc near
;
;
;	invoke GetConsoleWindow
;	mov    hWnd,eax 
;
;	Invoke SetConsoleTitle, ADDR Net2BBSTitle              ; Set Window Title
;;	invoke FindWindow,ADDR ClassName, Addr Net2BBSTitle    ; Find Window handle matching this class/title
;
;
;;invoke CreateConsoleScreenBuffer,GENERIC_READ OR GENERIC_WRITE,0,0,CONSOLE_TEXTMODE_BUFFER,0
;
;; There is no need to change the input
;;	invoke GetStdHandle,STD_INPUT_HANDLE
;;	mov hStdIn, eax
;;	invoke SetConsoleMode, hStdIn, ENABLE_PROCESSED_INPUT
;
;
;; But we must define the output
;	invoke GetStdHandle,STD_OUTPUT_HANDLE
;	mov   hStdOut,eax
;
; ;InitClear:
; ;	cls		  ; Clear the screen via MASM32
; ;	invoke FillConsoleOutputAttribute,hStdOut,00,80*25,NULL,ADDR temp   ; Force the screen to clear black
; ;	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
; ;    movzx ebx,csbi.dwSize.x
; ;    mov   console_X_size,ebx
; ;    movzx ecx,csbi.swSize.y
; ;    mov   console_Y_size,ecx
; ;    mov dx,csbi.dwCursorPosition.y ; Get 'y' Cursor position.
;
;      ;cls ; clear screen
;      ret
;      
;InitConsole endp

;------------------------------------------------------------------------------------------------
; Convert Double-Word to ASCII string
;
; dwValue is passed as a value, direct, indirect or in register
; lpBuffer is the ADDRESS of the receiving buffer
; Returns with eax= number of characters written to buffer (zero=error).
;
; EXAMPLE:
; invoke dw2a,edx,ADDR buffer


dw2a proc near dwValue:DWORD, lpBuffer:DWORD

	invoke wsprintfA,lpBuffer,ADDR fMtStrinG,dwValue
	ret
dw2a endp


;------------------------------------------------------------------------------------------------
SetTextColor proc near foreback16:BYTE ;was fore:DWORD,back:DWORD

; 
; This proc sets the foreground and background attributes for
; the characters written to the console screen buffer.
;
; The color values are normal 4-bit IRGB character mode
; attributes where:
;   bit3 = intensity
;   bit2 = red
;   bit1 = green
;   bit0 = blue
; 
; The attribute is stored in a single byte (contained in a dword).
	;mov   eax,back
	;shl   eax,4
	;or	  eax,fore
      movzx eax,foreback16
	invoke SetConsoleTextAttribute,hStdOut,eax ; was ,eax
	ret
SetTextColor endp


end start
 