;------------------------------------------------------------------------------------------------
;  Net2BBS Telnet Server
;  Version 1.10
;  Written by Mike Ehlert - PC Micro Systems, Inc. 
;  http://pcmicro.com/netfoss
;  Released as Public Domain, Open Source Code.
;  Read Net2BBS.txt for license details.
; 
;  Compile in MASM32, using Qeditor > Project > "Console Assemble and Link"
;  or link using Polink.exe for optimum file size.
;------------------------------------------------------------------------------------------------
.586
.model flat,stdcall

;===============
service equ TRUE  ; TRUE=compile with service functions, FALSE=compile without
;===============  ; The EXE will be about 1k smaller when set for FALSE

option casemap:none
   include \masm32\include\windows.inc	; Windows
   include \masm32\include\user32.inc	; User
   include \masm32\include\kernel32.inc	; Kernel
   include \masm32\include\ws2_32.inc	; Winsock 2.0
   include \masm32\include\winmm.inc	; MultiMedia play functions
   include \masm32\include\masm32.inc	; MASM32
   include \masm32\macros\macros.asm	; MASM32 Macros
   include \masm32\include\advapi32.inc	; Services

   includelib \masm32\lib\user32.lib	; User
   includelib \masm32\lib\kernel32.lib	; Kernel
   includelib \masm32\lib\ws2_32.lib	; WinSock 2.0
  ;includelib \masm32\lib\wsock32.lib	; WinSock 2.0 (alt lib)
   includelib \masm32\lib\winmm.lib 	; MultiMedia play functions
   includelib \masm32\lib\masm32.lib	; MASM32
   includelib \masm32\lib\msvcrt.lib	; C library (only used for getkey)
if service
   includelib \masm32\lib\advapi32.lib	; Services
endif

   StartServer       proto
   AcceptThread      proto
   AcceptThread2     proto
   BindListen        proto :DWORD
   SpawnNodeThread   proto :DWORD
   GetAppPath        proto :DWORD
   ReadMyFile        proto :DWORD    
   PlayWav           proto :DWORD
   SetTextColor      proto :BYTE
   ServiceMsgHandler proto :DWORD
   Shell             proto :DWORD,:DWORD,:DWORD
   GetFromIni        proto :DWORD,:DWORD,:DWORD,:DWORD
   WriteLog          proto :DWORD,:DWORD
   WriteLog2         proto :DWORD,:DWORD,:DWORD,:DWORD,:BYTE
   LogRefused        proto :DWORD,:DWORD
   Replace           proto :DWORD,:DWORD,:DWORD,:DWORD	
   ReadLine          proto :DWORD,:DWORD,:DWORD
   WildMatch         proto :DWORD,:DWORD

.data
align 4

if service
   ServiceTable    dd  offset ServiceName, offset ServiceMain, 0, 0 ; Service Control Table
endif

   null            dd  0			; zero binary doubleword	   
   zero            db  "0",0			; zero ascii string
   one             db  "1",0			; one  ascii string
   wsa2size        dd  SIZEOF wsa2        	; The size of our winsock listen/accept info buffer
   fMtString       db  "%lu",0			; Format string mode used by wsprintf
   ;ClassName      db  "ConsoleWindowClass",0
   Net2BBSTitle    db  "Net2BBS "
   TelnetSrvTxt    db  "Telnet Server",0
   VersionTxt      db  " 1.10",0  ; 225,"1",0 =B1
   PolicySrvTxt    db  "Socket Policy Server",0
   IniFileName     db  "net2bbs.ini",0
   HelpFileName    db  "net2bbs.txt",0
   IniSectionName  db  "Settings", 0	; [Settings] is our .INI Section
   DateTxt         db  "00-00-0000 "	; Date Format for WriteLog
   TimeTxt         db  "00:00:00"		; Time Format for WriteLog
   DotSlash        db  "./",0		; Default StartPath
  dodecactivenodes db  0

; Log file messages:

   WaitingTxt      db  "Listening for ",0
   TelnetTxt       db  "Telnet",0
   PolicyTxt       db  "Socket Policy",0
   ConnectionsTxt  db  " connections"
   OnPortTxt       db  " on port ",0
   ErrorTxt        db  "Error starting ",0
   Node_           db  "Node ",0
   LoginTxt        db  " login: ",0
   ResolvedTxt     db  "Hostname: ",0
   UnknownTxt      db  "Unknown",0
   OpenedTxt       db  " opened.",0
   ClosedTxt       db  " closed.",0
   RefusedTxt      db  "Refused (",0
   Refused1Txt     db  "All Nodes in use).",0 
   Refused2Txt     db  "Semaphore exists).",0 
   Refused3Txt     db  "Matched kill list).",0
   MissingTxt      db  "Missing ",0         ; Log message when missing socket policy
   SendPolicyTxt   db  "Sent "              ; Log message when sending socket policy 
   PolicyFileName  db  "SocketPolicy.xml",0 ; Socket Policy FileName
   StoppingTxt     db  "Shutting down.",0   ; Log message when exiting
   BBSTitle        db  "BBS node "          ; The Title of an active BBS node window
   BBSTitleNode    db   "   ",0             ; Room to add the node number
   BUSYtxt         db  "BUSY",13,10         ; Send this to client when all nodes are in use
   LogonWav        db  "logon.wav",0        ; Play this sound during a new logon (if it exists)
   LogoffWav       db  "logoff.wav",0       ; Play this sound during a logoff (if it exists)
   DNSBLTxt        db  " - DNSBL:"          ; DNS Blacklist checker (uses spacestring below)
   spacestring     db  " ",0                ; string spacer
   PassedTxt       db  " (passed).",0       ; DNS BL Passed result.
   ListedTxt       db  " (listed).",0       ; DNS BL Listed result.
   CRLFLFLF        db  10
   CRLFLF          db  10
   CRLF            db  10,13,0

;  ANSIClear       db  01Bh,"[2J"		; ANSI command to clear the remote screen
   HitEscAgainTxt  db  10,10,10,10,10,9,"Press [ESC] to exit [R] to restart, or any other key to resume."
   mailslot        db  "\\.\mailslot\net2bbs",0 ;  mailslot to send service messages to the monitor 
   RestartFlag     db  0 ; Flag enabled during a restart only 
   ServiceFlag     db  0 ; Flag enabled when started with /s parameter (Service Mode)

   ntext           db  "*n",0	; Command Line Macro to replace with Node value    (must be lower case here)
   htext           db  "*h",0	; Command Line Macro to replace with Handle value  (must be lower case here)  
   IPtext          db  "*i",0	; Command Line Macro to replace with IP Address    (must be lower case here)
   restext         db  "*r"	; Command Line Macro to replace with resolved name (must be lower case here)   
   ServiceName     db  0	; Service name can be blank for SERVICE_WIN32_OWN_PROCESS 

.data?
align 4
   TCPport         dd ?		; Default Telnet TCP port = 23   
   PolicyPort      dd ?		; Default Policy Port is disabled. Set to 843 to enable
   StartNode       dd ?		; First Telnet node to use
   MaxNodes        dd ?		; Maximum number of Telnet nodes
   LastNode        dd ?		; Last node number (startnode+maxnodes-1)
   INI_ADDR        dd ?		; Address of NET2BBS.INI
   hWnd            dd ?		; Handle of Console Window
;  hStdIn          dd ?		; Handle of Standard Input - not used
   hStdOut         dd ?		; Handle ot Standard Output - Needed for Color text 
   hInSock         dd ?		; Handle of Incoming Telnet Socket
   hInSock2        dd ?		; Handle of Incoming Policy Socket
   hSock2          dd ?		; Handle of Actual Policy Socket			
   hLogFile        dd ?		; Handle of the Log File
   hServiceStatus  dd ?		; Handle to status info structure for the service
   ThreadID        dd ?		; Thread ID is not used currently (write only)
   StopEvent       dd ?		; Event to signal shutdown in progress
   written         dd ?		; Bytes written to log file - Not currently used (write only)
   HelpY           dd ?		; Y position of the help line on the Console screen

   NodeTable       db 256 dup (?) ; This table defines which nodes are in use(1) or inactive(0).
   LogBuf          db 128 dup (?) ; Buffer used for current log line
   CommandTxt      db 128 dup (?) ; Spawn Command line provided in INI
   StartPath       db 128 dup (?) ; Node Start Path provided in INI
   KillFileName    db 128 dup (?) ; List of blocked IP's
   KillMsg         db 128 dup (?) ; Text to show a blocked IP
   KillMsgFileName db 128 dup (?) ; Kill Message FileName
   EditorName      db 256 dup (?) ; Editor Filename + space + path to Net2BBS\
   EditorCmd       db 256 dup (?) ; Editor Filename + space + path to Net2BBS\filename to open
   LogFileName     db 128 dup (?) ; Log FileName
   SemFileName     db 128 dup (?) ; Semaphore FileName
   ResolveMsg      db 128 dup (?) ; Message shown to user at connect (if Resolve enabled)
   DotTxt          db ?
   DNSBL           db 63  dup (?) ; DNS Blacklist URL 
   BLHostName      db 64  dup (?) ; Blacklist Host Name to test via DNS
;=============== These need to stay in this order, as all are sent to the MailSlot at the same time
   MailSlotColor   db ?            ; Color passed to MailSlot
   MailSlotSound   db ?            ; Sound passed to MailSlot
   LaunchSpyNode   db ?
   ActiveNodes     db ?		     ; Number of currently active nodes
   LogBuf2         db 128 dup (?)  ; Secondary Log buffer (used by writelog only)
;===============
   TCPportTxt      db   8 dup (?) ; Ascii text of the TCP port (default 23)
   PolicyPortTxt   db   8 dup (?) ; Ascii text of the Policy port (default 0 = disabled. Set to 843 to enable)
   StartNodeTxt    db   4 dup (?) ; Ascii text of the first telnet node number
   MaxNodesTxt     db   4 dup (?) ; Ascii text of the maximum number of telnet connections
   NodeLinesTxt    db   4 dup (?) ; Ascii text of the number of lines in the node window (25 or 50)
   DebugModeTxt    db   2 dup (?) ; Ascii "0"=disable, "1"=enable - Display debug messages 
   ResolveModeTxt  db   2 dup (?) ; Ascii "0"=disable, "1"=enable - Resolve IP address to hostname 
   ShowHostTxt     db   6 dup (?) ; Ascii text of the ShowHost mode for showing caller their hostname
   NodeViewTxt     db   3 dup (?) ; Ascii text of the showWindow mode for node windows
   MainViewTxt     db   3 dup (?) ; Ascii text of the ShowWindow mode for this window
   NodeView        db          ?  ; Node ShowWindow view. Default = 1 (Normal)
   temp            dd          ?  ; Temporary dword used by FillConsoleOutputAttribute
  ;ShutdownFlag    db          ?  ; Flag for service to know when Shutdown is complete

; Data structures:

   SysTime SYSTEMTIME  <?>		; Used by GetLocalTime
   sinfo_   STARTUPINFO <?>		; Used for shell
   pinfo_   PROCESS_INFORMATION <?> ; Used for shell
   wsd  WSADATA      <?>		; Winsock data structure
   wsa  sockaddr_in  <?>		; Winsock primary   sockaddress_inbound structure
   wsa2 sockaddr_in  <?>		; Winsock secondary sockaddress_inbound structure
   csbi CONSOLE_SCREEN_BUFFER_INFO <> ; Structure used for Console screen positioning
   
if service
   status   SERVICE_STATUS <?>	; Used for Service Status      
endif

; For reading console keyboard without using msvcrt
;_INPUT_RECORD STRUCT
;	 EventType   WORD ?
;	 WORD ? 		   ; For alignment
;	 UNION
;	     KeyEvent		   KEY_EVENT_RECORD	     <>
;	     MouseEvent		   MOUSE_EVENT_RECORD	     <>
;	     WindowBufferSizeEvent WINDOW_BUFFER_SIZE_RECORD <>
;	     MenuEvent		   MENU_EVENT_RECORD	     <>
;	     FocusEvent		   FOCUS_EVENT_RECORD	     <>
;	   ENDS
;_INPUT_RECORD ENDS


;------------------------------------------------------------------------------------------------
.code

start:

if service

; The EXE can run either as an Application or as a Service.	
; First check if the service is active, then either do startservice, or startserver

	invoke ArgClC,1,ADDR EditorCmd
	mov ax, word ptr EditorCmd
	or ah,020h
	cmp ax,'s/' ; check for '/s' being passed as first Command Line parameter.
	jne Application

Service:

	invoke	AllocConsole ; This is only needed if running as a service.

	inc ServiceFlag
	invoke StartServiceCtrlDispatcher, offset ServiceTable ; http://msdn.microsoft.com/en-us/library/ms686324(VS.85).aspx
	jmp short exitproc

endif ; service

Application:
	invoke StartServer

exitproc:
	invoke ExitProcess,0


if service
;-------------------------------------------------------------------------------------------------------------------------------
SetStatus proc near State:dword, CheckPoint:dword, WaitHint:dword

; Set the Service Status

	mov eax,State
	mov status.dwCurrentState, eax
	mov status.dwWin32ExitCode, NO_ERROR 
	mov status.dwServiceSpecificExitCode, 0
	mov eax,CheckPoint
	mov status.dwCheckPoint, eax      ; increment for every subsequent START_PENDING update to reset time-out
	mov eax,WaitHint
	mov status.dwWaitHint, eax        ; time-out for next operation and subsequent call to SetServiceStatus
	invoke SetServiceStatus,hServiceStatus, offset status  ; http://msdn.microsoft.com/en-us/library/ms686241(VS.85).aspx
	ret
SetStatus endp

;-------------------------------------------------------------------------------------------------------------------------------
ServiceMain proc 	ArgC:dword,ArgV:dword

; Service Main

	invoke RegisterServiceCtrlHandlerEx, offset ServiceName, offset ServiceMsgHandler, 0
	mov hServiceStatus,eax

	; Initialize ServiceStatus structure

	mov status.dwServiceType, SERVICE_WIN32_OWN_PROCESS
	mov status.dwControlsAccepted, SERVICE_ACCEPT_SHUTDOWN + SERVICE_ACCEPT_STOP ; + SERVICE_ACCEPT_PARAMCHANGE                                                              ; SERVICE_ACCEPT_PAUSE_CONTINUE 
	invoke SetStatus, SERVICE_START_PENDING, 0, 2000

; Start the telnet server in a new thread!
	xor eax,eax	
	invoke CreateThread,eax,eax,offset StartServer,eax,eax,addr ThreadID ; hStartServerThread
	invoke CloseHandle,eax
	xor eax,eax
	invoke SetStatus, SERVICE_RUNNING, eax, eax
	
waitforstop:
	invoke Sleep,100	; allow time for service to create StopEvent
	invoke WaitForSingleObject, StopEvent, INFINITE
	cmp RestartFlag,0		; Don't exit if a restart command was performed
	jne waitforstop
	call ShutDown		; Tell all nodes to shutdown
	invoke WSACleanup		; Cleanup Winsock
	xor eax,eax
	invoke SetStatus, SERVICE_STOPPED, eax, eax
	ret
ServiceMain endp

;-------------------------------------------------------------------------------------------------------------------------------
ServiceMsgHandler proc near CtrlCode:DWORD

; This can check the following Service ControlCodes:
;
; SERVICE_CONTROL_STOP        requires SERVICE_ACCEPT_STOP
; SERVICE_CONTROL_SHUTDOWN    requires SERVICE_ACCEPT_SHUTDOWN
; SERVICE_CONTROL_PAUSE       requires SERVICE_ACCEPT_PAUSE_CONTINUE
; SERVICE_CONTROL_CONTINUE    requires SERVICE_ACCEPT_PAUSE_CONTINUE
; SERVICE_CONTROL_PARAMCHANGE requires SERVICE_ACCEPT_PAUSE_CONTINUE and SERVICE_ACCEPT_PARAMCHANGE

	mov eax,CtrlCode
	cmp eax,SERVICE_CONTROL_STOP
	je STOP

	cmp eax, SERVICE_CONTROL_SHUTDOWN
	jne SMH_exit

STOP:
	;------------------------------------------------
	; Update the service status and turn on StopEvent
 
	invoke SetStatus, SERVICE_STOP_PENDING, 1, 5000
	invoke SetEvent, StopEvent		; Tell all nodes and threads to shut down

SMH_exit:
	ret

ServiceMsgHandler endp

endif ; service

;------------------------------------------------------------------------------------------------
; StartServer - Configure Console screen and tell Winsock to Accept TCP connections
  StartServer proc near

begin:
	mov MailSlotSound,0
	mov LaunchSpyNode,0
	;mov ShutdownFlag,0
	cmp RestartFlag,0
	jne skipinit

    	; StopEvent will be used as a shut down notification

	invoke CreateEvent,NULL,             ; security attributes
    		TRUE,             ; flag for manual-reset event
    		FALSE,            ; flag for initial state
    		addr StoppingTxt	; event text
            
	cmp eax, INVALID_HANDLE_VALUE
	je  init_console
	mov StopEvent,eax

init_console:

	invoke GetConsoleWindow                                ; Define Console Window Handle
	mov    hWnd,eax 
	invoke GetStdHandle,STD_OUTPUT_HANDLE                  ; Define Output Handle
	mov   hStdOut,eax
	Invoke SetConsoleTitle, ADDR Net2BBSTitle              ; Set Console Window Title
	;call   InitConsole

	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi

skipinit:
	invoke ResetEvent, StopEvent ; StopEvent must be Reset in case a Restart occurs
	cls 		 ; macro to clear the screen
	movzx ebx,csbi.dwSize.x ; Get screen column size, usually 80
	shl   ebx,1  ; Multiply column count by 2 to create a 2-line blue bar
	invoke FillConsoleOutputAttribute,hStdOut,31,ebx,NULL,ADDR temp    ; Create blue background color at top
	invoke SetTextColor,10+(1*16) ;Green text on blue background
	print " Net2BBSķ " ; Was -=Net2BBS=-
	invoke SetTextColor,15+(1*16) ; white text on blue background
	;print " Telnet Server 1.xx",225,"2" ; 1.xxB2
	invoke StdOut,ADDR TelnetSrvTxt
	invoke StdOut,ADDR VersionTxt

	xor ebx,ebx
	invoke locate,6,ebx
	print "2"               ; make the "2" in Net2BBS white
	invoke SetTextColor,9+(1*16) ; blue text on blue background
	invoke locate,74,ebx
	print chr$(250),"pcm",250,13,10,10 ; sign it .pcm.
  
readini:
	call GetSettingsFromIni 	; Read the INI file and process it (this sets text color to green)
	jnc iniok
	jmp error_exit			; exit if INI file not found
iniok:	
	xor ebx,ebx
	mov ActiveNodes,bl           ; no active nodes
	invoke memfill, ADDR NodeTable, sizeof NodeTable, ebx ; Zero fill Node table
	cmp byte ptr DebugModeTxt,"0"
	je Nodebug
	print "Debug: Cmd="
	invoke StdOut,ADDR CommandTxt
	invoke StdOut,ADDR CRLF		; print chr$(13),10

Nodebug:
	invoke StdOut,ADDR CRLFLFLF ; move cursor 3 lines down
	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
	movzx eax,csbi.dwCursorPosition.y ; Get 'y' Cursor position.
	dec eax
	dec eax
	mov HelpY,eax ; HelpY is the Vertical position of the help-text showing the hotkey commands.

	cmp RestartFlag,0
	jne skip_ws ; Don't re-enable Winsock if restarted

initws:
	invoke WSAStartup,0202h,addr wsd	; Enable WinSock version 2
	.if eax!=NULL				; Check for error
		invoke SetTextColor,12 + 0	; set Color=Red
		print "WinSock Error"
	jmp error_exit
	.endif

	mov wsa.sin_family, AF_INET 	    ; Set address family
	;mov wsa.sin_addr, INADDR_ANY	    ; use all network interfaces available
skip_ws:

; for debug. jmp skipall

	;invoke SetTextColor,8 + 0 ; Grey Text for "Waiting for connections..."
	lea edi,LogBuf				; Set EDI pointer to start of buffer

; Bind Telnet Server and accept connections in a new thread

	mov eax,TCPport ; Get Telnet Server TCP Port
	or  eax,eax
	jz skiptelnet ; Skip Telnet if zero

	invoke BindListen,eax   ; Bind TCP port and tell it to listen for connections
	jc telnetservererror
	mov hInSock,eax         ; Save telnet Socket handle

	; Create thread to accept telnet connections
	xor eax,eax
	invoke CreateThread,eax,eax,offset AcceptThread,eax,eax,addr ThreadID
	invoke CloseHandle,eax		; Remove thread handle
	invoke WriteLog2, ADDR WaitingTxt, ADDR TelnetTxt, ADDR ConnectionsTxt, ADDR TCPportTxt,8

skiptelnet:

; Bind Socket Policy Server and accept connections in a new thread
 
	mov eax,PolicyPort	; Get Policy Server TCP port
	or eax,eax
	jz skippolicy           ; Skip Policy if zero
	invoke BindListen,eax   ; TCP Port 843 = socket policy port
	jc policyservererror
	mov hInSock2,eax

	; Create thread to accept policy connections
	xor eax,eax
	invoke CreateThread,eax,eax,offset AcceptThread2,eax,eax,addr ThreadID
	invoke CloseHandle,eax
	invoke WriteLog2, ADDR WaitingTxt, ADDR PolicyTxt, ADDR ConnectionsTxt, ADDR PolicyPortTxt,8

skipall:
skippolicy:

; Now the Telnet Server and/or Policy Server threads are up and running, so just process keyboard commands.
 
;First Save cursor position

	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
	mov ebx,HelpY
	invoke locate,0,ebx
	invoke SetTextColor,7 + 0 ; Light White Text

	print "Commands: [ESC] Exit, [C] Configure INI, [E] Edit Blocked IP List, [F1] Help"

	invoke SetTextColor,15 + 0	; white text on black background
	invoke locate,11,ebx          ; Position cursor
	print "ESC"                   ; Whiten it
	invoke locate,23,ebx          ; Postion cursor
	print "C"                     ; Whiteen it
	invoke locate,42,ebx          ; Postion cursor
	print "E"                     ; Whiten it
	invoke locate,68,ebx          ; Postion cursor
	print "F1"                    ; Whiten it
	invoke StdOut,ADDR CRLFLFLF     ; print 10,10,13


	;cmp RestartFlag,0          ; Check if we restarted, if so we must clear restart message
	;je doreadkey
	;invoke Sleep,1000          ; wait one second
	;invoke locate,50,0
	;invoke SetTextColor,15 +(1*16) ; White text on blue background
	;print "         "  ; remove the "Restarted" text from top bar
	;invoke locate,0,HelpY  ; Restore cursor to help line
	;dec RestartFlag        ; Clear flag

mov RestartFlag,0

doreadkey:
	movzx eax,csbi.dwCursorPosition.y ; Get Saved 'y' Cursor position.
	invoke locate,0,eax
	invoke SetTextColor,10 + 0 ; Green text on black background

readkey:
	getkey      	; get a key press
	or ecx,ecx		; is it an extended key code, (function key, arrow, etc)?
	jz standard_key	; skip this if its not.

extended_key:
	cmp al,59		; test for F1 key	
	je gotF1
	jne readkey		; ignore any other extended key

standard_key:
	cmp al,01Bh		; test for ESC
	je gotesc
	or al,020h		; force lower-case result
	cmp al,"e"		; test for "E" or "e"
	je gote
	cmp al,"c"		; test for "C" or "c"
	je gotc
	jne readkey		; loop if no matches

telnetservererror:
	invoke WriteLog2, ADDR ErrorTxt, ADDR TelnetSrvTxt, ADDR OnPortTxt, ADDR TCPportTxt, 12

go_err_exit:
	jmp error_exit

policyservererror:
	;invoke SetTextColor,12 + 0	; Set bright red text on black background
	invoke WriteLog2, ADDR ErrorTxt, ADDR PolicySrvTxt, ADDR OnPortTxt, ADDR PolicyPortTxt, 12
	invoke SetTextColor,10 + 0	; Set bright green text on black background
	;xor eax,eax
	;cmp eax,TCPport	; Check if telnet server is enabled
	;je go_err_exit	; if not, its a serious error
	jmp skippolicy	; otherwise treat as a soft error, no exit
;-----
gotF1:
	; "F1" was pressed - Run editor and pass file name of the HelpFile

	mov ebx, offset HelpFileName	; F1 pressed, Open Helpfile net2bbs.txt
	jmp RunEditor
;-----
gotc: 
	; "c" was pressed - Run editor and pass the name of the Configuration INI file 

	;print "Restart after saving changes",10,13
	mov ebx,offset IniFileName
	jmp RunEditor
;-----
gote:
	; "e" was pressed - Run editor and pass the name of the kill list

	mov ebx,offset KillFileName
	jmp short RunEditor
;------
gotesc:
	; "ESC" was pressed - Display a separate console buffer with a Red background to confirm exit

	invoke	SetTextColor,15+(4*16)   ; Create a new Console screen with White Text on Red Background
	xor ecx,ecx
	invoke	CreateConsoleScreenBuffer,GENERIC_READ OR GENERIC_WRITE,ECX,ECX,CONSOLE_TEXTMODE_BUFFER,ECX
	mov	ebx,eax 	    ; Save Handle of Screenbuffer in ebx
	invoke	WriteConsole,ebx,ADDR HitEscAgainTxt, sizeof HitEscAgainTxt, ADDR written, NULL ;Print to it
	invoke	SetConsoleActiveScreenBuffer, ebx ; Activate it
	invoke	SetTextColor,10 + 0 ; Bright Green  ; Restore color of future output
	getkey			; wait for a second keypress
	push eax
	invoke CloseHandle,ebx	; close the red console buffer first (1.02 fix for Win 7)
	pop eax
	cmp al,01Bh		; ESC key?
	je cleanup		; If so, cleanup and exit
	or al,020h		; force lower-case result
	cmp al,"r"		; "R" or "r" to Restart?
	je restart
readkeyx:
    	jmp readkey    ; Return to main key menu


; ---------
; RunEditor runs the defined editor and passes it a filename to open.
; EBX = pointer to the filename string.

RunEditor:
	mov byte ptr EditorCmd, 0   ; Zero (terminate) the string
	invoke lstrcat, ADDR EditorCmd, ADDR EditorName    ; Copy the EditorName to the Editor Command line
	invoke lstrcat, ADDR EditorCmd, ebx  ; Add filename to edit to the "edit filename" Command Line

	mov sinfo_.cb,sizeof sinfo_ ; this is done to maintain compatibility with future versions of Windows
	invoke GetStartupInfo,addr sinfo_
	xor ecx,ecx
	invoke CreateProcess, ecx, ADDR EditorCmd, ecx, ecx, ecx,
			      ecx, ecx, ecx, addr sinfo_,addr pinfo_ 

	invoke CloseHandle, pinfo_.hThread			    ; Close open handles
	invoke CloseHandle, pinfo_.hProcess	   
	jmp short readkeyx     ; resume processing keyboard input

error_exit:
if service
	cmp ServiceFlag,0
	je error_exit2
	invoke SetEvent, StopEvent		; Tell the service to stop
	jmp short done
endif

error_exit2:
	invoke SetTextColor,15 + 0	; Color= White
	print chr$(10), 13, "*** Press Enter to Exit ***"
jel:
	getkey
	cmp al,13  ; Got Enter?
	jne jel    ; jello till we do
	jmp short done

restart:
	inc RestartFlag

cleanup:

	invoke SetEvent, StopEvent		; Tell all nodes and threads to shut down
	cmp RestartFlag,0
	jne doit
	cmp ServiceFlag,0
	jne done ; avoid calling ShutDown twice
doit:
	call ShutDown			; Commence Shutdown	
done:
	cmp RestartFlag,1		; Don't exit if a restart command was performed
	je restart2

	invoke WSACleanup		; Cleanup Winsock
	invoke SetTextColor,15 + 0	; Set White text on black background
	ret				; Exit Net2BBS

restart2:
	;mov al,"B"
	;mov BBSTitle,al ; The first character of the BBS title gets zeroed, so restore it.
	jmp begin

StartServer endp

    
;-------------------------------------------------------------------------------------------------------
ShutDown proc near

	lea edi,LogBuf				; Set EDI pointer to start of buffer
	mov ebx, offset null
	invoke WriteLog2, ADDR StoppingTxt, ebx, ebx, ebx, 10		; Fixes a bug in WriteLog
	;invoke WriteLog, ADDR StoppingTxt, ADDR StoppingTxt 		; Write "Shutting down." to log (and to screen)

	mov eax,TCPport
	test eax,eax   ; is a TCP port defined?
	jz skiptelnet2
	invoke shutdown,hInSock,NULL ; SD_BOTH ; shutdown socket
	invoke closesocket,hInSock	; Close socket

skiptelnet2:
	mov eax,PolicyPort
	test eax,eax
	jz finished
	invoke shutdown,hInSock2,NULL; SD_BOTH ; shutdown socket
	invoke closesocket,hInSock2	; Close socket

finished:
; now we must wait for all open nodes to close by checking ActiveNodes

	mov ecx, 120 ; wait 1.2 second for all nodes to close
;
waitforshutdown:
	mov al,ActiveNodes	; wait for all active nodes to be closed
	or al,al
	jz alldown
	push ecx
	invoke Sleep,10
	pop ecx
	loop waitforshutdown

alldown:
	;invoke WSACleanup		; Cleanup Winsock
	;inc ShutdownFlag
	ret
ShutDown endp


;------------------------------------------------------------------------------------------------
BindListen proc near myPort:dword

; Bind a TCP port, and tell it to Listen for incoming connections. 
;
; "Socket" to get socket Descriptor.
; "htons" to convert TCP port from decimal to network bytes.
; "Bind" to own a TCP port.
; "Listen" for incoming connections on port.
;
; After this routine is done, "CreateProcess" can be used to pass each connection in its own thread.


	invoke socket,AF_INET,SOCK_STREAM,IPPROTO_TCP	; "Socket" sets us up the descriptor
	mov ebx,eax							; save socket descriptor handle in EBX

	invoke htons,myPort		    ; Convert port values host/network bytes 
	mov wsa.sin_port, ax		    ; store sin_port to bind		

	invoke bind,ebx,addr wsa,sizeof sockaddr_in   ; "Bind" to port socket
	.if eax!=NULL						    ; Check for error
		;print " Bind Failed"
        	stc
	      ret
	.endif

	invoke listen,ebx,3		; "Listen" for incoming connection (maximum=3) SOMAXCONN
	.if eax!=NULL				; Check for error
	   ;print "Listen Failed",10,13
	   stc
	   ret
	.endif

	clc
	mov eax,ebx ;Return socket handle in EAX
 	ret
BindListen endp

;------------------------------------------------------------------------------------------------
; 
;------------------------------------------------------------------------------------------------
; Telnet Server

AcceptThread proc near

; This thread accepts incoming telnet connections, and passes each one to its own SpawnNode Thread. 
;
AT_loop:
	invoke accept,hInSock,ADDR wsa2, ADDR wsa2size  ; "Accept" a new incoming connection.
									; wsa2=buffer for incoming ip
	.if eax!=INVALID_SOCKET					; If socket is good, Create the Thread. 
	    xor ebx,ebx
	    invoke CreateThread,ebx,ebx,offset SpawnNodeThread,eax,ebx,addr ThreadID ; eax is the winsock handle
	    invoke CloseHandle,eax
	.endif

	invoke WaitForSingleObject, StopEvent, 0 ; This might not be needed
	or eax,eax
	jnz AT_loop

	;invoke closesocket,hInSock ;This is now done during cleanup
	invoke ExitThread, 0
AcceptThread endp

;------------------------------------------------------------------------------------------------
; 
;------------------------------------------------------------------------------------------------
; Socket Policy Server

AcceptThread2 proc near
; param:dword

; This thread accepts incoming Socket Policy connections, and handles each one on its own.
; We could create a new thread for each connection, which would be required if this was a full
; feature policy server, but to keep it simple all we need to do is accept the connect, send the
; policy xml file, pause a little bit (10ms) and disconnect.

AT_loop2:
	invoke accept,hInSock2,ADDR wsa2, ADDR wsa2size ; "Accept" a new incoming connection.
									; wsa2=buffer for incoming ip
	.if eax!=INVALID_SOCKET					; If socket is good, Create the Thread. 
	  mov hSock2,eax
   	  lea edi,LogBuf					; Set EDI pointer to start of buffer
	  invoke ReadMyFile, offset PolicyFileName ;attempt to read policy file		  
	  jnc AT2_do        				; fail if it doesnt exist

AT2_fail:
	invoke lstrcpy,edi,ADDR MissingTxt	; Copy "Missing " text to buffer
	add edi,sizeof MissingTxt-1		; point EDI to end of buffer
	mov esi,offset PolicyFileName     	; point ESI to start of the Policy filename
	jmp short AT2_close

AT2_do:
	  invoke send,hSock2,esi,ecx,0		; Write the Policy file to the socket
	  invoke GlobalFree,esi				; free the Policy file allocated memory
	  invoke Sleep,10					; Pause 10ms
	  mov esi, offset SendPolicyTxt		; Point to "Sent policyname" text
AT2_close:
	  invoke  closesocket,hSock2			; Close the Socket
	  invoke lstrcpy,edi,esi		; copy the policy filename to the buffer
	  mov eax,wsa2.sin_addr			; Get the Internet Host Address
	  invoke inet_ntoa,eax			; Convert Internet Host Addr to dotted IP addr
	  invoke WriteLog, ADDR LogBuf, eax	; Write it to log (and to screen)
	.endif

	invoke        WaitForSingleObject, StopEvent, 0 ; Check if a shutdown is requested
	or eax,eax
	jnz AT_loop2

	;invoke closesocket,hInSock2 ; This is now done at cleanup
	invoke ExitThread, 0
AcceptThread2 endp


;------------------------------------------------
; SpawnNodeThread - This thread is created for each telnet connection. It spawns NetFoss and waits.

  SpawnNodeThread proc near hSock:dword

;----------------------------	
;local hDupeSock:dword	    ; The Duplicate Socket Handle
local Node:dword  	    ; Node number for this thread
local rpos:dword  	    ; Position in Blocked IP File
local pHostIPAddr:dword     ; pointer to the Host IP Address (non-dotted)
local pHostName:dword	    ; pointer to the resolved HostName
local pIPAddrTxt:dword      ; pointer to the IP Address dotted text
local NodeTxt[6]:byte	    ; Node number in ascii
local HandleTxt[6]:byte     ; Handle number in ascii
local TempBuff1[128]:byte   ; Temp buffers to replace command line macros
local TempBuff2[128]:byte   ; 
;----------------------------

	mov eax,wsa2.sin_addr	; Save the Internet Host Address
	mov pHostIPAddr,eax
	invoke inet_ntoa,eax	; Convert Internet Host Addr to dotted IP addr
	mov pIPAddrTxt,eax

	lea edi,LogBuf				    ; Set EDI pointer to start of buffer
	invoke lstrcpy,edi,ADDR TelnetTxt	    ; Copy "Telnet" text to buffer
	add edi,sizeof TelnetTxt-1		    ; point EDI to end
	invoke lstrcpy,edi,ADDR LoginTxt	    ; Copy "Incoming connection:" text to buffer
	add edi,sizeof LoginTxt-1		    ; point EDI to end
;	invoke WriteLog, ADDR LogBuf, pIPAddrTxt   ; Write it to log (and to screen)
; don't write it yet! (saves an extra line in the log file)

;	xor eax,eax ; 1.01 bugfix		    ; Zero Node value for now	
;	mov Node,eax

findnode:
	mov ebx, offset NodeTable	; Point EBX to nodetable, indexed with ECX
	mov ecx,StartNode
	dec  ecx
findnode1:
	cmp byte ptr [ebx+ecx],0	; Is node in use?
	je foundnode			; If not then claim it
	inc ecx 			; next
	cmp ecx,LastNode		; only check up to Last Node
	jne findnode1		; loop

; Here get out with Node=0, and handle the "no node" refusal later on.

	xor ecx,ecx
	jmp short setnode

foundnode:
	inc byte ptr [ebx+ecx]		; Enable this node in the table
	inc ActiveNodes
	inc ecx
setnode:
	mov Node,ecx			; Convert Node number to ascii
	or ecx,ecx
	jz nonode2			; Get out if node=0
	invoke dw2a,ecx,ADDR NodeTxt	; and store in NodeTxt

; Write the Users Connection info to Log file

	invoke lstrcpy,edi,ADDR Node_	; Copy "Node " text to buffer
	add edi,sizeof Node_-1 ; point EDI to end
	invoke lstrcpy,edi,ADDR NodeTxt ; Copy Node Number text to buffer
	invoke lstrlen,ADDR NodeTxt	; point EDI to end
	add edi,eax
	invoke lstrcpy,edi,ADDR OpenedTxt	; Copy " opened." text to buffer

nonode2:
	inc MailSlotSound ; Tell MailSlot login
	invoke WriteLog, ADDR LogBuf, pIPAddrTxt	; Write it to log (and to screen)
	dec MailSlotSound ; Tell MailSlot no sound
	cmp byte ptr ResolveModeTxt,"0"	       ; Check if ResolveIP mode enabled
	je check_blockfile				 ; Get out if not
	xor eax,eax
	cmp Node,eax					 ; Get out if no node
	je ResolveIP
	mov eax,len(ADDR ResolveMsg)               ; Get size of the ResolveMsg
	invoke send,hSock,ADDR ResolveMsg,eax,0    ; Write the ResolveMsg text to the socket

;--------------------------------------
; Resolve the IP address to a hostname
;--------------------------------------
ResolveIP:

	invoke gethostbyaddr,ADDR pHostIPAddr,4,AF_INET ; resolve HostIP Value into hostname
	mov ebx, offset UnknownTxt			; Assume IP won't resolve
	test eax,eax
	jz resolvefailed
	mov ebx,[eax].hostent.h_name			; Resolve was successful!   
resolvefailed:
	invoke lstrcpy,edi,ADDR ResolvedTxt	    ; Copy "Hostname: " text to buffer
	add edi,sizeof ResolvedTxt-1		    ; point EDI to end
	invoke lstrcpy,edi,ebx			    ; Copy Hostname text to buffer
	invoke WriteLog, ADDR LogBuf, pIPAddrTxt   ; Write it to log (and to screen)
	mov pHostName,ebx

; Display the resolved hostname result to the user, along with a CR/LF

	cmp ShowHostTxt,"0"
	je check_blockfile
	xor eax,eax
	cmp Node,eax
	je check_blockfile

	invoke send, hSock, ebx, len(ebx),0 ; Send resolved name to client

skipresult:

	invoke send,hSock, offset CRLF, sizeof CRLF-1,0 ; Send Carrage Return + Line Feed
	invoke atodw,addr ShowHostTxt  ; Number of milliseconds to show hostname for
	invoke Sleep,eax


;---------------
check_blockfile:
;
; Check if the telnet users IP or hostname exists within our file list of blocked IP's
;
; Variables used:
; rpos = Position in Blocked IP File
; ebx,ecx,edx,esi,edi will be overwritten by wildmatch

	invoke ReadMyFile, ADDR KillFileName ; Open and read the KillFile
	jc noblockfile		; get out if the file was not found
	push esi			; save the file pointer so we can later Globalfree

	xor eax,eax	    ; start at the first line (position 0)
	mov rpos,eax
	jmp short linein
	
readloop:
	mov eax,rpos		; check if rpos=0, if so we are done
	test eax,eax
	jz blockdone

linein:
;	mov rpos, linein$(esi,ADDR TempBuff1,rpos) ; This macro reads a line, and updates position
	invoke ReadLine, esi,ADDR TempBuff1,rpos ; uses modified readline to check for buffer overflow.
	mov rpos,eax        

;	test eax,eax   ; end of source?
;     jz blockdone   ; don't exit yet still must test last line
      test ecx,ecx   ; blank line?
	jz readloop    ; skip empty line

; Before we run the WildMatch, we should remove any spaces from the end of line
; (another idea: could remove spaces from entire line)

kill_trailing:
	cmp byte ptr TempBuff1[ecx], " "    ; look for a space
	jne notspace
	dec ecx 			    ; loop till all checked
	jnz kill_trailing
	jmp  short readloop ; if the line is empty, skip the wildmatch on this line

notspace:
	mov byte ptr TempBuff1+1[ecx],0     ; define the end-of-line with a zero

; Future Idea: could check if first character is either a plus or minus
; + = always allow this ip (takes priority).
; - = deny this ip (assumed)
; if an IP was explecitly allowed using +, then always allow it even if there is a deny *.
; 
; so when a + is found that matches, end the search
; when a deny is found that matches, set the result as fail, and continue searching.
; at the end of search, check result


	invoke WildMatch, ADDR TempBuff1, pIPAddrTxt	; Compare Line with dotted IP text
	jnz gotwild
	cmp byte ptr ResolveModeTxt,"0"			; Check if resolving hostnames
	je readloop					; get out if not

	invoke WildMatch, ADDR TempBuff1,  pHostName	; Compare Line with HostName
	jz readloop					; Zero=No match, so go back to readloop


gotwild:

; Here we found a match, so send the killmsg (or killfile) and disconnect the user

	invoke ReadMyFile, offset KillMsgFileName	; attempt to read killmsg file		  
	jc nokillmsgfile				; skip if it doesnt exist
	invoke send,hSock,esi,ecx,0			; Write the KillMsg file to the socket
	invoke GlobalFree,esi				; free the killmsg file allocated memory
	jmp short killfinish

nokillmsgfile:
	invoke send,hSock,ADDR KillMsg,sizeof KillMsg,0	  ; Write the unwelcome text to the socket
killfinish:
	invoke LogRefused, ADDR Refused3Txt, pIPAddrTxt ; Note the Log
	pop eax
	invoke GlobalFree,eax 	; free the allocated memory
sleepclose:
	invoke Sleep,500       ; wait half a second
socketclose:
	invoke closesocket,hSock			    ; Close the socket handle
	jmp freenode		; and close connection

blockdone:
	pop eax
	invoke GlobalFree,eax		; free the allocated memory of killfile

noblockfile:


; DNSBL Queries  - DNS Blacklists
; 
; When a mail server receives a connection from a client, and wishes to check that client against a DNSBL
; (let's say, dnsbl.example.net), it does more or less the following:
; 1.Take the client's IP address say, 192.168.42.23 and reverse the order of octets, yielding 23.42.168.192.
; 2.Append the DNSBL's domain name: 23.42.168.192.dnsbl.example.net.
; 3.Look up this name in the DNS as a domain name ("A" record). This will return either an address, indicating
; that the client is listed; or an "NXDOMAIN" ("No such domain") code, indicating that the client is not.
; 4.Optionally, if the client is listed, look up the name as a text record ("TXT" record). Most DNSBLs publish
; information about why a client is listed as TXT records.
; 
; There is an informal protocol for the addresses returned by DNSBL queries which match. Most DNSBLs return an
; address in the 127.0.0.0/8 IP loopback network. The address 127.0.0.2 indicates a generic listing. Other
; addresses in this block may indicate something specific about the listing that it indicates an open relay,
; proxy, spammer-owned host, etc. For details see RFC 5782. Any result which is not in the 127.0.0.* range
; should not be considered a blacklist (because Spamhaus features a whitelist result as well).

	cmp DNSBL, 0
	je skipDNSBL
	mov eax,pHostIPAddr  ; Get Internet Host Addr
	xchg al,ah           ; Reverse the order of octets
	ror eax,16
	xchg al,ah
	invoke inet_ntoa,eax ; Convert to dotted IP addr
	mov BLHostName,0     ; Zero the length of BLHostName string 
	mov DotTxt, "."      ; Place a dot in front of BLHostName String to avoid an extra lsrcat

	invoke lstrcat, ADDR BLHostName, eax         ; Copy the dotted IP string into BLHostName
	invoke lstrcat, ADDR BLHostName, ADDR DotTxt ; Append the dot followed by the DNSBL's domain name.
	invoke inet_ntoa,pHostIPAddr	; Restore the dotted IP address to its forward form (used by close).
	mov pIPAddrTxt,eax ; this might not be needed

	; print " The DNS BlackList reverse-IP Hostname is: "
	; invoke StdOut,ADDR BLHostName
	; print " ",13,10

	invoke gethostbyname, addr BLHostName       ;Attempt to resolve hostname into IP address
	or eax,eax
	jz DNSBL_passed				; If no record was found, the IP passed.
	mov eax,[eax+12]				; move the value of h_list member into eax 
	mov eax,[eax]				; copy the pointer to the actual IP address into eax 
	mov eax,[eax]				; copy hostname's resolved IP address into eax
	and eax,00FFFFFFh  			; 127.0,0.1 = 0100007F hex
	cmp eax,0000007Fh                   ; Make sure result is in the 127.0.0.* range   
	jne DNSBL_passed                    ; otherwise it's assumed non-blacklisted and passed the test

	;print " The result is a bad IP",13,10
	invoke WriteLog2, pIPAddrTxt, ADDR DNSBLTxt, ADDR DNSBL, ADDR ListedTxt, 10 ; Listed!
	jmp socketclose ; Kill the connection

DNSBL_passed:
	;print " The result is a good IP",13,10
	invoke WriteLog2, pIPAddrTxt, ADDR DNSBLTxt, ADDR DNSBL, ADDR PassedTxt, 10 ; Passed OK.

skipDNSBL:

; If there is a semaphore file, send it to winsock and refuse user.

	cmp byte ptr SemFileName,0	; Is Semaphore file defined?
	je  nosemfound			; skip if none

	invoke	ReadMyFile, offset SemFileName	; Read the entire semaphore file		 
	jc nosemfound						; Skip if it's not there
	invoke	send,hSock,esi,ecx,0			; Write the semaphore file to the socket
	invoke	GlobalFree,esi				; free the allocated memory
	invoke	LogRefused, ADDR Refused2Txt, pIPAddrTxt ; Note Sem Refusal in Log
	jmp sleepclose						; close connection

nosemfound:
;       print "Semaphore was not found",10,13

; check if all nodes are busy (and handle the no nodes available state)

	xor eax,eax
	or  eax,Node
	jnz nodevalid	; Node 0 must fail, with a busy message

	invoke LogRefused, ADDR Refused1Txt, pIPAddrTxt ; All nodes are in use

	;cmp byte ptr ResolveModeTxt,"0"		               ; Check if ResolveIP mode enabled
	;je tellbusy						         ; Skip Clear if not
	;invoke send,hSock,ADDR ANSIClear,SIZEOF ANSIClear,0     ; Send an ANSI clear screen command

tellbusy:
	invoke send,hSock,addr BUSYtxt,sizeof BUSYtxt,0    ; Tell user "BUSY"+CRLF
	jmp sleepclose			; Close connection


nodevalid:

; Here we have a valid node number, and the IP / Hostname were not in the block/kill list, so all is good.
; allow user to spawn a node.

; First send a signal to the Telnet Monitor informing it to launch a netspy monitor.

; New for 2013:
	mov eax,Node
	mov LaunchSpyNode,al
	xor ebx,ebx ; just send the 4 byte header
	call WriteMailSlot
	mov LaunchSpyNode,0


	;invoke	  GetCurrentProcess	; Get hProcess number
	;mov ebx,eax
	;
	; Duplicate the Socket Handle for the spawned process
	; invoke DuplicateHandle,ebx,hSock,ebx,addr hDupeSock,0,TRUE,DUPLICATE_SAME_ACCESS  ; Store the dupesockhandle value in ascii
	; This is not required by Windows NT (and later variants).

	invoke dw2a,hSock, ADDR HandleTxt      ; Create HandleTxt ascii


; Now NodeTxt and HandleTxt are defined, so replace *N/*H/*I/*R macros on the Command Line

 invoke Replace,ADDR CommandTxt,ADDR TempBuff1,ADDR ntext, ADDR NodeTxt   ; Replace *N with {node}
 invoke Replace,ADDR TempBuff1, ADDR TempBuff2,ADDR htext, ADDR HandleTxt ; Replace *H with {handle}
 invoke Replace,ADDR TempBuff2, ADDR TempBuff1,ADDR IPtext, pIPAddrTxt    ; Replace *I with {IP Address}
 invoke Replace,ADDR TempBuff1, ADDR TempBuff2,ADDR restext, pHostName    ; Replace *R with {Resolved text}

; Now Command is in TempBuff2
; Do the same with the StartPath (place in TempBuff1)

 invoke Replace,ADDR StartPath, ADDR TempBuff1,ADDR ntext,ADDR NodeTxt	 ; Replace *N with {node}

; Now spawn NetFoss to take over the connection

	invoke PlayWav,addr LogonWav			    ; Play the logon wav
	invoke lstrcpy,ADDR BBSTitleNode,ADDR NodeTxt ; Create Title (with node number)

	;cmp byte ptr ResolveModeTxt,"0"		    ; Check if ResolveIP mode enabled
	;je doshell						    ; Skip Clear if not
	;invoke send,hSock,ADDR ANSIClear,SIZEOF ANSIClear,0     ; Send an ANSI clear screen command

doshell:
	invoke Shell, ADDR TempBuff1, ADDR TempBuff2,hSock  ; Shell to NF+BBS, passing Path + Command to Spawn
	;invoke CloseHandle,hSock			    ; Sock Handle is now closed by Shell!

freenode:
	mov ebx, offset NodeTable
	mov ecx,Node
	dec ecx
	jc close   ; skip over node removal if node was zero
	dec byte ptr [ebx+ecx]			; Mark node as available in Node Table
	mov dodecactivenodes,1
	;dec ActiveNodes				; One less node
	mov MailSlotSound,2 ; Sound = Logoff
close:
	xor eax,eax
	cmp eax,Node                          ; Skip if node # not assigned
	je  nonode
	lea edi,LogBuf                        ; Set EDI pointer to start of buffer
	invoke lstrcpy,edi,ADDR Node_         ; Add "Node 1 closed." line to log
	add edi,sizeof Node_-1
	invoke lstrcpy,edi,ADDR NodeTxt       ; copy Node number text
	invoke lstrlen, ADDR NodeTxt          ; point EDI to end
	add edi,eax
	invoke lstrcpy,edi,ADDR ClosedTxt	; Copy "closed." text to buffer
	invoke WriteLog, ADDR LogBuf, pIPAddrTxt	; Write it to the log (and to the screen)
; play wave only after log is written.
	invoke PlayWav,addr LogoffWav		; Play the logoff WAV
	mov MailSlotSound,0 		; finished with sound
	cmp dodecactivenodes,1		; Check flag to decrement activenodes
	jne nonode
	dec dodecactivenodes		; Clear the flag
	dec ActiveNodes			; One less active node

nonode:
	invoke ExitThread, 0

SpawnNodeThread endp

;------------------------------------------------------------------------------------------------
ReadMyFile proc near lpfilename

; This opens a file (if the file already exists), and reads the entire file into memory.
; Exit with Carry Set to indicate an error
; Exit with ESI= Global Memory handle (to be released) if successful
; AND ECX= bytes read

local hTempFile
local bytesread

	invoke GetFileAttributes, lpfilename		   ; Check if the file exists
	inc eax
	jz readmyfile_error

	invoke CreateFile,lpfilename,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,NULL
	mov hTempFile,eax
	invoke GetFileSize,eax,NULL	; get the file size
	push eax
	invoke GlobalAlloc,GMEM_FIXED,eax	;  allocate at least that much memory (Destroys ECX and ?)
	pop ecx
	mov esi, eax				;  Save the memory Handle.
	invoke	ReadFile,hTempFile,	;  Read the File
			esi,				;  Buffer Address
			ecx,				;  Max Amount to send
			ADDR bytesread, 		;  In: bytes actually read
			NULL				;  overlapped

	or eax,eax
	jz readmyfile_error ; This may be overkill since the file exists

; Here we could make sure the entire file was read, and try to read the remainder if needed.
; Exit this proce with carry set if there was an error?
		
	invoke CloseHandle, hTempFile		   ; close the file handle
	mov ecx, bytesread			   ; Return bytes read in ECX
	clc
	ret

readmyfile_error:
	;print "file not found",10,13
	stc
	ret

ReadMyFile endp

;------------------------------------------------------------------------------------------------
PlayWav proc near lpfilename
; 
; Check if a WAV file exits, and if it does, play it

	invoke GetFileAttributes, lpfilename
	inc eax		; Check that EAX!=-1
	jz NoPlay
	Invoke PlaySound, lpfilename, NULL, SND_FILENAME or SND_ASYNC
NoPlay:
	ret
PlayWav endp

;------------------------------------------------------------------------------------------------
WriteLog proc near lplogbuffer:DWORD, lpIPTextAddr:DWORD

; This writes the string passed to it to the log file (and screen), appending the current
; date and time to the beginning, and appends a CR/LF to the end. If a pointer to an IP
; address text string is provided, then the IP address is added after the time.
;
; All registers are saved

; for the mailslot, we need to send the additional 4 bytes:
; MailSlotColor (byte)
; MailSlotSound effect (byte)
; LaunchSpyNode (byte)
; ActiveNodes (byte)


	pusha      ; Save all registers

; First append CR/LF and zero to end of custom string:

	;invoke lstrcat, lplogbuffer, ADDR CRLF ; This won't work since the buffer is not zero terminated

	mov edi, lplogbuffer			; point EDI to end of log line buffer
	add edi,len (edi)
	mov dword ptr [edi],00000A0Dh		; append CR/LF/NULL to buffer, using mov dword for speed

; Get the Date and Time, and format it.

	invoke GetLocalTime,addr SysTime
	invoke GetTimeFormat,NULL,NULL,addr SysTime,SADD("HH':'mm':'ss "),addr TimeTxt,sizeof TimeTxt
	invoke GetDateFormat,NULL,NULL,addr SysTime,SADD("MM'-'dd'-'yyyy"),addr DateTxt,sizeof DateTxt
	mov byte ptr DateTxt+10," " ; put a space between date and time. 
	lea esi, LogBuf2		    ; Point ESI to buffer
	invoke lstrcpy,esi,Addr DateTxt	; Add Date+Time
	add esi,(sizeof DateTxt) + (sizeof TimeTxt)
	mov ebx,00202D20h		; " - ",0 
	mov [esi],ebx	    		        ; add it as a dword
	add esi,3                             ; skip the zero
; If the IP address text is zero, then skip this part
	mov eax,lpIPTextAddr
	test eax,eax
	jz skipip

	invoke lstrcpy,esi,eax ; lpIPTextAddr	  ; Append the IP Address to buffer
	invoke lstrlen,eax ; lpIPTextAddr		  ; adjust buffer size for IP length
	add esi,eax
	;mov ebx, 00202D20h 
	mov [esi],ebx				  ; add " - " as a dword
	add esi,3
skipip:
	invoke lstrcpy,esi, lplogbuffer	  ; Copy Custom String in Buff2 to Buff1

	lea esi, LogBuf2

	invoke lstrlen,esi			  ; Get size of new string
	mov ebx,eax ; Store String Length in ebx

; Write the entire line to the log

	invoke CreateFile,ADDR LogFileName,GENERIC_WRITE,FILE_SHARE_READ,0,
			  OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
	mov hLogFile,eax
	invoke SetFilePointer,hLogFile,0,0,FILE_END ; Point to end of log file
	invoke WriteFile,hLogFile,ADDR LogBuf2,ebx,ADDR written,0
	invoke CloseHandle,hLogFile
	invoke StdOut,ADDR LogBuf2		  ; Print it to screen as well



; Now also attempt to write it to a mailslot

	call WriteMailSlot

	popa
	mov edi,lplogbuffer			  ; Reset EDI pointer to start of buffer
	ret

WriteLog endp


WriteMailSlot proc near
	add ebx,4 ; ebx contains length of string to write, so add 4 bytes for the header
	Invoke CreateFile,ADDR mailslot,   ; Filename 
		GENERIC_WRITE,        ; Write mode
		FILE_SHARE_READ,      ; Read mode
		0,                    ; ?
		OPEN_EXISTING,        ; Sharing
		FILE_ATTRIBUTE_NORMAL,; Attribute
		0                     ; ?	

	cmp eax, INVALID_HANDLE_VALUE ; Was the mailslot created ok?
	je nomailslot
	mov esi,eax                    ; esi = mailslot handle

	invoke WriteFile, esi,\   ; handle to write to
		ADDR MailSlotColor,\                       ; buffer address
		ebx,\                    ; max bytes to write
		ADDR written,\        ; bytes actually written
		0                           ; Flags

invoke CloseHandle, esi ; Close the mailslot

nomailslot:
	ret

WriteMailSlot endp





;------------------------------------------------------------------------------------------------
WriteLog2 proc near String1:DWORD, String2:DWORD, String3:DWORD, String4:DWORD, Color:BYTE

; Mission: Call Writelog (without an IP address) passing 4 strings of text

	invoke lstrcpy,edi, String1		; Copy "Waiting for telnet connections" text to buffer
	invoke lstrlen, String1	; point EDI to end
	add edi,eax
	invoke lstrcpy,edi, String2
	invoke lstrlen,String2	; point EDI to end
	add edi,eax
	invoke lstrcpy,edi, String3
	invoke lstrlen,String3	; point EDI to end
	add edi,eax
	invoke lstrcpy,edi, String4
	invoke SetTextColor,Color
	invoke WriteLog, ADDR LogBuf, 0	; 0 means no IP passed. Write it to log (and to screen)
	ret
WriteLog2 endp

;------------------------------------------------------------------------------------------------ 
LogRefused proc near lpfilename:DWORD, lpIPTextAddr:DWORD 

	invoke lstrcpy,edi,ADDR RefusedTxt	; Add RefusedTxt to buffer
	add edi,sizeof RefusedTxt-1		; Adjust buffer end pointer 
	invoke lstrcpy,edi,lpfilename		; Add filename to buffer
	invoke WriteLog, ADDR LogBuf, lpIPTextAddr	; Write the log entry
	ret
LogRefused endp

;----------------------------------------------------------------------------------------------- 
Shell proc near lppath:DWORD,lpfilename:DWORD,hShellSock:DWORD

; Shell - Spawn a process and wait for it to finish
; 
;
; LPCTSTR lpApplicationName,		       null
; LPTSTR lpCommandLine, 		       lpfilename
; LPSECURITY_ATTRIBUTES lpProcessAttributes,   null
; LPSECURITY_ATTRIBUTES lpThreadAttributes,    null 
; BOOL bInheritHandles, 		       true
; DWORD dwCreationFlags,		       create_new_cons+normal_prior (30h)
; LPVOID lpEnvironment, 		       null
; LPCTSTR lpCurrentDirectory,		       lppath
; LPSTARTUPINFO lpStartupInfo,		       addr sinfo
; LPPROCESS_INFORMATION lpProcessInformation   addr pinfo

local event_list[2]:DWORD               ; array of events to monitor
LOCAL sinfo:STARTUPINFO
LOCAL pinfo:PROCESS_INFORMATION

	cmp byte ptr DebugModeTxt,"0"
	je skipdebug
	invoke SetTextColor,2 + 0	   ; Text = Dark Green
	print " Spawn: "
	invoke StdOut,lpfilename
	invoke StdOut,ADDR CRLF ; print $chr(13),10
	invoke SetTextColor,  10 + 0	   ; Text = Bright Green

skipdebug:

	mov sinfo.cb,sizeof sinfo ; this is done to maintain compatibility with future versions of Windows
	invoke GetStartupInfo,addr sinfo
	mov sinfo.lpTitle, offset BBSTitle
	; Set the Window Title

;	mov sinfo.dwFlags, STARTF_USESHOWWINDOW	; Demand setting window view mode.
	mov ebx, STARTF_USESHOWWINDOW			; Demand setting window view mode.

	invoke atodw,addr NodeLinesTxt		; Get NodeLines= value
	or eax,eax
	jz skipsize

	or ebx, STARTF_USECOUNTCHARS Or STARTF_USESIZE ;or STARTF_USEPOSITION

; This sets the console buffer size (buffer size can be bigger then screen size, but must not be smaller!)
	mov sinfo.dwXCountChars,80
	mov sinfo.dwYCountChars,eax
    
; The console screen size can only be set in Pixels, so we must assume the default font size of 8x12 for this to work:
; or we could use GetCurrentConsoleFont process (only for XP and above)

; A fucture option would be to use the GetCurrentConsoleFont process, but it's only for XP and above.



	mov sinfo.dwXSize, 80*8 ; multiply X size by font width, and always use X-size=80
	mov edx,12              ; multiply Y size by font height 
	mul edx  
	mov sinfo.dwYSize, eax

skipsize:
	mov sinfo.dwFlags, ebx	; Set the STARTF flags.

  ; ShowWindow modes:
  ; These are described here:  http://msdn.microsoft.com/en-us/library/ms633548.aspx
  ;
  ; SW_HIDE = 0
  ; SW_NORMAL = 1
  ; SW_SHOWMINIMIZED = 2
  ; SW_MAXIMIZE = 3
  ; SW_SHOWNOACTIVATE = 4
  ; SW_SHOW = 5
  ; SW_MINIMIZE = 6
  ; SW_SHOWMINNOACTIVE = 7
  ; SW_SHOWNA = 8
  ; SW_RESTORE = 9
  ; SW_SHOWDEFAULT = 10
  ; SW_FORCEMINIMIZE = 11
 
	movzx ax,NodeView 	; Window Show mode: Normal, Minimize, Maximize, Hidden, etc.

; Full Screen View option was disabled in version 1.03a
; because this function was only supported in XP and 2003.
;
; cmp al,99 ;99=Full-Screen
; jne set_node_view
;=======================================================
; Force Full-Screen window by stuffing keyboard events
; Sends Alt-Enter to console for Win XP, 2000, and 2003
; This will not work under Windows Vista or later!
;  invoke keybd_event,VK_MENU,38h,0,0
;  invoke keybd_event,VK_RETURN,1Ch,0,0
;  invoke keybd_event,VK_RETURN,1Ch,KEYEVENTF_KEYUP,0
;  invoke keybd_event,VK_MENU,38h,KEYEVENTF_KEYUP,0
;  mov ax,SW_NORMAL
;=======================================================

set_node_view:
	mov sinfo.wShowWindow, ax

; CreateProcess
	xor ecx,ecx
	invoke CreateProcess, ecx, lpfilename, ecx, ecx, TRUE,
			CREATE_NEW_CONSOLE Or NORMAL_PRIORITY_CLASS,
			ecx, lppath, addr sinfo, addr pinfo


  .if eax 

; Wait for either the process to terminate or the StopEvent to be triggered

	;invoke closesocket,hShellSock  		; Close the socket


	mov eax, pinfo.hProcess 
	mov event_list+4,eax 
	mov eax,StopEvent
	mov event_list,eax

	invoke WaitForMultipleObjects,\
		2,\                             ; number of events
		ADDR event_list,\               ; events
		FALSE,\                         ; return if any event is signaled
		INFINITE                        ; Wait forever

  .else
	cmp byte ptr DebugModeTxt,"0"
	je Shell_end
	invoke SetTextColor,2 + 0	    ; Text = Dark Green
	print " Spawn Failed!",13,10
	invoke SetTextColor,10 + 0	    ; Text = Bright Green
  .endif 

Shell_end:
	invoke shutdown,hShellSock,SD_BOTH		; force disconnect
	invoke closesocket,hShellSock  		; Close the socket 	
	invoke CloseHandle, pinfo.hThread		; Close open handles
	invoke CloseHandle, pinfo.hProcess	   
	ret

Shell endp


;------------------------------------------------------------------------------------------------
; Get Settings from net2bbs.ini

GetSettingsFromIni proc near ; uses ebx esi edi

    ;LOCAL   APP_Path[128] :BYTE
    LOCAL   INI_Path[128] :BYTE

    CTEXT MACRO text:VARARG
      LOCAL TxtName
      .data
	TxtName BYTE text, 0
      .code
      EXITM <ADDR TxtName>
    ENDM
    
	;invoke  GetAppPath, ADDR APP_Path			; Get path of Application  
	invoke  GetAppPath, ADDR INI_Path			; Get path of Application for INI
	invoke  SetCurrentDirectory, ADDR INI_Path      ; Set CurrentDirectory (in case of Service)
	invoke lstrcat, ADDR INI_Path, ADDR IniFileName	; Append the Ini FileName to the INI path 	   

	; Make sure ini file can be found, or else we fail.

	invoke GetFileAttributes, addr INI_Path ; Does the .ini file exist?
	inc eax				; -1 means it doesn't exist
	jnz iniread
	invoke SetTextColor,12 + 0	; color=Red
	;print  "Config missing: "
	invoke StdOut,ADDR MissingTxt
	invoke SetTextColor,7 + 0	; color=White
	invoke StdOut,ADDR INI_Path
inifail:
	stc 				; set carry to indicate error and exit
	ret
		
iniread:
	lea eax,INI_Path
	mov INI_ADDR, eax


; GetFromIni uses:  Command Text, default value, Where to place it, maximum size in bytes

 invoke GetFromIni, CTEXT("Command"),    ADDR null,    ADDR CommandTxt, sizeof CommandTxt
 invoke GetFromIni, CTEXT("StartPath"),  ADDR DotSlash,  ADDR StartPath, sizeof StartPath
 invoke GetFromIni, CTEXT("Port"),       CTEXT("23"),ADDR TCPportTxt,sizeof TCPportTxt
 invoke GetFromIni, CTEXT("PolicyPort"), ADDR zero,  ADDR PolicyPortTxt,sizeof PolicyPortTxt
 invoke GetFromIni, CTEXT("Nodes"),      CTEXT("256"),ADDR MaxNodesTxt, sizeof MaxNodesTxt
 invoke GetFromIni, CTEXT("StartNode"),  ADDR one,   ADDR StartNodeTxt, sizeof StartNodeTxt
 invoke GetFromIni, CTEXT("Debug"),      ADDR one,   ADDR DebugModeTxt, sizeof DebugModeTxt
 invoke GetFromIni, CTEXT("Resolve"),    ADDR one,   ADDR ResolveModeTxt, sizeof ResolveModeTxt
 invoke GetFromIni, CTEXT("DNSBL"),      ADDR null,  ADDR DNSBL, sizeof DNSBL
 invoke GetFromIni, CTEXT("Log"),        CTEXT("telnet.log"), ADDR LogFileName, sizeof LogFileName
 invoke GetFromIni, CTEXT("Editor"),     CTEXT("notepad"), ADDR EditorName, sizeof EditorName
 invoke GetFromIni, CTEXT("KillList"),   CTEXT("kill.txt"), ADDR KillFileName, sizeof KillFileName
 invoke GetFromIni, CTEXT("KillMsg"),    CTEXT("Access Denied."), ADDR KillMsg, sizeof KillMsg
 invoke GetFromIni, CTEXT("KillMsgFile"),ADDR null,  ADDR KillMsgFileName, sizeof KillMsgFileName
 invoke GetFromIni, CTEXT("Semaphore"),  ADDR null,  ADDR SemFileName, sizeof SemFileName
 invoke GetFromIni, CTEXT("ResolveMsg"), ADDR null,  ADDR ResolveMsg, sizeof ResolveMsg
 invoke GetFromIni, CTEXT("ShowHost"),   ADDR zero,   ADDR ShowHostTxt, sizeof ShowHostTxt
 invoke GetFromIni, CTEXT("NodeView"),   ADDR one,   ADDR NodeViewTxt, sizeof NodeViewTxt
 invoke GetFromIni, CTEXT("MainView"),   ADDR one,   ADDR MainViewTxt, sizeof MainViewTxt
 invoke GetFromIni, CTEXT("NodeLines"),  ADDR zero,  ADDR NodeLinesTxt, sizeof NodeLinesTxt


;invoke lstrcat, ADDR KillMsg, ADDR CRLF ; Add CR/LF to end of killmsg?

	cmp byte ptr StartPath,0 ; Empty StartPath is illegal
	jne pathok
	invoke lstrcat, ADDR StartPath, ADDR DotSlash   ; Add a ./ to an empty StartPath 
pathok:

	invoke lstrcat, ADDR EditorName, ADDR spacestring   ; Add a space to the base EditorName 
	invoke lstrcat, ADDR ResolveMsg, ADDR spacestring   ; Add a space to the resolve message 
	;invoke lstrcat, ADDR EditorName, ADDR APP_Path      ; Add the Application path to the EditorName
	; There is no longer any need to add the app path to the editor name since we changed to the app dir


	invoke atodw,addr NodeViewTxt	; Save the NodeView= value

SetNodeView:

	mov NodeView,al
	invoke atodw,addr MainViewTxt	; Get MainView= value

	invoke ShowWindow,hWnd,eax   ; Set our Console Window view

skipShowWin:

; this is now done later
;	invoke atodw,addr NodeLinesTxt	; Get NodeLines= value
;	mov NodeLines,eax
	
	invoke atodw,addr TCPportTxt	; Save the provided TCP port if its non-zero
	mov TCPport,eax

	invoke atodw,addr PolicyPortTxt	; Save the provided Policy port
	mov PolicyPort,eax

	invoke atodw,addr StartNodeTxt	 ; Save the start node if its non-zero
	or eax,eax
	jnz setstartnode
	inc eax
setstartnode:
	mov StartNode,eax

	invoke atodw,addr MaxNodesTxt	; Save the max nodes if its non-zero
	;or eax,eax
	;jnz setmaxnode
	;mov ax,256
setmaxnode:
	mov MaxNodes,eax
	add eax,StartNode
	dec eax
	mov LastNode,eax		; Define LastNode (StartNode+MaxNodes-1)
    
    	cmp byte ptr DebugModeTxt,"0"
	je initdone
	invoke SetTextColor,2 + 0
	print "Debug: Read "
	invoke StdOut,ADDR INI_Path
	invoke StdOut,ADDR CRLF ; print " ",10,13

initdone:
	clc
	ret
GetSettingsFromIni endp

;------------------------------------------------------------------------------------------------
; Get a command from INI file

GetFromIni proc near lpCmd:DWORD, lpDefault:DWORD, lpDest:DWORD, DestSize:DWORD

; This stub calls GetPrivateProfileString in Kernel32.dll

	invoke GetPrivateProfileString, ADDR IniSectionName, lpCmd, lpDefault, lpDest, DestSize, INI_ADDR
	ret
GetFromIni endp


;------------------------------------------------------------------------------------------------
; Get the Application Path

GetAppPath proc near lpPathBuffer:DWORD

	invoke GetModuleFileName,0,lpPathBuffer,128  ; return length in eax
	add eax, lpPathBuffer         ; Search from end to start
findslash:
	dec eax                        
	cmp BYTE PTR [eax],"\"  	; find the last "\"
	jne  findslash
	mov  BYTE PTR [eax+1],0		; write zero terminator after "\"
	;mov  eax, lpPathBuffer
	ret
GetAppPath endp


;------------------------------------------------------------------------------------------------
; Initialize Console
;
; Returns with: EBX = X-console width
;               ECX = Y-console height (currently disabled)
;InitConsole proc near
;
;
;	invoke GetConsoleWindow
;	mov    hWnd,eax 
;
;	Invoke SetConsoleTitle, ADDR Net2BBSTitle              ; Set Window Title
;	invoke FindWindow,ADDR ClassName, Addr Net2BBSTitle    ; Find Window handle matching this class/title
;
;
;;invoke CreateConsoleScreenBuffer,GENERIC_READ OR GENERIC_WRITE,0,0,CONSOLE_TEXTMODE_BUFFER,0
;
;; There is no need to change the input
;;	invoke GetStdHandle,STD_INPUT_HANDLE
;;	mov hStdIn, eax
;;	invoke SetConsoleMode, hStdIn, ENABLE_PROCESSED_INPUT
;
;
;; But we must define the output
;	invoke GetStdHandle,STD_OUTPUT_HANDLE
;	mov   hStdOut,eax
;
; ;InitClear:
; ;	cls		  ; Clear the screen via MASM32
; ;	invoke FillConsoleOutputAttribute,hStdOut,00,80*25,NULL,ADDR temp   ; Force the screen to clear black
; ;	invoke GetConsoleScreenBufferInfo,hStdOut,ADDR csbi
; ;	movzx ebx,csbi.dwSize.x
; ;	mov   console_X_size,ebx
; ;	movzx ecx,csbi.swSize.y
; ;	mov   console_Y_size,ecx
; ;	mov dx,csbi.dwCursorPosition.y ; Get 'y' Cursor position.
;
;      ;cls ; clear screen
;      ret
;      
;InitConsole endp

;------------------------------------------------------------------------------------------------
; Convert Double-Word to ASCII string
;
; dwValue is passed as a value, direct, indirect or in register
; lpBuffer is the ADDRESS of the receiving buffer
; Returns with eax= number of characters written to buffer (zero=error).
;
; EXAMPLE:
; invoke dw2a,edx,ADDR buffer


dw2a proc near dwValue:DWORD, lpBuffer:DWORD

	invoke wsprintfA,lpBuffer,ADDR fMtString,dwValue
	ret
dw2a endp


;------------------------------------------------------------------------------------------------
; This ReadLine procedure was taken from the MASM32 library and modified to prevent line buffer
; overflow.  It is used to process the killfile list of bocked IP's and hostnames.

OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

align 4
ReadLine proc source:DWORD,buffer:DWORD,spos:DWORD

comment * ------------------------------------------------------

        source  =   source memory to read line from
        buffer  =   buffer that line of text is written to
        spos    =   start position in buffer to write to

        readline copies a line of text from the source
        to the buffer starting from the offset set in "spos",
        updates the "spos" variable to the start of the following
        line of text and returns that variable in EAX.
        EAX returns ZERO if the end of the source is on the
        curent line.

        The length of the line not including ascii
        0 and 13 is returned in ECX. You should test
        the buffer if ZERO is returned in EAX as it may
        contain the last line of text that is zero terminated.

        Conditions to test for.
        1. End of source returns zero in EAX.
        2. blank line has 1st byte in buffer set to zero
           and a line length in ECX of ZERO.
        3. Line length is returned in ECX.

        ------------------------------------------------------ *

    push edi

    mov edx, [esp+8]            ; source address in EDX
    mov edi, [esp+12]           ; buffer address in EDI
    add edx, [esp+16]           ; add spos to source
    xor eax, eax                ; clear EAX
    mov ecx, -1                 ; set index and counter to -1
    jmp short ristart

  align 4
  pre:
  ;---------- buffer overflow pcm fix 1
  cmp ecx,128
  ja ristart
  ;----------
    mov [edi+ecx], al           ; write BYTE to buffer
  ristart:
    add ecx, 1
    mov al, [edx+ecx]           ; read BYTE from source
    cmp al, 9                   ; handle TAB character
    je pre
    cmp al, 13                  ; test for ascii 13 and 0
    ja pre
    ;---------- buffer overflow pcm fix 2
    mov edx,128
    cmp ecx,edx
    jb termit
    mov ecx,edx
   ;----------

termit:
    mov BYTE PTR [edi+ecx], 0   ; write terminator to buffer
    test eax, eax               ; test for end of source
    jz liout                    ; return zero if end of source
    lea eax, [ecx+2]            ; add counter + 2 to EAX
    add eax, [esp+16]           ; return next spos in eax

  liout:
    pop edi
    ret 12

ReadLine endp

OPTION PROLOGUE:PrologueDef
OPTION EPILOGUE:EpilogueDef



;------------------------------------------------------------------------------------------------
; The procedures below this line were found in public forums and may or may not be public domain!
;------------------------------------------------------------------------------------------------


;------------------------------------------------------------------------------------------------
SetTextColor proc near foreback16:BYTE ;was fore:DWORD,back:DWORD

; 
; This proc sets the foreground and background attributes for
; the characters written to the console screen buffer.
;
; The color values are normal 4-bit IRGB character mode
; attributes where:
;   bit3 = intensity
;   bit2 = red
;   bit1 = green
;   bit0 = blue
; 
; The attribute is stored in a single byte (contained in a dword).
	;mov   eax,back
	;shl   eax,4
	;or	  eax,fore

      movzx eax,foreback16
      mov MailSlotColor,al ; Save the current color for the mailslot
	invoke SetConsoleTextAttribute,hStdOut,eax
	ret
SetTextColor endp


;------------------------------------------------------------------------------------------------
; Replace - Text String Search and Replace Function
;
align 4

Replace proc near src:DWORD,dst:DWORD,txt1:DWORD,txt2:DWORD

;  Source String, Dest String, orig text, new text
    LOCAL lsrc	:DWORD

;	push ebx
;	push esi
;	push edi
	cld				; Clear direction flag	(needed for stosb)		
	mov lsrc, len(src)	; procedure call for src length
	sub lsrc, len(txt1) 	; procedure call for 1st text length

	mov esi, src
	add lsrc, esi		; set exit condition
	mov ebx, txt1
	inc lsrc			; adjust to get last character
	mov edi, dst
	xor eax, eax		; zero EAX
	dec esi
	jmp short rpst
; ----------------------------
  align 4
pre:
    add esi, ecx		; ecx = len of txt1, add it to ESI for next read
rpst:
	inc esi
	cmp lsrc, esi		; test for exit condition
	jle rpout
	mov al, [esi]		; load byte from source
	mov ah,al
	or ah,020h
	cmp ah, [ebx]		; test it against 1st character in txt1
	je test_match
	stosb				; write byte to destination (same as mov [edi],al - inc edi) 
	jmp short rpst
; ----------------------------
  align 4
test_match:
	mov edx, ebx		; load txt1 address into EDX
	xor ecx,ecx 		; clear ECX to use as index
@@:
	mov al, [edx]
	test al, al 		; if you have got to the zero
	jz change_text		; replace the text in the destination
;    cmp [esi+ecx], al		; keep testing character matches
	mov ah, [esi+ecx]
	or ah,020h			; convert to lower case
	inc edx
	inc ecx
	cmp ah,al
	je @B
	mov al, [esi]		; if text does not match
	stosb				; write byte at ESI to DSI (destination)
	jmp short rpst
; ----------------------------
  align 4
change_text:			; write txt2 to location of txt1 in destination
	mov edx, txt2
	dec ecx
@@:
	mov al, [edx]
	test al, al
	jz pre
	inc edx
	stosb
	jmp short @B
; ----------------------------
  align 4
rpout:				; write any last bytes and terminator
	xor ecx,ecx
@@:
	mov al, [esi+ecx]
	mov [edi+ecx], al
      inc ecx
	test al, al
	jnz @B
;	pop edi
;	pop esi
;	pop ebx
	ret
Replace endp


;------------------------------------------------------------------------------------------------
; WildMatch - Checks if one string exists within another string, supporting wildcards "?" and "*".
; Returns with ZF=off if match (JNZ MATCH)

  align 4

WildMatch proc near wild :DWORD, string :DWORD ;uses ebx ecx edx esi edi

    mov        ecx, wild
    mov        edx, string

    .while BYTE PTR [edx] != 0 && BYTE PTR [ecx] != "*"
	mov	   bl, [ecx]
	mov	   bh, [edx]
	.if bl != bh && bl != "?"
          xor        eax, eax ; no match = zero on
	    ret
	.endif
	inc	   ecx
	inc	   edx
    .endw

    .while BYTE PTR [edx] != 0
	mov	   bl, [ecx]
	mov	   bh, [edx]
	.if bl == "*"
	    inc        ecx
	    mov        bl, [ecx]
	    .if bl == 0
		;xor	   eax, eax
		;inc	   eax
		inc      ebx
		ret ; match, return with zero flag off!
	    .endif
	    mov        eax, edx
	    mov        esi, ecx
	    inc        eax
	.elseif bl == bh || bl == "?"
	    inc        ecx
	    inc        edx
	.else
	    mov        edx, eax
	    mov        ecx, esi
	    inc        eax
	.endif
    .endw
    
    .while    BYTE PTR [ecx] == "*"
	inc	   ecx
    .endw

 	sete byte ptr [ecx] ; Set Zero Flag to 1 if zero
    	ret

WildMatch endp


end start
