#include <stdio.h>
#include <pthread.h>
#include <string.h>

/*
 * decoder most probably means mpg123... I should code it modular enough that this can be changed easily
 * OO?
 * ...as with audio interface (alsa/oss)
 */

/*
 * What we want: 
 * 	n channels, each handled by a number of threads (?)
 * 	- starting of decoder itself
 * 	- reading audio data
 * 	- giving commands ( or should the main thread do this?)
 * 	- reading stderr of decoder (most important: look for "P 0" and indicate end wait state)
 * 	main thread to copy audio data from channel buffers to audio buffer / device, with volume, etc.
 * 	- does pitch belong here? maybe the channel thread should do this, since it is channel-specific. 
 * 		...as is equalizer (as long as it is done in decoder)
 * 	client/server threads - not looked into this yet
 * 	- a thread for every client, reading commands and setting variables or executing functions (?), controlling the other threads, ...?
 * 	- how is this done in old mixplayd?
 * 	thread for signals...?
 * 	
 * 	we'll see...
 * 
 */


/*
 * keep it modular... 
 * 	channel worker gets file to load... chooses decoder (either predefined or guess by filename?) and appropriate communication routines
 * 	So we have:
 * 		int (mp3|ogg|...)_decoder_start(channel* ch){ start decoder and put streams (stdin/out/err) in ch struct }
 * 		int (mp3|ogg|...)_listener(channel* ch){ thread: watch for messages on response stream and react when necessary (most important: get audio reading stopped when some ending message occured)}
 * 		int (mp3|ogg|...)_command(channel* ch, command)
 * 
 * 		... this looks too object oriented for not being coded that way. a bunch of routines operating on some common channel struct.
 * 		
 * 	What about this:
 * 			
 * 	class (MP3|OGG|...) { decoder start, listener, command, ... }
 * 	and channel_worker deciding between the ch object being of class (MP3|OGG|...) ?
 * 				
 * 	Of course I'll just implement the class MP3 using mpg123 now but the interface should be general enough to add ogg later
 */
			
/* class MP3
{
	void* new(channel* ch)
	{
		return self;
	}		
}		
 */		
								
#define BUFFER_SIZE 1024	

/* types */

typedef struct
{
	pthread_t worker;
	int retval;
	int volatile id;
	int volatile active;
	pthread_mutex_t lock; /* Lock for channel data... is one enough? */
	char volatile buffer[BUFFER_SIZE];
	pthread_mutex_t cond_lock; /* condition lock for channel worker  */
	int volatile updated;
	pthread_cond_t cond; /* the work condition: one trigger: do something (normally fill the buffer once) */
	char* teststr;
} channel;

/* prototypes */

void* channel_worker(void* cha);
int channel_init(channel* ch, int id);


/* variables */

channel ch[2];

/* main */

int main(int argc, char** argv)
{
	channel_init(&ch[0],0);
	channel_init(&ch[1],1);
	printf("Test: %s\n", ch[0].teststr);
	int i;
	for(i = 0; i < 5; ++i)
	{
		printf("signalling action to 0\n");
		pthread_mutex_lock(&ch[0].cond_lock);
		pthread_mutex_lock(&ch[0].lock);
		ch[0].updated = 0;
		pthread_mutex_unlock(&ch[0].lock);
		pthread_cond_signal(&ch[0].cond);
		pthread_mutex_unlock(&ch[0].cond_lock);

		printf("signalling action to 1\n");
		pthread_mutex_lock(&ch[1].cond_lock);
		pthread_mutex_lock(&ch[1].lock);
		ch[1].updated = 0;
		pthread_mutex_unlock(&ch[1].lock);
		pthread_cond_signal(&ch[1].cond);
		pthread_mutex_unlock(&ch[1].cond_lock);

		pthread_mutex_lock(&ch[0].lock);
		while(ch[0].updated == 0)
		{
			/* I was to quick with re-locking...? */
			printf("giving the thread more time...\n");
			pthread_mutex_unlock(&ch[0].lock);
			sleep(1);
			pthread_mutex_lock(&ch[0].lock);
		}
		printf("buffer 0 updated\n");
		pthread_mutex_unlock(&ch[0].lock);

		pthread_mutex_lock(&ch[1].lock);
		while(ch[1].updated == 0)
		{
			/* I was to quick with re-locking...? */
			printf("giving the thread more time...\n");
			pthread_mutex_unlock(&ch[1].lock);
			sleep(1);
			pthread_mutex_lock(&ch[1].lock);
		}
		printf("buffer 1 updated\n");
		pthread_mutex_unlock(&ch[1].lock);

	}


	pthread_mutex_lock(&ch[0].lock);
	ch[0].active = -1;
	pthread_mutex_unlock(&ch[0].lock);

	pthread_mutex_lock(&ch[0].cond_lock);
	pthread_cond_signal(&ch[0].cond);
	pthread_mutex_unlock(&ch[0].cond_lock);

	pthread_mutex_lock(&ch[1].lock);
	ch[1].active = -1;
	pthread_mutex_unlock(&ch[1].lock);

	pthread_mutex_lock(&ch[1].cond_lock);
	pthread_cond_signal(&ch[1].cond);
	pthread_mutex_unlock(&ch[1].cond_lock);
	
	pthread_join(ch[0].worker, NULL);
	printf("channel 0 worker exited with %d\n", ch[0].retval);
	pthread_join(ch[1].worker, NULL);
	printf("channel 1 worker exited with %d\n", ch[1].retval);
	exit(0);
}


/* functions */


/* initialize channel data and start worker thread */
int channel_init(channel* ch, int id)
{
	ch->id = id;
	ch->active=0;
//	strcpy(ch->buffer,"");
//	pthread_mutex_init(&ch->buffer_lock, NULL);
//	pthread_mutex_init(&ch->cond_lock, NULL);
//	pthread_cond_init(&ch->cond, NULL);
	ch->teststr = (char*) malloc(sizeof(*ch->teststr));
	pthread_create(&ch->worker, NULL, channel_worker, ch);
	return(0);
}

/* the channel worker */
void* channel_worker(void* cha)
{
	channel* ch = (channel*) cha;
	printf("channel %d starting\n", ch->id);

	/* wait for being told to do sth */
	pthread_mutex_lock(&ch->cond_lock);
	while(1)
	{
		pthread_cond_wait(&ch->cond,&ch->cond_lock);
		pthread_mutex_lock(&ch->lock);
		if(ch->active == -1)
		{
			pthread_mutex_unlock(&ch->lock);
			break; 
		}
		printf("channel %d: doing sth.\n", ch->id);
		sleep(1);
		ch->updated = 1;
		pthread_mutex_unlock(&ch->lock);
	}

	/* inside or outside loop ??? */
	pthread_mutex_unlock(&ch->cond_lock);
	
	printf("channel %d exiting\n", ch->id);
	pthread_exit(&ch->retval);
}

