/*
TODO:  the inchannel's targets dilemma
	after that, I may well come to real action:
	-code the server + command syntax & parsing
	-never forget gapless...
	-test the framework
	-make real input and output devices
*/

/*
The second approach: input threading - if needed - in input classes, serialized gathering of the inputs, parallel output with threads here...
Does this splitting make sense?
...
'd be cool to just have the input objects informed when I need new buffers, signal me when ready, read input buffers, mix, write to output buffers, inform the output objects that new stuff is there, gather, mix: _now_ wait for the output object and put new stuff in its buffer.

So, lets switch to the 2.5th approach, then.
*/
 
#include "common.h"
#include <algorithm>

#include "output.h"
#include "out_dummy.h"

#include "input.h"
#include "in_dummy.h"


/*
Theory of common stuff: 

ADD generic input/output channels
LOAD file/stream/... on input/output -> choosing correct  input/output device
PAUSE temporarily exclude from any input/output actions
PLAY include in input/output actions
STOP exclude from actions and seek to start / close output, but stay ready to reopen

REMOVE the generic channel, closing any active device
*/

//actions
//common:
#define REMOVE 0
#define ADD 1
#define PAUSE 2
#define PLAY 3 
#define LOAD 5 
#define STOP 6 

//only input:
#define SEEK 20 //absolute seek
#define RSEEK 21 //relative seek
#define BIND 22 //bind <input> <output>
#define UNBIND 23 //unbind <input> <output>
#define VOLUME 24
#define BASS 25
#define MID 26
#define TREBLE 27
#define SPEED 28


class action
{
	public:	
	unsigned char id;
	vector<char*> strings;
	vector<int> ints; //enough?
	vector<float> floats;
	action(unsigned char i){ id = i; };
	~action(){ strings.clear(); ints.clear(); floats.clear(); };
};

//status.
#define PLAYING 1
#define PAUSED 2
#define DEAD 0
#define NODEV 3 

class outchannel
{
	public:
	signed char volatile status;
	output_device* volatile device;
	output_data data;
	
	inchannel()
	{
		status = NODEV; 
		data.format.rate = AUDIO_RATE;
		data.format.bytes = AUDIO_BYTES;
		data.format.channely = AUDIO_CHANNELS;
	};
	
	~inchannel(){ if( device != NULL ) delete device; }
}

class inchannel
{
	public:
	signed char volatile status;
	input_device* volatile device;
	input_data data;

	vector<outchannel*> volatile targets; //pointers to output objects... just make sure that on deletion of those the pointers here are deleted first

	inchannel()
	{
		speed = 1; volume = 1; status = NODEV; 
		data.format.rate = AUDIO_RATE;
		data.format.bytes = AUDIO_BYTES;
		data.format.channely = AUDIO_CHANNELS;
	};

	~inchannel(){ if( device != NULL ) delete device; delete targets; }
};


vector<inchannel*> inners;
vector<outchannel*> outers;

vector<action*> inactions;
vector<action*> outactions;


format.rate = 44100;
format.bytes = 2;
format.channels = 2;

int main(int argc, char** argv)
{
	bool active = true;
	unsigned int i,j;

	unsigned int active_inputs = 0;
	unsigned int active_outputs = 0;

	
	vector<action*>::iterator k,l;

	vector<unsigned int> delinquents;
	// parse commands/defaults -> input_actions,output_actions 
	
	//addition of two input channels
	
	inactions.push_back(new action(ADD));
	inactions.push_back(new action(ADD));

	//bind to nonexistent output? maybe the reference as target is still not the best idea.
	//dammed; I'll have to come up with a real solution, may it be hashes when there is no other way
	inactions.push_back(new action(BIND));
	inactions[0]->ints.push_back(0); //bind channel 0...
	inactions[0]->ints.push_back(0); //...to output 0
		
	inactions.push_back(new action(BIND));
	inactions[1]->ints.push_back(1); //bind channel 1...
	inactions[1]->ints.push_back(0); //...to output 0
	
	outactions.push_back(new action(ADD));
		
	//addition
	
	//operation
	while(active)
	{
		//---parallelism: output of previous chunk active
		
		//stage1a: input admin for upcoming audio chunk; think over simplyfying this with both mixing and input & output actions in one, threadless place... 
		pthread_mutex_lock(&inlock);
		if(inactions.size() >= 1)
		{
				cout << "executing input actions\n";
				for(k = inactions.begin(); k != inactions.end(); ++k)
				{
					inchannel* in = inners.(inners.begin() + (*k)->ints.front());
					switch( (*k)->id )
					{
						case ADD:
							inners.push_back(new inchannel);
						break;
						case REMOVE:
							delinquents.push_back((*k)->ints.front())
						break;
						case VOLUME:
							in->volume = (*k)->floats-front();
						break;
						case SPEED:
							in->speed = (*k)->floats-front();
						break;
						case SPEED:
							in->speed = (*k)->floats-front();
						break;
					}	
				}
				
				//now we can delete; reordering doesn't hurt anymore
				delete_inners(delinquents);
								
				//be clean
				inactions.clear();
				delinquents.clear();
				
		}
		pthread_mutex_unlock(&inlock);
		
		//stage2a: beginning to fetch input data for upcoming chunk
		active_inputs = 0;
		for(k = inputs.begin(); k < inputs.end(); ++k)
		{
			//play(number) means start reading of <number> samples into inbuffer, this is sizeof(audio_type)*in.format.channels bytes!!!
			if((*k)->status == PLAYING)
			{
				(*k)->device->play((unsigned int) (*k)->speed*BUFFER_SAMPLES/format.rate*(*k)->data.format.rate);
				++active_inputs;
			}
		}
	
		//---parallelism: now both old output and new data fetch active
		
		//stage4b: wait for output of _previous_ chunk to finish
		for(i = 0; i < active_outputs; ++i){ sem_wait(&outputsem); } 		
		
		//---parallelism: only new data fetching
		
		//stage1b: output admin for upcoming audio chunk
		pthread_mutex_lock(&outlock);
		if(outactions.size() >= 1)
		{
				cout << "executing output actions\n";

				for(k = outactions.begin(); k != outactions.end(); ++k)
				{
					outchannel* out = outers.(outers.begin() + (*k)->ints.front());
					switch( (*k)->id )
					{
						case ADD:
							outers.push_back(new inchannel);
						break;
						case REMOVE:
							delinquents.push_back((*k)->ints.front())
							(*k)->status = DEAD; //first declare dead, the delete? -> the inchannel's targets dilemma
						break;
					}	
				}
				outactions.clear();
		}
		pthread_mutex_unlock(&outlock);
		

		//stage2b: wait for input data of upcoming chunk
		for(i = 0; i < active_inputs; ++i){ sem_wait(&inputsem); } 		
		//stage3: mixing
		
		
		//stage4a: activate output
		active_outputs = 0;
		for(i = 0; i < outputs.size(); ++i)
		{
			if(outputs[i].status == PLAYING)
			{
				outputs[i].play(outputsem);
				++active_outputs;
			}
		} 		
	}

	//do I really want this?
	for(i = 0; i < active_inputs; ++i){ sem_wait(&inputsem); } 		
	for(i = 0; i < active_outputs; ++i){ sem_wait(&outputsem); } 		

	//does this really destruct all objects properly or just delete the pointers?
	//on the other hand: whe I erase output pointers out of the channel's targets, do the objects get destroyed?!!
	//is the compiler so smart to delete object when initial pointer gets deleted and not if any later one gets the bumm?
	inners.clear();
	outers.clear();

	//server should be quitting by itself because of command... or what about SIGQUIT...?
	//but lets politely wait for server threads to finish

	cout << "finished normally" << endl;
	return 0;
}




/* vector functions:
sizesize_type size() const;
Returns the number of items (elements) currently stored in the vector. The size_type type is an unsigned integral value.empty

bool empty() const;
Returns a true value if the number of elements is zero, false otherwise.

void push_back(const T& x);

Adds the element x at the end of the vector. (T is the data type of the vector's elements.)
		
iterator begin();
Returns an iterator (a special kind of object) that references the beginning of the vector. Although the iterator can be used for many things, for now we will just consider its use with erase and sort.

iterator end();
Returns an iterator (a special kind of object) that references a position past the end of the vector. Like begin(), we will just consider its use with erase and sort.
		
void erase(iterator first, iterator last);
a.erase(a.begin(),a.end()); // Remove all elements. 

a.clear(); // Remove all elements. 
*/


//very, very narrow-minded.... 

int delete_inners( vector<unsigned int> & indicator)
{
	vector<unsigned int>::iterator i,j;
	sort( indicator.begin(), indicator.end() );
	reverse( indicator.begin(), indicator.end() );
	j = unique( indicator.begin(), indicator.end() );
	for(i = indicator.begin(); i < j; ++i)
	{
		//cout << "erasing element " << *i << "(value: " << inners[*i] << ")" << endl;
		inners.erase(inners.begin() + *i);	
	}
	return 0;
}

int delete_outers( vector<unsigned int> & indicator)
{
	vector<unsigned int>::iterator i,j;
	sort( indicator.begin(), indicator.end() );
	reverse( indicator.begin(), indicator.end() );
	j = unique( indicator.begin(), indicator.end() );
	for(i = indicator.begin(); i < j; ++i)
	{
		//cout << "erasing element " << *i << "(value: " << outers[*i] << ")" << endl;
		outers.erase(outers.begin() + *i);	
	}
	return 0;
}
