#include "common.h"

#include "output.h"
#include "out_dummy.h"

#include "input.h"
#include "in_dummy.h"
#include "in_mpg123"

/* the work to do for channel_worker */

#define NOTHING -1
#define FEED 0
#define NEW_FILE 1
#define SEEK 2
#define STOP 3



/*
	channel.status:
	0: not there (worker/decoder) 
	1: there, but nothing loaded
	2: ready to deliver data - file loaded
*/

/*
	channel.active: 
	-1: not at all: signal to terminate worker
	 0: dwell in inactivity (paused)
	 1: action
*/

#define END -1
#define NO 0
#define YUPP 1

typedef struct channel
{
	pthread_t worker;
	int retval;
	unsigned char volatile id;
	signed char volatile active;
	unsigned char volatile status;
	signed char volatile task;
			
	sem_t sem; //semaphore for normal sync
	pthread_mutex_t talklock; /* Lock for ensuring conversation with worker is not threesome */

	input_device* volatile decoder;
	channel_data data;
};

/* struct for channel worker */

typedef struct output
{
	phthread_t worker;
	unsigned char volatile id;
	signed char volatile active;
	unsigned char volatile status;
	signed char volatile task;
	sem_t sem; //semaphore for normal sync
	pthread_mutex_t talklock; /* Lock for ensuring conversation with worker is not threesome */
	
	output_data data;
	vector<int*> buffers;
				
}
	

								
/* prototypes */

void* channel_worker(void* cha);
int channel_init(channel& ch, unsigned int& id);

//unsigned char filetype(char* filename);

/* variables */

unsigned int ch_n = 2;
channel ch[2];
sem_t ch_sem;
output_device* dev[1];

/* main */

int main(int argc, char** argv)
{
	/* parse command line args... */
	
	/* create initial stuff */
	
	dev[0] = new dummy_output();
	
	sem_init(&ch_sem, 0, 0);
	unsigned int i;

	for(i = 0; i < ch_n; ++i)
	{
		channel_init(ch[i],i);
		sem_wait(&ch_sem);
		cout << "thread [" << i << "] ready\n";
	}	
	
	for(i = 0; i < 100; ++i)
	{

		unsigned int u;

		for(u = 0; u < ch_n; ++u)
		{
			printf("signalling action to %i\n", u);
			sem_post(&ch[u].sem);
		}	
		
		for(u = 0; u < ch_n; ++u)
		{
			sem_wait(&ch_sem);
			printf("thread [%i] done\n", u);
		}

	}

	for(i = 0; i < ch_n; ++i)
	{

		pthread_mutex_lock(&ch[i].data.lock);
		ch[i].active = -1;
		pthread_mutex_unlock(&ch[i].data.lock);	

		sem_post(&ch[i].sem);
		
		pthread_join(ch[i].worker, NULL);
		cout << "channel " << i << " worker exited with " << ch[i].retval << endl;
		
	}

	return(0);
}


/* functions */


/* initialize channel data and start worker thread */
int channel_init(channel& ch,unsigned int& id)
{
	ch.id = id;
	ch.active = NO;
	ch.task = NOTHING;
	
	sem_init(&ch.sem, 0, 0);
	pthread_mutex_init(&ch.talklock, NULL);
	pthread_mutex_init(&ch.data.lock, NULL);

	ch.data.speed = 1;
	ch.data.volume = 100;
	ch.data.bass = 1;
	ch.data.mid = 1;
	ch.data.treble = 1;

	ch.data.buffer_fill = 0;
	
//	strcpy(ch->buffer,"");
//	pthread_cond_init(&ch->cond, NULL);
//	ch.teststr = (char*) malloc(sizeof(*ch.teststr));
	pthread_create(&ch.worker, NULL, channel_worker, &ch);
	return(0);
}

/* the channel worker */
void* channel_worker(void* cha)
{
	channel* ch = (channel*) cha;
	cout << "channel " << ch->id << "starting\n";
	/* wait for being told to do sth */
	sem_post(&ch_sem);
	while(1)
	{
		printf("wait...\n");
		sem_wait(&ch->sem);
		printf("lock...\n");
		pthread_mutex_lock(&ch->data.lock);
		if(ch->active == -1)
		{
			//printf("quitting...\n");
			pthread_mutex_unlock(&ch->data.lock);
			break; 
		}
		if(ch->active == 1)
		{
		switch(ch->task)
		{
			case FEED:
				ch->decoder->fill_buffer();
				break;
			case SEEK:
				ch->decoder->seek();
				break;
			case NEW_FILE:
				{
					unsigned char newtype = filetype(ch->data.filename);
					if(ch->decoder->type != newtype)
					{
						if(ch->deoder != NULL){ delete(ch->decoder); }
						switch(newtype)
						{
							case MP3:
								ch->decoder = new mpg123(&ch->data);
								break;
							case DUMMY:
								ch->decoder = new decoder(&ch->data);
								break;
							default:
								cout << "Unknown file type! Bad stuff can/will happen...\n";
						}
					}
					ch->decoder->load();
				}
				break;
			case STOP:
				ch->decoder->seek(0);
				break;
		}
		ch->task = FEED;
		//printf("channel %d: doing sth.\n", ch->id);
		usleep(10000);
		//printf("done...\n");
		}
		sem_post(&ch_sem);
		//printf("unlock...\n");
		pthread_mutex_unlock(&ch->data.lock);
	}

	/* inside or outside loop ??? */
	
	cout << "channel " << ch->id << " exiting\n";
	pthread_exit(&ch->retval);
}


/* output worker */
void* output_worker(void* od)
{
	output* out = (output*) od;
}

/* utilities */

/* dummy... */
/*unsigned char filetype(char* filename)
{
	return DUMMY;
}
*/

