#include <stdio.h>
#include <pthread.h>
#include <semaphore.h>
#include <string.h>

/*
 * decoder most probably means mpg123... I should code it modular enough that this can be changed easily
 * OO?
 * ...as with audio interface (alsa/oss)
 */

/*
 * What we want: 
 * 	n channels, each handled by a number of threads (?)
 * 	- starting of decoder itself
 * 	- reading audio data
 * 	- giving commands ( or should the main thread do this?)
 * 	- reading stderr of decoder (most important: look for "P 0" and indicate end wait state)
 * 	main thread to copy audio data from channel buffers to audio buffer / device, with volume, etc.
 * 	- does pitch belong here? maybe the channel thread should do this, since it is channel-specific. 
 * 		...as is equalizer (as long as it is done in decoder)
 * 	client/server threads - not looked into this yet
 * 	- a thread for every client, reading commands and setting variables or executing functions (?), controlling the other threads, ...?
 * 	- how is this done in old mixplayd?
 * 	thread for signals...?
 * 	
 * 	we'll see...
 * 
 */


/*
 * keep it modular... 
 * 	channel worker gets file to load... chooses decoder (either predefined or guess by filename?) and appropriate communication routines
 * 	So we have:
 * 		int (mp3|ogg|...)_decoder_start(channel* ch){ start decoder and put streams (stdin/out/err) in ch struct }
 * 		int (mp3|ogg|...)_listener(channel* ch){ thread: watch for messages on response stream and react when necessary (most important: get audio reading stopped when some ending message occured)}
 * 		int (mp3|ogg|...)_command(channel* ch, command)
 * 
 * 		... this looks too object oriented for not being coded that way. a bunch of routines operating on some common channel struct.
 * 		
 * 	What about this:
 * 			
 * 	class (MP3|OGG|...) { decoder start, listener, command, ... }
 * 	and channel_worker deciding between the ch object being of class (MP3|OGG|...) ?
 * 				
 * 	Of course I'll just implement the class MP3 using mpg123 now but the interface should be general enough to add ogg later
 */
			
/* class MP3
{
	void* new(channel* ch)
	{
		return self;
	}		
}		

	I can OO, but not C++... namely libstdc++ vs. glibc, the includes here are not enough for g++ ?
			stick to what I can.

			
	With function pointers I get the same benefit... 
			
			
	So: I have still to learn:
			- function pointers or C++
			- how to correclty spwan a process from a thread
			
			
 */		
								
#define BUFFER_SIZE 1024	

/* types */

typedef struct
{
	pthread_t worker;
	int retval;
	int volatile id;
	int volatile active;
	pthread_mutex_t lock; /* Lock for channel data... is one enough? */
	char volatile buffer[BUFFER_SIZE];
	//pthread_mutex_t cond_lock; /* condition lock for channel worker  */
	//pthread_cond_t cond; /* the work condition: one trigger: do something (normally fill the buffer once) */
	sem_t sem;
	char* teststr;
	unsigned int decoder_pid;
	char* filename;
	FILE* data;
	FILE* status;
	FILE* control;
} channel;

/* prototypes */

void* channel_worker(void* cha);
int channel_init(channel* ch, int id);


/* variables */

unsigned int ch_n = 2;
channel ch[2];
sem_t ch_sem;

/* main */

int main(int argc, char** argv)
{

	sem_init(&ch_sem, 0, 0);
	int i;

	for(i = 0; i < ch_n; ++i)
	{
		channel_init(&ch[i],i);
		sem_wait(&ch_sem);
		printf("thread [%i] ready\n", i);
	}	
	
	for(i = 0; i < 100; ++i)
	{

		int u;

		for(u = 0; u < ch_n; ++u)
		{
			//printf("signalling action to %i\n", u);
			sem_post(&ch[u].sem);
		}	
		
		for(u = 0; u < ch_n; ++u)
		{
			sem_wait(&ch_sem);
			//printf("thread [%i] done\n", u);
		}

	}

	for(i = 0; i < ch_n; ++i)
	{

		pthread_mutex_lock(&ch[i].lock);
		ch[i].active = -1;
		pthread_mutex_unlock(&ch[i].lock);	

		sem_post(&ch[i].sem);
		
		pthread_join(ch[i].worker, NULL);
		printf("channel %i worker exited with %i\n", i, ch[i].retval);
		
	}

	return(0);
}


/* functions */


/* initialize channel data and start worker thread */
int channel_init(channel* ch, int id)
{
	ch->id = id;
	ch->active=0;
	sem_init(&ch->sem, 0, 0);
//	strcpy(ch->buffer,"");
//	pthread_mutex_init(&ch->buffer_lock, NULL);
//	pthread_mutex_init(&ch->cond_lock, NULL);
//	pthread_cond_init(&ch->cond, NULL);
	ch->teststr = (char*) malloc(sizeof(*ch->teststr));
	pthread_create(&ch->worker, NULL, channel_worker, ch);
	return(0);
}

/* the channel worker */
void* channel_worker(void* cha)
{
	channel* ch = (channel*) cha;
	printf("channel %d starting\n", ch->id);
	/* wait for being told to do sth */
	sem_post(&ch_sem);
	while(1)
	{
		//printf("wait...\n");
		sem_wait(&ch->sem);
		//printf("lock...\n");
		pthread_mutex_lock(&ch->lock);
		if(ch->active == -1)
		{
			//printf("quitting...\n");
			pthread_mutex_unlock(&ch->lock);
			break; 
		}
		//printf("channel %d: doing sth.\n", ch->id);
		usleep(10000);
		//printf("done...\n");
		sem_post(&ch_sem);
		//printf("unlock...\n");
		pthread_mutex_unlock(&ch->lock);
	}

	/* inside or outside loop ??? */
	
	printf("channel %d exiting\n", ch->id);
	pthread_exit(&ch->retval);
}

// 
// void spawn_stream(channel* ch) 
// {
// 	int strm[2],i;
// 	int dec_stdin[2], dec_err[2];
// 	int pid;
// 	int ret;
// 	fprintf(stderr,"spawn_stream (running pid %d)\n",ch->decoder_pid);	
// 	if (!ch->decoder_pid)
// 	{
// 		/* re-use decoder if possible */ 
// 		/* create pipes */
// 		pipe(strm);
// 		pipe(dec_stdin); 
// 		pipe(dec_err); 
// 
// 		/* one could check if fork failed */
// 		
// 		pid=fork();
// 		if (pid == 0)
// 		{
// 
// 			/* duplicate for getting connected */
// 			dup2(dec_stdin[0], STDIN_FILENO);
// 			dup2(strm[1],STDOUT_FILENO);
// 			dup2(dec_err[1], STDERR_FILENO);
// 
// 			/* being fresh and ready */
// 			close(dec_err[0]);
// 			close(dec_err[1]);
// 			close(dec_stdin[0]);
// 			close(dec_stdin[1]);
// 			close(strm[0]);
// 			close(strm[1]);
// 
// 			/* close audio too */
// 			for (i=0;i<conf.num_snddevs;i++)
// 			{
// 				if (audio_fd[i] >= 0) close(audio_fd[i]);
// 			}
// 
// 			
// 			//execlp(DECODER,DECODER,"-q","-s","-R","--remote-err","-",NULL);
// 			execlp("/home/thomas-data/mp3/progs/ext/mpg123","/home/thomas-data/mp3/progs/ext/mpg123","-q","-s","-R","--remote-err","-",NULL);
// 			writelog("Start of decoder failed... You should stop me and check your setup.\n");
// 			fprintf(stderr,"Start of decoder failed... You should stop me and check your setup.\n");
// 			exit(-1);
// 		}
// 		else
// 		{
// 			
// 	
// 			ch->decoder_pid=pid;
// 			
// 			/* Why? What?*/
// 			/* fcntl(dec_err[0], F_SETFL, O_NONBLOCK); */
// 
// 			close(dec_stdin[0]);
// 			close(strm[1]);
// 			close(dec_err[1]);
// 			
// 			ch->data=fdopen(strm[0],"rb"); /* the sound */
// 			ch->status=fdopen(dec_err[0],"a"); /* the responses or errors */
// 			ch->control=fdopen(dec_stdin[1],"a"); /* here we can dump orders */
// 			setlinebuf(ch->control);
// 			setlinebuf(ch->status);
// 
// 		}
// 	}
// 	
// 	//reset_eq(ch);
// 	//fprintf(ch->control, "SLJ %s %s\n",0,ch->filename);
// 	fprintf(stderr,"spawned stream (running pid %d)\n",ch->decoder_pid);	
// 	
// }
// 
// 		
// 		
