/*
 * netcomm.h for new mixplayd by Thomas Orgis
 * message reading and writing is changed, the rest is basically the same with C++ classes around it
 *
 * derived from:
 *
 * netcomm.h for mixplayd
 *
 * (c) Siegfried Wagner 01/06/27
 *
 * license: GNU General Public License (GPL)
 *          For details see the file COPYING included with this archive
 *
 * last update: 01/08/26 by Siegfried Wagner
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>

//beware of cancellation points... does capsulation of reading prevent this?

#define MAX_MSG_LENGTH 10000
#define MSG_BUF_SIZE 1024

class socket_buffer
{
	private:
	int sock;
	char buf[MSG_BUF_SIZE];
	int pos;
	int fill;
	
	public:
	socket_buffer(int s)
	{
		sock = s;
		buf[MSG_BUF_SIZE-1] = '\0';
		pos = 0;
		fill = 0;
	};
	~socket_buffer(){ close(sock); };
	int read_line(string& msg); //doesn't include the "\n"!
	int write(string& msg); //doesn't automatically append "\n"
};

class port_listener
{
	private:
	int sock;
	int bind_tcp(int port_number, int local);
	
	public:
	bool online;
	port_listener(int port_number, int local);
	~port_listener();
	int accept_connection();
};
