/*
 * netcomm.cpp for the new mixplayd by Thomas Orgis
 *
 * derived from:
 *
 * netcomm.c for mixplayd
 *
 * provides functions for communiction on a tcp socket
 * (c) Siegfried Wagner 01/06/27
 *
 * license: GNU General Public License (GPL)
 *          For details see the file COPYING included with this archive
 *
 * last update: 01/08/28 by Siegfried Wagner
 */

#include "common.h"
#include "netcomm.h"

//get main listening socket for conneting

port_listener::port_listener(int port_number, int local)
{
	sock = bind_tcp(port_number, local);
	online = (sock < 0) ? false : true;
}

port_listener::~port_listener()
{
	if(online) close(sock);
}

int port_listener::bind_tcp(int port_number, int local)
{
  int sock;
  struct sockaddr_in svr;
	int flag=1;

  svr.sin_family = AF_INET;
  svr.sin_port = htons(port_number);
  if (local)
		svr.sin_addr.s_addr = inet_addr("127.0.0.1");
	else svr.sin_addr.s_addr = INADDR_ANY;

/*
  struct hostent *hent;
	hent = gethostbyname ("localhost");
	memcpy (&srv.sin_addr, hent->h_addr_list[0], hent->h_length);
*/

  if ( (sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror ("error creating listening socket");
    return -1;
  }

	if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(flag)) < 0) {
		perror ("error setting SO_REUSEADDR on listening socket");
		return -1;
	}

  if (bind(sock, (struct sockaddr *) &svr, sizeof(svr)) < 0) {
		fprintf (stderr, "bind: failed to bind to port %d: %s.\n\n",
				port_number, strerror (errno));
		if (port_number < 1024 && getuid ()) {
			fprintf (stderr, "A likely reason is that you tried to bind "
					"low-numbered ports but you are not root!\n");
		}
		close (sock);
    return -1;
  }

	if (listen (sock, SOMAXCONN) < 0) {
		fprintf (stderr, "error listening: %s\n", strerror (errno));
		close (sock);
		return -1;
	}
	
	//I want blocking
	//fcntl(sock, F_SETFL, O_NONBLOCK);

  return sock;
}

//wait for and accept connection requests (delivering new socket for communication)

int port_listener::accept_connection()
{
	struct sockaddr_in cli;
	socklen_t clilen;
	int clisock;

	clilen = (socklen_t) sizeof(cli);
	clisock = accept(sock, (struct sockaddr *)&cli, &clilen);

	//I want blocking...
	//fcntl(clisock, F_SETFL, O_NONBLOCK);

	return clisock;
}

//simple reader object

	
//only looking for \n, not \r

/*
algo:

when still sth. in buffer (indicated by buffed == true, beginning at pos)
begin search for next \n
if found before end: make \0, add to msg, update the pos, 

this may go on in a loop if the line to read is really long... 

*/


int socket_buffer::read_line(string& msg)
{
	int msglen = 0;
	int i;
	
	while(1)
	{
		cout << "fill: " << fill << endl;
		if(fill)
		{
			//search for next line end
			for(i=pos;i<fill;++i)
			{
				if(buf[i] == '\n'){ buf[i] = '\0'; break; }
				if(buf[i] == '\r'){ buf[i] = '\0'; }
			}
			cout << "i: " << i << endl;
			if( (msglen += i - pos) > MAX_MSG_LENGTH )
			{
				cout << "msglen of " << msglen << " is greater than " << MAX_MSG_LENGTH << endl;
				fill = 0;
				pos = 0;
				return -2; //interpet this!
			}
			//copy line starting at pos and ending at i
			msg += (buf + pos);
			if(i < fill) //really found a \n
			{
				//the line was the buffer: i is last character
				if(i == fill-1)
				{
					fill = 0;
					pos = 0;
				}
				//there is sth. left: i is smaller
				else
				{
					pos = i + 1;
				}
				return msglen;
			}
			//not at end: reading sth. next time...
			else{ fill = 0; pos = 0; } //pos=0 here or a few lines below?
		}
		else
		{
			pos = 0;
			fill = recv(sock, buf, MSG_BUF_SIZE-1, 0);
			cout << "received: ]" << buf << "[\n";
			if(fill < 1)
			{
				if(fill < 0){ fill=0; return -1; }
				//handle this!!
				return 0; //hm... read nothing... maybe having read sth. before
			}
		}
	}	
}

int socket_buffer::write(string& msg)
{
	if (sock<0) return -1;
//	if (debug)
//		fprintf(stderr, "debug: %d byte(s) sent.\n", sent);
	return send(sock, msg.c_str() , msg.length() , MSG_NOSIGNAL);
}

