/*
 * netcomm.c for mixplayd
 *
 * provides functions for communiction on a tcp socket
 * (c) Siegfried Wagner 01/06/27
 *
 * license: GNU General Public License (GPL)
 *          For details see the file COPYING included with this archive
 *
 * last update: 01/08/28 by Siegfried Wagner
 */

#include "netcomm.h"

int bind_tcp(int port_number, int local) {
  int sock;
  struct sockaddr_in svr;
	int flag=1;

  svr.sin_family = AF_INET;
  svr.sin_port = htons(port_number);
  if (local)
		svr.sin_addr.s_addr = inet_addr("127.0.0.1");
	else svr.sin_addr.s_addr = INADDR_ANY;

/*
  struct hostent *hent;
	hent = gethostbyname ("localhost");
	memcpy (&srv.sin_addr, hent->h_addr_list[0], hent->h_length);
*/

  if ( (sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror ("error creating listening socket");
    return -1;
  }

	if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(flag)) < 0) {
		perror ("error setting SO_REUSEADDR on listening socket");
		return -1;
	}

  if (bind(sock, (struct sockaddr *) &svr, sizeof(svr)) < 0) {
		fprintf (stderr, "bind: failed to bind to port %d: %s.\n\n",
				port_number, strerror (errno));
		if (port_number < 1024 && getuid ()) {
			fprintf (stderr, "A likely reason is that you tried to bind "
					"low-numbered ports but you are not root!\n");
		}
		close (sock);
    return -1;
  }

	if (listen (sock, SOMAXCONN) < 0) {
		fprintf (stderr, "error listening: %s\n", strerror (errno));
		close (sock);
		return -1;
	}
	
	fcntl(sock, F_SETFL, O_NONBLOCK);

  return sock;
}

int accept_conn(int sock) {
	struct sockaddr_in cli;
	int clilen;
	int clisock;

	clilen = sizeof(cli);
	clisock = accept(sock, (struct sockaddr *)&cli, &clilen);

	fcntl(clisock, F_SETFL, O_NONBLOCK);

	return clisock;
}

int get_msg(int clisock, char *msg) {
	int msglen;
	char static *waiting_msgs[MAXBUF/2];
	int static msgs_waiting = 0;
	char *msg_part;

	if (msgs_waiting == 0) {
		msglen = recv(clisock, msg, MAXBUF, 0);
		if (msglen>0) {
			if (debug)
				fprintf(stderr, "debug: %d byte(s) received.\n", msglen);
			if ((msglen > 1)&&(msg[msglen-2] == 13)) { /* strip off CR+LF */
				msg[msglen-2] = '\0';
				msglen -= 2;
			} else { /* strip off LF */
				msg[msglen-1] = '\0';
				msglen--;
			}
			msg_part = strtok(msg, "\n");
			while (msg_part != NULL) { /* split the message by \n */
				waiting_msgs[msgs_waiting] = strdup(msg_part);
				msgs_waiting++;
				msg_part = strtok(NULL, "\n");
			}
		}
	}
	if (msgs_waiting > 0) {
		if (debug)
			fprintf(stderr, "debug: %d msgs_waiting.\n", msgs_waiting);
		msgs_waiting--;
		strcpy(msg, waiting_msgs[msgs_waiting]);
		free(waiting_msgs[msgs_waiting]);
		msglen = strlen(msg);

		if (msglen > 0) {
			if (verbose)
				printf("RECV: %s\n", msg);
			return msglen;
		} else return -1;
	} else return -1;
}

int send_msg(int clisock, char *msg) {
	int sent;
	if (clisock<0) return -1;
	sent = send(clisock, msg, strlen(msg), MSG_NOSIGNAL);
	if (debug)
		fprintf(stderr, "debug: %d byte(s) sent.\n", sent);
	return sent;
}
