/* decoder file types in the according header*/

/* types */

typedef struct input_data
{
	float volatile bass,mid,treble; //as linear (?) factors, look at mpg123's eq
	char* volatile filename;
	float volatile speed;
	float volatile volume;
	unsigned long int volatile position; //internal samples
	unsigned long int volatile length; 	//internal samples
	audio_format volatile format;
};


class input_device
{
	protected:
		input_data* chdata;
	public:
		audio_type* volatile buffer; //the buffer to store mixer frames in
		unsigned int volatile buffer_fill; //frames really in buffer 
		static const unsigned char type = 0;
		//		decoder(channel* chan) = 0;
		virtual int load() = 0; //load the file stated in chdata
		virtual	unsigned long int seek(unsigned long int sample) = 0; //seek to sample, return actual position (as in mp3 you can only seek in frames (?)  
		virtual	int play(unsigned int n_samples, sem_t& semph) = 0; //fill buffer with mixer data format (after pitch / resampling)
};
