#include "common.h"
#include "input.h"
#include "in_dummy.h"

/* class dummy_input */

dummy_input::dummy_input(input_data* chd)
{
		chdata = chd;
		chdata->format.rate = 44100;
		chdata->format.bytes = 2;
		chdata->format.channels = 2;
		if(chdata->buffer != NULL){ free(chdata->buffer; }
}

			
dummy_input::~dummy_input()
{
	cout << "dummy_input: goodbye\n";
	if(chdata->buffer != NULL){ free(chdata->buffer; }
	buffer_fill = 0;
}

			
int dummy_input::load() 
{
	cout << "dummy_input: loading file\n";
	chdata->position = 0;
	chdata->length = 4410000; // 100s
	return 0;
}

int dummy_input::play(unsigned int n_samples, sem_t& semph)
{
	cout << "dummy_input: filling buffer\n";
	int bytes = n_samples*sizeof(audio_type)*chdata->format.channels;
	int i;
		
	realloc(chdata->buffer, bytes); 
	
	//read
	
	buffer_fill = bytes;
	
	for(i = 0; i < bytes; ++i){ chdata->buffer[i] = i; }
	
	sem_post(&semph);
	return 0;
}

int dummy_input::seek(unsigned long pos) //seek to frame (consider different formats mixer/decoder!)
{
	cout << "dummy_input: seeking\n";
	return 0;
}
