#include "../common.h"
#include "../audio_functions.h"

void SoundPrint(char lett, audio_type* ar, unsigned int s);


int main()
{
	audio_type ai[20000], bi[20000];
	unsigned int a,b;
	for(a = 0; a<10; ++a){ ai[2*a] = 0; ai[2*a+1] = 1; }
	a = 10;
	b = 5;
	double volume = 1;
	fullsample2(ai,a,bi,b,volume);
	cout << "ChannelTest: 10 Samples A to 5 Samples B\n";
	SoundPrint('A', ai, 10);
	SoundPrint('B', bi, 5);

	for(a = 0; a<20; ++a){ ai[2*a] = a*a; ai[2*a+1] = a*3; }
	a = 20;
	b = 7;
	volume = 1;

	fullsample2(ai,a,bi,b,volume);
	cout << "OverallTest: 20 Samples A to 7 Samples B\n";
	SoundPrint('A', ai, 20);
	SoundPrint('B', bi, 7);

	a = 3;
	b = 7;

	fullsample2(ai,a,bi,b,volume);
	cout << "UpTest: 3 Samples A to 7 Samples B\n";
	SoundPrint('A', ai, 3);
	SoundPrint('B', bi, 7);

	volume = 2;

	fullsample2(ai,a,bi,b,volume);
	cout << "Now again with volume 2\n";
	SoundPrint('B', bi, 7);

	cout << "Speed test: volume = 1.3, a=1000 b=999\n";

	a = 1000;
	b = 999;
	volume = 1.3;
	for(unsigned int i=0; i < 10000; ++i)
	{
		fullsample2(ai,a,bi,b,volume);
	}

}


void SoundPrint(char lett, audio_type* ar, unsigned int s)
{
	for(unsigned int a = 0; a < s; ++a) cout << lett << "[" << 2*a << "] = " << ar[2*a] << ", " << lett << "[" << 2*a+1 << "] = " << ar[2*a+1] << endl;
}
