#include "basics.hxx"
#include "threads/threads.hxx"

#include <unistd.h>
#include <vector>
#include <string>
using std::string;

#include "shortcuts.hxx"
#include "debug.hxx"

class testthread: public dmd::thread
{
	public:

	 testthread(): thread("test thread", 1)
	{
		CONSTRUCT("testthread");
	};

	~testthread()
	{
		DESTRUCT("testthread");
	};

	void thread_work()
	{
		for(int i=1; i <= 2; ++i)
		{
			fprintf(stderr,"Thread %p is here: %i\n", this, i);
		}
		fprintf(stderr,"Thread %p is done.\n", this);
	};
};

class testcont: public dmd::thread_container
{
	public:
	 testcont()
	{
		CONSTRUCT("testcont");
		for(int i=1; i <= 10; ++i)
		{
			fprintf(stderr, "Creating testthread %i\n", i);
			create_thread(new testthread);
		}
	};

	~testcont()
	{
		DESTBEGIN("testcont");
		fprintf(stderr, "Container destruction; %zu threads left here.\n", threads.size());
		FOR_VECTOR(dmd::thread*, threads, ted)
		{
			fprintf(stderr, "Killing off thread %p...\n", *ted);
			(*ted)->thread_kill();
			delete *ted;
		}
		forget_threads();
		fprintf(stderr, "Container empty.\n");
		DESTEND("testcont");
	};
};


int main(int argc, char **argv)
{
	int ret = 0;
	fprintf(stderr, "Going funky with threads on stack.\n");
	std::vector<string*> tinfo;
	{
		testcont conti;
		conti.thread_info(tinfo);
		// Kill some thread explicitly...
		if(!conti.kill_thread(conti.threads[3]))
		{
			SERROR("Unable to kill a thread!");
			++ret;
		}
	}
	fprintf(stderr, "If I am still alive, I might be successful... those were the threads:\n\n");
	FOR_VECTOR(string*, tinfo, ti)
	{
		fprintf(stderr, "%s\n", (*ti)->c_str());
		delete *ti;
	}

	fprintf(stderr, "Note: Because of timing, some threads might not have worked out their stuff yet.\n");

	printf("%s\n", ret == 0 ? "PASS" : "FAIL");
	return ret;
}
