#include "basics.hxx"
#include "threads/semaphore.hxx"
#include "threads/threads.hxx"
#include "secsleep.hxx"
#include "mutex.hxx"

#include <unistd.h>
#include <vector>
#include <string>
using std::string;

#include "shortcuts.hxx"
#include "debug.hxx"

const int nthreads = 7;
const int startval = 17;

class testthread: public dmd::thread
{
	public:

	 testthread(int *j, mutex *loki, semaphore *beg, semaphore *en):
		thread("test thread", 1), i(j), locke(loki), begin(beg), end(en)
	{
		CONSTRUCT("testthread");
	};

	~testthread()
	{
		DESTRUCT("testthread");
	};

	void thread_work()
	{
		// This takes the lock for the full duration of the method.
		locker room(locke);
		int j = *i;
		begin->wait();
		*i = 2*j;
		end->post();
	};
	private:
	int *i;
	semaphore *begin;
	semaphore *end;
	mutex *locke;
};

class testcont: public dmd::thread_container
{
	public:
	 testcont(): j(startval)
	{
		CONSTRUCT("testcont");
		for(int i=1; i <= nthreads; ++i)
		{
			fprintf(stderr, "Creating testthread %i\n", i);
			create_thread(new testthread(&j, &lockshme, &begin, &end));
		}
		// Wait a bit for the havoc to begin.
		// Threads need time to grab the outdating value to make this
		// really trigger when the locking does not work.
		secsleep(0.01);
		for(int i=1; i <= nthreads; ++i) begin.post();

		for(int i=1; i <= nthreads; ++i) end.wait();
	};

	~testcont()
	{
		DESTBEGIN("testcont");
		fprintf(stderr, "Container destruction; %zu threads left here.\n", threads.size());
		FOR_VECTOR(dmd::thread*, threads, ted)
		{
			fprintf(stderr, "Killing off thread %p...\n", *ted);
			(*ted)->thread_kill();
			delete *ted;
		}
		forget_threads();
		fprintf(stderr, "Container empty.\n");
		DESTEND("testcont");
	};

	int j;

	private:	
	semaphore begin;
	semaphore end;
	real_mutex lockshme;
};


int main(int argc, char **argv)
{
	int ret = 0;
	int j = -1;
	fprintf(stderr, "Going funky with threads on stack.\n");
	std::vector<string*> tinfo;
	{
		testcont conti;
		j=conti.j;
	}

	int shouldbe = startval* (1<<nthreads);
	fprintf(stderr, "Result of pointlessly parallel computation: %i (should be %i)\n", j, shouldbe);

	printf("%s\n", j == shouldbe ? "PASS" : "FAIL");
	return ret;
}
