// Trying to test the socket stuff en bloc.
// Creation / destruction of the whole thing... optionally adding unix/tcp watchers.

#include "basics.hxx"
#include "coms/socket_watch.hxx"
#include "param_init.hxx"
#include "debug.hxx"
#include "shortcuts.hxx"

int main(int argc, char **argv)
{
	int ret = 0;
	// Non-interactive run of test shall not aquire sockets.
	param("tcp") = "false";
	param("unix") = "false";
	if(param.parse(argc, argv))
	{
		dmd::actionlist actions;
		semaphore go;
		dmd::socket_watch fredo(actions, go);
		if(fredo.init())
		{
			bool listening = false;
			if(param.as_bool("unix"))
			{
				if(!fredo.add_unix(param("socket")))
				{
					MERROR("Unable to listen on UNIX domain socket %s!", param("socket").c_str());
					++ret;
				}
				else listening = true;
			}
			if(param.as_bool("tcp"))
			{
				if(!fredo.add_tcp(param.as_lint("port"), param.as_bool("remote")))
				{
					MERROR("Unable to listen on TCP socket %s!", param("port").c_str());
					++ret;
				}
				else listening = true;
			}

			if(listening)
			{
				go.post(); // Start accepting connections.
				bool end = false;
				while(!end)
				{
					actions.idle();
					actions.pulling();
					FOR_VECTOR(action*, actions.get_list(), act)
					{
						fprintf(stderr, "Got an action of type  %i\n", (*act)->def->id);
						if((*act)->def->id == dmd::api::QUIT)
						{
							fprintf(stderr, "This is the end!\n");
							end = true;
						}
						(*act)->notify();
					}
					actions.done_pulling();
				}
			}
		}
		else
		{
			SERROR("Initialization of socket watch failed.");
			++ret;
		}
	}
	else
	{
		SERROR("Meh, parsing did not work.");
		++ret;
	}
	printf("%s\n", ret == 0 ? "PASS" : "FAIL");
	return ret;
}
