// A simple test that checks if the socket buffer works on stdin / stdout.

#include "basics.hxx"

#include "coms/netcomm.hxx"
#include "syserror.hxx"

int main(int argc, char **argv)
{
	std::string msg;
	syserror serr;
	socket_buffer sb(STDIN_FILENO, STDOUT_FILENO, false);

	printf("BEGIN\n");
	fflush(stdout);
	while(sb.read_line(msg) >= 0)
	{
		std::string outmsg = std::string("ECHO: ") + msg + "\n";
		sb.write_exactly(outmsg);
	}
	printf("END\n");
	if(serr.problem())
	{
		fprintf(stderr, "There was a problem: %s\n", serr.str());
		return -1;
	}
	return 0;
}
