#include "basics.hxx"

#include "parsenum.hxx"
#include <cstdio>
#include <string>

using namespace std;

int cond(const bool condition, const string name)
{
	if(!condition)
	{
		fprintf(stderr,"%s: FAIL\n", name.c_str());
		return 1;
	}
	else
	{
		fprintf(stderr, "%s: PASS\n", name.c_str());
		return 0;
	}
}

int main(int argc, char **argv)
{
	int ret = 0;

	printf("size of intmax: %zu\n", sizeof(intmax_t));
	printf("long:   %li <=> %li\n", long_min, long_max);
	printf("size_t: %zu <=> %zu\n", (size_t)0, size_t_max);
	printf("off_t:  %"OFF_P" <=> %"OFF_P"\n", (off_p)off_t_min, (off_p)off_t_max);

	long l;
	off_t o;
	size_t s;
	int err;

	// Only testing basic functionality with small values.
	const char *smallneg = "-253";
	const char *smallpos = "101";
	const char *bad = "y234";
	const char *floater = "0.34";

	l = str_to_long(bad, err);
	ret += cond(err == strnum_invalid, "invalid long string");

	o = str_to_offset(bad, err);
	ret += cond(err == strnum_invalid, "invalid offset string");

	s = str_to_size(bad, err);
	ret += cond(err == strnum_invalid, "invalid size string");

	l = str_to_long(smallneg, err);
	ret += cond(err == strnum_good && l == -253, "negative long");

	o = str_to_offset(smallneg, err);
	ret += cond(err == strnum_good && o == -253, "negative offset");

	s = str_to_size(smallneg, err);
	ret += cond(err == strnum_overflow, "negative size");

	l = str_to_long(smallpos, err);
	ret += cond(err == strnum_good && l == 101, "small long");

	o = str_to_offset(smallpos, err);
	ret += cond(err == strnum_good && l == 101, "small offset");

	s = str_to_size(smallpos, err);
	ret += cond(err == strnum_good && l == 101, "small size");

	l = str_to_long(floater, err);
	ret += cond(err == strnum_invalid, "non-integer");

	printf("%s\n", ret == 0 ? "PASS" : "FAIL");
	return 0;
}
