// Test for numparam stuff.

#include "basics.hxx"

#include "numparam.hxx"
#include "shortcuts.hxx"

using namespace std;

int cond(const bool condition, const string name)
{
	if(!condition)
	{
		fprintf(stderr,"%s: FAIL\n", name.c_str());
		return 1;
	}
	else
	{
		fprintf(stderr, "%s: PASS\n", name.c_str());
		return 0;
	}
}

int main()
{
	int err = 0;
	numparm_group par("test", "a test of basic numparam functionality");
	par.define("bass", 1., "bass volume");
	par.define("mid", 1., "mid frequencies volume");
	par.define("treble", 1., "treble volume");

	vector<string*> help;
	par.helptext(help);
	FOR_VECTOR(string*, help, li)
	{
		fprintf(stderr, "%s\n", (*li)->c_str());
		delete *li;
	}
	help.clear();

	err += cond(par.parse("4") && par[0].value==4, "parsing of single number");
	fprintf(stderr, "par[0].value=%g\n", par[0].value);
	err += cond(par.parse("  17 ") && par[0].value==17, "parsing of single number with spaces");
	err += cond(par.parse("treble=7") && par[2].value==7, "single name parse");
	err += cond(par.parse("10 20  30") && par[0].value==10 && par[1].value==20 && par[2].value==30, "all numbers parse");
	err += cond(par.parse("11 21  31 76 8 300") && par[0].value==11 && par[1].value==21 && par[2].value==31, "all numbers parse too many");
	err += cond(par.parse("33 12 mid=73 15  bass=16 90") && par[0].value==16 && par[1].value==73 && par[2].value==15, "parse mix");

	err += cond(par.parse("bass=6 treble=3") && par("bass").value == 6 && par("treble").value==3, "named access");

	par[0].value = 5;
	par[1].value = 9;
	par[2].value = 42;
	string parline;
	par.plainstring(parline);
	fprintf(stderr, "plain: %s\n", parline.c_str());
	err += cond(parline == "5 9 42", "plain-value text representation");
	parline="";
	par.namestring(parline);
	fprintf(stderr, "names: %s\n", parline.c_str());
	err += cond(parline == "bass=5 mid=9 treble=42", "plain-value text representation");

	par[0].value = 11.2;
	err += cond(par[0].as_longint() == 11, "integer rounding down");
	par[0].value = 11.7;
	err += cond(par[0].as_longint() == 12, "integer rounding up");
	par[0].value = 0.2;
	par[1].value = 0.99;
	err += cond(par[0].as_bool() == false && par[1].as_bool() == true, "bool interpretation");

	fprintf(stderr, "Just for fun, value of the bad parameter: %g\n", bad_numparm.value);

	printf("%s\n", err ? "FAIL" : "PASS");
	return err;
}
