#include "basics.hxx"

#include <string>
#include <iostream>
#include <cstdio>

#include "file_type.hxx"

using namespace std;

class test_file_type: public input::file_type
{
	private:
	bool check(const bool cond, const string name = "something")
	{
		cout << name << ": \t" << (cond ? "PASS" : "FAIL") << endl;
		if(!cond) ++err_count;

		return cond;
	};

	public:
	int err_count;
	 test_file_type(): err_count(0) {};
	~test_file_type(){};
	void test()
	{
		check( ending("some/frick.ing/file") == "", "bogus ending");
		check( ending("some/frick.ing/file.wav") == "wav", "wav ending" );
		check( prefix("gimme://some/thing://yeah") == "gimme", "prefix" );
		check( prefix("/some/thing/yeah") == "", "no prefix" );
		check( prefix("gim:me://some/thing://yeah") == "", "no prefix 2" );
		check( mime_to_type("audio/mpeg") == input::mpg123, "mpeg MIME" );
		check( mime_to_type("") == input::invalid, "empty MIME" );
		check( ending_to_type("mp2") == input::mpg123, "mpeg ending");
		check( ending_to_type("") == input::invalid, "empty ending" );
	};
};


int main(int argc, char **argv)
{
	test_file_type typer;
	if(argc > 1)
	{
		printf("Going to guess types of files you provided...\n\n");
		for(int i=1; i<argc; ++i)
		{
			printf("%s: %s\n", argv[i], input::id_to_name(typer.guess(argv[i])));
		}
	}
	else
	{
		typer.test();

		cout << (typer.err_count ? "FAIL" : "PASS") << endl;
	}
	return 0;
}
